/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class FcgTypeUtils {
    private static HashMap s_predefinedMap = new HashMap();

    public static FcgType getFcgType(FcgCodeGen cg, Class clazz) {
        FcgType type2;
        if (clazz.isArray()) {
            FcgType componentType = FcgTypeUtils.getFcgType(cg, clazz.getComponentType());
            type2 = cg.getArrayType(componentType);
        } else {
            String className = clazz.getName();
            type2 = (FcgType)s_predefinedMap.get(className);
            if (type2 == null) {
                className = FcgTypeUtils.fixupInnerClassName(cg, className);
                type2 = clazz.isInterface() ? cg.getInterfaceType(className) : cg.getClassReferenceType(className);
            }
        }
        return type2;
    }

    private static String fixupInnerClassName(FcgCodeGen cg, String className) {
        int index2 = className.indexOf(36);
        if (index2 > 0) {
            String outerName = className.substring(0, index2);
            String innerName = FcgTypeUtils.fixupInnerClassName(cg, className.substring(index2 + 1, className.length()));
            FcgClassReferenceType type2 = cg.getInnerClassReferenceType(outerName, innerName);
            className = type2.getTypeName();
        }
        return className;
    }

    static {
        s_predefinedMap.put("boolean", FcgType.BOOLEAN);
        s_predefinedMap.put("byte", FcgType.BYTE);
        s_predefinedMap.put("char", FcgType.CHAR);
        s_predefinedMap.put("short", FcgType.SHORT);
        s_predefinedMap.put("int", FcgType.INT);
        s_predefinedMap.put("long", FcgType.LONG);
        s_predefinedMap.put("float", FcgType.FLOAT);
        s_predefinedMap.put("double", FcgType.DOUBLE);
        s_predefinedMap.put("[Z", FcgType.BOOLEAN_ARRAY);
        s_predefinedMap.put("[B", FcgType.BYTE_ARRAY);
        s_predefinedMap.put("[C", FcgType.CHAR_ARRAY);
        s_predefinedMap.put("[S", FcgType.SHORT_ARRAY);
        s_predefinedMap.put("[I", FcgType.INT_ARRAY);
        s_predefinedMap.put("[J", FcgType.LONG_ARRAY);
        s_predefinedMap.put("[F", FcgType.FLOAT_ARRAY);
        s_predefinedMap.put("[D", FcgType.DOUBLE_ARRAY);
        s_predefinedMap.put(Boolean.class.getName(), FcgType.BOOLEAN_OBJECT);
        s_predefinedMap.put(Byte.class.getName(), FcgType.BYTE_OBJECT);
        s_predefinedMap.put(Character.class.getName(), FcgType.CHAR_OBJECT);
        s_predefinedMap.put(Short.class.getName(), FcgType.SHORT_OBJECT);
        s_predefinedMap.put(Integer.class.getName(), FcgType.INT_OBJECT);
        s_predefinedMap.put(Long.class.getName(), FcgType.LONG_OBJECT);
        s_predefinedMap.put(Float.class.getName(), FcgType.FLOAT_OBJECT);
        s_predefinedMap.put(Double.class.getName(), FcgType.DOUBLE_OBJECT);
        s_predefinedMap.put(CharSequence.class.getName(), FcgType.CHARSEQUENCE);
        s_predefinedMap.put(String.class.getName(), FcgType.STRING);
        s_predefinedMap.put(String[].class.getName(), FcgType.STRING_ARRAY);
        s_predefinedMap.put(StringBuffer.class.getName(), FcgType.STRINGBUFFER);
        s_predefinedMap.put(Object.class.getName(), FcgType.OBJECT);
        s_predefinedMap.put(Object[].class.getName(), FcgType.OBJECT_ARRAY);
        s_predefinedMap.put(BigDecimal.class.getName(), FcgType.BIG_DECIMAL);
        s_predefinedMap.put(BigInteger.class.getName(), FcgType.BIG_INTEGER);
        s_predefinedMap.put(Exception.class.getName(), FcgType.EXCEPTION);
        s_predefinedMap.put(RuntimeException.class.getName(), FcgType.RUNTIME_EXCEPTION);
        s_predefinedMap.put(ArithmeticException.class.getName(), FcgType.ARITHMETIC_EXCEPTION);
        s_predefinedMap.put("com.ibm.xltxe.rnm1.xylem.utils.OverflowException", FcgType.OVERFLOW_EXCEPTION);
    }
}

