/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgCodeGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgFieldGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgInstructionListBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgMethodGenBCEL;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgAttrsImpl;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgCodeGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FcgClassGenBCEL
extends FcgClassGenImpl
implements FcgClassGen {
    private static final int METHOD_SIZE_LIMIT = 65535;
    public static final int CONSTANTPOOL_BEST_SIZE = 65524;
    static final boolean REPORT_SPLIT = HiddenOptions.wasSpecified("reportsplit") && HiddenOptions.getBooleanValue("reportsplit") != false;
    private final FcgClassReferenceType class_name;
    private final FcgClassReferenceType super_class_name;
    private final String file_name;
    private final FcgAttrs m_attrs;
    private int m_numberOfClassFields;
    private final ClassGen _cg;
    private final ConstantPoolGen _cp;
    private final InstructionFactory _factory;
    FcgMethodGen m_staticCode;
    private LinkedInstructionList m_free_ils;
    private FcgMethodGen m_currentMethodGen;

    public FcgClassGenBCEL(FcgCodeGen cg, FcgClassReferenceType clazz, FcgClassReferenceType superClazz, String fileName, FcgAttrs attrs, String[] interfaces) {
        super(cg);
        this.class_name = clazz;
        if (superClazz == null) {
            superClazz = FcgType.OBJECT;
        }
        this.super_class_name = superClazz;
        this.file_name = fileName;
        this.m_attrs = attrs;
        int bcelAttrs = 32;
        bcelAttrs = this.m_attrs != null ? (bcelAttrs |= FcgCodeGenBCEL.fcg2bcelAttrs(this.m_attrs)) : (bcelAttrs |= 1);
        this._cg = new ClassGen(this.class_name.getTypeName(), this.super_class_name.getTypeName(), this.class_name.getTypeName() + ".java", bcelAttrs, interfaces);
        this._cp = this._cg.getConstantPool();
        this._factory = new InstructionFactory(this._cg, this._cp);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this._cg.addInterface(interfaces[i]);
            }
        }
        if (fileName != null) {
            this.setSourceNameInClass(fileName);
        }
    }

    @Override
    public ConstantPoolGen getbcelConstPool() {
        return this._cp;
    }

    @Override
    public int getbcelConstPoolSize() {
        return this._cp.getSize();
    }

    public ClassGen getbcelClassGen() {
        return this._cg;
    }

    @Override
    public final void dump(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.dump2(fos);
        fos.flush();
    }

    private void dump2(OutputStream out) throws IOException {
        this.finish();
        this._cg.getJavaClass().dump(out);
    }

    @Override
    public final void dump(OutputStream os) throws IOException {
        this.dump2(os);
        os.flush();
        os.close();
    }

    public final String getClassName() {
        return this.class_name.getTypeName();
    }

    @Override
    public final String getSuperClassName() {
        return this.super_class_name.getTypeName();
    }

    @Override
    public final FcgClassReferenceType getClassType() {
        return this.class_name;
    }

    @Override
    public final FcgClassReferenceType getSuperClassType() {
        return this.super_class_name;
    }

    @Override
    public final FcgInstructionList newInstructionList() {
        FcgCodeGenImpl codeGen = this.m_fcgCodeGen;
        FcgMethodGenBCEL m = (FcgMethodGenBCEL)this.getCurrentMethod();
        return new FcgInstructionListBCEL(this, null, m);
    }

    @Override
    public final FcgInstructionList newInstructionList(FcgMethodGen method) {
        return new FcgInstructionListBCEL(this, null, method);
    }

    @Override
    public final FcgInstructionList getClassInstructionList() {
        if (this.m_staticCode == null) {
            this.getClassInitMethod();
        }
        return this.m_staticCode.getInstructionList();
    }

    private String toString(FcgAttrs a) {
        FcgAttrsImpl attr2 = (FcgAttrsImpl)a;
        StringBuffer sb = new StringBuffer();
        int i = attr2.getAttrs();
        if ((i & 0x40) > 0) {
            sb.append("abstract ");
        }
        if ((i & 0x10) > 0) {
            sb.append("final ");
        }
        if ((i & 2) > 0) {
            sb.append("public ");
        }
        if ((i & 8) > 0) {
            sb.append("private ");
        }
        if ((i & 0x20) > 0) {
            sb.append("protected ");
        }
        if ((i & 4) > 0) {
            sb.append("static ");
        }
        String ret = sb.toString();
        return ret;
    }

    boolean hasDefaultConstructor() {
        return this.m_defaultCtor != null;
    }

    @Override
    public final FcgMethodGen getClassInitMethod() {
        if (this.m_staticCode == null) {
            this.m_staticCode = new FcgMethodGenBCEL(this, FcgAttrs.STATIC, FcgType.VOID, this.class_name, "<clinit>", null);
        }
        return this.m_staticCode;
    }

    @Override
    public final FcgField newInstanceField(FcgAttrs attrs, FcgType type2, String string2) {
        if (attrs == null) {
            attrs = FcgAttrs.PUBLIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING) {
            if (attrs.isStatic()) {
                FinalCodeGenerator.error("FCG: creating an instance field named " + string2 + " in class " + this.getClassName() + " but its  attributes say it is STATIC.");
            }
            if (type2 == FcgBasicType.VOID) {
                throw new RuntimeException("FcgClassGenBCEL, internal error, can't have an instance field of type void!");
            }
        }
        FcgFieldGenBCEL f2 = new FcgFieldGenBCEL(this, attrs, type2, string2);
        super.addField(f2);
        return f2;
    }

    FcgField findInstanceField(String name2) {
        int max2 = super.getNumFcgFields();
        for (int i = 0; i < max2; ++i) {
            FcgField f2 = this.getField(i);
            if (!name2.equals(f2.getName())) continue;
            return f2;
        }
        return null;
    }

    @Override
    public final FcgField newClassField(FcgAttrs attrs, FcgType type2, String string2) {
        if (attrs == null) {
            attrs = FcgAttrs.PUBLIC_STATIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && !attrs.isStatic()) {
            FinalCodeGenerator.error("FCG: creating a class (i.e. static) field named " + string2 + " in class " + this.getClassName() + " but the creation attributes don't include STATIC");
        }
        FcgFieldGenBCEL f2 = new FcgFieldGenBCEL(this, attrs, type2, string2);
        super.addField(f2);
        ++this.m_numberOfClassFields;
        return f2;
    }

    @Override
    public final int getNumberOfClassFields() {
        return this.m_numberOfClassFields;
    }

    @Override
    public final FcgMethodGen newConstructorGen(FcgAttrs attrs) {
        FcgMethodGenBCEL mg = new FcgMethodGenBCEL(this, attrs, FcgType.VOID, this.class_name, null, null);
        return mg;
    }

    private FcgMethodGen newMethodGen(FcgAttrs attrs, FcgType retType, FcgReferenceType className, String methodName, FcgType[] exceptionsThrown, FcgInstructionList il) {
        FcgMethodGenBCEL mg = new FcgMethodGenBCEL(this, attrs, retType, className, methodName, il);
        return mg;
    }

    @Override
    public final void addMethod(FcgMethodGen m) {
        int len;
        super.addMethod(m);
        FcgMethodGenBCEL meth = (FcgMethodGenBCEL)m;
        MethodGen methodGenBCEL = meth.getBCELMethodGen();
        Method methodBCEL = methodGenBCEL.getMethod();
        Code code = methodBCEL.getCode();
        if (code != null && (len = code.getCodeLength()) > 65535) {
            if (REPORT_SPLIT) {
                System.err.println("DBG: " + m.getName() + " oversize at " + len + " bytes");
            }
            throw new FcgMethodSizeException(len, meth.getName());
        }
        int cpSize = this.getbcelConstPoolSize();
        if (cpSize > 65524 && !meth.getName().equals("<init>")) {
            this._cp.rollback(65524);
            throw new FcgConstantPoolSizeException(cpSize, meth.getName());
        }
        this._cg.addMethod(methodBCEL);
    }

    @Override
    public final FcgMethodGen newMethodGen(FcgAttrs attrs, FcgType retType, String methodName, FcgInstructionList il) {
        FcgClassReferenceType className = this.getClassType();
        FcgMethodGenBCEL mg = new FcgMethodGenBCEL(this, attrs, retType, className, methodName, il);
        return mg;
    }

    @Override
    public final void comment(String com) {
    }

    @Override
    public final void finish() {
        if (!this.hasDefaultConstructor()) {
            this.addDefaultConstructor(this.m_fcgCodeGen);
        }
    }

    @Override
    public final FcgCodeGen getFcgCodeGen() {
        return this.m_fcgCodeGen;
    }

    private FcgMethodGen newConstructorGen(FcgAttrs accessAttrs, String ctorName, FcgInstructionList il) {
        FcgMethodGenBCEL mg = new FcgMethodGenBCEL(this, il);
        return mg;
    }

    @Override
    public final void addDefaultConstructor(FcgCodeGen cg) {
        this.addDefaultConstructor(cg, null);
    }

    @Override
    public final void addDefaultConstructor(FcgCodeGen cg, FcgInstructionList il2) {
        FcgInstructionList body;
        if (!this.hasDefaultConstructor()) {
            String className = this.getClassName();
            FcgMethodGen ctor = this.newConstructorGen(FcgAttrs.PUBLIC, className, il2);
            body = ctor.getInstructionList();
            this.setDefaultCtor(ctor);
            body.beginMethod();
            String sName = this.super_class_name.getTypeName();
            FcgInstructionListBCEL bcelIL = (FcgInstructionListBCEL)body;
            InstructionList il = bcelIL.getCode();
            il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
            il.append(this._factory.createInvoke(sName, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        } else {
            body = this.m_defaultCtor.getInstructionList();
        }
        body.returnInstruction();
        body.endMethod();
    }

    @Override
    public final void addInterface(String interfaceName) {
        this._cg.addInterface(interfaceName);
    }

    InstructionFactory getBCELInstructionFactory() {
        return this._factory;
    }

    InstructionList getInstructionList() {
        LinkedInstructionList il;
        if (this.m_free_ils != null) {
            il = this.m_free_ils;
            this.m_free_ils = this.m_free_ils.m_next;
        } else {
            il = new LinkedInstructionList();
        }
        return il;
    }

    void disposeInstructionList(InstructionList il) {
        il.dispose();
        LinkedInstructionList lil = (LinkedInstructionList)il;
        lil.m_next = this.m_free_ils;
        this.m_free_ils = lil;
    }

    private FcgMethodGen getCurrentMethod() {
        FcgMethodGen m = this.m_currentMethodGen;
        return m;
    }

    private void setCurrentMethod(FcgMethodGen methodGen) {
        this.m_currentMethodGen = methodGen;
    }

    @Override
    public final FcgMethodGen newMethodGen(FcgAttrs acc, FcgType retType, String methodName) {
        return this.newMethodGen(acc, retType, methodName, null);
    }

    public void setSourceNameInClass(String s) {
        Attribute[] attr2 = this._cg.getAttributes();
        for (int i = 0; i < attr2.length; ++i) {
            Attribute thisAttr = attr2[i];
            if (!(thisAttr instanceof SourceFile) || ((SourceFile)thisAttr).getTag() != 0) continue;
            this._cg.removeAttribute(thisAttr);
            this._cg.addAttribute(new SourceFile(this._cp.addUtf8("SourceFile"), 2, this._cp.addUtf8(s), this._cp.getConstantPool()));
        }
    }

    public static class FcgConstantPoolSizeException
    extends RuntimeException {
        private static final long serialVersionUID = -6283433797247228002L;
        public int size;

        FcgConstantPoolSizeException(int sz, String name2) {
            super("Constant Pool size limit of 65535 exceeded if added method: " + name2);
            this.size = sz;
        }
    }

    public static class FcgMethodSizeException
    extends RuntimeException {
        private static final long serialVersionUID = 1675941579481699540L;
        public int size;

        FcgMethodSizeException(int sz, String name2) {
            super("Method size limit of 65535 exceeded for method: " + name2);
            this.size = sz;
        }
    }

    static final class LinkedInstructionList
    extends InstructionList {
        LinkedInstructionList m_next;

        LinkedInstructionList() {
        }
    }
}

