/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.fcg.FcgArrayType;
import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassCollector;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgClassGenBCEL;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgCodeGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;

public class FcgCodeGenBCEL
extends FcgCodeGenImpl {
    private String m_sourceFileName = null;

    public FcgCodeGenBCEL(FcgClassCollector cc) {
        super(cc);
    }

    @Override
    public FcgClassGen newClassGen(FcgClassReferenceType clazz, FcgClassReferenceType baseClazz, FcgAttrs attrs) {
        FcgClassGenBCEL classGen = new FcgClassGenBCEL(this, clazz, baseClazz, null, attrs, null);
        return classGen;
    }

    @Override
    public void acceptGeneratedClass(FcgClassGen jc) {
        this.m_cc.acceptGeneratedClass(jc);
    }

    static Type fcg2bcelType(FcgType t) {
        Type bcelType;
        if (t == FcgBasicType.INT || t == FinalCodeGenerator.INT_LITERAL || t == FcgType.INT) {
            bcelType = Type.INT;
        } else if (t == FcgBasicType.BOOLEAN) {
            bcelType = Type.BOOLEAN;
        } else if (t == FcgBasicType.VOID) {
            bcelType = Type.VOID;
        } else if (t == FcgType.FLOAT) {
            bcelType = Type.FLOAT;
        } else if (t == FcgType.DOUBLE) {
            bcelType = Type.DOUBLE;
        } else if (t == FcgType.BYTE) {
            bcelType = Type.BYTE;
        } else if (t == FcgType.CHAR) {
            bcelType = Type.CHAR;
        } else if (t == FcgType.LONG) {
            bcelType = Type.LONG;
        } else if (t == FcgType.SHORT) {
            bcelType = Type.SHORT;
        } else if (t == FcgType.STRING) {
            bcelType = Type.STRING;
        } else if (t == FcgType.STRINGBUFFER) {
            bcelType = Type.STRINGBUFFER;
        } else if (t instanceof FcgClassReferenceType) {
            FcgClassReferenceType crt = (FcgClassReferenceType)t;
            String typeName = crt.getTypeName();
            bcelType = new ObjectType(typeName);
        } else if (t instanceof FcgInterfaceType) {
            FcgInterfaceType it = (FcgInterfaceType)t;
            String typeName = it.getTypeName();
            bcelType = new ObjectType(typeName);
        } else if (t instanceof FcgArrayType) {
            FcgArrayType at = (FcgArrayType)t;
            FcgType elemType = at.getCoreType();
            Type bcelElemType = FcgCodeGenBCEL.fcg2bcelType(elemType);
            bcelType = new ArrayType(bcelElemType, 1);
        } else {
            String msg = "Couldn't convert FcgType to BCEL type: Fcgtype '";
            msg = t == null ? msg + "null' " : msg + ((Object)t).toString() + "' ";
            FinalCodeGenerator.unimplementedException(msg);
            bcelType = null;
        }
        return bcelType;
    }

    static int fcg2bcelAttrs(FcgAttrs fcg) {
        int bcelAttrs = 0;
        if (fcg.isPublic()) {
            bcelAttrs |= 1;
        }
        if (fcg.isStatic()) {
            bcelAttrs |= 8;
        }
        if (fcg.isAbstract()) {
            bcelAttrs |= 0x400;
        }
        if (fcg.isFinal()) {
            bcelAttrs |= 0x10;
        }
        if (fcg.isPrivate()) {
            bcelAttrs |= 2;
        }
        if (fcg.isProtected()) {
            bcelAttrs |= 4;
        }
        return bcelAttrs;
    }

    @Override
    public String getInnerClassName(String className, String innerClassName) {
        return className + "$" + innerClassName;
    }

    @Override
    public void setSourceFileName(String sourceFileName) {
        this.m_sourceFileName = sourceFileName;
    }

    @Override
    public String getSourceFileName() {
        return this.m_sourceFileName;
    }
}

