/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgClassGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgCodeGenBCEL;
import com.ibm.xltxe.rnm1.fcg.bcel.FcgInstructionListBCEL;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgMethodGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.util.ArrayList;

public class FcgMethodGenBCEL
extends FcgMethodGenImpl
implements FcgMethodGen {
    private MethodGen m_bcelMethodGen;
    protected FcgClassGenBCEL m_classGen;
    protected FcgReferenceType m_className;
    protected final String m_methodName;
    protected FcgType[] m_throws;
    protected final boolean m_isStatic;
    public static final boolean STRIP_LOCALVARTABLE = !HiddenOptions.wasSpecified("fcg.localvartable");
    public static final boolean STRIP_LINETABLE = !HiddenOptions.wasSpecified("fcg.linetable") && HiddenOptions.wasSpecified("sourceLineInfo") && "off".equals(HiddenOptions.getStringValue("sourceLineInfo"));
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String S_HIDDEN_OPT_REG_INFO = "fcg.register.info";
    static final boolean S_REG_INFO_SPECIFIED = HiddenOptions.wasSpecified("fcg.register.info");
    public static final String S_REG_INFO_VALUE = S_REG_INFO_SPECIFIED ? HiddenOptions.getStringValue("fcg.register.info") : null;
    private static final FcgInstructionListBCEL.BcelVariable s_float = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_double = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_long = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_ref = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_int = new FcgInstructionListBCEL.BcelVariable();
    private final RegistersInUse m_registers;

    public FcgMethodGenBCEL(FcgClassGen classGen, FcgAttrs attrs, FcgType retType, FcgReferenceType className, String methodName, FcgInstructionList il) {
        super(classGen, il);
        il = this.m_code;
        this.m_isStatic = attrs.isStatic();
        this.m_registers = new RegistersInUse();
        this.m_classGen = (FcgClassGenBCEL)classGen;
        if (attrs == null) {
            attrs = FcgAttrs.PUBLIC;
        }
        this.m_attrs = attrs;
        this.m_retType = retType;
        this.m_className = className;
        if (methodName == null) {
            methodName = "<init>";
        }
        this.m_methodName = methodName;
        ConstantPoolGen _cp = this.m_classGen.getbcelConstPool();
        InstructionList bcelIL = il == null ? null : ((FcgInstructionListBCEL)il).getCode();
        int bcelAccessFlags = FcgCodeGenBCEL.fcg2bcelAttrs(attrs);
        Type bcelReturnType = FcgCodeGenBCEL.fcg2bcelType(retType);
        String[] arg_names = EMPTY_STRING_ARRAY;
        String classTypeName = className.getTypeName();
        this.m_bcelMethodGen = null;
    }

    public FcgMethodGenBCEL(FcgClassGen classGen, FcgInstructionList il) {
        super(classGen, il);
        il = this.m_code;
        this.m_attrs = FcgAttrs.PUBLIC;
        this.m_isStatic = this.m_attrs.isStatic();
        this.m_registers = new RegistersInUse();
        this.m_classGen = (FcgClassGenBCEL)classGen;
        this.m_methodName = "<init>";
        this.m_retType = FcgBasicType.VOID;
        int bcelAttrs = FcgCodeGenBCEL.fcg2bcelAttrs(this.m_attrs);
        String[] arg_names = EMPTY_STRING_ARRAY;
        String className = this.m_classGen.getClassName();
        InstructionList bcelIL = il != null ? ((FcgInstructionListBCEL)il).getCode() : new InstructionList();
        this.m_bcelMethodGen = new MethodGen(bcelAttrs, Type.VOID, Type.NO_ARGS, arg_names, this.m_methodName, className, bcelIL, this.m_classGen.getbcelConstPool());
    }

    public void finish() {
        if (STRIP_LOCALVARTABLE) {
            this.m_bcelMethodGen.stripLocalVarTable(true);
        }
        if (STRIP_LINETABLE) {
            this.m_bcelMethodGen.stripLineTable(true);
        }
        this.m_bcelMethodGen.setMaxLocals();
        this.m_bcelMethodGen.setMaxStack();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Method: " + this.m_methodName);
        return sb.toString();
    }

    @Override
    public FcgType getReturnType() {
        return this.m_retType;
    }

    @Override
    public FcgType[] getArgumentTypes() {
        int sz = this.m_parms.size();
        FcgType[] arr = new FcgType[this.m_parms.size()];
        for (int p = 0; p < sz; ++p) {
            arr[p] = ((FcgVariable)this.m_parms.get(p)).getType();
        }
        return arr;
    }

    @Override
    public String[] getArgumentNames() {
        int sz = this.m_parms.size();
        String[] arr = new String[this.m_parms.size()];
        for (int p = 0; p < sz; ++p) {
            arr[p] = ((FcgVariable)this.m_parms.get(p)).getName();
        }
        return arr;
    }

    @Override
    public String getName() {
        return this.m_methodName;
    }

    @Override
    public FcgAttrs getAttributes() {
        return this.m_attrs;
    }

    @Override
    public FcgVariable addParameter(FcgType parmType, String parmName) {
        FcgVariable var = ((FinalCodeGenerator)this.m_code).defineMethodParam(FcgAttrs.NONE, parmType, parmName);
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && parmName != null) {
            int mx = this.m_parms.size();
            for (int p = 0; p < mx; ++p) {
                if (!parmName.equals(((FcgVariable)this.m_parms.get(p)).getName())) continue;
                FcgInstructionListBCEL.error("FCG: method " + this.getName() + " has more than on parameter with the name " + parmName);
            }
        }
        this.m_parms.add(var);
        int reg = this.m_registers.getFreeReg(parmType);
        ((FcgInstructionListBCEL.BcelVariable)var).setRegister(reg);
        this.m_registers.setReg(reg, var);
        return var;
    }

    @Override
    public void setExceptionTypes(FcgClassReferenceType[] exceptionTypes) {
        this.m_throws = exceptionTypes;
        for (int e = 0; e < exceptionTypes.length; ++e) {
            String string2 = exceptionTypes[e].getTypeName();
        }
    }

    protected MethodGen getBCELMethodGen() {
        return this.m_bcelMethodGen;
    }

    public void setBCELMethodGen(MethodGen method) {
        this.m_bcelMethodGen = method;
    }

    RegistersInUse getRegisters() {
        return this.m_registers;
    }

    static {
        s_float.setType(FcgType.FLOAT);
        s_double.setType(FcgType.DOUBLE);
        s_long.setType(FcgType.LONG);
        s_ref.setType(FcgType.OBJECT);
        s_int.setType(FcgType.INT);
        s_float.setName("*** UNUSED, WAS FLOAT ***");
        s_double.setName("*** UNUSED, WAS DOUBLE ***");
        s_long.setName("*** UNUSED, WAS LONG ***");
        s_ref.setName("*** UNUSED, WAS REF ***");
        s_int.setName("*** UNUSED, WAS INT ***");
    }

    class RegistersInUse {
        private int m_regs_requested;
        static final boolean trace = false;
        final int first;
        final ArrayList reg2FcgVari = new ArrayList();
        int m_firstUnusedReg;

        private RegistersInUse() {
            if (FcgMethodGenBCEL.this.m_isStatic) {
                this.first = 0;
                this.m_firstUnusedReg = 0;
            } else {
                this.reg2FcgVari.add(0, null);
                this.first = 1;
                this.m_firstUnusedReg = 1;
                if (S_REG_INFO_SPECIFIED) {
                    this.m_regs_requested = 1;
                }
            }
        }

        final void setReg(int reg, FcgVariable var) {
            int max2;
            boolean isRegPair;
            FcgType type2 = var.getType();
            boolean bl = isRegPair = type2 == FcgType.LONG || type2 == FcgType.DOUBLE;
            if (reg == this.m_firstUnusedReg) {
                this.m_firstUnusedReg = isRegPair ? (this.m_firstUnusedReg += 2) : ++this.m_firstUnusedReg;
            }
            if (reg < (max2 = this.reg2FcgVari.size())) {
                this.setRegister(reg, var);
                if (isRegPair) {
                    if (reg + 1 == max2) {
                        this.reg2FcgVari.add(null);
                    }
                    this.setRegister(reg + 1, var);
                }
            } else if (reg == max2) {
                this.reg2FcgVari.add(var);
                if (isRegPair) {
                    this.reg2FcgVari.add(reg + 1, var);
                }
            } else if (reg == max2 + 1) {
                this.reg2FcgVari.add(null);
                this.reg2FcgVari.add(var);
                if (isRegPair) {
                    this.reg2FcgVari.add(reg + 1, var);
                }
            }
        }

        private void setRegister(int reg, FcgVariable var) {
            this.reg2FcgVari.set(reg, var);
        }

        private final FcgVariable getRegister(int reg) {
            return (FcgVariable)this.reg2FcgVari.get(reg);
        }

        private final int getMaxReg() {
            return this.reg2FcgVari.size();
        }

        private final String getRegVarName(int reg) {
            FcgVariable var = this.getRegister(reg);
            if (var == null) {
                return null;
            }
            return var.getName();
        }

        private final FcgType getRegType(int reg) {
            FcgVariable var = this.getRegister(reg);
            if (var == null) {
                return null;
            }
            return var.getType();
        }

        int getFreeReg(FcgType t) {
            if (S_REG_INFO_SPECIFIED) {
                this.m_regs_requested = t == FcgType.LONG || t == FcgType.DOUBLE ? (this.m_regs_requested += 2) : ++this.m_regs_requested;
            }
            int max2 = this.getMaxReg();
            int reg = this.m_firstUnusedReg;
            for (reg = this.m_firstUnusedReg; reg < max2; ++reg) {
                FcgVariable r = this.getRegister(reg);
                if (!this.notInUse(reg)) continue;
                if (t == FcgType.DOUBLE && r != s_double) {
                    if (reg + 1 < max2) {
                        if (!this.notInUse(reg + 1)) continue;
                        return reg;
                    }
                    return reg;
                }
                if (t instanceof FcgReferenceType && r != s_ref) {
                    return reg;
                }
                if (t == FcgType.FLOAT && r != s_float) {
                    return reg;
                }
                if (t == FcgType.LONG && r != s_long) {
                    if (reg + 1 < max2) {
                        if (!this.notInUse(reg + 1)) continue;
                        return reg;
                    }
                    return reg;
                }
                if (r == s_int) continue;
                return reg;
            }
            for (reg = this.m_firstUnusedReg; reg < max2; ++reg) {
                if (!this.notInUse(reg)) continue;
                if (t == FcgType.LONG || t == FcgType.DOUBLE) {
                    if (reg + 1 == max2) {
                        return reg;
                    }
                    if (reg + 1 >= max2 || !this.notInUse(reg + 1)) continue;
                    return reg;
                }
                return reg;
            }
            reg = max2 == 0 ? this.first : max2;
            return reg;
        }

        private boolean notInUse(int reg) {
            FcgVariable r = this.getRegister(reg);
            return r == s_ref || r == s_int || r == s_double || r == s_long || r == s_float;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("REGISTERS USAGE: (all regs below " + this.m_firstUnusedReg + " in use)\n");
            for (int reg = 0; reg < this.getMaxReg(); ++reg) {
                FcgType t = this.getRegType(reg);
                if (t != null) {
                    String name2 = this.getRegVarName(reg);
                    String s = "" + reg + " :     ";
                    s = s.substring(0, 5);
                    sb.append(s).append(" : ");
                    sb.append(name2).append(", ").append(((Object)t).toString());
                    sb.append('\n');
                    continue;
                }
                String s = "" + reg + " : *** USED, BUT NOT PRESENTLY IN USE ***\n";
                sb.append(s);
            }
            if (S_REG_INFO_SPECIFIED) {
                sb.append("without register re-use " + this.m_regs_requested + " would have been used\n");
            }
            return sb.toString();
        }

        void clearReg(FcgInstructionListBCEL.BcelVariable bcelVar) {
            int reg = bcelVar.getRegister();
            FcgType type2 = this.getRegType(reg);
            if (reg < this.m_firstUnusedReg) {
                this.m_firstUnusedReg = reg;
            }
            if (type2 == FcgType.INT) {
                this.setRegister(reg, s_int);
            } else if (type2 instanceof FcgReferenceType) {
                this.setRegister(reg, s_ref);
            } else if (type2 == FcgType.LONG) {
                this.setRegister(reg, s_long);
                this.setRegister(reg + 1, s_long);
            } else if (type2 == FcgType.DOUBLE) {
                this.setRegister(reg, s_double);
                this.setRegister(reg + 1, s_double);
            } else if (type2 == FcgType.FLOAT) {
                this.setRegister(reg, s_float);
            } else {
                this.setRegister(reg, s_int);
            }
        }
    }
}

