/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.bcel;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CompoundInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.POP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TargetLostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FcgSwitchBuilderBCEL {
    private final InstructionList m_il;
    private final InstructionHandle m_switchInsertionPoint;
    private InstructionHandle m_defaultCase;
    private final ConstantPoolGen _cp;
    private final ArrayList m_breaksToEnd;
    private final ArrayList m_testsAndLabels;

    FcgSwitchBuilderBCEL(ConstantPoolGen cp, InstructionList il) {
        this._cp = cp;
        this.m_il = il;
        this.m_defaultCase = null;
        this.m_breaksToEnd = new ArrayList();
        this.m_testsAndLabels = new ArrayList();
        this.m_switchInsertionPoint = this.m_il.append(new TABLESWITCH(new int[0], new InstructionHandle[0], null));
    }

    void startCase(int value2) {
        this.m_testsAndLabels.add(new ValueLabelPair(new Integer(value2), this.m_il.append(InstructionConstants.NOP)));
    }

    void breakCase() {
        GOTO bi = new GOTO(null);
        this.m_breaksToEnd.add(bi);
        this.m_il.append(bi);
    }

    void startDefaultCase() {
        this.m_defaultCase = this.m_il.append(InstructionConstants.NOP);
    }

    void startSwitch() {
    }

    void endSwitch() {
        int numCases = this.m_testsAndLabels.size();
        if (numCases == 0) {
            if (this.m_defaultCase == null) {
                this.removeBranchAtStartOfSwitch();
                this.m_il.append(new POP());
                return;
            }
        } else if (numCases == 1 && this.m_defaultCase == null) {
            ValueLabelPair pair = (ValueLabelPair)this.m_testsAndLabels.get(0);
            int val = pair.caseValue;
            PUSH pushCaseValue = new PUSH(this._cp, val);
            this.m_il.insert(this.m_switchInsertionPoint, (CompoundInstruction)pushCaseValue);
            BranchInstruction if_icmpne_3 = InstructionFactory.createBranchInstruction((short)160, null);
            this.m_il.insert(this.m_switchInsertionPoint, if_icmpne_3);
            this.removeBranchAtStartOfSwitch();
            InstructionHandle gotoForBreak = this.m_il.getEnd();
            try {
                this.m_il.delete(gotoForBreak);
            }
            catch (TargetLostException e) {
                throw new RuntimeException(e);
            }
            InstructionHandle end_of_switch = this.m_il.append(InstructionConstants.NOP);
            if_icmpne_3.setTarget(end_of_switch);
            return;
        }
        if (this.m_defaultCase == null) {
            this.startDefaultCase();
            this.breakCase();
        }
        Collections.sort(this.m_testsAndLabels, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ValueLabelPair pair0 = (ValueLabelPair)arg0;
                ValueLabelPair pair1 = (ValueLabelPair)arg1;
                return pair0.caseValue.compareTo(pair1.caseValue);
            }
        });
        int[] tests = new int[numCases];
        for (int i = 0; i < numCases; ++i) {
            ValueLabelPair pair = (ValueLabelPair)this.m_testsAndLabels.get(i);
            tests[i] = pair.caseValue;
        }
        InstructionHandle[] labels = new InstructionHandle[numCases];
        LOOKUPSWITCH branchAtStartOfSwitch = new LOOKUPSWITCH(tests, labels, null);
        for (int i = 0; i < numCases; ++i) {
            ValueLabelPair pair = (ValueLabelPair)this.m_testsAndLabels.get(i);
            branchAtStartOfSwitch.setTarget(i, pair.label);
        }
        this.m_switchInsertionPoint.setInstruction(branchAtStartOfSwitch);
        branchAtStartOfSwitch.setTarget(this.m_defaultCase);
        InstructionHandle end_of_switch = this.m_il.append(InstructionConstants.NOP);
        int numBreaks = this.m_breaksToEnd.size();
        for (int i = 0; i < numBreaks; ++i) {
            ((BranchInstruction)this.m_breaksToEnd.get(i)).setTarget(end_of_switch);
        }
    }

    private void removeBranchAtStartOfSwitch() {
        try {
            this.m_il.delete(this.m_switchInsertionPoint);
        }
        catch (TargetLostException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ValueLabelPair {
        final Integer caseValue;
        final InstructionHandle label;

        ValueLabelPair(Integer i, InstructionHandle firstIntructionInCaseBlock) {
            this.caseValue = i;
            this.label = firstIntructionInCaseBlock;
        }
    }
}

