/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.ifacecore;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;

public final class FcgAttrsImpl
implements FcgAttrs {
    public static final int ACC_SUPER = 128;
    public static final int ACC_PUBLIC = 2;
    public static final int ACC_STATIC = 4;
    public static final int ACC_PRIVATE = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_PROTECTED = 32;
    public static final int ACC_ABSTRACT = 64;
    final int m_attrs;

    public FcgAttrsImpl(int attrs) {
        this.m_attrs = attrs;
    }

    public int getAttrs() {
        return this.m_attrs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if ((this.m_attrs & 0x10) > 0) {
            sb.append("final ");
        }
        if ((this.m_attrs & 0x40) > 0) {
            sb.append("abstract ");
        }
        if ((this.m_attrs & 2) > 0) {
            sb.append("public ");
        }
        if ((this.m_attrs & 8) > 0) {
            sb.append("private ");
        }
        if ((this.m_attrs & 0x20) > 0) {
            sb.append("protected ");
        }
        if ((this.m_attrs & 4) > 0) {
            sb.append("static ");
        }
        if ((this.m_attrs & 0x80) > 0) {
            sb.append("super ");
        }
        return sb.toString();
    }

    @Override
    public boolean isStatic() {
        boolean ret = 0 < (this.m_attrs & 4);
        return ret;
    }

    @Override
    public boolean isPublic() {
        boolean ret = 0 < (this.m_attrs & 2);
        return ret;
    }

    @Override
    public boolean isAbstract() {
        boolean ret = 0 < (this.m_attrs & 0x40);
        return ret;
    }

    @Override
    public boolean isProtected() {
        boolean ret = 0 < (this.m_attrs & 0x20);
        return ret;
    }

    @Override
    public boolean isPrivate() {
        boolean ret = 0 < (this.m_attrs & 8);
        return ret;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public boolean isFinal() {
        boolean ret = 0 < (this.m_attrs & 0x10);
        return ret;
    }

    @Override
    public boolean isSuper() {
        boolean ret = 0 < (this.m_attrs & 0x80);
        return ret;
    }

    @Override
    public FcgAttrs union(FcgAttrs a2) {
        FcgAttrsImpl attrsImpl = (FcgAttrsImpl)a2;
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && (this.isPrivate() && !a2.isPackagePrivate() && !a2.isPrivate() || this.isPublic() && !a2.isPackagePrivate() && !a2.isPublic() || this.isProtected() && !a2.isPackagePrivate() && !a2.isProtected())) {
            String message = "FCG: can't merge attributes \"" + this.toString() + "\" with \"" + a2.toString() + "\"";
            FinalCodeGenerator.error(message);
        }
        int unionOfFlags = this.m_attrs | attrsImpl.m_attrs;
        FcgAttrsImpl atts = new FcgAttrsImpl(unionOfFlags);
        return atts;
    }
}

