/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.impl;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class FcgCoercionTable {
    static HashMap<String, HashMap<String, FcgCoercion>> coerceMap;
    static int dummy;

    public static void forceLoad() {
        dummy = 12;
    }

    public static FcgCoercion registerCoercion(FcgType fromType, FcgType toType, FcgCoercion coercion) {
        String fromKey = fromType.getTypeName();
        HashMap<String, FcgCoercion> toMap = coerceMap.get(fromKey);
        if (toMap == null) {
            toMap = new HashMap();
            coerceMap.put(fromKey, toMap);
        }
        String toKey = toType.getTypeName();
        return toMap.put(toKey, coercion);
    }

    public static FcgCoercion getCoercian(FcgType fromType, FcgType toType) {
        String fromKey = fromType.getTypeName();
        HashMap<String, FcgCoercion> toMap = coerceMap.get(fromKey);
        if (toMap == null) {
            return null;
        }
        String toKey = toType.getTypeName();
        return toMap.get(toKey);
    }

    private static void unimplementedException() {
        String msg = "FCG BCEL feature is unimplemented";
        throw new RuntimeException(msg);
    }

    private static void registerReflected(Method method, int nArgs, Field fromField, Field toField, FcgType fromType, FcgType toType) {
        if (nArgs == 1) {
            FcgCoercionTable.registerCoercion(fromType, toType, new FcgCoercionReflected(method){

                @Override
                protected Object coerce(FinalCodeGenerator g, FinalCodeGenerator.StackValue v) {
                    try {
                        Object[] args = new Object[]{v};
                        return this.m.invoke((Object)g, args);
                    }
                    catch (IllegalArgumentException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (IllegalAccessException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (InvocationTargetException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    return null;
                }
            });
        } else if (nArgs == 2) {
            FcgCoercionTable.registerCoercion(fromType, toType, new FcgCoercionReflected2(fromField, method){

                @Override
                protected Object coerce(FinalCodeGenerator g, FinalCodeGenerator.StackValue v) {
                    try {
                        Object[] args = new Object[]{this.fromField.get(null), v};
                        return this.m.invoke((Object)g, args);
                    }
                    catch (IllegalArgumentException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (IllegalAccessException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (InvocationTargetException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    return null;
                }
            });
        } else if (nArgs == 3) {
            FcgCoercionTable.registerCoercion(fromType, toType, new FcgCoercionReflected3(fromField, toField, method){

                @Override
                protected Object coerce(FinalCodeGenerator g, FinalCodeGenerator.StackValue v) {
                    try {
                        Object[] args = new Object[]{this.fromField.get(null), this.toField.get(null), v};
                        return this.m.invoke((Object)g, args);
                    }
                    catch (IllegalArgumentException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (IllegalAccessException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    catch (InvocationTargetException e) {
                        FcgCoercionTable.unimplementedException();
                    }
                    return null;
                }
            });
        }
    }

    static {
        Method[] methods;
        coerceMap = new HashMap();
        Class<FinalCodeGenerator> finalCodeGeneratorClazz = FinalCodeGenerator.class;
        for (Method method : methods = finalCodeGeneratorClazz.getDeclaredMethods()) {
            String name2 = method.getName();
            String leader = "genCode_COERCE_";
            String notleader = "genCode_COERCE_2";
            if (!name2.startsWith("genCode_COERCE_") || name2.startsWith("genCode_COERCE_2")) continue;
            int the2index = name2.indexOf(50);
            String fromName = name2.substring("genCode_COERCE_".length(), the2index);
            String toName = name2.substring(the2index + 1);
            Class<?>[] argTypes = method.getParameterTypes();
            int nArgs = argTypes.length;
            Class<FcgType> FcgTypeClazz = FcgType.class;
            Field[] fields = FcgTypeClazz.getDeclaredFields();
            Field fromField = null;
            Field toField = null;
            for (Field field : fields) {
                String fName = field.getName();
                if (fName.equals(fromName)) {
                    fromField = field;
                } else if (fName.equals(toName)) {
                    toField = field;
                }
                if (fromField != null && toField != null) break;
            }
            assert (fromField != null);
            assert (toField != null);
            try {
                FcgType fromType = (FcgType)fromField.get(null);
                FcgType toType = (FcgType)toField.get(null);
                FcgCoercionTable.registerReflected(method, nArgs, fromField, toField, fromType, toType);
                if (fromType != FcgType.INT) continue;
                FcgCoercionTable.registerReflected(method, nArgs, fromField, toField, FinalCodeGenerator.INT_LITERAL, toType);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        FcgCoercionTable.registerCoercion(FcgType.INT, FinalCodeGenerator.INT_LITERAL, new FcgCoercionInternalBase(){

            @Override
            protected Object coerce(FinalCodeGenerator g, FinalCodeGenerator.StackValue v) {
                return v.getCodeData();
            }
        });
        FcgCoercionTable.registerCoercion(FinalCodeGenerator.INT_LITERAL, FcgType.INT, new FcgCoercionInternalBase(){

            @Override
            protected Object coerce(FinalCodeGenerator g, FinalCodeGenerator.StackValue v) {
                return v.getCodeData();
            }
        });
    }

    private static abstract class FcgCoercionReflected3
    extends FcgCoercionReflected2 {
        final Field toField;

        FcgCoercionReflected3(Field fromField, Field toField, Method m) {
            super(fromField, m);
            this.toField = toField;
        }
    }

    private static abstract class FcgCoercionReflected2
    extends FcgCoercionReflected {
        final Field fromField;

        FcgCoercionReflected2(Field fromField, Method m) {
            super(m);
            this.fromField = fromField;
        }
    }

    private static abstract class FcgCoercionReflected
    extends FcgCoercionInternalBase {
        final Method m;

        FcgCoercionReflected(Method m) {
            this.m = m;
        }
    }

    private static abstract class FcgCoercionInternalBase
    extends FcgCoercion {
        private FcgCoercionInternalBase() {
        }

        protected abstract Object coerce(FinalCodeGenerator var1, FinalCodeGenerator.StackValue var2);

        @Override
        public Object getCoercion(FinalCodeGenerator codeGen, FinalCodeGenerator.StackValue valToCoerce) {
            return this.coerce(codeGen, valToCoerce);
        }
    }

    public static abstract class FcgCoercionExt
    extends FcgCoercion {
        protected abstract void coerce(FcgInstructionList var1);

        @Override
        public Object getCoercion(FinalCodeGenerator codeGen, FinalCodeGenerator.StackValue valToCoerce) {
            FinalCodeGenerator il = codeGen;
            FinalCodeGenerator.Construct constructKind = valToCoerce.getConstructKind();
            FinalCodeGenerator.StackValue cloned = (FinalCodeGenerator.StackValue)valToCoerce.clone();
            valToCoerce.reset();
            codeGen.push(constructKind, cloned.getType(), cloned.getCodeData());
            this.coerce(il);
            FinalCodeGenerator.StackValue coerced = codeGen.pop(constructKind);
            cloned.reset();
            Object generatedCode = coerced.getCodeData();
            return generatedCode;
        }
    }

    public static abstract class FcgCoercion {
        public abstract Object getCoercion(FinalCodeGenerator var1, FinalCodeGenerator.StackValue var2);
    }
}

