/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.impl;

import com.ibm.xltxe.rnm1.fcg.FcgArrayType;
import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgTerOp;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgOperation;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgReferenceTypeImpl;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgVarMutableInternal;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgCoercionTable;
import com.ibm.xltxe.rnm1.fcg.impl.FcgFieldGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgRuntimeException;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class FinalCodeGenerator
implements FcgInstructionList {
    private static final String FCG_COMPILE_TIME_CHECKING = "fcg.compile.check";
    public static final boolean DO_COMPILE_CHECKING = !HiddenOptions.optionValueIs("fcg.compile.check", "off");
    final FcgClassGen m_classGen;
    final FcgMethodGen m_method;
    protected final CodeGenStack m_codeGenerationStack = new CodeGenStack();
    private int m_nonValueConstructsOnStack = 0;
    private final LocalVarStack m_varStack = new LocalVarStack();
    private static final boolean debug_reset = System.getProperty("com.ibm.xltxe.rnm1.fcg.options.stackreset", "false").compareToIgnoreCase("true") == 0;
    private static final Construct UNDEFINED = new Construct("UNDEFINED");
    private static final Construct CLASS = new Construct("CLASS");
    private static final Construct METHOD = new Construct("METHOD");
    private static final Construct IF = new Construct("IF");
    private static final Construct ELSE = new Construct("ELSE");
    private static final Construct TRYBLOCK = new Construct("TRY");
    private static final Construct CATCHBLOCK = new Construct("CATCH");
    private static final Construct SCOPEBLOCK = new Construct("SCOPE");
    private static final Construct CHOOSE = new Construct("CHOOSE");
    private static final Construct CHOOSEBLOCK = new Construct("CHOOSEBLOCK");
    protected static final Construct LOOP = new Construct("LOOP");
    private static final Construct VALUE = new Construct("VALUE");
    private static final Construct VAR_SCOPE = new Construct("LOC_VAR_SCOPE");
    private ArrayList m_comments = new ArrayList();
    private boolean m_endMethodWasCalled = false;
    private FcgMethodGen m_beginMethod2;
    protected int m_loopCount = 0;
    public static final FcgBasicType INT_LITERAL = new FcgBasicType("int literal");
    static final boolean useReflectedFcgCoercionTable = true;

    protected FinalCodeGenerator(FcgClassGen classGen) {
        this.m_classGen = classGen;
        this.m_method = null;
    }

    protected FinalCodeGenerator(FcgClassGen classGen, FcgMethodGen method) {
        this.m_classGen = classGen;
        this.m_method = method;
    }

    private void push(Construct constructKind) {
        this.m_codeGenerationStack.push(constructKind, null, null, this.m_varStack.numLocalVars());
        this.increaseConstructCount(constructKind);
    }

    void push(Construct constructKind, FcgType type2, Object code) {
        if (DO_COMPILE_CHECKING && this.m_endMethodWasCalled) {
            FinalCodeGenerator.error("FCG: trying to add code after endMethod() was already called on an FcgInstructionList");
        }
        this.m_codeGenerationStack.push(constructKind, type2, code, this.m_varStack.numLocalVars());
        this.increaseConstructCount(constructKind);
    }

    private StackValue peek() {
        return this.m_codeGenerationStack.peek();
    }

    private StackValue peek(int stackDepth) {
        return this.m_codeGenerationStack.peek(stackDepth);
    }

    StackValue pop(Construct expectedConstructKind) {
        if (expectedConstructKind == null) {
            expectedConstructKind = this.peek().m_constructKind;
        }
        this.decreaseConstructCount(expectedConstructKind);
        return this.m_codeGenerationStack.pop(expectedConstructKind);
    }

    private void increaseConstructCount(Construct constructKind) {
        if (constructKind != VALUE) {
            ++this.m_nonValueConstructsOnStack;
        }
    }

    private void decreaseConstructCount(Construct constructKind) {
        if (constructKind != VALUE) {
            --this.m_nonValueConstructsOnStack;
        }
    }

    protected final int getActiveNonValueConstructsCount() {
        return this.m_nonValueConstructsOnStack;
    }

    @Override
    public final void comment(String comment2) {
        if (((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getSupressComments()) {
            return;
        }
        StackValue topOfStack = this.peek();
        if (topOfStack != null && topOfStack.getConstructKind() == VALUE) {
            this.cacheComment(comment2);
            return;
        }
        this.clearCachedComments();
        this.genCode_comment(comment2);
    }

    private void cacheComment(String comment2) {
        this.m_comments.add(comment2);
    }

    private void clearCachedComments() {
        int cached_comments = this.m_comments.size();
        while (cached_comments-- > 0) {
            String old_comment = (String)this.m_comments.get(0);
            this.genCode_comment(old_comment);
            this.m_comments.remove(0);
        }
    }

    protected abstract void genCode_comment(String var1);

    @Override
    public final FcgVariable defineVar(FcgType varType, String varName, boolean init) {
        StackValue topOfStack = this.peek();
        if (varType == null) {
            varType = topOfStack.getType();
        }
        FcgAttrs varAttrs = FcgAttrs.NONE;
        FcgVariable var = this.m_varStack.push(varName, varType, varAttrs);
        if (!init || topOfStack == null || topOfStack.getType() == FcgBasicType.VOID) {
            StackValue outerConstruct = topOfStack;
            this.genCode_defineLocalVariable(outerConstruct, var, null);
        } else {
            FcgType initType = topOfStack.getType();
            if (varType != null && initType != varType) {
                this.convertExpr(initType, varType);
            }
            StackValue varValue = this.pop(VALUE);
            StackValue outerConstruct = null;
            this.genCode_defineLocalVariable(outerConstruct, var, varValue);
            varValue.reset();
        }
        this.clearCachedComments();
        return var;
    }

    public final FcgVariable defineMethodParam(FcgAttrs varAttrs, FcgType varType, String varName) {
        FcgVariable parm = this.m_varStack.push(varName, varType, varAttrs);
        return parm;
    }

    private final FcgVariable defineCatchClauseParam(String varName, FcgType varType, FcgAttrs varAttrs) {
        FcgVariable excpVar = this.defineVar(varType, varName, false);
        return excpVar;
    }

    protected abstract void genCode_defineLocalVariable(StackValue var1, FcgVariable var2, StackValue var3);

    private void undefinelVar() {
        StackValue outerConstruct = this.peek();
        FcgVariable locVar = this.m_varStack.peek();
        this.genCode_undefineLocalVariable(outerConstruct, locVar);
        this.m_varStack.pop(locVar.getName());
    }

    protected abstract void genCode_undefineLocalVariable(StackValue var1, FcgVariable var2);

    @Override
    public final FcgVariable defineConstVar(FcgType varType, String varName) {
        StackValue topOfStack = this.peek();
        if (varType == null) {
            varType = topOfStack.getType();
        }
        FcgAttrs varAttrs = FcgAttrs.FINAL;
        FcgVariable var = this.m_varStack.push(varName, varType, varAttrs);
        if (topOfStack == null || topOfStack.getType() == FcgBasicType.VOID) {
            StackValue outerConstruct = topOfStack;
            this.genCode_defineLocalVariable(outerConstruct, var, null);
        } else {
            StackValue varValue = this.pop(VALUE);
            FcgType valType = varValue.getType();
            if (DO_COMPILE_CHECKING && !FinalCodeGenerator.canConvert(valType, varType)) {
                FinalCodeGenerator.error("FCG: defineConstVar() can't convert the type of the value: " + valType + ", to the type of the variable: " + varType);
            }
            StackValue outerConstruct = null;
            this.genCode_defineLocalVariable(outerConstruct, var, varValue);
            varValue.reset();
        }
        this.clearCachedComments();
        return var;
    }

    @Override
    public final void endMethod() {
        StackValue method = this.pop(METHOD);
        this.undeclareLocals(method);
        StackValue clazz = this.peek();
        this.genCode_endMethod(clazz, method);
        method.reset();
        this.m_varStack.m_freeIndex = 0;
        FcgMethodGen meth = this.getMethod();
        FcgInstructionList il = meth.getInstructionList();
        FcgClassGen classGen = il.getFcgClassGen();
        ((FcgClassGenImpl)classGen).addMethod(meth);
        this.clearCachedComments();
        this.setMethod(null);
        this.m_endMethodWasCalled = true;
    }

    protected abstract void genCode_endMethod(StackValue var1, StackValue var2);

    protected abstract void genCode_endClass(StackValue var1);

    @Override
    public final FcgType loadInstanceField(FcgClassReferenceType classRef, String varName, FcgType varType) {
        StackValue objRef;
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)classRef)).isNotRegistered()) {
            String msg = "FCG: The reference type '" + classRef.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(msg);
        }
        try {
            objRef = this.pop(VALUE);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("FCG: loadInstanceField() failed, perhaps no object, whose instance field is being loaded, was pushed on the FCG stack.", e);
        }
        Object generatedCode = this.genCode_loadInstanceField(objRef, classRef, varName, varType);
        objRef.reset();
        this.push(VALUE, varType, generatedCode);
        return varType;
    }

    protected abstract Object genCode_loadInstanceField(StackValue var1, FcgClassReferenceType var2, String var3, FcgType var4);

    @Override
    public final void storeInstanceFieldStmt(FcgClassReferenceType classRef, String varName, FcgType varType) {
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)classRef)).isNotRegistered()) {
            String msg = "FCG: The reference type '" + classRef.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(msg);
        }
        FcgType rhsType = this.peek().getType();
        if (varType != null && rhsType != varType) {
            this.convertExpr(rhsType, varType);
        }
        StackValue rhs = this.pop(VALUE);
        StackValue objRef = this.pop(VALUE);
        String className = classRef != null ? classRef.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeInstanceVariableStmt(objRef, className, varName, varType, rhs);
        rhs.reset();
        objRef.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeInstanceVariableStmt(StackValue var1, String var2, String var3, FcgType var4, StackValue var5);

    @Override
    public final FcgVariable findVar(String varName) {
        return this.findFcgVariable2(varName);
    }

    @Override
    public FcgType loadVar(FcgVariable locVar) {
        FcgType type2 = locVar.getType();
        if (type2 != FcgType.VOID) {
            this.push(VALUE, type2, this.genCode_loadLocalVariable(locVar));
        }
        return type2;
    }

    @Override
    public final FcgClassReferenceType loadThis() {
        if (DO_COMPILE_CHECKING && this.isClassContext()) {
            FinalCodeGenerator.error("FCG: Can't generate a load of 'this' in a class (static) method.");
        }
        Object object_reference_code = this.genCode_loadThis();
        String className = this.m_classGen.getClassType().getTypeName();
        FcgClassReferenceType typeOfThis = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getClassReferenceType(className);
        this.push(VALUE, typeOfThis, object_reference_code);
        return typeOfThis;
    }

    protected abstract Object genCode_loadThis();

    @Override
    public final FcgType loadNull() {
        Object object_reference_code = this.genCode_loadNull();
        this.push(VALUE, FcgType.OBJECT, object_reference_code);
        return FcgType.OBJECT;
    }

    protected abstract Object genCode_loadNull();

    protected abstract Object genCode_loadClassRef(String var1);

    protected abstract Object genCode_loadLocalVariable(FcgVariable var1);

    @Override
    public final FcgType loadArrayElement(FcgType elemType) {
        StackValue index2 = this.pop(VALUE);
        StackValue array = this.pop(VALUE);
        Object arrayElementCode = this.genCode_loadFromArrayElement(array, index2, elemType);
        index2.reset();
        array.reset();
        this.push(VALUE, elemType, arrayElementCode);
        return elemType;
    }

    protected abstract Object genCode_loadFromArrayElement(StackValue var1, StackValue var2, FcgType var3);

    @Override
    public final FcgType loadLiteral(boolean b) {
        this.push(VALUE, FcgBasicType.BOOLEAN, this.genCode_loadLiteralValue(b));
        return FcgBasicType.BOOLEAN;
    }

    protected abstract Object genCode_loadLiteralValue(boolean var1);

    @Override
    public final FcgType loadLiteral(long l) {
        this.push(VALUE, FcgBasicType.LONG, this.genCode_loadLiteralValue(l));
        return FcgBasicType.LONG;
    }

    protected abstract Object genCode_loadLiteralValue(long var1);

    @Override
    public final FcgType loadLiteral(int i) {
        this.push(VALUE, INT_LITERAL, this.genCode_loadLiteralValue(i));
        StackValue top = this.peek();
        top.setLiteralValue(i);
        return FcgType.INT;
    }

    protected abstract Object genCode_loadLiteralValue(int var1);

    @Override
    public final FcgType loadLiteral(short s) {
        this.push(VALUE, FcgBasicType.SHORT, this.genCode_loadLiteralValue(s));
        return FcgBasicType.SHORT;
    }

    protected abstract Object genCode_loadLiteralValue(short var1);

    @Override
    public final FcgType loadLiteral(byte b) {
        this.push(VALUE, FcgBasicType.BYTE, this.genCode_loadLiteralValue(b));
        return FcgBasicType.BYTE;
    }

    protected abstract Object genCode_loadLiteralValue(byte var1);

    @Override
    public final FcgType loadLiteral(char c) {
        this.push(VALUE, FcgBasicType.CHAR, this.genCode_loadLiteralValue(c));
        return FcgBasicType.CHAR;
    }

    protected abstract Object genCode_loadLiteralValue(char var1);

    @Override
    public final FcgType loadLiteral(String s) {
        this.push(VALUE, FcgBasicType.STRING, this.genCode_loadLiteralValue(s));
        return FcgBasicType.STRING;
    }

    protected abstract Object genCode_loadLiteralValue(String var1);

    @Override
    public final FcgType loadLiteral(float f2) {
        this.push(VALUE, FcgBasicType.FLOAT, this.genCode_loadLiteralValue(f2));
        return FcgBasicType.FLOAT;
    }

    protected abstract Object genCode_loadLiteralValue(float var1);

    @Override
    public final FcgType loadLiteral(double d) {
        this.push(VALUE, FcgBasicType.DOUBLE, this.genCode_loadLiteralValue(d));
        return FcgBasicType.DOUBLE;
    }

    protected abstract Object genCode_loadLiteralValue(double var1);

    @Override
    public final FcgType invokeInstanceMethod(FcgClassReferenceType objType, String methodName, FcgType returnType, int argCount) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(true, isExpression, objType, methodName, returnType, argCount, null);
        return returnType;
    }

    @Override
    public final FcgType invokeInstanceMethod(FcgClassReferenceType objType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(true, isExpression, objType, methodName, returnType, paramTypes.length, paramTypes);
        return returnType;
    }

    @Override
    public final FcgType invokeInstanceMethodStmt(FcgClassReferenceType objectType, String methodName, FcgType returnType, int numArgs) {
        boolean isExpression = false;
        this.invokeMethod(true, isExpression, objectType, methodName, returnType, numArgs, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInstanceMethodStmt(FcgClassReferenceType objectType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = false;
        this.invokeMethod(true, isExpression, objectType, methodName, returnType, paramTypes.length, paramTypes);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInterfaceMethod(FcgInterfaceType ifaceType, String methodName, FcgType returnType, int numArgs) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(true, isExpression, ifaceType, methodName, returnType, numArgs, null);
        return returnType;
    }

    @Override
    public final FcgType invokeInterfaceMethod(FcgInterfaceType ifaceType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(true, isExpression, ifaceType, methodName, returnType, paramTypes.length, paramTypes);
        return returnType;
    }

    @Override
    public final FcgType invokeInterfaceMethodStmt(FcgInterfaceType ifaceType, String methodName, FcgType returnType, int numArgs) {
        boolean isExpression = false;
        this.invokeMethod(true, isExpression, ifaceType, methodName, returnType, numArgs, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeInterfaceMethodStmt(FcgInterfaceType ifaceType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = false;
        this.invokeMethod(true, isExpression, ifaceType, methodName, returnType, paramTypes.length, paramTypes);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeClassMethod(FcgClassReferenceType classType, String methodName, FcgType returnType, int argCount) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(false, isExpression, classType, methodName, returnType, argCount, null);
        return returnType;
    }

    @Override
    public final FcgType invokeClassMethod(FcgClassReferenceType classType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = returnType != FcgType.VOID;
        this.invokeMethod(false, isExpression, classType, methodName, returnType, paramTypes.length, paramTypes);
        return returnType;
    }

    @Override
    public final FcgType invokeClassMethodStmt(FcgClassReferenceType classType, String methodName, FcgType returnType, int argCount) {
        boolean isExpression = false;
        boolean isInstanceMethod = false;
        this.invokeMethod(isInstanceMethod, isExpression, classType, methodName, returnType, argCount, null);
        return FcgType.VOID;
    }

    @Override
    public final FcgType invokeClassMethodStmt(FcgClassReferenceType classType, String methodName, FcgType returnType, FcgType[] paramTypes) {
        boolean isExpression = false;
        boolean isInstanceMethod = false;
        this.invokeMethod(isInstanceMethod, isExpression, classType, methodName, returnType, paramTypes.length, paramTypes);
        return FcgType.VOID;
    }

    @Override
    public final void printOut() {
        StackValue string2 = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        this.genCode_printOut(outerConstruct, string2);
        string2.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printOut(StackValue var1, StackValue var2);

    @Override
    public final void throwObject() {
        StackValue objRef = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        this.genCode_throwObject(outerConstruct, objRef);
        objRef.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_throwObject(StackValue var1, StackValue var2);

    @Override
    public final void printErr() {
        StackValue string2 = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        this.genCode_printErr(outerConstruct, string2);
        string2.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printErr(StackValue var1, StackValue var2);

    @Override
    public void storeVar(FcgVariable localVariable) {
        StackValue rhs = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        FcgType varType = localVariable.getType();
        FcgType exprType = rhs.getType();
        this.genCode_storeLocalVariableStmt(outerConstruct, localVariable, rhs);
        rhs.reset();
        this.clearCachedComments();
    }

    @Override
    public void endExpressionStmt() {
        StackValue rhs = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        this.genCode_endExpressionStmt(outerConstruct, rhs);
        rhs.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endExpressionStmt(StackValue var1, StackValue var2);

    protected abstract void genCode_storeLocalVariableStmt(StackValue var1, FcgVariable var2, StackValue var3);

    @Override
    public final FcgType storeAndReloadVarExpr(FcgVariable var) {
        StackValue rhs = this.pop(VALUE);
        FcgType type2 = rhs.getType();
        StackValue outerConstruct = this.peek();
        Object code = this.genCode_storeLocalVariableExpr(outerConstruct, var, rhs);
        rhs.reset();
        this.push(VALUE, type2, code);
        return type2;
    }

    protected abstract Object genCode_storeLocalVariableExpr(StackValue var1, FcgVariable var2, StackValue var3);

    @Override
    public FcgType preIncrementAndLoadLocalVariable(FcgVariable var) {
        StackValue outerConstruct = this.peek();
        Object code = this.genCode_preIncrementAndLoadLocalVariable(outerConstruct, var);
        FcgType type2 = var.getType();
        this.push(VALUE, type2, code);
        return type2;
    }

    protected abstract Object genCode_preIncrementAndLoadLocalVariable(StackValue var1, FcgVariable var2);

    @Override
    public void incrementVarStmt(FcgVariable var) {
        StackValue outerConstruct = this.peek();
        this.genCode_incrementLocalVarStmt(outerConstruct, var);
    }

    protected abstract void genCode_incrementLocalVarStmt(StackValue var1, FcgVariable var2);

    @Override
    public final void storeAtStmt() {
        StackValue rhs = this.pop(VALUE);
        StackValue lhs = this.pop(VALUE);
        StackValue outerConstruct = this.peek();
        this.genCode_storeAt(outerConstruct, lhs, rhs);
        lhs.reset();
        rhs.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeAt(StackValue var1, StackValue var2, StackValue var3);

    @Override
    public final void beginConditionalLoop(String loopName, int numValues) {
        this.beginConditionalLoop(loopName, numValues, false);
    }

    @Override
    public final void beginConditionalDoWhileLoop(String loopName) {
        this.beginConditionalLoop(loopName, 1, true);
    }

    private final void beginConditionalLoop(String loopName, int numValues, boolean isDoWhileLoop) {
        StackValue nextIterationUpdate = 2 == numValues ? this.pop(VALUE) : null;
        StackValue condition = 1 <= numValues ? this.pop(VALUE) : null;
        FcgType loopType = nextIterationUpdate == null ? FcgBasicType.VOID : nextIterationUpdate.getType();
        Object startLoopCode = this.genCode_startConditionalLoop(loopName, condition, nextIterationUpdate, isDoWhileLoop);
        if (condition != null) {
            condition.reset();
        }
        if (nextIterationUpdate != null) {
            nextIterationUpdate.reset();
        }
        this.push(LOOP, loopType, startLoopCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_startConditionalLoop(String var1, StackValue var2, StackValue var3, boolean var4);

    @Override
    public final void endConditionalLoop() {
        StackValue loop = this.pop(LOOP);
        StackValue outerConstruct = this.peek();
        this.undeclareLocals(loop);
        this.genCode_endLoop(outerConstruct, loop);
        loop.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endLoop(StackValue var1, StackValue var2);

    @Override
    public final void breakFromLoop() {
        this.breakFromLoop(1);
        this.clearCachedComments();
    }

    @Override
    public final void breakFromLoop(int depth) {
        StackValue loop = this.getNthEnclosingLoop(depth);
        StackValue outerConstruct = this.peek();
        this.undeclareLocals(loop);
        this.genCode_breakFromLoop(outerConstruct, loop);
        this.clearCachedComments();
    }

    protected abstract void genCode_breakFromLoop(StackValue var1, StackValue var2);

    @Override
    public final void nextIterationOfLoop() {
        this.nextIterationOfLoop(1);
    }

    @Override
    public final void nextIterationOfLoop(int depth) {
        StackValue loop = this.getNthEnclosingLoop(depth);
        StackValue outerConstruct = this.peek();
        this.genCode_nextIterationOfLoop(outerConstruct, loop);
    }

    protected abstract void genCode_nextIterationOfLoop(StackValue var1, StackValue var2);

    private StackValue getNthEnclosingLoop(int loopDepth) {
        int stackDepth = this.m_codeGenerationStack.size();
        StackValue stackEntry = null;
        for (int i = 0; i < stackDepth && loopDepth != 0; ++i) {
            stackEntry = this.peek(i);
            if (stackEntry.getConstructKind() != LOOP) continue;
            --loopDepth;
        }
        if (DO_COMPILE_CHECKING && loopDepth != 0) {
            FinalCodeGenerator.error("FCG: Requested break or continue from non-existent loop depth " + loopDepth);
        }
        return stackEntry;
    }

    @Override
    public final void beginSwitch() {
        StackValue choiceOperand = this.pop(VALUE);
        Object choiceCode = this.genCode_beginChoice(choiceOperand);
        choiceOperand.reset();
        this.push(CHOOSE, FcgBasicType.VOID, choiceCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoice(StackValue var1);

    @Override
    public final void beginSwitchCaseBlock(int caseValue) {
        StackValue choiceConstruct = this.peek();
        Object choiceBlockCode = this.genCode_beginChoiceBlock(caseValue, choiceConstruct);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, choiceBlockCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(int var1, StackValue var2);

    @Override
    public final void beginSwitchCaseBlock(char caseValue) {
        StackValue choiceConstruct = this.peek();
        Object choiceBlockCode = this.genCode_beginChoiceBlock(caseValue, choiceConstruct);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, choiceBlockCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(char var1, StackValue var2);

    @Override
    public final void beginSwitchDefaultBlock() {
        StackValue choiceConstruct = this.peek();
        Object choiceBlockCode = this.genCode_beginChoiceBlockDefault(choiceConstruct);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, choiceBlockCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlockDefault(StackValue var1);

    @Override
    public final void endSwitchCaseBlock() {
        this.endSwitchCaseBlock(true);
    }

    @Override
    public final void endSwitchCaseBlockFallThru() {
        this.endSwitchCaseBlock(false);
    }

    private final void endSwitchCaseBlock(boolean noFallThrough) {
        StackValue choiceBlock = this.pop(CHOOSEBLOCK);
        StackValue choiceConstruct = this.peek();
        this.undeclareLocals(choiceBlock);
        this.genCode_endChoiceBlock(choiceConstruct, choiceBlock, noFallThrough);
        choiceBlock.reset();
        this.clearCachedComments();
    }

    @Override
    public final void endSwitchDefaultBlock() {
        this.endSwitchDefaultBlock(true);
    }

    @Override
    public final void endSwitchDefaultBlockFallThru() {
        this.endSwitchDefaultBlock(false);
    }

    private final void endSwitchDefaultBlock(boolean noFallThrough) {
        this.endSwitchCaseBlock(noFallThrough);
    }

    protected abstract Object genCode_endChoiceBlock(StackValue var1, StackValue var2, boolean var3);

    @Override
    public final void endSwitch() {
        StackValue choiceConstruct = this.pop(CHOOSE);
        StackValue outerConstruct = this.peek();
        this.undeclareLocals(choiceConstruct);
        this.genCode_endChoice(outerConstruct, choiceConstruct);
        choiceConstruct.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endChoice(StackValue var1, StackValue var2);

    @Override
    public final FcgType unaryOperationExpr(FcgUnaryOp op2) {
        StackValue operand2 = this.pop(VALUE);
        FcgType operatorResultType = this.getUnaryExprType(op2, operand2.getType());
        Object unOpCode = this.genCode_unaryOperation(op2, operand2, operatorResultType);
        operand2.reset();
        this.push(VALUE, operatorResultType, unOpCode);
        return operatorResultType;
    }

    private FcgType getUnaryExprType(FcgUnaryOp op2, FcgType operandType) {
        FcgType expressionType;
        if (operandType == INT_LITERAL) {
            operandType = FcgType.INT;
        }
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        switch (fcgOpCode) {
            case 106: {
                if (operandType == FcgType.BYTE) {
                    expressionType = FcgType.INT;
                    break;
                }
                expressionType = operandType;
                break;
            }
            case 1130: {
                if (operandType == FcgType.BYTE) {
                    expressionType = FcgType.INT;
                    break;
                }
                expressionType = operandType;
                break;
            }
            case 201: {
                expressionType = FcgType.BOOLEAN;
                break;
            }
            case 300: {
                if (operandType == FcgType.BYTE || operandType == INT_LITERAL) {
                    expressionType = FcgType.INT;
                    break;
                }
                expressionType = operandType;
                break;
            }
            case 301: {
                if (operandType == FcgType.FLOAT) {
                    expressionType = FcgType.INT;
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    expressionType = FcgType.LONG;
                    break;
                }
                if (operandType == FcgType.INT || operandType == INT_LITERAL) {
                    expressionType = FcgType.INT;
                    break;
                }
                if (operandType == FcgType.BYTE) {
                    expressionType = FcgType.INT;
                    break;
                }
                if (operandType == FcgType.LONG) {
                    expressionType = FcgType.LONG;
                    break;
                }
                if (operandType == FcgType.BIG_INTEGER) {
                    expressionType = FcgType.BIG_INTEGER;
                    break;
                }
                if (operandType == FcgType.BIG_DECIMAL) {
                    expressionType = FcgType.BIG_DECIMAL;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator:  round has an unsupported arg type: " + operandType);
            }
            case 302: 
            case 303: {
                if (operandType == FcgType.DOUBLE || operandType == FcgType.FLOAT || operandType == FcgType.BYTE || operandType == FcgType.LONG || operandType == FcgType.INT || operandType == FcgType.BIG_DECIMAL || operandType == FcgType.BIG_INTEGER) {
                    expressionType = operandType;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator, ceiling or floor has an unsupported arg type: " + operandType);
            }
            case 305: {
                expressionType = FcgType.BOOLEAN;
                break;
            }
            case 306: {
                expressionType = FcgType.INT;
                break;
            }
            case 307: {
                expressionType = FcgType.CHAR_ARRAY;
                break;
            }
            case 308: {
                expressionType = FcgType.CHAR_ARRAY;
                break;
            }
            default: {
                Object expressionType2 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator, UNARY_HEX_ESCAPE, has an unsupported op: " + fcgOpCode);
            }
        }
        return expressionType;
    }

    @Override
    public final FcgType binaryOperationExpr(FcgBinOp op2) {
        StackValue rightOperand = this.pop(VALUE);
        StackValue leftOperand = this.pop(VALUE);
        FcgType operatorResultType = this.getBinaryExprType(op2, leftOperand.getType(), rightOperand.getType());
        Object binOpCode = this.genCode_binaryOperation(op2, leftOperand, rightOperand, operatorResultType);
        rightOperand.reset();
        leftOperand.reset();
        this.push(VALUE, operatorResultType, binOpCode);
        return operatorResultType;
    }

    @Override
    public final FcgType ternaryOperationExpr(FcgTerOp op2) {
        StackValue rightOperand = this.pop(VALUE);
        StackValue middleOperand = this.pop(VALUE);
        StackValue leftOperand = this.pop(VALUE);
        FcgType operatorResultType = this.getTernaryExprType(op2, leftOperand.getType(), middleOperand.getType(), rightOperand.getType());
        Object terOpCode = this.genCode_ternaryOperation(op2, leftOperand, middleOperand, rightOperand, operatorResultType);
        rightOperand.reset();
        middleOperand.reset();
        leftOperand.reset();
        this.push(VALUE, operatorResultType, terOpCode);
        return operatorResultType;
    }

    private FcgType getTernaryExprType(FcgTerOp op2, FcgType leftType, FcgType midType, FcgType rightType) {
        FcgType expressionType;
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        switch (fcgOpCode) {
            case 309: {
                if (leftType.equals(FcgType.BOOLEAN) && (midType.equals(rightType) || midType.equals(INT_LITERAL) && rightType.equals(FcgType.INT) || rightType.equals(INT_LITERAL) && midType.equals(FcgType.INT))) {
                    expressionType = midType.equals(INT_LITERAL) ? rightType : midType;
                    break;
                }
                if (leftType.equals(FcgType.BOOLEAN) && (midType.equals(FcgType.OBJECT) || rightType.equals(FcgType.OBJECT))) {
                    expressionType = midType.equals(FcgType.OBJECT) ? rightType : midType;
                    break;
                }
                Object expressionType2 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator bad args to opcode: " + fcgOpCode + ": " + leftType + ',' + midType + ',' + rightType);
            }
            default: {
                Object expressionType2 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator bad ternary opcode: " + fcgOpCode);
            }
        }
        return expressionType;
    }

    private FcgType getBinaryExprType(FcgBinOp op2, FcgType leftType, FcgType rightType) {
        FcgType expressionType2;
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        switch (fcgOpCode) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                if (leftType == FcgType.BIG_DECIMAL && fcgOpCode != 104) {
                    expressionType2 = FcgType.BIG_DECIMAL;
                    break;
                }
                if (leftType == FcgType.BIG_INTEGER) {
                    expressionType2 = FcgType.BIG_INTEGER;
                    break;
                }
                if (leftType == FcgType.DOUBLE || rightType == FcgType.DOUBLE) {
                    expressionType2 = FcgType.DOUBLE;
                    break;
                }
                if (leftType == FcgType.FLOAT || rightType == FcgType.FLOAT) {
                    expressionType2 = FcgType.FLOAT;
                    break;
                }
                if (leftType == FcgType.LONG || rightType == FcgType.LONG) {
                    expressionType2 = FcgType.LONG;
                    break;
                }
                expressionType2 = FcgType.INT;
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                if (leftType == FcgType.LONG) {
                    expressionType2 = FcgType.LONG;
                    break;
                }
                expressionType2 = FcgType.INT;
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                if (leftType == FcgType.LONG || rightType == FcgType.LONG) {
                    expressionType2 = FcgType.LONG;
                    break;
                }
                expressionType2 = FcgType.INT;
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                expressionType2 = FcgType.BOOLEAN;
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                expressionType2 = FcgType.BOOLEAN;
                break;
            }
            default: {
                Object expressionType2 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator bad opcode: " + fcgOpCode);
            }
        }
        return expressionType2;
    }

    private final FcgType createObjectExpr(FcgType classType, int numParams, FcgType[] paramTypes) {
        int i;
        int size = numParams;
        StackValue[] initialValues = new StackValue[size];
        for (i = size - 1; i >= 0; --i) {
            initialValues[i] = this.pop(VALUE);
        }
        Object objectCreationCode = this.genCode_createObject(classType, initialValues, paramTypes);
        for (i = 0; i < size; ++i) {
            initialValues[i].reset();
        }
        this.push(VALUE, classType, objectCreationCode);
        return classType;
    }

    @Override
    public final FcgType createObjectExpr(FcgType classType, int numParams) {
        return this.createObjectExpr(classType, numParams, null);
    }

    @Override
    public final FcgType createObjectExpr(FcgType classType, FcgType[] paramTypes) {
        return this.createObjectExpr(classType, paramTypes.length, paramTypes);
    }

    @Override
    public final FcgType createInnerClassExpr(FcgType classType, int numParams, FcgClassGen innerClass) {
        int size = numParams;
        if (DO_COMPILE_CHECKING && !(innerClass instanceof FcgClassGenJavaSrc)) {
            FinalCodeGenerator.error("FCG: Can only create inner classes with Java source");
        } else {
            int i;
            StackValue[] initialValues = new StackValue[size];
            for (i = size - 1; i >= 0; --i) {
                initialValues[i] = this.pop(VALUE);
            }
            Object objectCreationCode = this.genCode_createInnerClass(classType, initialValues, innerClass);
            for (i = 0; i < size; ++i) {
                initialValues[i].reset();
            }
            this.push(VALUE, classType, objectCreationCode);
        }
        return classType;
    }

    protected abstract Object genCode_createObject(FcgType var1, StackValue[] var2, FcgType[] var3);

    protected abstract Object genCode_createInnerClass(FcgType var1, StackValue[] var2, FcgClassGen var3);

    @Override
    public final FcgType createArrayExpr(FcgType t, boolean initialize) {
        Object arrayCreationCode;
        StackValue sizeValue = this.pop(VALUE);
        if (sizeValue.m_valueType == INT_LITERAL && initialize) {
            int i;
            int size = sizeValue.getIntLiteralValue();
            StackValue[] initialValues = new StackValue[size];
            for (i = size - 1; i >= 0; --i) {
                initialValues[i] = this.pop(VALUE);
            }
            arrayCreationCode = this.genCode_createArray(t, initialValues);
            for (i = 0; i < size; ++i) {
                initialValues[i].reset();
            }
            sizeValue.reset();
        } else {
            if (DO_COMPILE_CHECKING && initialize) {
                String msg = "FCG: Can't initialize created array, size is not a literal integer.";
                FinalCodeGenerator.error(msg);
            }
            arrayCreationCode = this.genCode_createArray(t, sizeValue);
            sizeValue.reset();
        }
        FcgType arrayType = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getArrayType(t);
        this.push(VALUE, arrayType, arrayCreationCode);
        return arrayType;
    }

    protected abstract Object genCode_createArray(FcgType var1, StackValue[] var2);

    protected abstract Object genCode_createArray(FcgType var1, StackValue var2);

    @Override
    public final void beginIf() {
        StackValue conditionOperand = this.pop(VALUE);
        Object conditionCode = this.genCode_beginIf(conditionOperand);
        conditionOperand.reset();
        this.push(IF, FcgBasicType.VOID, conditionCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginIf(StackValue var1);

    @Override
    public final void beginElse() {
        this.clearCachedComments();
        StackValue ifConstruct = this.peek();
        this.undeclareLocals(ifConstruct);
        ifConstruct = this.pop(IF);
        Object elseCode = this.genCode_beginElse(ifConstruct);
        ifConstruct.reset();
        this.push(ELSE, FcgBasicType.VOID, elseCode);
    }

    protected abstract Object genCode_beginElse(StackValue var1);

    @Override
    public final void beginElseIf() {
        StackValue conditionOperand = this.pop(VALUE);
        StackValue ifConstruct = this.pop(IF);
        this.undeclareLocals(ifConstruct);
        Object conditionCode = this.genCode_elseIf(ifConstruct, conditionOperand);
        conditionOperand.reset();
        ifConstruct.reset();
        this.push(IF, FcgBasicType.VOID, conditionCode);
        this.clearCachedComments();
    }

    protected abstract Object genCode_elseIf(StackValue var1, StackValue var2);

    @Override
    public final void endIf() {
        StackValue if_or_else_Construct = this.peek();
        this.undeclareLocals(if_or_else_Construct);
        if_or_else_Construct = this.pop(null);
        Construct c = if_or_else_Construct.getConstructKind();
        if (DO_COMPILE_CHECKING && c != IF && c != ELSE) {
            String msg = "FCG: endIf() was expecting to pop previously pushed IF or ELSE contruct on the FCG stack but got: " + c + " construct";
            Object c_or_d = if_or_else_Construct.getCodeData();
            if (c_or_d instanceof String) {
                msg = msg + ", with value: " + c_or_d;
            }
            FinalCodeGenerator.error(msg);
        }
        StackValue outerConstruct = this.peek();
        this.genCode_endIf(outerConstruct, if_or_else_Construct);
        if_or_else_Construct.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endIf(StackValue var1, StackValue var2);

    @Override
    public final void endTryBlock() {
        StackValue catchConstruct = this.pop(CATCHBLOCK);
        StackValue outerConstruct = this.peek();
        this.undeclareLocals(catchConstruct);
        this.genCode_endTry(outerConstruct, catchConstruct);
        catchConstruct.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endTry(StackValue var1, StackValue var2);

    @Override
    public final FcgType convertExpr(FcgType fromType, FcgType toType) {
        if (fromType != toType) {
            if (this.checkForUnreachable(this.peek())) {
                return fromType;
            }
            StackValue castOperand = this.pop(VALUE);
            Object castCode = this.genCode_coerce(fromType, toType, castOperand);
            castOperand.reset();
            this.push(VALUE, toType, castCode);
        }
        return toType;
    }

    @Override
    public final void returnInstruction() {
        FcgType retType;
        FcgMethodGen meth = this.getMethod();
        if (DO_COMPILE_CHECKING && meth != null && (retType = meth.getReturnType()) != FcgBasicType.VOID && retType != null) {
            FinalCodeGenerator.error("FCG: internal error generating a return; when a value must be returned");
        }
        this.returnInstruction(FcgType.VOID);
        this.clearCachedComments();
    }

    @Override
    public final void returnInstruction(FcgType retType) {
        StackValue topOfStack = this.peek();
        if (topOfStack == null) {
            this.genCode_returnInstruction(null);
        } else {
            StackValue outerConstruct;
            FcgType topOfStackType = topOfStack.getType();
            if (topOfStackType != retType) {
                StackValue castOperand = this.pop(VALUE);
                Object castCode = this.genCode_coerce(topOfStackType, retType, castOperand);
                castOperand.reset();
                this.push(VALUE, retType, castCode);
            }
            if (retType == FcgType.VOID) {
                outerConstruct = topOfStack;
                this.genCode_returnInstruction(outerConstruct);
            } else {
                StackValue returnValue = this.pop(VALUE);
                outerConstruct = this.peek();
                this.genCode_returnInstruction(outerConstruct, returnValue);
                returnValue.reset();
            }
        }
    }

    protected abstract void genCode_returnInstruction(StackValue var1);

    protected abstract void genCode_returnInstruction(StackValue var1, StackValue var2);

    @Override
    public void streamElemCopyStmt() {
        StackValue howMany = this.pop(VALUE);
        StackValue targetPos = this.pop(VALUE);
        StackValue targetArray = this.pop(VALUE);
        StackValue sourcePos = this.pop(VALUE);
        StackValue sourceArray = this.pop(VALUE);
        this.genCode_streamElemCopyStmt(sourceArray, sourcePos, targetArray, targetPos, howMany);
        howMany.reset();
        targetPos.reset();
        targetArray.reset();
        sourcePos.reset();
        sourceArray.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_streamElemCopyStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4, StackValue var5);

    public static void error(String msg) {
        throw new RuntimeException(msg);
    }

    public static void notImplemented() {
        String msg = "FCG: not implemented";
        FinalCodeGenerator.error(msg);
    }

    private void invokeMethod(boolean isInstanceMethod, boolean isExpression, FcgReferenceType refType, String methodName, FcgType returnType, int argCount, FcgType[] paramTypes) {
        String refTypeName;
        String msg;
        StackValue[] args;
        if (0 < argCount) {
            args = new StackValue[argCount];
            for (int i = argCount - 1; i >= 0; --i) {
                args[i] = this.pop(VALUE);
            }
        } else {
            args = null;
        }
        StackValue objeRef = null;
        if (isInstanceMethod) {
            objeRef = this.pop(null);
            if (DO_COMPILE_CHECKING && objeRef.getConstructKind() != VALUE) {
                msg = "FCG: Expected 'this' reference, but got " + objeRef;
                FinalCodeGenerator.error(msg);
            }
        }
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)refType).isNotRegistered()) {
            msg = "FCG: The reference type '" + refType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(msg);
        }
        boolean isInterface = false;
        if (refType == null) {
            refTypeName = this.m_classGen.getClassType().getTypeName();
        } else {
            refTypeName = refType.getTypeName();
            if (refType instanceof FcgInterfaceType) {
                isInterface = true;
            }
        }
        Object methodCode = this.genCode_invokeMethod(isInstanceMethod, isInterface, isExpression, objeRef, refTypeName, methodName, args, returnType, paramTypes);
        if (objeRef != null) {
            objeRef.reset();
        }
        if (args != null) {
            for (int i = 0; i < argCount; ++i) {
                args[i].reset();
            }
        }
        if (returnType != FcgBasicType.VOID && isExpression) {
            this.push(VALUE, returnType, methodCode);
        }
        if (!isExpression) {
            this.clearCachedComments();
        }
    }

    protected abstract Object genCode_invokeMethod(boolean var1, boolean var2, boolean var3, StackValue var4, String var5, String var6, StackValue[] var7, FcgType var8, FcgType[] var9);

    private void undeclareLocals(StackValue sv) {
        int numLocalsAtStart = sv.getNumLocalVars();
        int numLocalsNow = this.m_varStack.numLocalVars();
        for (int i = numLocalsAtStart; i < numLocalsNow; ++i) {
            this.undefinelVar();
        }
    }

    @Override
    public final void invokeSuperConstructor(FcgClassReferenceType superClassType, int numParams) {
        StackValue objRef;
        int i;
        int size = numParams;
        StackValue[] initialValues = new StackValue[size];
        try {
            for (i = size - 1; i >= 0; --i) {
                initialValues[i] = this.pop(VALUE);
            }
            objRef = this.pop(VALUE);
        }
        catch (RuntimeException xe) {
            throw new RuntimeException("FCG: not enough arguments pushed on FCG stack for invokeSuperConstructor() call.", xe);
        }
        if (DO_COMPILE_CHECKING && superClassType == null) {
            FinalCodeGenerator.error("FCG: invokeSuperConstructor() requires non-null class type for the super class");
        }
        this.genCode_invokeSuper(superClassType, objRef, initialValues);
        for (i = 0; i < size; ++i) {
            initialValues[i].reset();
        }
        objRef.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_invokeSuper(FcgClassReferenceType var1, StackValue var2, StackValue[] var3);

    public final void dispose() {
    }

    @Override
    public final void beginTryBlock() {
        Object code = this.genCode_beginTryBlock();
        this.clearCachedComments();
        this.push(TRYBLOCK, FcgType.VOID, code);
    }

    protected abstract Object genCode_beginTryBlock();

    @Override
    public final FcgVariable beginCatchBlock(FcgType exceptionType, String eName) {
        StackValue try_or_catch_Construct = this.pop(null);
        Construct c = try_or_catch_Construct.getConstructKind();
        if (DO_COMPILE_CHECKING && c != TRYBLOCK && c != CATCHBLOCK) {
            String msg = "FCG: Expecting to pop a TRYBLOCK or CATCHBLOCK Contruct from the FCG stack but got: " + c;
            FinalCodeGenerator.error(msg);
        }
        StackValue outerConstruct = this.peek();
        this.undeclareLocals(try_or_catch_Construct);
        FcgVariable excpVar = this.m_varStack.push(eName, exceptionType, FcgAttrs.NONE);
        Object code = this.genCode_beginCatchBlock(outerConstruct, try_or_catch_Construct, excpVar);
        try_or_catch_Construct.reset();
        this.push(CATCHBLOCK, FcgType.VOID, code);
        this.clearCachedComments();
        return excpVar;
    }

    protected abstract Object genCode_beginCatchBlock(StackValue var1, StackValue var2, FcgVariable var3);

    @Override
    public final FcgType loadClassField(FcgClassReferenceType classRef, String fieldName, FcgType type2) {
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)classRef)).isNotRegistered()) {
            String msg = "FCG: The reference type '" + classRef.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(msg);
        }
        String className = classRef.getTypeName();
        Object fieldRefCode = this.genCode_loadClassVariable(className, fieldName, type2);
        this.push(VALUE, type2, fieldRefCode);
        return type2;
    }

    protected abstract Object genCode_loadClassVariable(String var1, String var2, FcgType var3);

    @Override
    public final void storeClassFieldStmt(FcgClassReferenceType classType, String fieldName, FcgType type2) {
        if (DO_COMPILE_CHECKING && ((FcgReferenceTypeImpl)((Object)classType)).isNotRegistered()) {
            String msg = "FCG: The reference type '" + classType.getTypeName() + "' is not registered.";
            FinalCodeGenerator.error(msg);
        }
        FcgType rhsType = this.peek().getType();
        if (type2 != null && rhsType != type2) {
            this.convertExpr(rhsType, type2);
        }
        StackValue val = this.pop(VALUE);
        String className = classType != null ? classType.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeStaticFieldStmt(className, type2, fieldName, val);
        val.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeStaticFieldStmt(String var1, FcgType var2, String var3, StackValue var4);

    final void setMethod(FcgMethodGen m) {
        this.m_beginMethod2 = m;
    }

    protected final FcgMethodGen getMethod() {
        return this.m_beginMethod2;
    }

    @Override
    public final void beginMethod() {
        FcgMethodGen m = this.getMethod();
        this.push(METHOD);
        this.genCode_beginMethod(m);
        this.clearCachedComments();
        if (m.getAttributes().isStatic()) {
            this.setStaticContext(true);
        } else {
            this.setStaticContext(false);
        }
        if (m.getName().equals("<init>") && (m.getArgumentTypes() == null || m.getArgumentTypes().length == 0)) {
            FcgClassGen clg = this.getFcgClassGen();
            ((FcgClassGenImpl)clg).setDefaultCtor(m);
        }
    }

    protected abstract void genCode_beginMethod(FcgMethodGen var1);

    @Override
    public FcgType loadLiteral(BigDecimal number2) {
        this.push(VALUE, FcgBasicType.BIG_DECIMAL, this.genCode_loadLiteralValue(number2));
        return FcgBasicType.BIG_DECIMAL;
    }

    @Override
    public FcgType loadLiteral(BigInteger number2) {
        this.push(VALUE, FcgBasicType.BIG_INTEGER, this.genCode_loadLiteralValue(number2));
        return FcgBasicType.BIG_INTEGER;
    }

    protected abstract Object genCode_loadLiteralValue(BigDecimal var1);

    protected abstract Object genCode_loadLiteralValue(BigInteger var1);

    protected abstract Object genCode_loadLiteralValue(Character var1);

    protected abstract Object genCode_loadLiteralValue(Boolean var1);

    @Override
    public final int codeGenStackDepth() {
        return this.m_codeGenerationStack.m_freeIndex;
    }

    protected abstract Object genCode_arrayLengthExpr(StackValue var1);

    @Override
    public void storeArrayElemStmt() {
        StackValue rightHandSide = this.pop(VALUE);
        StackValue index2 = this.pop(VALUE);
        StackValue arrayRef = this.pop(VALUE);
        this.genCode_storeArrayElemStmt(arrayRef, index2, rightHandSide);
        rightHandSide.reset();
        index2.reset();
        arrayRef.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeArrayElemStmt(StackValue var1, StackValue var2, StackValue var3);

    @Override
    public final void fillStmt() {
        StackValue fillValue = this.pop(VALUE);
        StackValue indexTo = this.pop(VALUE);
        StackValue indexFrom = this.pop(VALUE);
        StackValue arrayRef = this.pop(VALUE);
        this.clearCachedComments();
        this.genCode_fillStmt(arrayRef, indexFrom, indexTo, fillValue);
        fillValue.reset();
        indexTo.reset();
        indexFrom.reset();
        arrayRef.reset();
    }

    protected abstract void genCode_fillStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CODE CURRENTLY PUSHED ON FCG CODE GEN STACK:\n");
        int max2 = this.m_codeGenerationStack.m_freeIndex - 1;
        for (int i = 0; i <= max2; ++i) {
            StackValue sv = this.m_codeGenerationStack.peek(i);
            sb.append("at depth " + (max2 - i) + " ");
            sb.append(sv.toString());
        }
        return sb.toString();
    }

    public abstract FcgVarMutableInternal newFcgVariable();

    protected abstract void genCode_beginScopeBlock();

    protected abstract void genCode_endScopeBlock(StackValue var1, StackValue var2);

    @Override
    public final void beginScopeBlock() {
        this.genCode_beginScopeBlock();
        this.clearCachedComments();
        this.push(SCOPEBLOCK);
    }

    @Override
    public final void endScopeBlock() {
        StackValue scope_Construct = this.peek();
        this.undeclareLocals(scope_Construct);
        scope_Construct = this.pop(SCOPEBLOCK);
        StackValue outerConstruct = this.peek();
        this.genCode_endScopeBlock(outerConstruct, scope_Construct);
        scope_Construct.reset();
        this.clearCachedComments();
    }

    private static boolean canConvert(FcgType fromType, FcgType toType) {
        boolean canConvert = false;
        if (fromType == toType) {
            return true;
        }
        if (fromType == FcgType.STRING) {
            if (toType == FcgType.CHAR_ARRAY) {
                canConvert = true;
            } else if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER && toType != FcgType.BOOLEAN && toType != FcgType.BYTE && toType != FcgType.CHAR && !(toType instanceof FcgClassReferenceType) && toType != FcgType.DOUBLE && toType != FcgType.FLOAT && toType != FcgType.INT && toType != FcgType.LONG && toType != FcgType.SHORT && toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                // empty if block
            }
        } else if (fromType == FcgType.BIG_DECIMAL) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.BIG_INTEGER) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.BOOLEAN) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.BYTE) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.CHAR) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.CHAR_ARRAY) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER && toType != FcgType.BOOLEAN && toType != FcgType.BYTE && toType != FcgType.CHAR && toType != FcgType.CHAR_ARRAY) {
                if (toType instanceof FcgClassReferenceType) {
                    if ("java.lang.String".equals(toType.getTypeName())) {
                        canConvert = true;
                    }
                } else if (toType != FcgType.DOUBLE && toType != FcgType.FLOAT && toType != FcgType.INT && toType != FcgType.LONG && toType != FcgType.LONG && toType != FcgType.SHORT) {
                    if (toType == FcgType.STRING) {
                        canConvert = true;
                    } else if (toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType instanceof FcgClassReferenceType) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER && toType != FcgType.BOOLEAN && toType != FcgType.BYTE && toType != FcgType.CHAR && toType != FcgType.CHAR_ARRAY) {
                if (toType instanceof FcgClassReferenceType || toType instanceof FcgInterfaceType) {
                    canConvert = true;
                } else if (toType != FcgType.DOUBLE && toType != FcgType.FLOAT && toType != FcgType.INT && toType != FcgType.LONG && toType != FcgType.SHORT && toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                    // empty if block
                }
            }
        } else if (fromType == FcgType.DOUBLE) {
            if (toType != FcgType.BIG_DECIMAL) {
                if (toType == FcgType.BIG_DECIMAL) {
                    canConvert = true;
                } else if (toType != FcgType.BIG_INTEGER) {
                    if (toType == FcgType.BOOLEAN) {
                        canConvert = true;
                    } else if (toType == FcgType.BYTE) {
                        canConvert = true;
                    } else if (toType == FcgType.CHAR) {
                        canConvert = true;
                    } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                        if (toType == FcgType.DOUBLE) {
                            canConvert = true;
                        } else if (toType == FcgType.FLOAT) {
                            canConvert = true;
                        } else if (toType == FcgType.INT) {
                            canConvert = true;
                        } else if (toType == FcgType.LONG) {
                            canConvert = true;
                        } else if (toType == FcgType.SHORT) {
                            canConvert = true;
                        } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fromType == FcgType.FLOAT) {
            if (toType == FcgType.BIG_DECIMAL) {
                canConvert = true;
            } else if (toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.INT || fromType == INT_LITERAL) {
            if (toType != FcgType.BIG_DECIMAL) {
                if (toType == FcgType.BIG_DECIMAL) {
                    canConvert = true;
                } else if (toType != FcgType.BIG_INTEGER) {
                    if (toType == FcgType.BOOLEAN) {
                        canConvert = true;
                    } else if (toType == FcgType.BYTE) {
                        canConvert = true;
                    } else if (toType == FcgType.CHAR) {
                        canConvert = true;
                    } else if (toType == FcgType.CHAR_ARRAY) {
                        canConvert = true;
                    } else if (toType == FcgType.STRING) {
                        canConvert = true;
                    } else if (!(toType instanceof FcgClassReferenceType)) {
                        if (toType == FcgType.DOUBLE) {
                            canConvert = true;
                        } else if (toType == FcgType.FLOAT) {
                            canConvert = true;
                        } else if (toType == FcgType.INT) {
                            canConvert = true;
                        } else if (toType == FcgType.LONG) {
                            canConvert = true;
                        } else if (toType == FcgType.SHORT) {
                            canConvert = true;
                        } else if (toType == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fromType == FcgType.LONG) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.SHORT) {
            if (toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER) {
                if (toType == FcgType.BOOLEAN) {
                    canConvert = true;
                } else if (toType == FcgType.BYTE) {
                    canConvert = true;
                } else if (toType == FcgType.CHAR) {
                    canConvert = true;
                } else if (toType != FcgType.CHAR_ARRAY && !(toType instanceof FcgClassReferenceType)) {
                    if (toType == FcgType.DOUBLE) {
                        canConvert = true;
                    } else if (toType == FcgType.FLOAT) {
                        canConvert = true;
                    } else if (toType == FcgType.INT) {
                        canConvert = true;
                    } else if (toType == FcgType.LONG) {
                        canConvert = true;
                    } else if (toType == FcgType.SHORT) {
                        canConvert = true;
                    } else if (toType != FcgType.STRING && toType == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fromType == FcgType.STRINGBUFFER && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_DECIMAL && toType != FcgType.BIG_INTEGER && toType != FcgType.BOOLEAN && toType != FcgType.BYTE && toType != FcgType.CHAR) {
            if (toType == FcgType.CHAR_ARRAY) {
                canConvert = true;
            } else if (toType instanceof FcgClassReferenceType || toType == FcgType.DOUBLE || toType == FcgType.FLOAT || toType == FcgType.INT || toType == FcgType.SHORT || toType == FcgType.STRING || toType == FcgType.STRINGBUFFER) {
                // empty if block
            }
        }
        return canConvert;
    }

    @Override
    public FcgType loadInstanceField(FcgField instanceField) {
        FcgAttrs atts = instanceField.getAttrs();
        FcgClassReferenceType crt = ((FcgFieldGenImpl)instanceField).getDefiningClass();
        String name2 = instanceField.getName();
        FcgType t = instanceField.getType();
        if (DO_COMPILE_CHECKING && atts.isStatic()) {
            String fld = atts.toString() + t.getTypeName() + ' ' + crt.getTypeName() + '.' + name2;
            FinalCodeGenerator.error("FCG: loadInstanceField(FcgField) is trying to load a class field: " + fld);
        }
        this.loadInstanceField(crt, name2, t);
        return t;
    }

    @Override
    public FcgType loadClassField(FcgField classField) {
        FcgAttrs atts = classField.getAttrs();
        FcgClassReferenceType crt = ((FcgFieldGenImpl)classField).getDefiningClass();
        String name2 = classField.getName();
        FcgType t = classField.getType();
        if (DO_COMPILE_CHECKING && !atts.isStatic()) {
            String fld = atts.toString() + t.getTypeName() + ' ' + crt.getTypeName() + '.' + name2;
            FinalCodeGenerator.error("FCG: loadClassField(FcgField) is trying to load an instance field: " + fld);
        }
        this.loadClassField(crt, name2, t);
        return t;
    }

    @Override
    public void storeInstanceFieldStmt(FcgField instanceField) {
        FcgAttrs atts = instanceField.getAttrs();
        FcgClassReferenceType crt = ((FcgFieldGenImpl)instanceField).getDefiningClass();
        String name2 = instanceField.getName();
        FcgType t = instanceField.getType();
        if (DO_COMPILE_CHECKING && atts.isStatic()) {
            String fld = atts.toString() + t.getTypeName() + ' ' + crt.getTypeName() + '.' + name2;
            FinalCodeGenerator.error("FCG: storeInstanceFieldStmt(FcgField) is trying to store to a class field: " + fld);
        }
        this.storeInstanceFieldStmt(crt, name2, t);
    }

    @Override
    public void storeClassFieldStmt(FcgField classField) {
        FcgAttrs atts = classField.getAttrs();
        FcgClassReferenceType crt = ((FcgFieldGenImpl)classField).getDefiningClass();
        String name2 = classField.getName();
        FcgType t = classField.getType();
        if (DO_COMPILE_CHECKING && !atts.isStatic()) {
            String fld = atts.toString() + t.getTypeName() + ' ' + crt.getTypeName() + '.' + name2;
            FinalCodeGenerator.error("FCG: storeClassFieldStmt(FcgField) is trying to store to an instance field: " + fld);
        }
        this.storeClassFieldStmt(crt, name2, t);
    }

    @Override
    public void runtimeTypeCheck(FcgReferenceType type2) {
        StackValue object2 = this.pop(VALUE);
        Object typeCheckCode = this.genCode_runtimeTypeCheck(object2, type2);
        object2.reset();
        this.push(VALUE, FcgType.BOOLEAN, typeCheckCode);
    }

    @Override
    public FcgType peekTypeOnStack() {
        StackValue stackVal = this.peek();
        return stackVal.m_valueType;
    }

    protected abstract Object genCode_runtimeTypeCheck(StackValue var1, FcgReferenceType var2);

    private final FcgVariable findFcgVariable2(String varName) {
        for (int i = this.m_varStack.m_freeIndex - 1; 0 <= i; --i) {
            FcgVarMutableInternal var = this.m_varStack.m_stackArr[i];
            if (!varName.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public abstract void setStaticContext(boolean var1);

    protected abstract boolean isEmpty();

    protected abstract boolean isClassContext();

    public static void unimplementedException() {
        String msg = "FCG BCEL feature is unimplemented";
        throw new RuntimeException(msg);
    }

    public static void unimplementedException(String msg) {
        throw new FcgRuntimeException("FCG INTERNAL ERROR. " + msg);
    }

    private final Object genCode_unaryOperation(FcgUnaryOp op2, StackValue operand2, FcgType resultType) {
        FcgType operandType = operand2.getType();
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        Object generatedCode = null;
        switch (fcgOpCode) {
            case 106: {
                if (operandType == FcgType.BIG_INTEGER || operandType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.gencode_UNARY_NEGATE_BIG(operand2);
                    break;
                }
                if (resultType == FcgType.INT) {
                    generatedCode = this.genCode_UNARY_NEGATE_INT(operand2);
                    break;
                }
                if (operandType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_NEGATE_FLOAT(operand2);
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_NEGATE_DOUBLE(operand2);
                    break;
                }
                if (operandType == FcgType.LONG) {
                    generatedCode = this.genCode_UNARY_NEGATE_LONG(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 1130: {
                if (resultType == FcgType.INT) {
                    generatedCode = this.genCode_UNARY_BITWISE_NOT_INT(operand2);
                    break;
                }
                if (resultType == FcgType.LONG) {
                    generatedCode = this.genCode_UNARY_BITWISE_NOT_LONG(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 201: {
                generatedCode = this.genCode_UNARY_LOGICAL_NOT(operand2);
                break;
            }
            case 300: {
                if (operandType == FcgType.BIG_INTEGER || operandType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_UNARY_ABS_BIG(operand2);
                    break;
                }
                if (resultType == FcgType.INT) {
                    generatedCode = this.genCode_UNARY_ABS_INT(operand2);
                    break;
                }
                if (resultType == FcgType.LONG) {
                    generatedCode = this.genCode_UNARY_ABS_LONG(operand2);
                    break;
                }
                if (resultType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_ABS_FLOAT(operand2);
                    break;
                }
                if (resultType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_ABS_DOUBLE(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 301: {
                if (operandType == FcgType.BIG_INTEGER || operandType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_UNARY_ROUND_BIG(operand2);
                    break;
                }
                if (operandType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_ROUND_FLOAT(operand2);
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_ROUND_DOUBLE(operand2);
                    break;
                }
                if (operandType == FcgType.INT || operandType == FcgType.BYTE || operandType == FcgType.LONG) {
                    generatedCode = this.genCode_UNARY_ROUND_INT(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 302: {
                if (operandType == FcgType.BYTE || operandType == FcgType.INT || operandType == INT_LITERAL || operandType == FcgType.LONG || operandType == FcgType.BIG_INTEGER) {
                    generatedCode = this.genCode_UNARY_CEILING_INT(operand2);
                    break;
                }
                if (operandType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_CEILING_FLOAT(operand2);
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_CEILING_DOUBLE(operand2);
                    break;
                }
                if (operandType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_UNARY_CEILING_BIG_DECIMAL(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 303: {
                if (operandType == FcgType.BYTE || operandType == FcgType.INT || operandType == INT_LITERAL || operandType == FcgType.LONG || operandType == FcgType.BIG_INTEGER) {
                    generatedCode = this.genCode_UNARY_FLOOR_INT(operand2);
                    break;
                }
                if (operandType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_FLOOR_FLOAT(operand2);
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_FLOOR_DOUBLE(operand2);
                    break;
                }
                if (operandType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_UNARY_FLOOR_BIG_DECIMAL(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 305: {
                if (operandType == FcgType.BYTE || operandType == FcgType.INT || operandType == INT_LITERAL) {
                    generatedCode = this.genCode_UNARY_IS_NAN_INT(operand2);
                    break;
                }
                if (operandType == FcgType.LONG) {
                    generatedCode = this.genCode_UNARY_IS_NAN__LONG(operand2);
                    break;
                }
                if (operandType == FcgType.FLOAT) {
                    generatedCode = this.genCode_UNARY_IS_NAN__FLOAT(operand2);
                    break;
                }
                if (operandType == FcgType.DOUBLE) {
                    generatedCode = this.genCode_UNARY_IS_NAN_DOUBLE(operand2);
                    break;
                }
                throw new UnsupportedOperationException("FcgInstructionListBCEL: bad op type for isNaN" + operandType);
            }
            case 306: {
                if (operandType == FcgType.STRING) {
                    generatedCode = this.genCode_UNARY_ARRAY_LENGTH_STRING(operand2);
                    break;
                }
                if (operandType == FcgType.CHARSEQUENCE || operandType.getTypeName().equals("com.ibm.xml.xci.dp.values.chars.Chars")) {
                    generatedCode = this.genCode_UNARY_ARRAY_LENGTH_CHARSEQUENCE(operand2);
                    break;
                }
                if (operand2.getType() instanceof FcgArrayType) {
                    generatedCode = this.genCode_UNARY_ARRAY_LENGTH_ARRAY(operand2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 307: {
                if (operandType == FcgType.STRING) {
                    generatedCode = this.genCode_UNARY_TO_CHAR_ARRAY_STRING(operand2, operandType);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            default: {
                FinalCodeGenerator.unimplementedException();
            }
        }
        return generatedCode;
    }

    protected abstract Object genCode_UNARY_ABS_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_INT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_ARRAY(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_CHARSEQUENCE(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_STRING(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_INT(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_INT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_INT(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__LONG(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_INT(StackValue var1);

    protected abstract Object genCode_UNARY_LOGICAL_NOT(StackValue var1);

    protected abstract Object gencode_UNARY_NEGATE_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_INT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_INT(StackValue var1);

    protected abstract Object genCode_UNARY_TO_CHAR_ARRAY_STRING(StackValue var1, FcgType var2);

    protected abstract Object genCode_TERNARY_IF_ELSE(StackValue var1, StackValue var2, StackValue var3, FcgType var4);

    private final Object genCode_ternaryOperation(FcgTerOp op2, StackValue leftOperand, StackValue midOperand, StackValue rightOperand, FcgType resultType) {
        Object generatedCode;
        FcgType leftType = leftOperand.getType();
        FcgType rightType = rightOperand.getType();
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        switch (fcgOpCode) {
            case 309: {
                generatedCode = this.genCode_TERNARY_IF_ELSE(leftOperand, midOperand, rightOperand, resultType);
                break;
            }
            default: {
                String msg = "unexpected op-code for a ternary operation: " + op2 + " " + op2.toString();
                FinalCodeGenerator.unimplementedException(msg);
                generatedCode = null;
            }
        }
        return generatedCode;
    }

    private final Object genCode_binaryOperation(FcgBinOp op2, StackValue leftOperand, StackValue rightOperand, FcgType resultType) {
        Object generatedCode;
        FcgType leftType = leftOperand.getType();
        FcgType rightType = rightOperand.getType();
        int fcgOpCode = ((Operation)((Object)op2)).getFcgOpCode();
        switch (fcgOpCode) {
            case 100: {
                if ((leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL) && leftType == rightType) {
                    generatedCode = this.genCode_BINARY_ADD_BIG(leftOperand, rightOperand);
                    break;
                }
                if (leftType == FcgType.STRING) {
                    generatedCode = this.genCode_BINARY_ADD_STRING(leftOperand, rightOperand);
                    break;
                }
                generatedCode = this.genCode_BINARY_ADD(leftOperand, rightOperand, resultType, fcgOpCode);
                break;
            }
            case 101: {
                if ((leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL) && leftType == rightType) {
                    generatedCode = this.genCode_BINARY_SUBTRACT_BIG(leftOperand, rightOperand);
                    break;
                }
                generatedCode = this.genCode_BINARY_SUBTRACT(leftOperand, rightOperand, resultType, fcgOpCode);
                break;
            }
            case 102: {
                if ((leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL) && leftType == rightType) {
                    generatedCode = this.genCode_BINARY_MULTIPLY_BIG(leftOperand, rightOperand, resultType, fcgOpCode);
                    break;
                }
                generatedCode = this.genCode_BINARY_MULTIPLY(leftOperand, rightOperand, resultType, fcgOpCode);
                break;
            }
            case 103: {
                if ((leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL) && leftType == rightType) {
                    generatedCode = this.genCode_BINARY_DIVIDE_BIG(leftOperand, rightOperand);
                    break;
                }
                generatedCode = this.genCode_BINARY_DIVIDE(leftOperand, rightOperand, resultType, fcgOpCode);
                break;
            }
            case 104: {
                if (leftType == FcgType.BIG_INTEGER && rightType == FcgType.BIG_INTEGER) {
                    generatedCode = this.genCode_BINARY_MODULO_BIG(leftOperand, rightOperand);
                    break;
                }
                generatedCode = this.genCode_BINARY_MODULO(leftOperand, rightOperand, resultType, fcgOpCode);
                break;
            }
            case 110: {
                generatedCode = this.genCode_BINARY_SHIFT_LEFT(leftOperand, rightOperand, resultType);
                break;
            }
            case 111: {
                generatedCode = this.genCode_BINARY_SHIFT_RIGHT(leftOperand, rightOperand, resultType);
                break;
            }
            case 112: {
                generatedCode = this.genCode_BINARY_SHIFT_RIGHT_UNSIGNED(leftOperand, rightOperand, resultType);
                break;
            }
            case 114: {
                generatedCode = this.genCode_BINARY_BITWISE_AND(leftOperand, rightOperand, resultType);
                break;
            }
            case 115: {
                generatedCode = this.genCode_BINARY_BITWISE_OR(leftOperand, rightOperand, resultType);
                break;
            }
            case 116: {
                if (leftType == FcgType.BIG_INTEGER) {
                    generatedCode = this.genCode_BINARY_BITWISE_XOR_BIG(leftOperand, rightOperand, resultType);
                    break;
                }
                generatedCode = this.genCode_BINARY_BITWISE_XOR(leftOperand, rightOperand, resultType);
                break;
            }
            case 150: {
                generatedCode = this.genCode_BINARY_COMPARE_EQ_REFERENCE(leftOperand, rightOperand, leftType, rightType);
                break;
            }
            case 157: {
                generatedCode = this.genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(leftOperand, rightOperand, leftType, rightType);
                break;
            }
            case 151: {
                if (leftType == FcgType.STRING || rightType == FcgType.STRING) {
                    generatedCode = this.genCode_BINARY_COMPARE_EQ_STRING(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                if (leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL || rightType == FcgType.BIG_INTEGER || rightType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_BINARY_COMPARE_EQ_BIG(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                if (leftType instanceof FcgReferenceType || rightType instanceof FcgReferenceType) {
                    generatedCode = this.genCode_BINARY_COMPARE_EQ_REFERENCE(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                generatedCode = this.genCode_BINARY_COMPARE_EQ_PRIMITIVE(leftOperand, rightOperand, leftType, rightType);
                break;
            }
            case 152: {
                if (leftType == FcgType.STRING || rightType == FcgType.STRING) {
                    generatedCode = this.genCode_BINARY_COMPARE_NOT_EQ_STRING(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                if (leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL || rightType == FcgType.BIG_INTEGER || rightType == FcgType.BIG_DECIMAL) {
                    generatedCode = this.genCode_BINARY_COMPARE_NOT_EQ_BIG(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                if (leftType instanceof FcgReferenceType || rightType instanceof FcgReferenceType) {
                    generatedCode = this.genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(leftOperand, rightOperand, leftType, rightType);
                    break;
                }
                generatedCode = this.genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(leftOperand, rightOperand, leftType, rightType);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                if ((leftType == FcgType.BIG_INTEGER || leftType == FcgType.BIG_DECIMAL) && leftType == rightType) {
                    generatedCode = this.genCode_BINARY_COMPARE_ORDER_BIG(leftOperand, rightOperand, leftType, rightType, fcgOpCode);
                    break;
                }
                if (leftType == FcgType.STRING && rightType == FcgType.STRING) {
                    generatedCode = this.genCode_BINARY_COMPARE_ORDER_STRING(leftOperand, rightOperand, fcgOpCode);
                    break;
                }
                generatedCode = this.genCode_BINARY_COMPARE_ORDER_PRIMITIVE(leftOperand, rightOperand, leftType, rightType, fcgOpCode);
                break;
            }
            case 202: {
                generatedCode = this.genCode_BINARY_LOGICAL_AND_EVALBOTH(leftOperand, rightOperand);
                break;
            }
            case 203: {
                generatedCode = this.genCode_BINARY_LOGICAL_OR_EVALBOTH(leftOperand, rightOperand);
                break;
            }
            case 204: {
                generatedCode = this.genCode_BINARY_LOGICAL_XOR(leftOperand, rightOperand);
                break;
            }
            case 205: {
                generatedCode = this.genCode_BINARY_LOGICAL_CONDITIONAL_AND(leftOperand, rightOperand);
                break;
            }
            case 206: {
                generatedCode = this.genCode_BINARY_LOGICAL_CONDITIONAL_OR(leftOperand, rightOperand);
                break;
            }
            default: {
                String msg = "unexpected op-code for a binary operation: " + op2 + " " + op2.toString();
                FinalCodeGenerator.unimplementedException(msg);
                generatedCode = null;
            }
        }
        return generatedCode;
    }

    protected abstract Object genCode_BINARY_ADD(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_ADD_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_ADD_STRING(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_BITWISE_AND(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_OR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR_BIG(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_COMPARE_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_STRING(StackValue var1, StackValue var2, int var3);

    protected abstract Object genCode_BINARY_DIVIDE(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_DIVIDE_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_AND_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_AND(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_OR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_OR_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_XOR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MODULO(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MODULO_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MULTIPLY(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MULTIPLY_BIG(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SHIFT_LEFT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT_UNSIGNED(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SUBTRACT(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SUBTRACT_BIG(StackValue var1, StackValue var2);

    protected final Object genCode_coerce(FcgType fromType, FcgType toType, StackValue valToCoerce) {
        Object generatedCode;
        if (fromType == toType) {
            return valToCoerce.getCodeData();
        }
        FcgCoercionTable.FcgCoercion coercian = FcgCoercionTable.getCoercian(fromType, toType);
        if (coercian != null) {
            Object generatedCode2 = coercian.getCoercion(this, valToCoerce);
            return generatedCode2;
        }
        if (fromType instanceof FcgReferenceType) {
            if (toType instanceof FcgArrayType) {
                generatedCode = this.genCode_COERCE_2REFERENCE_TYPE(toType, valToCoerce);
            } else if (toType instanceof FcgClassReferenceType || toType instanceof FcgInterfaceType) {
                generatedCode = this.genCode_COERCE_2REFERENCE_TYPE2(toType, valToCoerce);
            } else if (fromType == FcgType.OBJECT && !(toType instanceof FcgReferenceType)) {
                generatedCode = this.genCode_COERCE_2PRIMITIVE_TYPE(toType, valToCoerce);
            } else {
                FinalCodeGenerator.unimplementedException();
                generatedCode = null;
            }
        } else if (toType instanceof FcgClassReferenceType || toType instanceof FcgInterfaceType) {
            generatedCode = this.genCode_COERCE_2REFERENCE_TYPE(toType, valToCoerce);
        } else if (toType == FcgType.OBJECT) {
            generatedCode = valToCoerce.getCodeData();
        } else {
            FinalCodeGenerator.unimplementedException();
            generatedCode = null;
        }
        return generatedCode;
    }

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE2(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_2PRIMITIVE_TYPE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BIG_INTEGER(FcgType var1, FcgType var2, StackValue var3);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2FLOAT(FcgType var1, FcgType var2, StackValue var3);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2INT(FcgType var1, FcgType var2, StackValue var3);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2SHORT(FcgType var1, FcgType var2, StackValue var3);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BIG_DECIMAL(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2FLOAT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2INT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2SHORT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BOOLEAN2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_INT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_INT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_INT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BIG_INTEGER(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2INT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2OBJECT(StackValue var1);

    protected abstract Object genCode_COERCE_STRING2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_CHARSEQUENCE2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(StackValue var1);

    protected abstract boolean checkForUnreachable(StackValue var1);

    public static final class UnaryOp
    extends Operation
    implements FcgUnaryOp {
        public UnaryOp(String name2, int fcgOpCode) {
            super(name2, fcgOpCode);
        }
    }

    public static final class BinaryOp
    extends Operation
    implements FcgBinOp {
        public BinaryOp(String name2, int fcgOpCode) {
            super(name2, fcgOpCode);
        }
    }

    public static final class TernaryOp
    extends Operation
    implements FcgTerOp {
        public TernaryOp(String name2, int fcgOpCode) {
            super(name2, fcgOpCode);
        }
    }

    private static class Operation
    implements FcgOperation {
        private static HashMap s_opCodes = new HashMap();
        private final String m_name;
        private final int m_opCode;

        private Operation(String name2, int fcgOpCode) {
            String oldname;
            this.m_name = name2;
            this.m_opCode = fcgOpCode;
            String sop = Integer.toString(fcgOpCode);
            if (DO_COMPILE_CHECKING && (oldname = (String)s_opCodes.get(sop)) != null) {
                String msg = "FinalCodeGenerator: opcode " + sop + " already in use by '" + oldname + "', now wants to be used by '" + name2;
                throw new RuntimeException(msg);
            }
            s_opCodes.put(sop, name2);
        }

        private int getFcgOpCode() {
            return this.m_opCode;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private final class LocalVarStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private FcgVarMutableInternal[] m_stackArr = new FcgVarMutableInternal[16];

        private int numLocalVars() {
            return this.m_freeIndex;
        }

        private LocalVarStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private FcgVariable push(String varName, FcgType type2, FcgAttrs attrs) {
            FcgVarMutableInternal nextFreeEntry;
            int currStackSize = this.m_stackArr.length;
            if (this.m_freeIndex == currStackSize) {
                FcgVarMutableInternal[] newStackArr = new FcgVarMutableInternal[currStackSize * 2];
                System.arraycopy(this.m_stackArr, 0, newStackArr, 0, currStackSize);
                this.m_stackArr = newStackArr;
            }
            if ((nextFreeEntry = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = nextFreeEntry = FinalCodeGenerator.this.newFcgVariable();
            }
            nextFreeEntry.setName(varName);
            nextFreeEntry.setType(type2);
            nextFreeEntry.setAttrs(attrs);
            ++this.m_freeIndex;
            return nextFreeEntry;
        }

        private void pop(String varName) {
            String poppedName;
            int top = --this.m_freeIndex;
            if (DO_COMPILE_CHECKING && !varName.equals(poppedName = this.m_stackArr[top].getName())) {
                FinalCodeGenerator.error("FCG: Popped a variable named '" + poppedName + "' but expected to pop one named '" + varName + "'.");
            }
        }

        FcgType getVarType(String varName) {
            FcgType ret = null;
            if (varName.equals("__should_never_be_used__")) {
                ret = FcgType.VOID;
                return ret;
            }
            for (int idx = this.m_freeIndex - 1; 0 <= idx; --idx) {
                if (!varName.equals(this.m_stackArr[idx].getName())) continue;
                ret = this.m_stackArr[idx].getType();
                break;
            }
            if (ret != null) {
                return ret;
            }
            if (ret == null) {
                ret = FcgType.OBJECT;
            }
            if (DO_COMPILE_CHECKING && ret == null) {
                FinalCodeGenerator.error("FCG: failed to find variable named '" + varName + "'");
            }
            return ret;
        }

        private FcgVariable peek() {
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("LocalVarStack:\n");
            if (this.size() == 0) {
                sb.append("  *** EMPTY ***");
            } else {
                for (int i = this.size() - 1; 0 <= i; --i) {
                    sb.append("  * ");
                    sb.append(this.m_stackArr[i].toString());
                    sb.append('\n');
                }
            }
            return sb.toString();
        }
    }

    protected static final class CodeGenStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private StackValue[] m_stackArr = new StackValue[16];

        private CodeGenStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private void push(Construct c, FcgType t, Object codeData, int numLocalVars) {
            StackValue nextFreeEntry;
            int currStackSize = this.m_stackArr.length;
            if (this.m_freeIndex == currStackSize) {
                StackValue[] newStackArr = new StackValue[currStackSize * 2];
                System.arraycopy(this.m_stackArr, 0, newStackArr, 0, currStackSize);
                this.m_stackArr = newStackArr;
            }
            if ((nextFreeEntry = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = nextFreeEntry = new StackValue();
            } else if (DO_COMPILE_CHECKING && nextFreeEntry.needsReset()) {
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + nextFreeEntry);
            }
            if (debug_reset) {
                System.out.println("push: " + nextFreeEntry);
            }
            nextFreeEntry.setConstructKind(c);
            nextFreeEntry.setType(t);
            nextFreeEntry.setCodeData(codeData);
            nextFreeEntry.setNumLocalVars(numLocalVars);
            ++this.m_freeIndex;
            if (debug_reset) {
                for (int i = this.m_freeIndex; i < this.m_stackArr.length - 1; ++i) {
                    if (this.m_stackArr[i] == null || !this.m_stackArr[i].needsReset()) continue;
                    FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + this.m_stackArr[i]);
                }
            }
        }

        private Construct peekAtConstructKind() {
            return this.m_stackArr[this.m_freeIndex - 1].getConstructKind();
        }

        private FcgType peekAtType() {
            return this.m_stackArr[this.m_freeIndex - 1].getType();
        }

        private StackValue peek() {
            if (this.m_freeIndex == 0) {
                return null;
            }
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        private StackValue peek(Construct expectedConstructKind) {
            if (DO_COMPILE_CHECKING) {
                Construct peeked = this.peekAtConstructKind();
                if (this.peekAtConstructKind() != expectedConstructKind) {
                    String msg = "FCG: Construct on top of the FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + expectedConstructKind.toString();
                    FinalCodeGenerator.error(msg);
                }
            }
            StackValue val = this.peek();
            return val;
        }

        private StackValue peek(int stackDepth) {
            return this.m_stackArr[this.m_freeIndex - 1 - stackDepth];
        }

        private StackValue pop(Construct expectedConstructKind) {
            if (DO_COMPILE_CHECKING && this.peekAtConstructKind() != expectedConstructKind) {
                String msg = "FCG: Popped construct from the top of FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + expectedConstructKind.toString();
                FinalCodeGenerator.error(msg);
            }
            --this.m_freeIndex;
            StackValue sv = this.m_stackArr[this.m_freeIndex];
            if (debug_reset) {
                System.out.println("pop: " + sv);
            }
            return sv;
        }

        public StackValue peekAtStackValue(int i) {
            return this.m_stackArr[i];
        }

        private void assertStackIsEmpty() {
            if (this.m_freeIndex != 0) {
                FinalCodeGenerator.error("FCG: Code generation stack is not empty at end of code generation!");
            }
            for (int i = 0; i < this.m_stackArr.length && this.m_stackArr[i] != null; ++i) {
                if (!this.m_stackArr[i].needsReset()) continue;
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset!");
            }
        }
    }

    public static class Construct {
        final String m_name;

        private Construct(String name2) {
            this.m_name = name2;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static final class StackValue {
        private static int s_id_counter;
        private int m_id;
        private Construct m_constructKind;
        private FcgType m_valueType;
        private Object m_codeData;
        private int m_numLocalVars;
        private boolean m_needsReset = false;
        private int m_int_literal = 0;

        private StackValue() {
            if (debug_reset) {
                this.m_id = ++s_id_counter;
            }
        }

        public Object clone() {
            StackValue sv = new StackValue();
            sv.m_constructKind = this.m_constructKind;
            sv.m_valueType = this.m_valueType;
            sv.m_codeData = this.m_codeData;
            sv.m_numLocalVars = this.m_numLocalVars;
            sv.m_needsReset = this.m_needsReset;
            return sv;
        }

        public void reset() {
            this.m_constructKind = null;
            this.m_valueType = FcgBasicType.VOID;
            this.m_codeData = null;
            this.m_numLocalVars = 0;
            this.m_needsReset = false;
            if (debug_reset) {
                System.out.println("reset: " + this);
            }
        }

        private void setConstructKind(Construct c) {
            this.m_constructKind = c;
            this.m_needsReset = true;
        }

        public Construct getConstructKind() {
            return this.m_constructKind;
        }

        private void setType(FcgType t) {
            this.m_valueType = t == null ? FcgBasicType.VOID : t;
            this.m_needsReset = true;
        }

        private void setLiteralValue(int i) {
            this.m_int_literal = i;
            this.m_needsReset = true;
        }

        public FcgType getType() {
            return this.m_valueType;
        }

        private int getIntLiteralValue() {
            return this.m_int_literal;
        }

        private void setCodeData(Object codeData) {
            this.m_codeData = codeData;
        }

        public Object getCodeData() {
            return this.m_codeData;
        }

        private int getNumLocalVars() {
            return this.m_numLocalVars;
        }

        private void setNumLocalVars(int num) {
            this.m_numLocalVars = num;
        }

        private boolean needsReset() {
            return this.m_needsReset;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("StackValue#" + this.m_id + " ");
            if (this.m_constructKind != null) {
                sb.append(this.m_constructKind.toString()).append(' ');
            }
            if (this.m_valueType != null) {
                sb.append(((Object)this.m_valueType).toString()).append(' ');
            }
            if (this.m_codeData != null) {
                sb.append(this.m_codeData.toString()).append(' ');
            }
            if (this.m_valueType == INT_LITERAL) {
                sb.append(" int literal: ").append(this.m_int_literal).append(' ');
            }
            sb.append('\n');
            return sb.toString();
        }
    }
}

