/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class HiddenOptions {
    private static final HashMap sOptions;
    private static final boolean sDebugMe;
    private static final String DEBUG_PROPERTY = "com.ibm.xltxe.rnm1.xylem.debugopt";

    private HiddenOptions() {
    }

    private static void installOptions(HashMap optionsMap, String options) {
        ArrayList<String> optionStack = new ArrayList<String>();
        ArrayList<String> valueStack = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(options, ":()", true);
        boolean processedValue = true;
        String currentOption = "";
        String currentValue = "";
        int parenCount = 0;
        optionStack.add("");
        valueStack.add("");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (":".equals(token)) {
                if (parenCount > 0) {
                    currentValue = currentValue + token;
                }
                if (processedValue) continue;
                optionsMap.put(currentOption, null);
                currentOption = optionStack.get(optionStack.size() - 1);
                continue;
            }
            if ("(".equals(token)) {
                valueStack.add(currentValue + token);
                optionStack.add(currentOption);
                currentValue = "";
                ++parenCount;
                continue;
            }
            if (")".equals(token)) {
                if (!processedValue) {
                    optionsMap.put(currentOption, null);
                }
                currentOption = optionStack.remove(optionStack.size() - 1);
                optionsMap.put(currentOption, currentValue);
                currentOption = optionStack.get(optionStack.size() - 1);
                int newValueStackSize = valueStack.size() - 1;
                currentValue = valueStack.remove(newValueStackSize).toString() + currentValue + token;
                valueStack.add(currentValue);
                --parenCount;
                processedValue = true;
                continue;
            }
            if (parenCount > 0) {
                currentValue = currentValue + token;
            }
            currentOption = currentOption.equals("") ? token : currentOption + "." + token;
            processedValue = false;
        }
        if (!processedValue && !currentOption.equals("")) {
            optionsMap.put(currentOption, null);
        }
    }

    public static boolean wasSpecified(String option) {
        boolean optionSeen;
        boolean bl = optionSeen = sOptions != null ? sOptions.containsKey(option) : false;
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling wasSpecified(\"" + option + "\"); result == " + optionSeen);
        }
        return optionSeen;
    }

    public static Boolean getBooleanValue(String option) {
        Boolean optionValue;
        String stringValue = sOptions != null ? (String)sOptions.get(option) : null;
        Boolean bl = optionValue = stringValue != null ? Boolean.valueOf(stringValue) : null;
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling getBooleanValue(\"" + option + "\"); result ==  " + optionValue);
        }
        return optionValue;
    }

    public static String getStringValue(String option, String defaultVal) {
        String optionValue;
        String string2 = optionValue = sOptions != null ? (String)sOptions.get(option) : defaultVal;
        if (optionValue == null) {
            optionValue = defaultVal;
        }
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling getStringValue(\"" + option + "\"); result ==  \"" + optionValue + "\"");
        }
        return optionValue;
    }

    public static String getStringValue(String option) {
        String optionValue;
        String string2 = optionValue = sOptions != null ? (String)sOptions.get(option) : null;
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling getStringValue(\"" + option + "\"); result ==  \"" + optionValue + "\"");
        }
        return optionValue;
    }

    public static boolean optionValueIs(String option, String value2) {
        String optionValue = HiddenOptions.getStringValue(option);
        boolean ret = value2.equals(optionValue);
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling stringValueIs(\"" + option + "\", \"" + value2 + "\"); result ==  " + ret);
        }
        return ret;
    }

    public static Integer getIntegerValue(String option) {
        String stringValue = sOptions != null ? (String)sOptions.get(option) : null;
        Integer optionValue = null;
        if (stringValue != null) {
            try {
                optionValue = Integer.valueOf(stringValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling getIntegerValue(\"" + option + "\"); result ==  " + optionValue);
        }
        return optionValue;
    }

    public static Integer getIntegerValue(String option, int defaultVal) {
        Integer optionValue;
        String stringValue;
        String string2 = stringValue = sOptions != null ? (String)sOptions.get(option) : null;
        if (stringValue != null) {
            try {
                optionValue = Integer.valueOf(stringValue);
            }
            catch (Throwable t) {
                optionValue = defaultVal;
            }
        } else {
            optionValue = defaultVal;
        }
        if (sDebugMe) {
            System.err.println(HiddenOptions.class.getName() + ":  Calling getIntegerValue(\"" + option + "\"); result ==  " + optionValue);
        }
        return optionValue;
    }

    private static String dump() {
        return sOptions != null ? sOptions.toString() : "{}";
    }

    static {
        String debugOptions = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(HiddenOptions.DEBUG_PROPERTY);
            }
        });
        boolean forceDebuggingForMe = false;
        if (debugOptions != null) {
            sOptions = new HashMap();
            try {
                HiddenOptions.installOptions(sOptions, debugOptions);
            }
            catch (Throwable t) {
                forceDebuggingForMe = true;
            }
            boolean bl = sDebugMe = forceDebuggingForMe || HiddenOptions.wasSpecified("HiddenOptions");
            if (sDebugMe) {
                System.err.println(HiddenOptions.class.getName() + ":  value of " + DEBUG_PROPERTY + " == " + debugOptions);
                System.err.println(HiddenOptions.class.getName() + ":  options " + HiddenOptions.dump());
            }
        } else {
            sOptions = null;
            sDebugMe = forceDebuggingForMe;
        }
    }
}

