/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.javasrc;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassCollector;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgField;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgBasicType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FcgFieldGenImpl;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgFieldJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgInstructionListJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgMethodGenJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgTraceBack;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public class FcgClassGenJavaSrc
extends FcgClassGenImpl
implements FcgClassGen {
    protected FcgClassReferenceType m_classReference;
    protected FcgClassReferenceType m_superClassReference;
    protected String m_fileName;
    protected String m_className;
    protected String m_packageName;
    protected FcgAttrs m_attrs;
    protected ArrayList attribute_vec = new ArrayList();
    protected ArrayList interface_vec = new ArrayList();
    FcgTraceBack m_traceBack = FcgTraceBack.TRACECOMMENTSENABLED ? new FcgTraceBack() : null;
    protected int m_numberOfClassFields;
    FcgInstructionList m_classLoad;
    FcgMethodGen m_staticCode;
    private boolean m_defaultConstructorAdded = false;
    public static final char[] m_eol = System.getProperty("line.separator").toCharArray();

    public FcgClassGenJavaSrc(FcgCodeGen cg, FcgClassReferenceType clazz, FcgClassReferenceType superClazz, String fileName, FcgAttrs attrs, String[] interfaces) {
        super(cg);
        if (FcgTraceBack.TRACECOMMENTSENABLED) {
            this.m_traceBack.recordTrace();
        }
        this.m_classReference = clazz;
        this.m_superClassReference = superClazz;
        this.m_fileName = fileName;
        this.m_attrs = attrs;
        String qualifiedClassName = clazz.getTypeName();
        int lastDot = qualifiedClassName.lastIndexOf(46);
        if (lastDot > 0) {
            this.m_className = qualifiedClassName.substring(lastDot + 1);
            this.m_packageName = qualifiedClassName.substring(0, lastDot);
        } else {
            this.m_className = qualifiedClassName;
            this.m_packageName = null;
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.interface_vec.add(interfaces[i]);
            }
        }
    }

    @Override
    public void dump(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        this.dump(out);
        ((Writer)out).close();
    }

    public void dump(Writer out) throws IOException {
        int numInterfaces;
        if (FcgTraceBack.TRACECOMMENTSENABLED) {
            this.m_traceBack.comment(out, false);
        }
        if (this.m_packageName != null) {
            out.write("package ");
            out.write(this.m_packageName);
            out.write(59);
            out.write(m_eol);
        }
        String attrs = this.createAttrDeclaration(this.m_attrs);
        out.write(attrs);
        out.write("class ");
        out.write(this.m_className);
        if (this.m_superClassReference != null) {
            out.write(" extends ");
            out.write(this.m_superClassReference.getTypeName());
        }
        if (0 < (numInterfaces = this.interface_vec.size())) {
            out.write(" implements ");
            for (int i = 0; i < numInterfaces; ++i) {
                if (0 < i) {
                    out.write(44);
                }
                out.write((String)this.interface_vec.get(i));
            }
        }
        this.dumpContents(out);
    }

    public void dumpContents(Writer out) throws IOException {
        int i;
        out.write(" {");
        out.write(m_eol);
        for (i = 0; i < super.getNumFcgFields(); ++i) {
            FcgField fg = super.getField(i);
            ((FcgFieldGenImpl)fg).dump(out);
        }
        if (this.m_classLoad != null) {
            out.write("  static {");
            out.write(m_eol);
            StringBuffer sb = ((FcgInstructionListJavaSrc)this.m_classLoad).getCode();
            out.write(sb.toString());
            out.write("  }");
            out.write(m_eol);
        }
        for (i = 0; i < this.method_vec.size(); ++i) {
            FcgMethodGenJavaSrc m = (FcgMethodGenJavaSrc)this.method_vec.get(i);
            m.dump(out);
        }
        out.write("}");
        out.write(m_eol);
    }

    @Override
    public void dump(OutputStream os) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        this.dump(out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public String getClassName() {
        return this.m_classReference.getTypeName();
    }

    @Override
    public String getSuperClassName() {
        return this.m_superClassReference.getTypeName();
    }

    @Override
    public FcgClassReferenceType getClassType() {
        return this.m_classReference;
    }

    @Override
    public FcgClassReferenceType getSuperClassType() {
        return this.m_superClassReference;
    }

    @Override
    public FcgInstructionList newInstructionList() {
        return new FcgInstructionListJavaSrc(this);
    }

    @Override
    public FcgInstructionList newInstructionList(FcgMethodGen method) {
        return new FcgInstructionListJavaSrc(this, method);
    }

    @Override
    public FcgInstructionList getClassInstructionList() {
        if (this.m_classLoad == null) {
            this.m_classLoad = new FcgInstructionListJavaSrc(this);
        }
        return this.m_classLoad;
    }

    protected String createAttrDeclaration(FcgAttrs attributes2) {
        String ret = attributes2 == null ? "public " : this.toString(attributes2);
        return ret;
    }

    protected String toString(FcgAttrs attr2) {
        StringBuffer sb = new StringBuffer();
        if (attr2.isAbstract()) {
            sb.append("abstract ");
        }
        if (attr2.isFinal()) {
            sb.append("final ");
        }
        if (attr2.isPublic()) {
            sb.append("public ");
        }
        if (attr2.isPrivate()) {
            sb.append("private ");
        }
        if (attr2.isProtected()) {
            sb.append("protected ");
        }
        if (attr2.isStatic()) {
            sb.append("static ");
        }
        String ret = sb.toString();
        return ret;
    }

    String createDeclaration(String name2, FcgAttrs declarationAttributes, FcgType t) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.createAttrDeclaration(declarationAttributes));
        sb.append(this.fcgType2Name(t));
        sb.append(' ');
        sb.append(name2);
        return sb.toString();
    }

    @Override
    public FcgMethodGen getClassInitMethod() {
        if (this.m_staticCode == null) {
            this.m_staticCode = new FcgMethodGenJavaSrc(this, null, null, this.m_classReference, null, null);
        }
        return this.m_staticCode;
    }

    @Override
    public FcgField newInstanceField(FcgAttrs attrs, FcgType type2, String string2) {
        if (attrs == null) {
            attrs = FcgAttrs.PUBLIC;
        }
        FcgFieldJavaSrc f2 = new FcgFieldJavaSrc(this, attrs, type2, string2);
        super.addField(f2);
        return f2;
    }

    @Override
    public FcgField newClassField(FcgAttrs attrs, FcgType type2, String string2) {
        if (attrs == null) {
            attrs = FcgAttrs.PUBLIC_STATIC;
        }
        FcgFieldJavaSrc f2 = new FcgFieldJavaSrc(this, attrs, type2, string2);
        super.addField(f2);
        ++this.m_numberOfClassFields;
        return f2;
    }

    @Override
    public int getNumberOfClassFields() {
        return this.m_numberOfClassFields;
    }

    @Override
    public FcgMethodGen newConstructorGen(FcgAttrs attrs) {
        FcgMethodGenJavaSrc mg = new FcgMethodGenJavaSrc(this, attrs, null, this.m_fcgCodeGen.getClassReferenceType(this.m_className), null, null);
        return mg;
    }

    public FcgMethodGen newMethodGen(FcgAttrs attrs, FcgType retType, FcgReferenceType className, String methodName, FcgType[] exceptionsThrown, FcgInstructionList il) {
        FcgMethodGenJavaSrc mg = new FcgMethodGenJavaSrc(this, attrs, retType, className, methodName, il);
        return mg;
    }

    public FcgMethodGen newMethodGen(FcgAttrs attrs, FcgBasicType retType, String methName, FcgInstructionList il) {
        FcgMethodGen mg = this.newMethodGen(attrs, retType, methName, il);
        return mg;
    }

    @Override
    public void comment(String com) {
    }

    @Override
    public void finish() {
    }

    @Override
    public FcgMethodGen newMethodGen(FcgAttrs attrs, FcgType retType, String methodName, FcgInstructionList il) {
        FcgClassReferenceType className = this.getClassType();
        FcgMethodGenJavaSrc mg = new FcgMethodGenJavaSrc(this, attrs, retType, className, methodName, il);
        return mg;
    }

    @Override
    public FcgCodeGen getFcgCodeGen() {
        return this.m_fcgCodeGen;
    }

    public FcgMethodGen newConstructorGen(FcgAttrs accessAttrs, String ctorName, FcgInstructionList il) {
        FcgMethodGenJavaSrc mg = new FcgMethodGenJavaSrc(this, il);
        return mg;
    }

    @Override
    public void addDefaultConstructor(FcgCodeGen cg) {
        this.addDefaultConstructor(cg, null);
    }

    @Override
    public void addDefaultConstructor(FcgCodeGen cg, FcgInstructionList body) {
        this.m_defaultConstructorAdded = true;
        String className = this.getClassName();
        FcgMethodGen ctor = this.newConstructorGen(FcgAttrs.PUBLIC, className, body);
        FcgInstructionList il = ctor.getInstructionList();
        il.beginMethod();
        il.endMethod();
    }

    @Override
    public void addInterface(String interfaceName) {
        if (!this.interface_vec.contains(interfaceName)) {
            this.interface_vec.add(interfaceName);
        }
    }

    public FcgMethodGen getCurrentMethod() {
        return null;
    }

    public void setCurrentMethod(FcgMethodGen m) {
    }

    @Override
    public FcgMethodGen newMethodGen(FcgAttrs acc, FcgType retType, String methodName) {
        return this.newMethodGen(acc, retType, methodName, (FcgInstructionList)null);
    }

    public static FcgClassCollector newClassCollector(final File outputDir) {
        return new FcgClassCollector(){

            @Override
            public void acceptGeneratedClass(FcgClassGen jc) {
                try {
                    String outputFileName = jc.getClassType().getTypeName() + ".java";
                    File outputFile = new File(outputDir, outputFileName);
                    jc.dump(outputFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

