/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.javasrc;

import com.ibm.xltxe.rnm1.fcg.FcgArrayType;
import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.ifacecore.FcgVarMutableInternal;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgLoopBuilderJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgTraceBack;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class FcgInstructionListJavaSrc
extends FinalCodeGenerator
implements FcgInstructionList {
    protected final FcgClassGen m_classGen;
    protected final StringBuffer m_code = new StringBuffer();
    private String _classname;
    protected boolean m_staticContext = false;
    protected final HashMap m_operatorMapsToMethod = new HashMap();
    protected final StringBuffer m_debugBuf;
    FcgTraceBack m_traceBack = FcgTraceBack.TRACECOMMENTSENABLED ? new FcgTraceBack() : null;
    protected boolean m_atStartOfLine = true;
    protected boolean m_useParentIndentLevel = false;
    HashMap m_Name2Type = new HashMap();

    public FcgInstructionListJavaSrc(FcgClassGenJavaSrc classGen) {
        super(classGen);
        this.m_debugBuf = new StringBuffer();
        this.m_classGen = classGen;
    }

    public FcgInstructionListJavaSrc(FcgClassGenJavaSrc classGen, FcgMethodGen method) {
        super(classGen, method);
        this.m_debugBuf = new StringBuffer();
        this.m_classGen = classGen;
    }

    private FcgInstructionListJavaSrc() {
        super(null);
        this.m_debugBuf = null;
        this.m_classGen = null;
    }

    @Override
    protected void genCode_comment(String comment2) {
        boolean multi_line = false;
        this.print(this.m_code, "/*");
        if (comment2 != null) {
            char[] chars = comment2.toCharArray();
            block4: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '*': {
                        if (i + 1 >= chars.length || chars[i + 1] != '/') continue block4;
                        this.print(this.m_code, '@');
                        continue block4;
                    }
                    case '\n': {
                        this.println(this.m_code, "");
                        multi_line = true;
                        this.print(this.m_code, " * ");
                        continue block4;
                    }
                    default: {
                        this.print(this.m_code, c);
                    }
                }
            }
            if (multi_line) {
                this.println(this.m_code, "");
                this.print(this.m_code, " ");
            }
        } else {
            this.print(this.m_code, ' ');
        }
        this.println(this.m_code, "*/");
    }

    @Override
    protected final void genCode_defineLocalVariable(FinalCodeGenerator.StackValue outerConstruct, FcgVariable var, FinalCodeGenerator.StackValue varValue) {
        FcgAttrs varAttrs = var.getAttrs();
        if (varAttrs == null) {
            varAttrs = FcgAttrs.NONE;
        }
        String varName = var.getName();
        FcgType t = var.getType();
        this.print(this.m_code, ((FcgClassGenJavaSrc)this.m_classGen).createDeclaration(varName, varAttrs, t));
        if (varValue != null) {
            this.print(this.m_code, " = ");
            this.print(this.m_code, varValue.getCodeData());
        }
        this.println(this.m_code, ';');
    }

    @Override
    protected final void genCode_undefineLocalVariable(FinalCodeGenerator.StackValue outerConstruct, FcgVariable var) {
    }

    @Override
    protected void genCode_printOut(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue str) {
        this.print(this.m_code, "System.out.println(");
        this.print(this.m_code, str.getCodeData());
        this.println(this.m_code, ");");
    }

    @Override
    protected void genCode_printErr(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue str) {
        this.print(this.m_code, "System.err.println(");
        this.print(this.m_code, str.getCodeData());
        this.println(this.m_code, ");");
        this.println(this.m_code, "System.err.flush();");
    }

    @Override
    protected void genCode_endMethod(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue method) {
    }

    @Override
    protected void genCode_endClass(FinalCodeGenerator.StackValue val) {
    }

    @Override
    protected Object genCode_loadInstanceField(FinalCodeGenerator.StackValue objRef, FcgClassReferenceType classType, String varName, FcgType varType) {
        String objRefCode = (String)objRef.getCodeData();
        String code = "this".equals(objRefCode) ? "this." + varName : "(" + objRefCode + ")." + varName;
        return code;
    }

    @Override
    protected Object genCode_loadClassVariable(String className, String fieldName, FcgType type2) {
        String code = className + '.' + fieldName;
        return code;
    }

    @Override
    protected Object genCode_loadThis() {
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && this.m_staticContext) {
            String msg = "Cannot use 'this' in a static context.";
            FcgInstructionListJavaSrc.error(msg);
        }
        return "this";
    }

    @Override
    protected Object genCode_loadNull() {
        return "null";
    }

    @Override
    protected Object genCode_loadFromArrayElement(FinalCodeGenerator.StackValue arrayReference, FinalCodeGenerator.StackValue arrayIndex, FcgType elemType) {
        return "(" + arrayReference.getCodeData() + ")[" + arrayIndex.getCodeData() + ']';
    }

    @Override
    protected Object genCode_loadLiteralValue(boolean b) {
        return b ? "true" : "false";
    }

    @Override
    protected Object genCode_loadLiteralValue(long l) {
        String code = l < 0L ? "(" + Long.toString(l) + "l)" : Long.toString(l) + 'l';
        return code;
    }

    @Override
    protected Object genCode_loadLiteralValue(int i) {
        String code = i < 0 ? "(" + Integer.toString(i) + ')' : Integer.toString(i);
        return code;
    }

    @Override
    protected final Object genCode_loadLiteralValue(short s) {
        String code = "((short)" + Short.toString(s) + ")";
        return code;
    }

    @Override
    protected final Object genCode_loadLiteralValue(byte b) {
        String code = "((byte)" + Byte.toString(b) + ")";
        return code;
    }

    @Override
    protected Object genCode_loadLiteralValue(char c) {
        return "'" + FcgInstructionListJavaSrc.escape(String.valueOf(c)) + '\'';
    }

    @Override
    protected Object genCode_loadLiteralValue(String s) {
        s = FcgInstructionListJavaSrc.escape(s);
        return "\"" + s + '\"';
    }

    private static String escape(String s) {
        char ch;
        int i;
        StringBuffer sb = null;
        for (i = 0; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (ch != '\b' && ch != '\t' && ch != '\n' && ch != '\f' && ch != '\r' && ch != '\\' && ch != '\'' && ch != '\"' && ch < '\u0080') continue;
            sb = new StringBuffer(s.substring(0, i));
            break;
        }
        if (i < s.length()) {
            while (i < s.length()) {
                ch = s.charAt(i);
                switch (ch) {
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\'': {
                        sb.append("\\'");
                        break;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    default: {
                        if (ch >= '\u0080') {
                            String hex2 = Integer.toHexString(ch);
                            sb.append("\\u");
                            sb.append("000".substring(hex2.length() - 1));
                            sb.append(hex2);
                            break;
                        }
                        sb.append(ch);
                    }
                }
                ++i;
            }
        }
        if (sb != null) {
            s = sb.toString();
        }
        return s;
    }

    @Override
    protected Object genCode_loadLiteralValue(float f2) {
        String code;
        if (Float.isNaN(f2)) {
            code = "Float.NaN";
        } else if (f2 == Float.POSITIVE_INFINITY) {
            code = "Float.POSITIVE_INFINITY";
        } else if (f2 == Float.NEGATIVE_INFINITY) {
            code = "Float.NEGATIVE_INFINITY";
        } else if (f2 < 0.0f) {
            code = '(' + Float.toString(f2) + "f)";
        } else {
            code = Float.toString(f2);
            code = code + 'f';
        }
        return code;
    }

    @Override
    protected Object genCode_loadLiteralValue(double d) {
        String code = Double.isNaN(d) ? "Double.NaN" : (d == Double.POSITIVE_INFINITY ? "Double.POSITIVE_INFINITY" : (d == Double.NEGATIVE_INFINITY ? "Double.NEGATIVE_INFINITY" : (d < 0.0 ? '(' + Double.toString(d) + "d)" : Double.toString(d) + 'd')));
        return code;
    }

    private String prepareArgumentList(FinalCodeGenerator.StackValue[] args) {
        StringBuffer argList = new StringBuffer();
        argList.append('(');
        if (args != null && args.length > 0) {
            argList.append(args[0].getCodeData());
            for (int i = 1; i < args.length; ++i) {
                argList.append(',');
                argList.append(args[i].getCodeData());
            }
        }
        argList.append(')');
        return argList.toString();
    }

    @Override
    protected Object genCode_storeLocalVariableExpr(FinalCodeGenerator.StackValue outerConstruct, FcgVariable var, FinalCodeGenerator.StackValue rhs) {
        StringBuffer sb = new StringBuffer();
        sb.append('(').append(var.getName()).append(" = ").append(rhs.getCodeData()).append(')');
        String code = sb.toString();
        return code;
    }

    @Override
    protected void genCode_storeAt(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue lhs, FinalCodeGenerator.StackValue rhs) {
        this.print(this.m_code, lhs.getCodeData());
        this.print(this.m_code, '=');
        this.print(this.m_code, rhs.getCodeData());
        this.println(this.m_code, ';');
    }

    @Override
    protected Object genCode_startConditionalLoop(String loopName, FinalCodeGenerator.StackValue condition, FinalCodeGenerator.StackValue loopUpdate, boolean isDoWhileLoop) {
        if (loopName == null) {
            loopName = "loop" + ++this.m_loopCount;
        }
        String conditionCode = condition == null ? "true" : (String)condition.getCodeData();
        this.print(this.m_code, loopName);
        if (isDoWhileLoop) {
            this.println(this.m_code, ": do {");
        } else {
            this.print(this.m_code, ": for (;");
            this.print(this.m_code, conditionCode);
            this.print(this.m_code, ";");
            if (loopUpdate != null) {
                this.print(this.m_code, loopUpdate.getCodeData());
            }
            this.println(this.m_code, ") {");
        }
        FcgLoopBuilderJavaSrc builder = new FcgLoopBuilderJavaSrc(loopName, conditionCode, isDoWhileLoop);
        return builder;
    }

    @Override
    protected void genCode_endLoop(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue loop) {
        FcgLoopBuilderJavaSrc loopBuilder = (FcgLoopBuilderJavaSrc)loop.getCodeData();
        if (loopBuilder.isDoWhileLoop()) {
            this.println(this.m_code, "} while(" + loopBuilder.getCondition() + ");");
        } else {
            this.println(this.m_code, '}');
        }
    }

    @Override
    protected void genCode_breakFromLoop(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue loop) {
        this.print(this.m_code, "break ");
        FcgLoopBuilderJavaSrc builder = (FcgLoopBuilderJavaSrc)loop.getCodeData();
        String loopName = builder.getLoopName();
        this.print(this.m_code, loopName);
        this.println(this.m_code, ';');
    }

    @Override
    protected void genCode_nextIterationOfLoop(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue loop) {
        this.print(this.m_code, "if (true) {");
        this.print(this.m_code, "continue ");
        FcgLoopBuilderJavaSrc builder = (FcgLoopBuilderJavaSrc)loop.getCodeData();
        String loopName = builder.getLoopName();
        this.print(this.m_code, loopName);
        this.print(this.m_code, ';');
        this.println(this.m_code, "}");
    }

    @Override
    protected Object genCode_beginChoice(FinalCodeGenerator.StackValue choiceOperand) {
        this.print(this.m_code, "switch (");
        this.print(this.m_code, choiceOperand.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    @Override
    protected Object genCode_beginChoiceBlock(char value2, FinalCodeGenerator.StackValue choiceConstruct) {
        this.print(this.m_code, "case ");
        this.print(this.m_code, this.genCode_loadLiteralValue(value2));
        this.println(this.m_code, ": {");
        return null;
    }

    @Override
    protected Object genCode_beginChoiceBlock(int value2, FinalCodeGenerator.StackValue choiceConstruct) {
        this.print(this.m_code, "case ");
        this.print(this.m_code, value2);
        this.println(this.m_code, ": {");
        return null;
    }

    @Override
    protected Object genCode_beginChoiceBlockDefault(FinalCodeGenerator.StackValue choiceConstruct) {
        this.println(this.m_code, "default: {");
        return null;
    }

    @Override
    protected Object genCode_endChoiceBlock(FinalCodeGenerator.StackValue choiceConstruct, FinalCodeGenerator.StackValue choiceBlock, boolean noFallThrough) {
        if (noFallThrough) {
            this.println(this.m_code, "  break;");
        }
        this.println(this.m_code, '}');
        return null;
    }

    @Override
    protected void genCode_endChoice(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue choiceConstruct) {
        this.println(this.m_code, '}');
    }

    @Override
    public final Object genCode_TERNARY_IF_ELSE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue midOperand, FinalCodeGenerator.StackValue rightOperand, FcgType returnType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)midOperand.getCodeData();
        String test2 = (String)leftOperand.getCodeData();
        String generatedCode = "(" + test2 + '?' + x + ":" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_LOGICAL_CONDITIONAL_OR(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "||" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_LOGICAL_CONDITIONAL_AND(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "&&" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_LOGICAL_XOR(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "^" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_LOGICAL_OR_EVALBOTH(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "|" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_LOGICAL_AND_EVALBOTH(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "&" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_ORDER_PRIMITIVE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType, int fcgOpCode) {
        String comp2;
        switch (fcgOpCode) {
            case 153: {
                comp2 = "<";
                break;
            }
            case 154: {
                comp2 = "<=";
                break;
            }
            case 155: {
                comp2 = ">";
                break;
            }
            case 156: {
                comp2 = ">=";
                break;
            }
            default: {
                comp2 = null;
            }
        }
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + comp2 + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_ORDER_STRING(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, int fcgOpCode) {
        String comp2;
        switch (fcgOpCode) {
            case 153: {
                comp2 = "<";
                break;
            }
            case 154: {
                comp2 = "<=";
                break;
            }
            case 155: {
                comp2 = ">";
                break;
            }
            case 156: {
                comp2 = ">=";
                break;
            }
            default: {
                comp2 = null;
            }
        }
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").compareTo(" + y + ")" + comp2 + " 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_ORDER_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType, int fcgOpCode) {
        String comp2;
        switch (fcgOpCode) {
            case 153: {
                comp2 = "<";
                break;
            }
            case 154: {
                comp2 = "<=";
                break;
            }
            case 155: {
                comp2 = ">";
                break;
            }
            case 156: {
                comp2 = ">=";
                break;
            }
            default: {
                comp2 = null;
            }
        }
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").compareTo(" + y + ")" + comp2 + " 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "!=" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "!=" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_NOT_EQ_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").compareTo(" + y + ") != 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_NOT_EQ_STRING(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").equals(" + y + ") == false)";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_EQ_PRIMITIVE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "==" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_EQ_REFERENCE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "==" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_EQ_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").compareTo(" + y + ") == 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_COMPARE_EQ_STRING(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType leftType, FcgType rightType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "((" + x + ").equals(" + y + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_BITWISE_XOR(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "^" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_BITWISE_XOR_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").xor(" + y + ")";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_BITWISE_OR(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String generatedCode;
        if (resultType == FcgType.BIG_INTEGER) {
            String y = (String)rightOperand.getCodeData();
            String x = (String)leftOperand.getCodeData();
            generatedCode = "(" + x + ").or(" + y + ")";
        } else {
            String y = (String)rightOperand.getCodeData();
            String x = (String)leftOperand.getCodeData();
            generatedCode = "(" + x + "|" + y + ')';
        }
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_BITWISE_AND(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String generatedCode;
        if (resultType == FcgType.BIG_INTEGER) {
            String y = (String)rightOperand.getCodeData();
            String x = (String)leftOperand.getCodeData();
            generatedCode = "(" + x + ").and(" + y + ")";
        } else {
            String y = (String)rightOperand.getCodeData();
            String x = (String)leftOperand.getCodeData();
            generatedCode = "(" + x + "&" + y + ')';
        }
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_SHIFT_RIGHT_UNSIGNED(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ">>>" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_SHIFT_RIGHT(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ">>" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_SHIFT_LEFT(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + "<<" + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_MODULO(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpCode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '%' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_MODULO_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").remainder(" + y + ")";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_DIVIDE(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpCode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '/' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_DIVIDE_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").divide(" + y + ")";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_MULTIPLY_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpCode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").multiply(" + y + ")";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_MULTIPLY(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpCode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '*' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_SUBTRACT(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpcode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '-' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_SUBTRACT_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").subtract(" + y + ")";
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_ADD_STRING(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '+' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_ADD(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand, FcgType resultType, int fcgOpCode) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + '+' + y + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_BINARY_ADD_BIG(FinalCodeGenerator.StackValue leftOperand, FinalCodeGenerator.StackValue rightOperand) {
        String y = (String)rightOperand.getCodeData();
        String x = (String)leftOperand.getCodeData();
        String generatedCode = "(" + x + ").add(" + y + ")";
        return generatedCode;
    }

    @Override
    protected Object genCode_createArray(FcgType elementType, FinalCodeGenerator.StackValue size) {
        String typeName = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(elementType);
        String arrayCode = null;
        if (elementType instanceof FcgArrayType) {
            int bracketPos = typeName.indexOf(91);
            arrayCode = "new " + typeName.substring(0, bracketPos) + '[' + size.getCodeData() + ']' + typeName.substring(bracketPos);
        } else {
            arrayCode = "new " + typeName + '[' + size.getCodeData() + ']';
        }
        return arrayCode;
    }

    @Override
    protected Object genCode_createArray(FcgType elementType, FinalCodeGenerator.StackValue[] initValues) {
        StringBuffer newExpr = new StringBuffer("new ");
        newExpr.append(((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(elementType));
        newExpr.append("[] {");
        for (int i = 0; i < initValues.length; ++i) {
            newExpr.append(initValues[i].getCodeData());
            newExpr.append(',');
        }
        newExpr.append('}');
        return newExpr.toString();
    }

    @Override
    protected final Object genCode_createObject(FcgType classType, FinalCodeGenerator.StackValue[] constructorArgs, FcgType[] paramTypes) {
        String className = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(classType);
        StringBuffer newExpr = new StringBuffer("new ");
        newExpr.append(className);
        newExpr.append(this.prepareArgumentList(constructorArgs));
        return newExpr.toString();
    }

    @Override
    protected Object genCode_beginIf(FinalCodeGenerator.StackValue conditionOperand) {
        this.print(this.m_code, "if (");
        this.print(this.m_code, conditionOperand.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    @Override
    protected Object genCode_elseIf(FinalCodeGenerator.StackValue ifConstruct, FinalCodeGenerator.StackValue conditionOperand) {
        this.print(this.m_code, "} else if (");
        this.print(this.m_code, conditionOperand.getCodeData());
        this.println(this.m_code, ") {");
        return null;
    }

    @Override
    protected Object genCode_beginElse(FinalCodeGenerator.StackValue ifConstruct) {
        this.useParentIndentLevel();
        this.println(this.m_code, "  } else {");
        return null;
    }

    @Override
    protected void genCode_endIf(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue ifConstruct) {
        this.println(this.m_code, '}');
    }

    @Override
    protected void genCode_returnInstruction(FinalCodeGenerator.StackValue outerConstruct) {
        this.println(this.m_code, "return;");
    }

    @Override
    protected void genCode_returnInstruction(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue returnValue) {
        this.print(this.m_code, "return ");
        this.print(this.m_code, returnValue.getCodeData());
        this.println(this.m_code, ';');
    }

    protected void print(StringBuffer sb, String s) {
        if (this.m_atStartOfLine) {
            this.m_atStartOfLine = false;
            int indentLevel = 2 + this.getActiveNonValueConstructsCount();
            if (this.m_useParentIndentLevel) {
                --indentLevel;
                this.m_useParentIndentLevel = false;
            }
            for (int i = 0; i < indentLevel; ++i) {
                sb.append("  ");
                this.m_debugBuf.append("  ");
            }
        }
        sb.append(s);
        this.m_debugBuf.append(s);
        this.stop_debugger();
    }

    protected void print(StringBuffer sb, Object o) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        }
        sb.append(o.toString());
        this.m_debugBuf.append(o);
        this.stop_debugger();
    }

    protected void print(StringBuffer sb, char c) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        } else if (c == '\n') {
            this.m_atStartOfLine = true;
        }
        sb.append(c);
        this.m_debugBuf.append(c);
        this.stop_debugger();
    }

    protected void println(StringBuffer sb, char c) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        }
        sb.append(c);
        if (FcgTraceBack.TRACECOMMENTSENABLED) {
            this.m_traceBack.blockCommentFromCurrentPos(sb);
        }
        sb.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(c).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void println(StringBuffer sb, String s) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        }
        sb.append(s);
        if (FcgTraceBack.TRACECOMMENTSENABLED) {
            this.m_traceBack.blockCommentFromCurrentPos(sb);
        }
        sb.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(s).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void println(StringBuffer sb, Object o) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        }
        sb.append(o.toString());
        if (FcgTraceBack.TRACECOMMENTSENABLED) {
            this.m_traceBack.blockCommentFromCurrentPos(sb);
        }
        sb.append(FcgClassGenJavaSrc.m_eol);
        this.m_debugBuf.append(o).append(FcgClassGenJavaSrc.m_eol);
        this.m_atStartOfLine = true;
        this.stop_debugger();
    }

    protected void print(StringBuffer sb, int i) {
        if (this.m_atStartOfLine) {
            this.print(sb, "");
        }
        sb.append(i);
        this.m_debugBuf.append(i);
        this.stop_debugger();
    }

    private void useParentIndentLevel() {
        this.m_useParentIndentLevel = true;
    }

    private void unimplemented(String message) {
        FcgInstructionListJavaSrc.error(message);
    }

    @Override
    protected final Object genCode_invokeMethod(boolean isInstanceMethod, boolean isInterface, boolean isExpr, FinalCodeGenerator.StackValue object2, String className, String methodName, FinalCodeGenerator.StackValue[] args, FcgType returnType, FcgType[] paramTypes) {
        String code;
        StringBuffer sb = new StringBuffer();
        if (isInstanceMethod) {
            String objRef = object2.getCodeData().toString();
            if ("this".equals(objRef)) {
                sb.append("this.");
            } else {
                sb.append('(').append(objRef).append(").");
            }
        } else {
            sb.append(className).append('.');
        }
        sb.append(methodName).append(this.prepareArgumentList(args));
        if (!isExpr) {
            sb.append(';');
            if (FcgTraceBack.TRACECOMMENTSENABLED) {
                FcgTraceBack traceBack = new FcgTraceBack();
                traceBack.recordTrace();
                traceBack.blockComment(sb);
            }
            this.println(this.m_code, sb.toString());
            code = null;
        } else {
            code = sb.toString();
        }
        return code;
    }

    private void stop_debugger() {
        StringBuffer output = this.m_debugBuf;
    }

    @Override
    protected void genCode_throwObject(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue obj) {
        this.print(this.m_code, "throw (");
        this.print(this.m_code, obj.getCodeData());
        this.println(this.m_code, ");");
    }

    @Override
    protected final void genCode_invokeSuper(FcgClassReferenceType crt, FinalCodeGenerator.StackValue obj, FinalCodeGenerator.StackValue[] args) {
        this.print(this.m_code, "super(");
        for (int a = 0; a < args.length; ++a) {
            this.print(this.m_code, args[a].getCodeData());
            if (a + 1 >= args.length) continue;
            this.print(this.m_code, ',');
        }
        this.println(this.m_code, ");");
    }

    StringBuffer getCode() {
        return this.m_code;
    }

    @Override
    public boolean mightExceedMaximumMethodLength() {
        return false;
    }

    @Override
    protected void genCode_storeInstanceVariableStmt(FinalCodeGenerator.StackValue objRef, String className, String varName, FcgType varType, FinalCodeGenerator.StackValue rightHandSide) {
        this.print(this.m_code, (String)objRef.getCodeData());
        this.print(this.m_code, '.');
        this.print(this.m_code, varName);
        this.print(this.m_code, " = ");
        this.print(this.m_code, (String)rightHandSide.getCodeData());
        this.println(this.m_code, ';');
    }

    @Override
    protected final void genCode_storeLocalVariableStmt(FinalCodeGenerator.StackValue outerConstruct, FcgVariable localVariable, FinalCodeGenerator.StackValue rhs) {
        if (this.checkForUnreachable(rhs)) {
            return;
        }
        this.print(this.m_code, localVariable.getName());
        this.print(this.m_code, " = ");
        this.print(this.m_code, rhs.getCodeData());
        this.println(this.m_code, ';');
    }

    @Override
    protected final void genCode_endExpressionStmt(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue rhs) {
        if (this.checkForUnreachable(rhs)) {
            return;
        }
        this.print(this.m_code, rhs.getCodeData());
        this.println(this.m_code, ';');
    }

    @Override
    protected void genCode_beginMethod(FcgMethodGen m) {
    }

    @Override
    public final FcgClassGen getFcgClassGen() {
        return this.m_classGen;
    }

    @Override
    public void setStaticContext(boolean isStatic) {
        this.m_staticContext = isStatic;
    }

    @Override
    public final boolean isClassContext() {
        return this.m_staticContext;
    }

    @Override
    protected Object genCode_beginTryBlock() {
        this.println(this.m_code, "try {");
        return null;
    }

    @Override
    public Object genCode_beginCatchBlock(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue try_or_catchConstruct, FcgVariable excpVar) {
        this.println(this.m_code, "} catch(" + excpVar.getType().getTypeName() + ' ' + excpVar.getName() + ") {");
        return null;
    }

    @Override
    protected void genCode_endTry(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue catchConstruct) {
        this.println(this.m_code, '}');
    }

    @Override
    protected Object genCode_loadClassRef(String className) {
        return className;
    }

    @Override
    protected Object genCode_loadLiteralValue(Character character) {
        char c = character.charValue();
        String code = "new Character('" + FcgInstructionListJavaSrc.escape(String.valueOf(c)) + "')";
        return code;
    }

    @Override
    protected Object genCode_loadLiteralValue(Boolean bool) {
        String code = bool != false ? "java.lang.Boolean.TRUE" : "java.lang.Boolean.FALSE";
        return code;
    }

    @Override
    protected Object genCode_arrayLengthExpr(FinalCodeGenerator.StackValue array) {
        StringBuffer sb = new StringBuffer();
        String arrayRefCode = (String)array.getCodeData();
        sb.append('(').append(arrayRefCode).append(')').append(".length");
        return sb.toString();
    }

    @Override
    protected void genCode_storeArrayElemStmt(FinalCodeGenerator.StackValue arrayRef, FinalCodeGenerator.StackValue index2, FinalCodeGenerator.StackValue rightHandSide) {
        StringBuffer sb = new StringBuffer();
        String arrayRefCode = (String)arrayRef.getCodeData();
        String indexCode = (String)index2.getCodeData();
        String rightSideCode = (String)rightHandSide.getCodeData();
        sb.append(arrayRefCode).append('[').append(indexCode).append(']');
        sb.append(" = ").append(rightSideCode).append(';');
        this.println(this.m_code, sb);
    }

    @Override
    public String toString() {
        String ret = super.toString();
        int codeSize = this.m_code.toString().length();
        int offset = codeSize - 9950 + ret.length();
        if (offset < 0) {
            offset = 0;
        }
        ret = ret + "CODE CURRENTLY IN THIS INSTRUCTION LIST:\n" + this.m_code.toString().substring(offset);
        return ret;
    }

    @Override
    protected void genCode_storeStaticFieldStmt(String className, FcgType fieldType, String fieldName, FinalCodeGenerator.StackValue val) {
        StringBuffer sb = new StringBuffer();
        String valueCode = (String)val.getCodeData();
        sb.append(className).append('.').append(fieldName).append(" = ").append(valueCode).append(';');
        this.println(this.m_code, sb);
    }

    @Override
    protected void genCode_fillStmt(FinalCodeGenerator.StackValue array, FinalCodeGenerator.StackValue from2, FinalCodeGenerator.StackValue to2, FinalCodeGenerator.StackValue fillValue) {
        StringBuffer sb = new StringBuffer();
        String arrayRef = (String)array.getCodeData();
        String fromIdx = (String)from2.getCodeData();
        String toIdx = (String)to2.getCodeData();
        String val = (String)fillValue.getCodeData();
        sb.append("java.util.Arrays.fill(" + arrayRef + ',' + fromIdx + ',' + toIdx + ',' + val + ");");
        this.println(this.m_code, sb);
    }

    @Override
    protected void genCode_streamElemCopyStmt(FinalCodeGenerator.StackValue srcArray, FinalCodeGenerator.StackValue srcPos, FinalCodeGenerator.StackValue targetArray, FinalCodeGenerator.StackValue targetPos, FinalCodeGenerator.StackValue howManyToCopy) {
        String source = (String)srcArray.getCodeData();
        String sourcePos = (String)srcPos.getCodeData();
        String tgt = (String)targetArray.getCodeData();
        String tgtPos = (String)targetPos.getCodeData();
        String howMany = (String)howManyToCopy.getCodeData();
        StringBuffer sb = new StringBuffer();
        sb.append("java.lang.System.arraycopy(").append(source).append(',').append(sourcePos);
        sb.append(',').append(tgt).append(',').append(tgtPos);
        sb.append(',').append(howMany).append(");");
        String code = sb.toString();
        this.println(this.m_code, code);
    }

    @Override
    public final boolean isEmpty() {
        boolean empty2 = this.m_code.length() <= 0;
        return empty2;
    }

    @Override
    public final Object genCode_createInnerClass(FcgType classType, FinalCodeGenerator.StackValue[] constructorArgs, FcgClassGen innerClass) {
        String className = ((FcgClassGenJavaSrc)this.m_classGen).fcgType2Name(classType);
        StringBuffer newExpr = new StringBuffer("new ");
        newExpr.append(className);
        newExpr.append(this.prepareArgumentList(constructorArgs));
        try {
            StringWriter innerClassContents = new StringWriter();
            ((FcgClassGenJavaSrc)innerClass).dumpContents(innerClassContents);
            newExpr.append(innerClassContents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return newExpr.toString();
    }

    @Override
    public final FcgVarMutableInternal newFcgVariable() {
        return new LocalVarRecord();
    }

    @Override
    protected final void genCode_beginScopeBlock() {
        this.println(this.m_code, "{");
    }

    @Override
    protected final void genCode_endScopeBlock(FinalCodeGenerator.StackValue outerConstruct, FinalCodeGenerator.StackValue scopeConstruct) {
        this.println(this.m_code, '}');
    }

    @Override
    protected final Object genCode_runtimeTypeCheck(FinalCodeGenerator.StackValue object2, FcgReferenceType type2) {
        StringBuffer sb = new StringBuffer();
        String objectRefCode = (String)object2.getCodeData();
        sb.append('(').append(objectRefCode).append(" instanceof ").append(type2.getTypeName()).append(')');
        return sb.toString();
    }

    @Override
    protected Object genCode_loadLiteralValue(BigDecimal number2) {
        double dbl = number2.doubleValue();
        String code = "new java.math.BigDecimal(" + dbl + ")";
        return code;
    }

    @Override
    protected Object genCode_loadLiteralValue(BigInteger number2) {
        String code = "new java.math.BigInteger(\"" + number2.toString() + "\")";
        return code;
    }

    @Override
    public final Object genCode_UNARY_ABS_BIG(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = x1 + ".abs()";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ABS_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.abs(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ABS_FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.abs(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ABS_INT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.abs(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ABS_LONG(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.abs(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ARRAY_LENGTH_ARRAY(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = x3 + ".length";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ARRAY_LENGTH_CHARSEQUENCE(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = x3 + ".length()";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ARRAY_LENGTH_STRING(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = x3 + ".length()";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_BITWISE_NOT_INT(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(~" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_BITWISE_NOT_LONG(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(~" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_CEILING_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.ceil(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_CEILING_BIG_DECIMAL(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "(" + x1 + ").setScale(0, java.math.BigDecimal.ROUND_CEILING)";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_CEILING_FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "((float) java.lang.Math.ceil(" + x1 + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_CEILING_INT(FinalCodeGenerator.StackValue operand2) {
        String x1;
        String generatedCode = x1 = (String)operand2.getCodeData();
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_FLOOR_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.floor(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_FLOOR_BIG_DECIMAL(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "(" + x1 + ").setScale(0, java.math.BigDecimal.ROUND_FLOOR)";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_FLOOR_FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "((float) java.lang.Math.floor(" + x1 + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_FLOOR_INT(FinalCodeGenerator.StackValue operand2) {
        String x1;
        String generatedCode = x1 = (String)operand2.getCodeData();
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_IS_NAN__FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Float.isNaN(" + x3 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_IS_NAN__LONG(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Double.isNaN((double)" + x3 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_IS_NAN_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Double.isNaN((double)" + x3 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_IS_NAN_INT(FinalCodeGenerator.StackValue operand2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Double.isNaN((double)" + x3 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_LOGICAL_NOT(FinalCodeGenerator.StackValue operand2) {
        String xx = (String)operand2.getCodeData();
        String generatedCode = "(!" + xx + ')';
        return generatedCode;
    }

    @Override
    public final Object gencode_UNARY_NEGATE_BIG(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = x + ".negate()";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_NEGATE_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(-" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_NEGATE_FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(-" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_NEGATE_INT(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(-" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_NEGATE_LONG(FinalCodeGenerator.StackValue operand2) {
        String x = (String)operand2.getCodeData();
        String generatedCode = "(-" + x + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ROUND_BIG(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "new java.math.BigDecimal(java.lang.Math.round( (" + x1 + ").doubleValue() ))";
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ROUND_DOUBLE(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.round(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ROUND_FLOAT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.round(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_ROUND_INT(FinalCodeGenerator.StackValue operand2) {
        String x1 = (String)operand2.getCodeData();
        String generatedCode = "java.lang.Math.round(" + x1 + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_UNARY_TO_CHAR_ARRAY_STRING(FinalCodeGenerator.StackValue operand2, FcgType type2) {
        String x3 = (String)operand2.getCodeData();
        String generatedCode = x3 + ".toCharArray()";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_2REFERENCE_TYPE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((" + toType.getTypeName() + ')' + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_2REFERENCE_TYPE2(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((" + toType.getTypeName() + ')' + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_2PRIMITIVE_TYPE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = toType.equals(FcgType.INT) ? "(((Integer)" + val + ").intValue())" : (toType.equals(FcgType.BOOLEAN) ? "(((Boolean)" + val + ").booleanValue())" : (toType.equals(FcgType.BYTE) ? "(((Byte)" + val + ").byteValue())" : (toType.equals(FcgType.CHAR) ? "(((Character)" + val + ").charValue())" : (toType.equals(FcgType.DOUBLE) ? "(((Double)" + val + ").doubleValue())" : (toType.equals(FcgType.FLOAT) ? "(((Float)" + val + ").floatValue())" : (toType.equals(FcgType.LONG) ? "(((Long)" + val + ").longValue())" : (toType.equals(FcgType.SHORT) ? "(((Short)" + val + ").shortValue())" : null)))))));
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2BOOLEAN(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".longValue() != 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2BYTE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((byte)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2CHAR(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((char)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2DOUBLE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".doubleValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2LONG(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".longValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2BIG_DECIMAL(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(new java.math.BigDecimal(" + val + ".toString()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2BOOLEAN(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".longValue() != 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2BYTE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((byte)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2CHAR(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((char)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2DOUBLE(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".doubleValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2FLOAT(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".floatValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2INT(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".intValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2LONG(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".longValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_INTEGER2SHORT(FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (byte)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (float)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (long)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BOOLEAN2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short)(" + val + " ? 1 : 0))";
        return generatedCode;
    }

    @Override
    protected Object genCode_COERCE_BOOLEAN2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Boolean.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + " != 0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Byte.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.String.valueOf(" + val + ").equals(\"true\")";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((byte)java.lang.Integer.parseInt(java.lang.String.valueOf(" + val + ")))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.Double.parseDouble(java.lang.String.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.Float.parseFloat(java.lang.String.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.Integer.parseInt(java.lang.String.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.Long.parseLong(java.lang.String.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.Short.parseShort(java.lang.String.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR_ARRAY2STRING(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "java.lang.String.valueOf(" + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((short) " + val + ')';
        return generatedCode;
    }

    @Override
    protected Object genCode_COERCE_CHAR2BIG_INTEGER(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.math.BigInteger.valueOf((long) " + val + "))";
        return generatedCode;
    }

    @Override
    protected Object genCode_COERCE_CHAR2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Character.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2BIG_DECIMAL(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(new java.math.BigDecimal(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2BIG_INTEGER(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(new java.math.BigDecimal(" + val + ").toBigInteger())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + "!=0 && !java.lang.Double.isNaN(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((int) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((short) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_DOUBLE2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Double.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2BIG_DECIMAL(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( new java.math.BigDecimal(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2BIG_INTEGER(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.math.BigInteger.valueOf((long)" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Float.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2BIG_DECIMAL(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(new java.math.BigDecimal(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2BIG_INTEGER(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.math.BigInteger.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2STRING(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Integer.toString(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Integer.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2BIG_DECIMAL(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(new java.math.BigDecimal(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2BIG_INTEGER(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.math.BigInteger.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2SHORT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (short) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2STRING(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Long.toString(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Long.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2BYTE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (byte) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2CHAR(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (char) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2DOUBLE(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (double) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2FLOAT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (float) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2LONG(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (long) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2OBJECT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Short.valueOf(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_STRING2CHAR_ARRAY(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".toCharArray())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHARSEQUENCE2CHAR_ARRAY(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".toString().toCharArray())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".toString().toCharArray())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2FLOAT(FcgType fromType, FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".floatValue())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2INT(FcgType fromType, FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".intValue())";
        return generatedCode;
    }

    @Override
    protected final Object genCode_COERCE_BIG_DECIMAL2BIG_INTEGER(FcgType fromType, FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + ".toBigInteger())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BIG_DECIMAL2SHORT(FcgType fromType, FcgType toType, FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "((short)(" + val + ".intValue()))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_BYTE2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_CHAR2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int) " + val + ')';
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_FLOAT2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (" + val + " != 0.0) && java.lang.Float.isNaN(" + val + "))";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + "!=0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_INT2CHAR_ARRAY(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Integer.toString(" + val + ").toCharArray())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_LONG2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + "!=0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2BOOLEAN(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(" + val + "!=0)";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2CHAR_ARRAY(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "(java.lang.Integer.toString(" + val + ").toCharArray())";
        return generatedCode;
    }

    @Override
    public final Object genCode_COERCE_SHORT2INT(FinalCodeGenerator.StackValue valToCoerce) {
        String val = (String)valToCoerce.getCodeData();
        String generatedCode = "( (int)" + val + ')';
        return generatedCode;
    }

    @Override
    protected Object genCode_loadLocalVariable(FcgVariable var) {
        String generatedCode = var.getName();
        return generatedCode;
    }

    @Override
    protected Object genCode_preIncrementAndLoadLocalVariable(FinalCodeGenerator.StackValue outerConstruct, FcgVariable locVar) {
        FcgType t = locVar.getType();
        String generatedCode = t == FcgType.BIG_INTEGER ? locVar.getName() + "=" + locVar.getName() + ".add(java.math.BigInteger.ONE)" : "++" + locVar.getName();
        return generatedCode;
    }

    @Override
    protected void genCode_incrementLocalVarStmt(FinalCodeGenerator.StackValue outerConstruct, FcgVariable var) {
        this.println(this.m_code, "++" + var.getName() + ';');
    }

    @Override
    protected boolean checkForUnreachable(FinalCodeGenerator.StackValue stackValue) {
        String string2 = stackValue.getCodeData().toString();
        return string2.equals("\"___unreachableTailRecursionReturnValue_doNotAssign___\"");
    }

    @Override
    public void setLineNumber(int linenumber) {
    }

    @Override
    public void setSourceNameInClass(String s) {
    }

    private static class LocalVarRecord
    implements FcgVarMutableInternal,
    FcgVariable {
        String m_varname;
        FcgType m_varType;
        FcgAttrs m_varAttrs;

        public final String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Name: ").append(this.m_varname);
            return sb.toString();
        }

        @Override
        public final String setName(String name2) {
            String old2 = this.m_varname;
            this.m_varname = name2;
            return old2;
        }

        @Override
        public final FcgAttrs setAttrs(FcgAttrs attrs) {
            FcgAttrs old2 = this.m_varAttrs;
            this.m_varAttrs = attrs;
            return old2;
        }

        @Override
        public final FcgType setType(FcgType t) {
            FcgType old2 = this.m_varType;
            this.m_varType = t;
            return old2;
        }

        @Override
        public final String getName() {
            return this.m_varname;
        }

        @Override
        public final FcgAttrs getAttrs() {
            return this.m_varAttrs;
        }

        @Override
        public final FcgType getType() {
            return this.m_varType;
        }
    }
}

