/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.fcg.javasrc;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FcgTraceBack {
    protected String m_comment = null;
    public static final String TRACECOMMENTSENABLED_OPTION = "fcgtrace";
    public static final boolean TRACECOMMENTSENABLED = HiddenOptions.optionValueIs("fcgtrace", "on");
    public static final String PRINTFORKREPORT_OPTION = "fcgforkreport";
    public static final boolean printFCGForkReport = HiddenOptions.optionValueIs("fcgforkreport", "on");
    public static final String MAX_TRACEBACK_DEPTH_OPTION = "fcgtracedepth";
    public static final int MAX_TRACEBACK_DEPTH = HiddenOptions.getIntegerValue("fcgtracedepth", 4);
    public static final String TRACEONLYINSTRUCTIONS_OPTION = "fcgtraceonlyinstr";
    public static final boolean TRACEONLYINSTRUCTIONSNABLED = HiddenOptions.optionValueIs("fcgtraceonlyinstr", "on");
    private static HashMap<String, Integer> forkCalls;

    public FcgTraceBack() {
        assert (TRACECOMMENTSENABLED);
    }

    protected void recordTrace() {
        this.recordTrace(null);
    }

    protected void recordTrace(StringBuffer outputBuf) {
        if (forkCalls == null) {
            forkCalls = new HashMap();
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean isForkCall = false;
        boolean isIForkCall = false;
        int numAppends = 0;
        StringBuffer buf = new StringBuffer();
        boolean foundInstruction = false;
        for (int i = 0; i < stackTrace.length; ++i) {
            boolean screenInstructions;
            StackTraceElement stackTraceElement = stackTrace[i];
            String methodName = stackTraceElement.getMethodName();
            if (methodName.equals("fork")) {
                isForkCall = true;
            } else if (methodName.equals("evaluateInstanceFork")) {
                isIForkCall = true;
            }
            String className = stackTraceElement.getClassName();
            boolean bl = screenInstructions = TRACEONLYINSTRUCTIONSNABLED ? className.contains("Instruction") : true;
            if (!screenInstructions || className.contains("com.ibm.xltxe.rnm1.fcg.") || className.equals("java.lang.Throwable") || className.equals("java.lang.Thread")) continue;
            String shortPos = this.getShortPos(stackTraceElement);
            if (numAppends < MAX_TRACEBACK_DEPTH) {
                if (numAppends != 0) {
                    buf.append(", ");
                }
                buf.append(shortPos);
            }
            ++numAppends;
            if (!isForkCall && !isIForkCall || foundInstruction || !className.equals("com.ibm.xltxe.rnm1.xylem.Instruction")) continue;
            foundInstruction = true;
            String forkString = shortPos + (isForkCall ? " generated fork" : " generated evaluateInstanceFork");
            Integer count2 = forkCalls.get(forkString);
            if (count2 == null) {
                forkCalls.put(forkString, 1);
                continue;
            }
            forkCalls.put(forkString, count2 + 1);
        }
        this.m_comment = buf.toString();
    }

    protected void blockCommentFromCurrentPos(StringBuffer out) {
        this.recordTrace(out);
        if (this.m_comment != null) {
            out.append(" /* ");
            out.append(this.m_comment);
            out.append(" */");
        }
    }

    private String getShortPos(String lineFromExceptionTrace) {
        StringTokenizer stringTok = new StringTokenizer(lineFromExceptionTrace, "()", false);
        stringTok.nextToken();
        String theirPos = stringTok.nextToken();
        return theirPos;
    }

    private String getShortPos(StackTraceElement ste) {
        String shortPos = "";
        String className = ste.getClassName();
        String[] classNameSplits = className.split("\\.");
        if (classNameSplits.length > 0) {
            String ident = classNameSplits[classNameSplits.length - 1];
            if (ident.endsWith("Instruction")) {
                ident = ident.substring(0, ident.length() - ("Instruction".length() - 1));
            } else if (ident.equals("ConventionalGenerationState")) {
                ident = "cgs";
            } else if (ident.equals("CodeGenerationTracker")) {
                ident = "cgt";
            } else if (ident.equals("ResultTreeStreamOptimizedGenerationState")) {
                ident = "RTSOGS";
            } else if (ident.equals("StreamOptimizedGenerationState")) {
                ident = "SOGS";
            } else if (ident.equals("CodeGenerationTracker")) {
                ident = "cgt";
            }
            return ident + ":" + ste.getLineNumber();
        }
        return shortPos;
    }

    protected void blockComment(StringBuffer out) {
        if (this.m_comment != null) {
            out.append(" /* ");
            out.append(this.m_comment);
            out.append(" */");
        }
    }

    protected void blockComment(Writer out) throws IOException {
        if (this.m_comment != null) {
            out.write(" /* ");
            out.write(this.m_comment);
            out.write(" */");
        }
    }

    protected void comment(Writer out, boolean inline) throws IOException {
        if (this.m_comment != null) {
            out.write("  // ");
            out.write(this.m_comment);
            if (!inline) {
                out.write(FcgClassGenJavaSrc.m_eol);
            }
        }
    }

    public static void printForkReport() {
        HashMap<String, Integer> forkLocations = forkCalls;
        if (forkLocations != null) {
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            treeMap.putAll(forkLocations);
            Set keys2 = treeMap.keySet();
            for (String key2 : keys2) {
                int numberCalls = forkLocations.get(key2);
                String head = key2;
                System.out.print(head);
                for (int i = 60 - head.length(); i >= 0; --i) {
                    System.out.print(".");
                }
                String numberCallsString = Integer.toString(numberCalls);
                System.out.print(numberCallsString);
                for (int i = 5 - numberCallsString.length(); i >= 0; --i) {
                    System.out.print(" ");
                }
                System.out.println("times");
            }
        }
    }
}

