/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Test;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class Parser {
    Object _parser;
    InputSource _input;
    public static final String XPATH1_STRING = "XPath1";
    public static final String XPATH2_STRING = "XPath2";
    public static final String XQUERY1_STRING = "XQuery1";
    public static final String XSLT1_STRING = "XSLT1";
    public static final String XSLT2_STRING = "XSLT2";
    public static final String XQUERY_MAIN_METHOD = "__xquery_result_fun__";
    public static final short XPATH1 = 1;
    public static final short XPATH2 = 2;
    public static final short XQUERY1 = 3;
    public static final short XSLT1 = 4;
    public static final short XSLT2 = 5;
    private int _lang;

    public Parser(ASTBuildingContext context2, String lang2, InputStream stream2, String sysID) {
        this._lang = Parser.langStringToEnum(lang2);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath prs = new XPath(context2, stream2);
                this._parser = prs;
                SimpleNode.setLanguage(prs.getExpressionFactory(), lang2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(stream2);
                this._input.setSystemId(sysID);
                XSLTParser parser = this.makeXSLTParser();
                this._parser = parser;
                parser.getExpressionFactory().setLanguage(lang2);
            }
        }
    }

    public Parser(ASTBuildingContext context2, String lang2, Reader stream2, String sysID) {
        this._lang = Parser.langStringToEnum(lang2);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath prs = new XPath(context2, stream2);
                this._parser = prs;
                SimpleNode.setLanguage(prs.getExpressionFactory(), lang2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(stream2);
                this._input.setSystemId(sysID);
                XSLTParser parser = this.makeXSLTParser();
                this._parser = parser;
                parser.getExpressionFactory().setLanguage(lang2);
            }
            default: {
                throw new RuntimeException("Parser doesn't understand language " + lang2 + "!");
            }
        }
    }

    public Parser(ASTBuildingContext context2, String lang2, String sysID) throws FileNotFoundException {
        this._lang = Parser.langStringToEnum(lang2);
        File file = new File(sysID);
        FileInputStream fis = new FileInputStream(file);
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath prs = new XPath(context2, fis);
                this._parser = prs;
                SimpleNode.setLanguage(prs.getExpressionFactory(), lang2);
                break;
            }
            case 4: 
            case 5: {
                this._lang = 5;
                this._input = new InputSource(fis);
                this._input.setSystemId(sysID);
                XSLTParser parser = this.makeXSLTParser();
                this._parser = parser;
                parser.getExpressionFactory().setLanguage(lang2);
            }
        }
    }

    private XSLTParser makeXSLTParser() {
        XSLTParser parser = new XSLTParser(this._lang == 5, new XStaticContext());
        parser.init();
        return parser;
    }

    public static int langStringToEnum(String lang2) {
        if (lang2.equals(XPATH1_STRING)) {
            return 1;
        }
        if (lang2.equals(XPATH2_STRING)) {
            return 2;
        }
        if (lang2.equals(XQUERY1_STRING)) {
            return 3;
        }
        if (lang2.equals(XSLT1_STRING)) {
            return 4;
        }
        if (lang2.equals(XSLT2_STRING)) {
            return 5;
        }
        throw new XPathError("ERR_LANGUAGE", lang2);
    }

    public static void main(String[] args) throws Exception {
        String langString = XPATH2_STRING;
        int argsStart = 0;
        String sysID = null;
        boolean dumpTree = false;
        while (argsStart < args.length) {
            if (args[argsStart].equals("-lang")) {
                langString = args[++argsStart];
                ++argsStart;
                continue;
            }
            if (args[argsStart].equals("-file")) {
                sysID = args[++argsStart];
                ++argsStart;
                continue;
            }
            if (args[argsStart].equals("-dumptree")) {
                dumpTree = true;
                ++argsStart;
                continue;
            }
            if (args[argsStart].equals("-match")) {
                ++argsStart;
                continue;
            }
            if (args[argsStart].equals("-expr")) {
                ++argsStart;
                ++argsStart;
                continue;
            }
            if (args[argsStart].equals("-deepdir")) {
                ++argsStart;
                ++argsStart;
                continue;
            }
            if (argsStart == args.length - 1) {
                sysID = args[argsStart];
                ++argsStart;
                continue;
            }
            ++argsStart;
        }
        int lang2 = Parser.langStringToEnum(langString);
        switch (lang2) {
            case 1: 
            case 2: 
            case 3: {
                Test.main(args);
                break;
            }
            case 4: 
            case 5: {
                Parser xsltParser = new Parser(null, langString, sysID);
                Expr expr = xsltParser.parse();
                if (!dumpTree) break;
                expr.dump("", System.out);
                break;
            }
        }
    }

    public Expr parse() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: {
                XPath xpParser = (XPath)this._parser;
                SimpleNode root2 = xpParser.XPath2();
                return (Expr)root2.jjtGetChild(0);
            }
            case 3: {
                XPath xpParser = (XPath)this._parser;
                xpParser.getExpressionFactory().setLanguage(XQUERY1_STRING);
                SimpleNode root3 = xpParser.XPath2();
                Expr program = (Expr)root3.jjtGetChild(0);
                XStaticContext context2 = xpParser.getStaticContext();
                this.processXQueryOptions(((XTQProgram)program).getOptions(), context2);
                if (program instanceof XTQProgram && ((XTQProgram)program).isLibraryModule()) {
                    return program;
                }
                int nChildren = program.jjtGetNumChildren();
                if (nChildren > 0) {
                    Expr lastChild = (Expr)program.jjtGetChild(nChildren - 1);
                    FunctionDecl funcDecl = new FunctionDecl();
                    funcDecl.setQName(new QName(XQUERY_MAIN_METHOD));
                    lastChild.replaceWith(funcDecl);
                    funcDecl.jjtAddChild(xpParser, lastChild, 0);
                    funcDecl.jjtGetLastChild().jjtSetParent(funcDecl);
                    funcDecl.setLineInfo(lastChild.getLineInfo());
                    this.addParam(funcDecl, "xqstart__context__", 169, null);
                    this.addParam(funcDecl, "xqstart__contextposition__", 184, TypeExpr.TYPENAME_INTEGER);
                    this.addParam(funcDecl, "xqstart__contextlast__", 184, TypeExpr.TYPENAME_INTEGER);
                    context2.addStylesheetFunction(funcDecl);
                }
                return program;
            }
            case 4: 
            case 5: {
                XSLTParser xsltParser = (XSLTParser)this._parser;
                return xsltParser.makeAST(this._input);
            }
        }
        return null;
    }

    private void processXQueryOptions(HashMap<QName, List<String>> options, XStaticContext context2) {
        List<String> mappings = options.get(new QName("http://www.ibm.com/xmlns/prod/xltxe-j", "java-extension"));
        if (mappings != null) {
            for (String option : mappings) {
                String existingBinding;
                StringTokenizer st = new StringTokenizer(option, "=");
                if (st.countTokens() != 2) {
                    this.raiseJavaExtFuncSyntaxErr(option);
                    continue;
                }
                String prefix2 = st.nextToken().trim();
                String clazz = st.nextToken().trim();
                if (prefix2 == null || prefix2.equals("")) {
                    this.raiseJavaExtFuncSyntaxErr(option);
                } else if (clazz == null || clazz.equals("")) {
                    this.raiseJavaExtFuncSyntaxErr(option);
                }
                String namespace2 = context2.getNamespaceURI(prefix2);
                if (namespace2 == null || namespace2.equals("")) {
                    XPath parser = (XPath)this.getRealParser();
                    ASTMsg error2 = new ASTMsg("JAVA_EXT_FUNC_UNBOUND_PREFIX_XQ_ERR", new Object[]{"{http://www.ibm.com/xmlns/prod/xltxe-j}java-extension", prefix2, clazz});
                    parser.getReporter().report(4, error2);
                }
                if ((existingBinding = context2.lookupJavaExtensionFunction(namespace2)) != null) {
                    XPath parser = (XPath)this.getRealParser();
                    ASTMsg error3 = new ASTMsg("JAVA_EXT_FUNC_MULT_BINDING_ERR", new Object[]{namespace2, existingBinding, clazz});
                    parser.getReporter().report(4, error3);
                }
                context2.addJavaExtensionFunctionClass(namespace2, clazz);
            }
        }
    }

    private void raiseJavaExtFuncSyntaxErr(String option) {
        XPath parser = (XPath)this.getRealParser();
        ASTMsg error2 = new ASTMsg("JAVA_EXT_FUNC_XQ_OPT_SYNTAX_ERR", new Object[]{"{http://www.ibm.com/xmlns/prod/xltxe-j}java-extension", option});
        parser.getReporter().report(4, error2);
    }

    private void addParam(FunctionDecl funcDecl, String name2, int typeConstant, QName typeName) {
        Param p0 = new Param();
        p0.setName("", "", name2);
        funcDecl.addParameter(p0);
        TypeExpr type2 = typeName == null ? new TypeExpr(typeConstant) : new TypeExpr(typeConstant, typeName);
        type2.setOccurrenceIndicator((short)0);
        p0.setType(type2);
    }

    public SimpleNode parseRaw() throws Exception {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xpParser = (XPath)this._parser;
                return xpParser.XPath2();
            }
            case 4: 
            case 5: {
                XSLTParser xsltParser = (XSLTParser)this._parser;
                return xsltParser.makeAST(this._input);
            }
        }
        return null;
    }

    public void ReInit(ASTBuildingContext context2, InputStream stream2, String sysID) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xpParser = (XPath)this._parser;
                xpParser.ReInit(context2, stream2);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(sysID);
                break;
            }
        }
    }

    public void ReInit(ASTBuildingContext context2, Reader stream2, String sysID) {
        switch (this._lang) {
            case 1: 
            case 2: 
            case 3: {
                XPath xpParser = (XPath)this._parser;
                xpParser.ReInit(context2, stream2);
                break;
            }
            case 4: 
            case 5: {
                this._input.setSystemId(sysID);
                break;
            }
        }
    }

    public Object getRealParser() {
        return this._parser;
    }
}

