/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.PathExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;

public class XPath20Utilities {
    public static boolean isMatchDocumentNode(Expr expr) {
        boolean result2;
        block0 : switch (expr.getId()) {
            case 40: {
                OperatorExpr op2 = (OperatorExpr)expr;
                if (op2.getOperandCount() == 1) {
                    result2 = XPath20Utilities.isMatchDocumentNode(op2.getOperand(0));
                    break;
                }
                result2 = false;
                break;
            }
            case 63: 
            case 64: {
                result2 = false;
                OperatorExpr op3 = (OperatorExpr)expr;
                for (int i = op3.getOperandCount() - 1; i >= 0; --i) {
                    if (!XPath20Utilities.isMatchDocumentNode(op3.getOperand(i))) continue;
                    result2 = true;
                    break block0;
                }
                break;
            }
            case 82: {
                PathExpr p = (PathExpr)expr;
                result2 = p.isAbsolute() && p.getOperandCount() == 1;
                break;
            }
            case 85: {
                result2 = ((StepExpr)expr).isRootOnSelfNode();
                break;
            }
            case 105: {
                result2 = ((FunctionCall)expr).isRootOnSelfNode();
                break;
            }
            default: {
                result2 = false;
            }
        }
        return result2;
    }

    public static boolean isSingletonSequence(Expr e) {
        return e != null && e.getId() == 40 && ((OperatorExpr)e).getOperandCount() == 1;
    }

    public static boolean isAbsolutePath(Expr expr) {
        return expr.getId() == 82 && ((PathExpr)expr).isAbsolute() || XPath20Utilities.isSingletonSequence(expr) && XPath20Utilities.isAbsolutePath(((OperatorExpr)expr).getOperand(0)) || XPath20Utilities.isRootOnSelfNode(expr);
    }

    public static boolean isRootOnSelfNode(Expr expr) {
        return expr.isRootOnSelfNode();
    }

    public static boolean isNumeric(Literal literal) {
        int type2 = literal.getId();
        return type2 == 98 || type2 == 99 || type2 == 97;
    }

    public static Expr parentless(Expr expr) {
        if (expr == null) {
            return null;
        }
        if (expr.jjtGetParent() == null) {
            return expr;
        }
        return expr.cloneExpression();
    }
}

