/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OutputCharacter;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public final class CharacterMap
extends TopLevelDecl {
    private String m_name;
    private String m_expandedName;
    private String m_use_character_maps;

    public CharacterMap(int i) {
        super(i);
    }

    public CharacterMap() {
        super(218);
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        Attributes attributes2 = this.getAttributes();
        if (attributes2 != null) {
            String nameValue = null;
            int numAtts = attributes2.getLength();
            for (int attr2 = 0; attr2 < numAtts; ++attr2) {
                String locName = attributes2.getLocalName(attr2);
                String value2 = attributes2.getValue(attr2);
                if ("use-character-maps".equals(locName)) {
                    this.setUseCharacterMaps(value2);
                    continue;
                }
                if (!"name".equals(locName)) continue;
                nameValue = value2;
                this.setName(parser, nameValue);
            }
            this.processUseCharacterMaps(parser);
            this.parseOwnChildren(parser);
        }
        return false;
    }

    private void parseOwnChildren(XSLTParser parser) {
        int count2 = this.jjtGetNumChildren();
        for (int i = 0; i < count2; ++i) {
            Expr child2 = (Expr)this.jjtGetChild(i);
            if (!(child2 instanceof OutputCharacter)) continue;
            parser.getStaticContext().setCurrentNode(child2);
            child2.callParseContents(parser);
        }
    }

    private void processUseCharacterMaps(XSLTParser parser) {
        String lexicalQName;
        MergedCharacterMapsManager charMapManager = parser.getStaticContext().getCharacterMapsManager();
        boolean doprocessing = true;
        if (this.m_expandedName != null) {
            MergedCharacterMapsManager.CharacterMapRecord cm = charMapManager.findCharMap(this.m_expandedName);
            if (cm != null && cm.getImportPrecedence().hasHigherPrecedenceThan(this.getImportPrecedence())) {
                doprocessing = false;
            } else if (cm != null && cm.getImportPrecedence() == this.getImportPrecedence()) {
                cm.markDuplicate();
                doprocessing = false;
            } else {
                cm = charMapManager.getCharMap(this.m_expandedName, this.getImportPrecedence());
                lexicalQName = this.getLexicalQName();
                cm.setLexicalQName(lexicalQName);
                cm.setExpr(this);
                doprocessing = true;
            }
        }
        if (this.m_expandedName != null && this.m_use_character_maps != null) {
            StringTokenizer tokens = Util.whitespaceTokenize(this.m_use_character_maps);
            while (tokens.hasMoreTokens()) {
                lexicalQName = tokens.nextToken();
                if (!XML11Char.isXML11ValidQName(lexicalQName)) {
                    ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NOT_LEXICAL_QNAME", (Object)lexicalQName, "xsl:charater-map");
                    parser.reportError(3, err);
                    continue;
                }
                String expandedQName = this.getExpandedQName(parser, lexicalQName);
                if (expandedQName != null) {
                    if (!doprocessing) continue;
                    charMapManager.setDependancy(this.m_expandedName, expandedQName);
                    charMapManager.characterMapIsReferenced(expandedQName, this);
                    continue;
                }
                ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NO_URI", (Object)lexicalQName, "xsl:charater-map");
                parser.reportError(3, err);
            }
        }
    }

    private void setName(XSLTParser parser, String lexicalQName) {
        this.m_name = lexicalQName;
        this.m_expandedName = this.getExpandedQName(parser, lexicalQName);
        if (!XML11Char.isXML11ValidQName(lexicalQName)) {
            ASTMsg err = new ASTMsg("CHARACTER_MAP_NAME_NOT_LEXICAL_QNAME", (Object)lexicalQName, (SimpleNode)this);
            parser.reportError(3, err);
            return;
        }
        if (this.m_expandedName == null) {
            int colon = lexicalQName.indexOf(58);
            String prefix2 = lexicalQName.substring(0, colon);
            ASTMsg err = new ASTMsg("CHARACTER_MAP_NAME_NO_URI", lexicalQName, prefix2, this);
            parser.reportError(3, err);
            return;
        }
        this.checkExpandedQNameForReservedNS(this.m_expandedName, "xsl:character-map", parser);
    }

    private void setUseCharacterMaps(String characterMaps) {
        this.m_use_character_maps = characterMaps;
    }

    String getExpandedQname() {
        return this.m_expandedName;
    }

    String getLexicalQName() {
        return this.m_name;
    }

    public short getExprType() {
        return 0;
    }
}

