/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorFactory;
import org.xml.sax.Attributes;

public final class CollationElement
extends TopLevelDecl {
    private static final String ATTR_URI = "collation-uri";
    private static final String ATTR_LANG = "lang";
    private static final String ATTR_DECOMP = "decompostion";
    private static final String ATTR_STRENGTH = "strength";
    private static final String ATTR_RULES = "rules";
    private static final String ATTR_CASEORDER = "case-order";
    private static final String ATTR_IMPL = "impl";
    private CollatorDeclaration m_decl = null;
    private boolean m_isDuplicateName = false;

    public CollatorDeclaration getDeclaration() {
        return this.m_decl;
    }

    public void setDeclaration(CollatorDeclaration decl) {
        this.m_decl = decl;
    }

    public CollationElement(int i) {
        super(i);
    }

    public CollationElement() {
        super(219);
    }

    public boolean isDuplicateName() {
        return this.m_isDuplicateName;
    }

    public void setDuplicateName(boolean isDup) {
        this.m_isDuplicateName = isDup;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String collation_uri = null;
        String lang2 = null;
        String decompostion = null;
        String strength = null;
        String rules = null;
        String case_order = null;
        String impl2 = null;
        if (this.getDeclaration() == null) {
            if (!this.hasAttribute(ATTR_URI)) {
                ASTMsg msg = new ASTMsg("REQUIRED_ATTR_ERR", (Object)ATTR_URI, (SimpleNode)this);
                parser.reportError(4, msg);
            } else {
                collation_uri = this.getAttribute(ATTR_URI);
                if (!CollatorFactory.isNameValid(collation_uri)) {
                    ASTMsg msg = new ASTMsg("INVALID_COLLATION_NAME", new Object[]{collation_uri}, (SimpleNode)this);
                    parser.reportError(4, msg);
                } else {
                    String decomposition;
                    ASTMsg msg;
                    String caseOrder;
                    parser.getStaticContext().addCollationElement(this.getImportPrecedence(), collation_uri, this);
                    if (this.hasAttribute(ATTR_RULES)) {
                        rules = this.getAttribute(ATTR_RULES);
                    }
                    if (this.hasAttribute(ATTR_CASEORDER) && !CollatorFactory.isCaseOrderValid(caseOrder = this.getAttribute(ATTR_CASEORDER))) {
                        msg = new ASTMsg("INVALID_ATTR_VALUE_IGNORED", new Object[]{ATTR_CASEORDER, caseOrder});
                        parser.reportError(4, msg);
                    }
                    if (this.hasAttribute(ATTR_IMPL)) {
                        impl2 = this.getAttribute(ATTR_IMPL);
                    }
                    if (this.hasAttribute(ATTR_LANG)) {
                        lang2 = this.getAttribute(ATTR_LANG);
                    }
                    if (this.hasAttribute(ATTR_DECOMP) && !CollatorFactory.isDecompositionValid(decomposition = this.getAttribute(ATTR_DECOMP))) {
                        msg = new ASTMsg("INVALID_ATTR_VALUE_IGNORED", new Object[]{ATTR_DECOMP, decomposition});
                        parser.reportError(4, msg);
                    }
                    if (this.hasAttribute(ATTR_STRENGTH) && !CollatorFactory.isStrengthValid(strength = this.getAttribute(ATTR_STRENGTH))) {
                        ASTMsg msg2 = new ASTMsg("INVALID_ATTR_VALUE_IGNORED", new Object[]{ATTR_STRENGTH, strength});
                        parser.reportError(4, msg2);
                    }
                }
            }
        }
        this.m_decl = new CollatorDeclarationImpl(collation_uri, lang2, decompostion, strength, rules, case_order, impl2);
        return false;
    }

    public String getCollationURI() {
        String uri2 = null;
        Attributes attributes2 = this.getAttributes();
        if (this.m_decl != null) {
            uri2 = this.m_decl.getName();
        } else if (attributes2 != null) {
            int max2 = attributes2.getLength();
            for (int i = 0; i < max2; ++i) {
                if (!ATTR_URI.equals(attributes2.getLocalName(i))) continue;
                uri2 = attributes2.getValue(i);
                break;
            }
        }
        return uri2;
    }
}

