/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class EffectiveMergedOutputElements {
    private Hashtable m_name2MergedOutputElement = new Hashtable();
    private ArrayList m_listOfNames = new ArrayList();
    private boolean m_isXSLT20;

    private MergedOutputElement getMergedOutputElement(String name2) {
        MergedOutputElement moe = (MergedOutputElement)this.m_name2MergedOutputElement.get(name2);
        if (moe == null) {
            moe = new MergedOutputElement();
            this.m_name2MergedOutputElement.put(name2, moe);
        }
        return moe;
    }

    public boolean exists(String formatName) {
        Object o = this.m_name2MergedOutputElement.get(formatName);
        boolean retval = o != null;
        return retval;
    }

    public void updateEffectiveMergedXSLOutputElement(Expr.ImportPrecedence importPrecedence, String name2, String key2, String value2) {
        MergedOutputElement moe = (MergedOutputElement)this.m_name2MergedOutputElement.get(name2);
        if (moe == null) {
            moe = new MergedOutputElement();
            this.m_name2MergedOutputElement.put(name2, moe);
            this.m_listOfNames.add(name2);
        }
        moe.update(importPrecedence, key2, value2);
    }

    public String[] getOutputNames() {
        int numElements = this.m_listOfNames.size();
        String[] names = new String[numElements];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)this.m_listOfNames.get(i);
        }
        return names;
    }

    public Properties getEffectiveMergedXslOutputProperties(String name2) {
        Properties props = new Properties();
        MergedOutputElement moe = this.getMergedOutputElement(name2);
        if (moe != null) {
            int numElems = moe.m_listOfMergedElements.size();
            for (int i = 0; i < numElems; ++i) {
                Attribute attr2 = (Attribute)moe.m_listOfMergedElements.get(i);
                if (attr2.key.equals("name")) continue;
                if (attr2.value == null) {
                    throw new XPathError("CONFLICTING_OUTPUT_ATTRIBUTES_ERR", attr2.key);
                }
                props.setProperty(attr2.key, attr2.value);
            }
        }
        return props;
    }

    public EffectiveMergedOutputElements(boolean isXslt20) {
        this.m_isXSLT20 = isXslt20;
    }

    private class MergedOutputElement {
        public ArrayList m_listOfMergedElements = new ArrayList();

        private MergedOutputElement() {
        }

        public void update(Expr.ImportPrecedence impPrecedence, String key2, String value2) {
            int i;
            int mx = this.m_listOfMergedElements.size();
            for (i = 0; i < mx; ++i) {
                Attribute attr2 = (Attribute)this.m_listOfMergedElements.get(i);
                if (!attr2.key.equals(key2)) continue;
                attr2.update(impPrecedence, key2, value2);
                break;
            }
            if (i == mx) {
                Attribute att = new Attribute(impPrecedence, key2, value2);
                this.m_listOfMergedElements.add(att);
            }
        }
    }

    private class Attribute {
        private Expr.ImportPrecedence importPrecedence;
        private final String key;
        private String value;

        public Attribute(Expr.ImportPrecedence imp, String k, String v) {
            this.importPrecedence = imp;
            this.key = k;
            this.value = v;
        }

        private boolean update(Expr.ImportPrecedence impPrecedence, String k, String v) {
            boolean wasUpdated;
            if (this.key.equals("cdata-section-elements")) {
                String oldValue = this.value;
                this.value = oldValue + ' ' + v;
                wasUpdated = true;
            } else if (this.key.equals("use-character-maps")) {
                String oldValue = this.value;
                this.value = oldValue + ' ' + v;
                wasUpdated = true;
            } else if (impPrecedence.hasSamePrecedenceAs(this.importPrecedence) && !EffectiveMergedOutputElements.this.m_isXSLT20 || impPrecedence.hasHigherPrecedenceThan(this.importPrecedence)) {
                this.importPrecedence = impPrecedence;
                this.value = v;
                wasUpdated = true;
            } else {
                if (EffectiveMergedOutputElements.this.m_isXSLT20 && this.importPrecedence == impPrecedence && !this.value.equals(v)) {
                    this.value = null;
                }
                wasUpdated = false;
            }
            return wasUpdated;
        }
    }
}

