/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Assert;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.Reporter;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Expr
extends SimpleNode {
    protected HashMap m_properties = null;
    protected Type _typeInference = null;
    protected static final String _DEFAULTCOLLATION_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.defaultCollation";
    protected static final String _RECOGNIZEDCOLLATIONS_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.recognizedCollations";
    protected static final String _DEFAULTCOLLATIONSURILIST_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.defaultCollationURIList ";
    protected static final String _EXCLUDEDURIS_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.excludedURI ";
    protected static final String _XPATHDEFAULTNS_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.xpathDefaultNS ";
    protected static final String _PROGRAMVERSION_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.ProgramVersion ";
    protected static final String _BACKWARDSCOMPATIBILITY_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.BackwardsCompatibility";
    protected static final String _FORWARDSCOMPATIBILITY_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.ForwardsCompatibility";
    protected static final String _ATTRIBUTES_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.xsltAttributes";
    protected static final String _PREFIXMAPPING_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.prefixMapping";
    protected static final String _EXCLUEDERESULTPREFIXES_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.excludeResultPrefixes";
    protected static final String _EXTENSIONELEMPREFIXES_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes._extensionElemPrefixes";
    protected static final String _TEMPLATE_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.template";
    protected static String _BASEURI_KEY = "com.ibm.xltxe.rnm1.xtq.ast.nodes.baseuri";
    private boolean _isTopLevelElementInEntity = false;
    protected XTQProgram _xtqprogram;
    protected QName _nodeQName;
    private String _useWhen;
    private boolean _hasCircularDefinition = false;

    public Expr(int i) {
        super(i);
    }

    public Expr(int i, Expr fc) {
        super(i, fc);
        this.m_properties = fc.m_properties;
        this._xtqprogram = fc._xtqprogram;
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate) {
        if (this.id == 101) {
            this.getXQueryStringForChildren(expr, abbreviate, " ");
        } else {
            this.getXQueryString(expr, abbreviate, "  ");
        }
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        if (this.id == 101) {
            this.getXQueryStringForChildren(expr, abbreviate, indent);
        } else {
            super.getXQueryString(expr, abbreviate, indent);
        }
    }

    protected void dumpChildren(String prefix2, PrintStream out) {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            SimpleNode n2 = (SimpleNode)this.jjtGetChild(i);
            if (n2 == null) continue;
            n2.dump(prefix2 + " ", out);
        }
    }

    public int hashCode() {
        return this.getXQueryString(true).hashCode();
    }

    protected boolean canBeFlatten(ASTBuildingContext context2, Expr expr) {
        return false;
    }

    public boolean isRootOnSelfNode() {
        return false;
    }

    public boolean isSimpleStringValue() {
        return false;
    }

    public String getSimpleStringValue() {
        Assert._assert(false, "getSimpleStringValue() should not be called on this node!");
        return null;
    }

    public final Expr lastChild() {
        int n2 = this.jjtGetNumChildren();
        return n2 == 0 ? null : (Expr)this.jjtGetChild(n2 - 1);
    }

    protected String getString(QName name2) {
        if (name2 == null) {
            return "";
        }
        if (name2.getPrefix() == null || "".equals(name2.getPrefix())) {
            return name2.getLocalPart();
        }
        return name2.getPrefix() + ":" + name2.getLocalPart();
    }

    public void addProperty(Object key2, Object value2) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        if (null != value2) {
            this.m_properties.put(key2, value2);
        } else {
            this.m_properties.remove(key2);
        }
    }

    public Object getProperty(Object key2) {
        return this.m_properties != null ? this.m_properties.get(key2) : null;
    }

    public Set getPropertyKeys() {
        return this.m_properties != null ? this.m_properties.keySet() : new HashSet();
    }

    public Object removeProperty(Object key2) {
        return this.m_properties != null ? this.m_properties.remove(key2) : null;
    }

    public void removeAllProperties() {
        if (this.m_properties != null) {
            this.m_properties.clear();
        }
    }

    public Expr cloneExpression() {
        return (Expr)super.clone();
    }

    public String getXQueryString(boolean abbreviate) {
        StringBuffer buf = new StringBuffer();
        this.getXQueryString(buf, abbreviate);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Expr && ((Expr)obj).getXQueryString(true).equals(this.getXQueryString(true));
    }

    public String getProgramVersion() {
        String programVersion = (String)this.getProperty(_PROGRAMVERSION_KEY);
        if (programVersion == null) {
            Attributes attrs = this.getAttributes();
            int count2 = attrs == null ? 0 : attrs.getLength();
            for (int i = 0; i < count2; ++i) {
                String namespaceURI = attrs.getURI(i);
                if (null == namespaceURI) {
                    namespaceURI = "";
                }
                if (!attrs.getLocalName(i).equals("version")) continue;
                if (namespaceURI.equals("") && !this.isExtensionElement() && this.getId() != 108) {
                    programVersion = attrs.getValue(i);
                    break;
                }
                if (!namespaceURI.equals("http://www.w3.org/1999/XSL/Transform")) continue;
                programVersion = attrs.getValue(i);
                break;
            }
            if (programVersion == null) {
                SimpleNode parent2;
                for (parent2 = (SimpleNode)this.jjtGetParent(); parent2 != null && !(parent2 instanceof Expr); parent2 = (SimpleNode)parent2.jjtGetParent()) {
                }
                if (parent2 != null) {
                    programVersion = ((Expr)parent2).getProgramVersion();
                }
            }
        }
        return programVersion;
    }

    public void setProgramVersion(String version) {
        this.addProperty(_PROGRAMVERSION_KEY, version);
    }

    public boolean isBackwardsCompatibilityMode(int language) {
        Boolean bcMode = (Boolean)this.getProperty(_BACKWARDSCOMPATIBILITY_KEY);
        if (bcMode == null) {
            if (language == 2) {
                bcMode = Boolean.FALSE;
            } else if (language == 3) {
                bcMode = Boolean.FALSE;
            } else {
                String versionStr = this.getProgramVersion();
                double version = versionStr != null ? Double.parseDouble(versionStr) : 1.0;
                bcMode = version < 2.0 ? Boolean.TRUE : Boolean.FALSE;
            }
            this.addProperty(_BACKWARDSCOMPATIBILITY_KEY, bcMode);
        }
        return bcMode;
    }

    public boolean isForwardsCompatibilityMode() {
        Boolean fwMode = (Boolean)this.getProperty(_FORWARDSCOMPATIBILITY_KEY);
        if (fwMode == null) {
            String versionStr = this.getProgramVersion();
            double version = versionStr != null ? Double.parseDouble(versionStr) : 2.0;
            fwMode = version > 2.0 ? Boolean.TRUE : Boolean.FALSE;
            this.addProperty(_FORWARDSCOMPATIBILITY_KEY, fwMode);
        }
        return fwMode;
    }

    public void setDefaultElementTypeNamespace(String namespace2) {
        this.addProperty(_XPATHDEFAULTNS_KEY, namespace2);
    }

    public String getDefaultNS() {
        String xpathDefaultNS = (String)this.getProperty(_XPATHDEFAULTNS_KEY);
        return xpathDefaultNS;
    }

    public void setNodeQName(QName qname2) {
        this._nodeQName = qname2;
    }

    public void setName(String uri2, String prefix2, String local2) {
    }

    public void setAttributes(Attributes attributes2) {
        this.addProperty(_ATTRIBUTES_KEY, attributes2);
    }

    public String getAttribute(String qname2) {
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        if (attributes2 == null) {
            return "";
        }
        String value2 = attributes2.getValue(qname2);
        return value2 == null || value2.equals("") ? "" : value2;
    }

    public String getAttribute(String uri2, String localName2) {
        int index2;
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        String ret = "";
        if (attributes2 != null && 0 <= (index2 = attributes2.getIndex(uri2, localName2))) {
            ret = attributes2.getValue(index2);
        }
        return ret;
    }

    public boolean hasAttribute(String qname2) {
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        return attributes2 != null && attributes2.getValue(qname2) != null;
    }

    public boolean hasAttribute(String uri2, String localName2) {
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        return attributes2 != null && attributes2.getIndex(uri2, localName2) >= 0;
    }

    public Attributes getAttributes() {
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        return attributes2;
    }

    public String getAttributeType(String qname2) {
        Attributes attributes2 = (Attributes)this.getProperty(_ATTRIBUTES_KEY);
        if (attributes2 == null) {
            return "";
        }
        String type2 = attributes2.getType(qname2);
        return type2 == null || type2.equals("") ? "" : type2;
    }

    public void setPrefixMapping(HashMap mapping) {
        this.addProperty(_PREFIXMAPPING_KEY, mapping);
    }

    public HashMap<String, String> getPrefixMapping() {
        HashMap property2 = (HashMap)this.getProperty(_PREFIXMAPPING_KEY);
        return property2;
    }

    public void addPrefixMapping(String prefix2, String uri2) {
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping == null) {
            prefixMapping = new HashMap();
            this.addProperty(_PREFIXMAPPING_KEY, prefixMapping);
        }
        prefixMapping.put(prefix2, uri2);
    }

    public String lookupNamespace(String prefix2) {
        String uri2 = null;
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping != null) {
            uri2 = prefixMapping.get(prefix2);
        }
        if (uri2 == null && this.jjtGetParent() != null) {
            uri2 = ((Expr)this.jjtGetParent()).lookupNamespace(prefix2);
            if (prefix2.length() == 0 && uri2 == null) {
                uri2 = "";
            }
        }
        return uri2;
    }

    public String lookupNamespaceNoDefault(String prefix2) {
        String uri2 = null;
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping != null) {
            uri2 = prefixMapping.get(prefix2);
        }
        if (uri2 == null && this.jjtGetParent() != null) {
            uri2 = ((Expr)this.jjtGetParent()).lookupNamespaceNoDefault(prefix2);
        }
        return uri2;
    }

    public String lookupNamespace(String prefix2, Expr parent2) {
        String uri2 = null;
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping != null) {
            uri2 = prefixMapping.get(prefix2);
        }
        if (uri2 == null && parent2 != null) {
            uri2 = parent2.lookupNamespace(prefix2);
            if (prefix2 == "" && uri2 == null) {
                uri2 = "";
            }
        }
        return uri2;
    }

    protected String lookupPrefix(String uri2) {
        String prefix2 = null;
        HashMap<String, String> prefixMapping = this.getPrefixMapping();
        if (prefixMapping != null) {
            for (Map.Entry<String, String> entry : prefixMapping.entrySet()) {
                String mapsTo = entry.getValue();
                if (!mapsTo.equals(uri2)) continue;
                return entry.getKey();
            }
        } else if (this.jjtGetParent() != null) {
            prefix2 = ((Expr)this.jjtGetParent()).lookupPrefix(uri2);
            if (uri2 == "" && prefix2 == null) {
                prefix2 = "";
            }
        }
        return prefix2;
    }

    public QName getQNameFromString(String stringRep, boolean reportError, String prefixForUnprefixed, String namespaceForUnprefixed, XSLTParser parser) {
        String defURI;
        int colon = stringRep.lastIndexOf(58);
        if (colon != -1) {
            String prefix2 = stringRep.substring(0, colon);
            String localname2 = stringRep.substring(colon + 1);
            String namespace2 = null;
            if (!prefix2.equals("xmlns") && (namespace2 = this.lookupNamespace(prefix2, this)) == null && reportError) {
                int line = this.getLineNumber();
                int column = this.getColumnNumber();
                ASTMsg err = new ASTMsg("NAMESPACE_UNDEF_ERR", line, column, prefix2);
                parser.getReporter().report(3, err);
            }
            return new QName(namespace2, localname2, prefix2);
        }
        if (stringRep.equals("xmlns")) {
            defURI = null;
            prefixForUnprefixed = null;
        } else {
            defURI = namespaceForUnprefixed == null ? this.lookupNamespace("", this) : namespaceForUnprefixed;
        }
        return new QName(defURI, stringRep, prefixForUnprefixed);
    }

    public HashMap getInScopeNamespaces() {
        HashMap<String, String> all2 = new HashMap<String, String>();
        for (Expr node2 = this; node2 != null; node2 = (Expr)node2.jjtGetParent()) {
            HashMap<String, String> mapping = node2.getPrefixMapping();
            if (mapping == null) continue;
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                String prefix2 = entry.getKey();
                if (all2.containsKey(prefix2)) continue;
                all2.put(prefix2, entry.getValue());
            }
        }
        return all2;
    }

    protected HashMap<String, Object> getInScopeNamespacesForLRE() {
        Expr node2 = this;
        HashMap<String, Object> all2 = new HashMap<String, Object>();
        while (node2 != null) {
            HashMap<String, String> mapping = node2.getPrefixMapping();
            if (mapping != null) {
                for (Map.Entry<String, String> entry : mapping.entrySet()) {
                    String prefix2 = entry.getKey();
                    if (all2.containsKey(prefix2)) continue;
                    all2.put(prefix2, entry.getValue());
                }
            }
            if ((node2 = (Expr)node2.jjtGetParent()) == null || node2.getId() != 108) continue;
            break;
        }
        return all2;
    }

    public void setExcludeResultPrefixes(ASTBuildingContext context2, String prefixes2, Expr parent2) {
        ArrayList excludeResultPrefixes = null == parent2 ? new ArrayList() : (ArrayList)parent2.getExcludeResultPrefixes().clone();
        this.setExcludeResultPrefixes(excludeResultPrefixes);
        if (prefixes2 != null) {
            if (Util.trimWhitespace(prefixes2).equals("#all")) {
                excludeResultPrefixes.clear();
                HashMap inScopePrefixes = this.getInScopeNamespaces();
                excludeResultPrefixes.addAll(inScopePrefixes.values());
            } else {
                StringTokenizer tokens = Util.whitespaceTokenize(prefixes2);
                while (tokens.hasMoreTokens()) {
                    ASTMsg err;
                    String uri2;
                    String prefix2 = tokens.nextToken();
                    if (prefix2.equals("#default")) {
                        uri2 = this.lookupNamespace("");
                        if (uri2 == null || uri2.length() == 0) {
                            err = new ASTMsg("ERR_RESULT_DEFAULT_PREFIX", this);
                            context2.getReporter().report(3, err);
                        }
                    } else {
                        uri2 = this.lookupNamespace(prefix2, parent2);
                        if (uri2 == null || uri2.length() == 0) {
                            err = new ASTMsg("ERR_RESULT_PREFIX", (Object)prefix2, (SimpleNode)this);
                            context2.getReporter().report(3, err);
                        }
                    }
                    if (excludeResultPrefixes.contains("uri")) continue;
                    excludeResultPrefixes.add(uri2);
                }
            }
        }
    }

    public void setExtensionElemPrefixes(ASTBuildingContext context2, String prefixes2, Expr parent2) {
        ArrayList extensionElemPrefixes = null == parent2 ? new ArrayList() : (ArrayList)parent2.getExtensionElemPrefixes().clone();
        this.setExtensionElemPrefixes(extensionElemPrefixes);
        if (prefixes2 != null) {
            StringTokenizer tokens = Util.whitespaceTokenize(prefixes2);
            while (tokens.hasMoreTokens()) {
                ASTMsg err;
                String uri2;
                String prefix2 = tokens.nextToken();
                if (prefix2.equals("#default")) {
                    uri2 = this.lookupNamespace("");
                    if (uri2 == null) {
                        err = new ASTMsg("ERR_EXTENSION_DEFAULT_PREFIX", this);
                        context2.getReporter().report(3, err);
                    }
                } else {
                    uri2 = this.lookupNamespace(prefix2, parent2);
                    if (uri2 == null) {
                        err = new ASTMsg("ERR_EXTENSION_PREFIX", (Object)prefix2, (SimpleNode)this);
                        context2.getReporter().report(3, err);
                    }
                }
                if (extensionElemPrefixes.contains("uri")) continue;
                extensionElemPrefixes.add(uri2);
            }
        }
    }

    public void excludePrefixes(XSLTParser parser) {
        this.excludeURI("http://www.w3.org/1999/XSL/Transform");
        this.excludeNamespaces(this.getExcludeResultPrefixes());
        this.excludeNamespaces(this.getExtensionElemPrefixes());
    }

    public void excludeURI(String uri2) {
        Integer refcnt;
        if (uri2 == null || uri2.equals("#all")) {
            return;
        }
        Hashtable<String, Integer> excludedURIs = this.getExcludedURIs();
        if (excludedURIs == null) {
            excludedURIs = new Hashtable<String, Integer>();
            this.setExcludedURIs(excludedURIs);
        }
        refcnt = (refcnt = (Integer)excludedURIs.get(uri2)) == null ? new Integer(1) : new Integer(refcnt + 1);
        excludedURIs.put(uri2, refcnt);
    }

    protected void unExcludeURI(String uri2) {
        Hashtable excludedURIs = this.getExcludedURIs();
        Integer refcnt = (Integer)excludedURIs.get(uri2);
        if (refcnt != null) {
            excludedURIs.put(uri2, new Integer(refcnt - 1));
        }
    }

    private void excludeNamespaces(ArrayList prefixes2) {
        if (prefixes2 != null) {
            Iterator prefixlist = prefixes2.iterator();
            while (prefixlist.hasNext()) {
                this.excludeURI((String)prefixlist.next());
            }
        }
    }

    public boolean isExcludedNamespace(String uri2) {
        if (uri2 == null) {
            return false;
        }
        Hashtable excludedURIs = this.getExcludedURIs();
        if (excludedURIs != null && excludedURIs.containsKey(uri2)) {
            Integer refcnt = (Integer)excludedURIs.get(uri2);
            return refcnt != null && refcnt > 0;
        }
        XTQProgram program = this.getXTQProgram();
        if (program != null && program != this) {
            return program.isExcludedNamespace(uri2);
        }
        return false;
    }

    public boolean isAllResultExcluded() {
        return this.getExcludeResultPrefixes().contains("#all");
    }

    public boolean isExtension(String uri2) {
        return this.getExtensionElemPrefixes().contains(uri2);
    }

    public boolean isExtensionElement() {
        return false;
    }

    protected final void parseChildren(XSLTParser parser) {
        boolean[] tolerateError = parser.checkAllowedChildren(this);
        int count2 = this.jjtGetNumChildren();
        XStaticContext context2 = parser.getStaticContext();
        for (int i = 0; i < count2; ++i) {
            Expr child2 = (Expr)this.jjtGetChild(i);
            context2.setCurrentNode(child2);
            if (!tolerateError[i]) {
                if (!child2.callParseContents(parser)) continue;
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
                continue;
            }
            try {
                if (!child2.callParseContents(parser)) continue;
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
                continue;
            }
            catch (Throwable t) {
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
            }
        }
        context2.setCurrentNode(this);
    }

    protected void reportError(Expr element2, XSLTParser parser, String errorCode, String message) {
        ASTMsg error2 = new ASTMsg(errorCode, (Object)message, (SimpleNode)element2);
        parser.reportError(3, error2);
    }

    protected void reportError(Expr element2, XSLTParser parser, String errorCode, String message1, String message2) {
        ASTMsg error2 = new ASTMsg(errorCode, message1, message2, element2);
        parser.reportError(3, error2);
    }

    public ImportPrecedence getImportPrecedence() {
        XTQProgram prog = this.getXTQProgram();
        if (prog == null) {
            return ImportPrecedence.getLowestPrecedence();
        }
        return prog.getImportPrecedence();
    }

    public XTQProgram getXTQProgram() {
        if (this._xtqprogram == null) {
            if (this instanceof XTQProgram) {
                this._xtqprogram = (XTQProgram)this;
            } else {
                Node parent2;
                for (parent2 = this.jjtGetParent(); parent2 != null && !(parent2 instanceof Expr); parent2 = parent2.jjtGetParent()) {
                }
                if (parent2 != null) {
                    this._xtqprogram = ((Expr)parent2).getXTQProgram();
                }
            }
        }
        return this._xtqprogram;
    }

    public Expr getRealParent() {
        Expr parent2 = (Expr)this.jjtGetParent();
        Expr realparent = null;
        if (parent2 != null && parent2.getId() == 3) {
            realparent = this.getXTQProgram();
        }
        if (realparent == null) {
            realparent = parent2;
        }
        return realparent;
    }

    public QName getNodeQName() {
        return this._nodeQName;
    }

    protected Template getTemplate() {
        Template template = (Template)this.getProperty(_TEMPLATE_KEY);
        if (template == null) {
            Expr parent2;
            for (parent2 = this; parent2 != null && !(parent2 instanceof Template); parent2 = (Expr)parent2.jjtGetParent()) {
            }
            template = (Template)parent2;
            this.setTemplate(template);
        }
        return template;
    }

    protected void setTemplate(Template template) {
        this.addProperty(_TEMPLATE_KEY, template);
    }

    public boolean parseContents(XSLTParser parser) {
        this.parseChildren(parser);
        return false;
    }

    public boolean callParseContents(XSLTParser parser) {
        if (this.parseContents(parser)) {
            return true;
        }
        if (this._nodeQName != null) {
            parser.checkNodesOrder(this);
        }
        return false;
    }

    protected static Expr parentless(Expr expr) {
        if (expr == null) {
            return null;
        }
        if (expr.jjtGetParent() == null) {
            return expr;
        }
        return expr.cloneExpression();
    }

    protected static Expr parseAVTAttrContent(ASTBuildingContext context2, String value2, Expr parent2) {
        Expr newexpr;
        Expr expr = new Expr(40);
        expr.jjtSetParent(parent2);
        if (Expr.checkAVT(context2, value2, parent2)) {
            Expr.parseAVTemplate(context2, value2, expr.getChildren(), expr);
        }
        if ((newexpr = (Expr)parent2.reducedNode(context2, expr)).getId() == 40 && newexpr.jjtGetNumChildren() == 0) {
            newexpr = context2.getExpressionFactory().createStringLiteralExpr("");
            newexpr.jjtSetParent(parent2);
        }
        expr = newexpr;
        return expr;
    }

    protected static List parseAVTemplate(ASTBuildingContext context2, String text2, List exprs, Expr parent2) {
        if (text2 == null) {
            return exprs;
        }
        int length2 = text2.length();
        int start = 0;
        block3: while (start < length2) {
            String str;
            int openingBraceIndex = text2.indexOf("{", start);
            if (openingBraceIndex != -1) {
                char c = text2.charAt(openingBraceIndex + 1);
                int quote = -1;
                switch (c) {
                    case '{': {
                        str = Expr.removeDuplicateBraces(text2.substring(start, openingBraceIndex + 2));
                        exprs.add(context2.getExpressionFactory().createStringLiteralExpr(str));
                        start = openingBraceIndex + 2;
                        continue block3;
                    }
                }
                if (openingBraceIndex > start) {
                    str = Expr.removeDuplicateBraces(text2.substring(start, openingBraceIndex));
                    exprs.add(context2.getExpressionFactory().createStringLiteralExpr(str));
                }
                str = Expr.parseAVTVariablepart(text2, openingBraceIndex + 1);
                exprs.add(Expr.parseExpression(context2, parent2, str));
                start = openingBraceIndex + str.length() + 2;
                continue;
            }
            if (start >= length2) continue;
            str = Expr.removeDuplicateBraces(text2.substring(start));
            exprs.add(context2.getExpressionFactory().createStringLiteralExpr(str));
            start = length2;
        }
        return exprs;
    }

    private static String parseAVTVariablepart(String text2, int start) {
        int index2 = start;
        int closingBraceIndex = -1;
        int length2 = text2.length();
        int commentDepth = 0;
        boolean inLiteral = false;
        char literalType = '\u0000';
        block6: for (int i = index2; i < length2; ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '(': {
                    if (inLiteral || text2.charAt(i + 1) != ':') continue block6;
                    ++commentDepth;
                    continue block6;
                }
                case ':': {
                    if (inLiteral || text2.charAt(i + 1) != ')') continue block6;
                    --commentDepth;
                    continue block6;
                }
                case '}': {
                    if (inLiteral || commentDepth != 0) continue block6;
                    closingBraceIndex = i;
                    break block6;
                }
                case '\"': 
                case '\'': {
                    if (commentDepth != 0) continue block6;
                    if (inLiteral) {
                        if (literalType != c) continue block6;
                        inLiteral = false;
                        continue block6;
                    }
                    inLiteral = true;
                    literalType = c;
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return text2.substring(start, closingBraceIndex);
    }

    public static Expr parseExpression(ASTBuildingContext context2, Expr parent2, String exp) {
        Expr expr = null;
        try {
            context2.getExpressionFactory().setExprContext(parent2);
            expr = context2.getExpressionFactory().createExpr(context2, context2.getStaticContext(), exp);
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (Expr)expr.jjtGetChild(0);
            }
            expr.jjtSetParent(parent2);
        }
        catch (XPath20Exception e) {
            Reporter rep = context2.getReporter();
            rep.report(3, e.getErrorMsg());
        }
        return expr;
    }

    private static String removeDuplicateBraces(String orig) {
        int index2;
        String result2 = orig;
        while ((index2 = result2.indexOf("{{")) != -1) {
            result2 = result2.substring(0, index2) + result2.substring(index2 + 1, result2.length());
        }
        while ((index2 = result2.indexOf("}}")) != -1) {
            result2 = result2.substring(0, index2) + result2.substring(index2 + 1, result2.length());
        }
        return result2;
    }

    public static boolean checkAVT(ASTBuildingContext context2, String value2, Expr parent2) {
        if (value2 == null) {
            return true;
        }
        char[] chars = value2.toCharArray();
        int level = 0;
        boolean inLiteral = false;
        char literalType = '\u0000';
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '{': {
                    if (inLiteral) break;
                    if (i + 1 == chars.length || chars[i + 1] != '{') {
                        ++level;
                        break;
                    }
                    ++i;
                    break;
                }
                case '}': {
                    if (inLiteral) break;
                    if (i + 1 == chars.length || chars[i + 1] != '}') {
                        --level;
                        break;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (inLiteral) {
                        if (literalType != chars[i]) break;
                        inLiteral = false;
                        break;
                    }
                    inLiteral = true;
                    literalType = chars[i];
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (level > 1) {
                ASTMsg error2 = new ASTMsg("ATTR_VAL_TEMPLATE_ERR_LEFT", (Object)value2, (SimpleNode)parent2);
                context2.reportError(3, error2);
                return false;
            }
            if (level >= 0) continue;
            ASTMsg error3 = new ASTMsg("ATTR_VAL_TEMPLATE_ERR", (Object)value2, (SimpleNode)parent2);
            context2.reportError(3, error3);
            return false;
        }
        if (level > 0) {
            ASTMsg error4 = new ASTMsg("ATTR_VAL_TEMPLATE_ERR_LEFT", (Object)value2, (SimpleNode)parent2);
            context2.reportError(3, error4);
            return false;
        }
        if (level < 0) {
            ASTMsg error5 = new ASTMsg("ATTR_VAL_TEMPLATE_ERR", (Object)value2, (SimpleNode)parent2);
            context2.reportError(3, error5);
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeReduced() {
        return this.getId() == 40 && this.jjtGetNumChildren() == 1;
    }

    public XStaticContext.UseWhenResult parseUseWhen(XSLTParser parser) {
        if (this.hasAttribute("use-when")) {
            String useWhen = this.getAttribute("use-when");
            Expr.parseExpression(parser, this, useWhen);
            if (useWhen != null && useWhen != "") {
                this._useWhen = "boolean(" + useWhen + ")";
                return parser.getStaticContext().evaluateUseWhen(parser, this);
            }
        }
        return XStaticContext.UseWhenResult.TRUE;
    }

    public String getUseWhen() {
        return this._useWhen;
    }

    public void setUseWhen(String useWhen) {
        this._useWhen = useWhen;
    }

    public String getDefaultCollationURI(ASTBuildingContext context2) {
        String defaultCollation = (String)this.getProperty(_DEFAULTCOLLATION_KEY);
        if (defaultCollation == null) {
            Attributes attrs = this.getAttributes();
            int count2 = attrs == null ? 0 : attrs.getLength();
            String defaultCollationURIList = null;
            for (int i = 0; i < count2; ++i) {
                String namespaceURI = attrs.getURI(i);
                if (null == namespaceURI) {
                    namespaceURI = "";
                }
                if (!attrs.getLocalName(i).equals("default-collation")) continue;
                if (namespaceURI.equals("") && !this.isExtensionElement() && this.getId() != 108) {
                    defaultCollationURIList = attrs.getValue(i);
                    break;
                }
                if (!namespaceURI.equals("http://www.w3.org/1999/XSL/Transform")) continue;
                defaultCollationURIList = attrs.getValue(i);
                break;
            }
            if (defaultCollationURIList != null) {
                this.setDefaultCollations(defaultCollationURIList);
                defaultCollation = context2.getStaticContext().getFirstRecognized(defaultCollationURIList, this.getBaseURI());
                if (defaultCollation == null) {
                    String errorCode = "COLLATIONS_NOT_RECOGNIZED";
                    ASTMsg error2 = new ASTMsg("COLLATIONS_NOT_RECOGNIZED", null, defaultCollationURIList, this);
                    context2.reportError(4, error2);
                }
            }
            if (defaultCollation == null) {
                Node parent2;
                for (parent2 = this.jjtGetParent(); parent2 != null && !(parent2 instanceof Expr); parent2 = parent2.jjtGetParent()) {
                }
                defaultCollation = null == parent2 ? context2.getStaticContext().getDefaultCollationName() : ((Expr)parent2).getDefaultCollationURI(context2);
            }
            if (defaultCollation == null) {
                defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            this.setDefaultCollationURI(defaultCollation);
            String[] uris = context2.getStaticContext().getRecognizedCollationURIs();
            this.setRecognizedCollationURIs(uris);
        }
        return defaultCollation;
    }

    public String[] getRegnizedCollationURIs() {
        Expr parent2 = (Expr)this.jjtGetParent();
        String[] recognizedCollations = (String[])this.getProperty(_RECOGNIZEDCOLLATIONS_KEY);
        if (recognizedCollations == null && parent2 != null) {
            recognizedCollations = parent2.getRegnizedCollationURIs();
        }
        return recognizedCollations;
    }

    public String getDefaultCollations() {
        String defaultCollationURIList = (String)this.getProperty(_RECOGNIZEDCOLLATIONS_KEY);
        return defaultCollationURIList;
    }

    public void setDefaultCollationURI(String collationURI) {
        this.addProperty(_DEFAULTCOLLATION_KEY, collationURI);
    }

    public void setRecognizedCollationURIs(String[] uris) {
        this.addProperty(_RECOGNIZEDCOLLATIONS_KEY, uris);
    }

    public void setDefaultCollations(String list) {
        this.addProperty(_DEFAULTCOLLATIONSURILIST_KEY, list);
    }

    protected Hashtable getExcludedURIs() {
        Hashtable excludedURIs = (Hashtable)this.getProperty(_EXCLUDEDURIS_KEY);
        return excludedURIs;
    }

    protected void setExcludedURIs(Hashtable excludedURI) {
        this.addProperty(_EXCLUDEDURIS_KEY, excludedURI);
    }

    protected ArrayList<String> getExcludeResultPrefixes() {
        return (ArrayList)this.getProperty(_EXCLUEDERESULTPREFIXES_KEY);
    }

    protected void setExcludeResultPrefixes(ArrayList<String> excludeResultPrefixes) {
        this.addProperty(_EXCLUEDERESULTPREFIXES_KEY, excludeResultPrefixes);
    }

    protected ArrayList<String> getExtensionElemPrefixes() {
        return (ArrayList)this.getProperty(_EXTENSIONELEMPREFIXES_KEY);
    }

    protected void setExtensionElemPrefixes(ArrayList<String> extensionElemPrefixes) {
        this.addProperty(_EXTENSIONELEMPREFIXES_KEY, extensionElemPrefixes);
    }

    public String getBaseURI() {
        String baseURIProp = (String)this.getProperty(_BASEURI_KEY);
        String resolveBase = null;
        try {
            if (baseURIProp == null || !SystemIDResolver.isAbsoluteURI(baseURIProp)) {
                if (this.getIsTopLevelElementInEntity() && this.getLineInfo() != null) {
                    resolveBase = this.getLineInfo().getSystemID();
                }
                if (resolveBase == null) {
                    Expr parent2 = this.getRealParent();
                    if (parent2 != null) {
                        resolveBase = parent2.getBaseURI();
                    } else if (baseURIProp == null) {
                        return null;
                    }
                } else if (!SystemIDResolver.isAbsolutePath(resolveBase) && !SystemIDResolver.isAbsoluteURI(resolveBase)) {
                    String parentBase = ((Expr)this.jjtGetParent()).getBaseURI();
                    resolveBase = SystemIDResolver.getAbsoluteURI(resolveBase, parentBase);
                }
                baseURIProp = SystemIDResolver.getAbsoluteURI(baseURIProp, resolveBase);
                this.setBaseURI(baseURIProp);
            }
            return baseURIProp;
        }
        catch (URI.MalformedURIException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public String getBaseURIProperty() {
        return (String)this.getProperty(_BASEURI_KEY);
    }

    public void setBaseURI(String baseURI) {
        this.addProperty(_BASEURI_KEY, baseURI);
    }

    public final boolean getIsTopLevelElementInEntity() {
        return this._isTopLevelElementInEntity;
    }

    public final void setIsTopLevelElementInEntity(boolean topLevel) {
        this._isTopLevelElementInEntity = topLevel;
    }

    protected String getExpandedQName(XSLTParser parser, String lexicalQName) {
        return this.getExpandedQName(parser, lexicalQName, false);
    }

    protected String getExpandedQName(XSLTParser parser, String lexicalQName, boolean noDefault) {
        StringBuffer sb = new StringBuffer();
        if (parser.isValidNCName(lexicalQName)) {
            String uri2;
            if (!noDefault && (uri2 = this.lookupNamespace("")) != null && !uri2.equals("")) {
                sb.append('{').append(uri2).append('}');
            }
            sb.append(lexicalQName);
        } else if (parser.isValidQName(lexicalQName)) {
            int colon = lexicalQName.indexOf(58);
            if (colon <= 0) {
                return null;
            }
            String prefix2 = lexicalQName.substring(0, colon);
            String uri3 = this.lookupNamespace(prefix2);
            if (uri3 == null || uri3.equals("")) {
                return null;
            }
            String localName2 = lexicalQName.substring(colon + 1);
            sb.append('{').append(uri3).append('}');
            sb.append(localName2);
        } else {
            return null;
        }
        String ret = sb.toString();
        return ret;
    }

    public boolean checkExpandedQNameForReservedNS(String name2, String construct2, XSLTParser parser) {
        int rbrace;
        if (name2 != null && (rbrace = name2.indexOf(125)) > 0) {
            String URI2 = name2.substring(1, rbrace);
            return parser.checkForReservedNamespace(URI2, construct2, (SimpleNode)this);
        }
        return true;
    }

    public Type getTypeInference() {
        return this._typeInference;
    }

    public boolean hasCircularDefinition() {
        return this._hasCircularDefinition;
    }

    public void isCircularlyDefined() {
        this._hasCircularDefinition = true;
    }

    public void setTypeInference(Type type2) {
        this._typeInference = type2;
    }

    public void writeAsXML(Writer w, HashMap t, boolean outerMost) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void throwSAXEvents(ContentHandler ch) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public void checkContent(XSLTParser parser) {
        this.checkContent(parser, "INVALID_CHILD_ERR");
    }

    public void checkContent(XSLTParser parser, String errID) {
        for (Expr child2 : this.getChildren()) {
            String param2;
            QName nodeName;
            if (child2 instanceof Text) {
                Text t = (Text)child2;
                t.parseContents(parser);
                if (t.isIgnore()) continue;
            }
            String param1 = (nodeName = this.getNodeQName()).getPrefix().equals("") ? "<" : "<" + nodeName.getPrefix() + ":";
            param1 = param1 + nodeName.getLocalPart() + ">";
            int cid = child2.getId();
            QName childQName = child2.getNodeQName();
            if (cid == 108) {
                childQName = ((DirElemConstructor)child2).getQName();
            }
            if (childQName == null) {
                param2 = child2.toString();
            } else {
                param2 = childQName.getPrefix().equals("") ? "<" : "<" + childQName.getPrefix() + ":";
                param2 = param2 + childQName.getLocalPart() + ">";
            }
            ASTMsg msg = new ASTMsg(errID, param1, param2, this);
            parser.reportError(3, msg);
            break;
        }
    }

    public static class ImportPrecedence {
        private static ImportPrecedence m_lowestPrecedence = new ImportPrecedence();
        private int precedence = 0;
        private ArrayList<ImportPrecedence> children;
        private ImportPrecedence root;

        private ImportPrecedence() {
        }

        public static ImportPrecedence createRootImportPrecedence(XSLTParser parser) {
            ImportPrecedence ip;
            ip.root = ip = new ImportPrecedence();
            return ip;
        }

        public static ImportPrecedence getLowestPrecedence() {
            return m_lowestPrecedence;
        }

        public static ImportPrecedence createUsingParent(ImportPrecedence ip) {
            if (ip.children == null) {
                ip.children = new ArrayList();
            }
            ImportPrecedence child2 = new ImportPrecedence();
            ip.children.add(child2);
            child2.root = ip.root;
            return child2;
        }

        public boolean hasSamePrecedenceAs(ImportPrecedence that) {
            return this == that;
        }

        public boolean hasHigherPrecedenceThan(ImportPrecedence that) {
            if (this.precedence > 0) {
                return this.precedence > that.precedence;
            }
            if (this.hasSamePrecedenceAs(that) || this.precedence == -1) {
                return false;
            }
            return this.root.findLower(this, that) == 0;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public void computePrecedenceOnImportTree() {
            this.computePrecedences(1);
        }

        private int computePrecedences(int p) {
            if (this.children != null) {
                for (ImportPrecedence child2 : this.children) {
                    p = child2.computePrecedences(p);
                }
            }
            this.precedence = p;
            return p + 1;
        }

        private int findLower(ImportPrecedence higher, ImportPrecedence lower2) {
            if (this.children != null) {
                for (ImportPrecedence child2 : this.children) {
                    int rc = child2.findLower(higher, lower2);
                    if (rc < 0) continue;
                    return rc;
                }
            }
            if (this == lower2) {
                return 0;
            }
            if (this == higher) {
                return 1;
            }
            return -1;
        }

        static {
            ImportPrecedence.m_lowestPrecedence.precedence = -1;
        }
    }
}

