/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OrderSpec;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.QuantifiedExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.WhereClause;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ILetClause;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IPositionalVar;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ISequenceType;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;

public class FLWORExpr
extends QuantifiedExpr {
    protected Expr _where = null;
    public static final int NO_MODIFIERS = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int EMPTY_GREATEST = 4;
    public static final int EMPTY_LEAST = 8;
    public static final int ASCENDING_EMPTY_GREATEST = 5;
    public static final int ASCENDING_EMPTY_LEAST = 9;
    public static final int DESCENDING_EMPTY_GREATEST = 6;
    public static final int DESCENDING_EMPTY_LEAST = 10;
    private static final Integer[] MODIFIERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), null, new Integer(4), new Integer(5), new Integer(6), null, new Integer(8), new Integer(9), new Integer(10)};
    private static final String[] STRING_MODIFIERS = new String[]{null, "ascending", "descending", null, "empty greatest", "ascending empty greatest", "descending empty greatest", null, "empty least", "ascending empty least", "descending empty least"};
    protected List m_osList;
    protected boolean m_orderByStable;
    protected List m_osExprList;
    protected List m_osModifiersList;
    protected List m_osCollationList;
    private TypeExpr lastSeqType = null;

    public FLWORExpr(int id2) {
        super(id2);
    }

    public Expr getWhere() {
        return this._where;
    }

    @Override
    public String toString(String prefix2) {
        StringBuffer buf = new StringBuffer();
        this.getXQueryString(buf, false, "  ");
        return buf.toString();
    }

    public static String getModifierAsString(int modifier) {
        return STRING_MODIFIERS[modifier];
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        int i;
        int prevVarIdType = -1;
        for (i = 0; i < this._vardecls.size(); ++i) {
            VariableRef pos;
            VarDecl vd = this.getVardecl(i);
            int varIdType = vd.getId();
            if (varIdType != prevVarIdType) {
                prevVarIdType = varIdType;
                if (i > 0) {
                    expr.append("\n");
                }
                if (varIdType == 45) {
                    expr.append(indent).append("let").append(' ');
                } else {
                    expr.append(indent).append("for").append(' ');
                }
            } else {
                expr.append(", ");
            }
            QName name2 = vd.getQName();
            expr.append("$").append(name2).append(" ");
            TypeExpr type2 = vd.getType();
            if (type2 != null) {
                expr.append(" as ");
                type2.getXQueryString(expr, abbreviate, indent + " ");
            }
            if ((pos = vd.getPositionalVar()) != null) {
                expr.append(" at ");
                pos.getXQueryString(expr, abbreviate, indent + " ");
                expr.append(" ");
            }
            if (varIdType == 45) {
                expr.append(":=").append(' ');
            } else {
                expr.append("in").append(' ');
            }
            Expr exprNode = vd.getExpression();
            exprNode.getXQueryString(expr, abbreviate, indent);
        }
        if (this._where != null) {
            expr.append("\n" + indent + "where ");
            this._where.getXQueryString(expr, abbreviate, indent + " ");
        }
        if (this.getOrderSpecCount() > 0) {
            if (this.isOrderByStable()) {
                expr.append(" stable");
            }
            expr.append("\n" + indent + " order by");
            for (i = 0; i < this.getOrderSpecCount(); ++i) {
                String collation2;
                if (i > 0) {
                    expr.append(",");
                }
                expr.append(" ");
                ((SimpleNode)this.getOrderSpecExpr(i)).getXQueryString(expr, abbreviate, indent);
                int mod2 = this.getOrderSpecModifiers(i);
                if (mod2 != 0) {
                    expr.append(" ").append(STRING_MODIFIERS[mod2]);
                }
                if ((collation2 = this.getOrderSpecCollation(i)) == null) continue;
                expr.append(" collation \"").append(collation2).append("\"");
            }
        }
        expr.append('\n').append(indent).append("return").append(' ');
        this._resExpr.getXQueryString(expr, abbreviate, indent + " ");
    }

    public String getOrderSpecCollation(int i) {
        if (this.getOrderSpecCount() > i) {
            return (String)this.m_osCollationList.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecCount() {
        return this.m_osExprList == null ? 0 : this.m_osExprList.size();
    }

    public Expr getOrderSpecExpr(int i) {
        if (this.getOrderSpecCount() > i) {
            return (Expr)this.m_osExprList.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getOrderSpecModifiers(int i) {
        if (this.getOrderSpecCount() > i) {
            return (Integer)this.m_osModifiersList.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    public Expr insertOrderSpec(int i, Expr expr, int modifiers, String collation2) {
        if (this.getOrderSpecCount() < i) {
            throw new IndexOutOfBoundsException();
        }
        if (modifiers < 0 || modifiers == 3 || modifiers == 7 || modifiers >= MODIFIERS.length) {
            throw new XPathError("ERR_INVALID_MODIFIER", new Integer(modifiers));
        }
        if (this.m_osExprList == null) {
            this.m_osExprList = new ArrayList(1);
            this.m_osCollationList = new ArrayList(1);
            this.m_osModifiersList = new ArrayList(1);
        }
        this.m_osCollationList.add(i, collation2);
        this.m_osExprList.add(i, expr);
        this.m_osModifiersList.add(i, MODIFIERS[modifiers]);
        return expr;
    }

    public boolean isOrderByStable() {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        return this.m_orderByStable;
    }

    public void setStableOrderBy(boolean flag) {
        if (this.getOrderSpecCount() == 0) {
            throw new XPathError("ERR_SYSTEM", "It is an invalid method call when there is no order by clause.");
        }
        this.m_orderByStable = flag;
    }

    public void removeOrderSpec(int i) {
        if (this.getOrderSpecCount() <= i) {
            throw new IndexOutOfBoundsException();
        }
        this.m_osCollationList.remove(i);
        Expr expr = (Expr)this.m_osExprList.remove(i);
        expr.jjtSetParent(null);
        this.m_osModifiersList.remove(i);
    }

    public Expr replaceOrderSpec(int i, Expr expr, int modifiers, String collation2) {
        this.removeOrderSpec(i);
        return this.insertOrderSpec(i, expr, modifiers, collation2);
    }

    public Expr getOrderSpec(int i) {
        return (Expr)this.m_osList.get(i);
    }

    public void addOrderSpec(Expr e) {
        if (this.m_osList == null) {
            this.m_osList = new ArrayList(1);
        }
        e = FLWORExpr.parentless(e);
        this.m_osList.add(0, e);
        e.jjtSetParent(this);
    }

    public int orderSpecCount() {
        if (this.m_osList != null) {
            return this.m_osList.size();
        }
        return 0;
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        switch (n2.getId()) {
            case 43: 
            case 47: 
            case 48: {
                this.addChildrenOfUselessNode(context2, n2, i);
                break;
            }
            case 46: {
                SimpleNode child2 = (SimpleNode)((WhereClause)n2).jjtGetChild(0);
                this._where = (Expr)this.reducedNode(context2, child2);
                break;
            }
            case 45: {
                ILetClause ilet = (ILetClause)n2;
                Vector vars = ilet.getVardecls();
                int k = 0;
                for (VarDecl decl : vars) {
                    decl.jjtSetParent(this);
                    this._vardecls.add(k, decl);
                    if (null != this.lastSeqType) {
                        decl.setType(this.lastSeqType);
                    }
                    ++k;
                }
                break;
            }
            case 49: {
                OrderSpec orderSpec = (OrderSpec)n2;
                String collation2 = orderSpec.getCollation() == null ? null : ((Literal)orderSpec.getCollation()).toString();
                this.insertOrderSpec(0, orderSpec.getSelect(), orderSpec.getOrderModifier(), collation2);
                this.addOrderSpec(orderSpec);
                break;
            }
            case 44: {
                IPositionalVar iposvar = (IPositionalVar)n2;
                VariableRef varRef = (VariableRef)iposvar.jjtGetChild(0);
                VarDecl forvar = this.getVardecl(0);
                forvar.setPositionalVar(varRef);
                break;
            }
            case 100: {
                super.jjtAddChild(context2, n2, i);
                VarDecl vd = this.getVardecl(0);
                if (vd == null) break;
                vd.setType(this.lastSeqType);
                break;
            }
            default: {
                if (!(n2 instanceof Expr)) {
                    n2 = this.reducedNode(context2, (SimpleNode)n2);
                }
                if (n2 instanceof ISequenceType) {
                    this.lastSeqType = ((ISequenceType)n2).getRealSeqType();
                    break;
                }
                super.jjtAddChild(context2, n2, i);
            }
        }
    }
}

