/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IQNameWrapper;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ISequenceType;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class FunctionDecl
extends TopLevelDecl {
    protected QName _name;
    protected TypeExpr _returnType;
    protected boolean _override = true;
    protected List _paramTypes;
    protected List _parameters = new ArrayList();
    protected FunctionDecl _duplicate = null;
    boolean m_external;

    public FunctionDecl(int i) {
        super(i);
    }

    public FunctionDecl() {
        super(32);
    }

    public boolean hasParams() {
        return this._parameters.size() > 0;
    }

    public void addParameter(Param param) {
        this._parameters.add(param);
        param.jjtSetParent(this);
    }

    public List getParameters() {
        return this._parameters;
    }

    public Param lookupParam(QName qname2) {
        for (int i = 0; i < this._parameters.size(); ++i) {
            Param p = (Param)this._parameters.get(i);
            if (!p.getQName().equals(qname2)) continue;
            return p;
        }
        return null;
    }

    public void setQName(QName name2) {
        this._name = name2;
    }

    public QName getQName() {
        return this._name;
    }

    public void setExternal(boolean value2) {
        this.m_external = value2;
    }

    public boolean isExternal() {
        return this.m_external;
    }

    public int getArity() {
        return this._parameters.size();
    }

    public boolean isOverride() {
        return this._override;
    }

    public List getParamTypes() {
        return this._paramTypes;
    }

    public TypeExpr getResultType() {
        return this._returnType;
    }

    public void setResultType(TypeExpr type2) {
        this._returnType = type2;
    }

    private void setTypeFromParams() {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList(this.getArity());
        }
        boolean typeSpecified = false;
        for (int i = 0; i < this._parameters.size(); ++i) {
            Node child2 = (Node)this._parameters.get(i);
            if (!(child2 instanceof Param)) continue;
            Param param = (Param)child2;
            TypeExpr type2 = param.getType();
            if (type2 == null) {
                type2 = null;
            } else {
                typeSpecified = true;
            }
            this._paramTypes.add(type2);
        }
        if (!typeSpecified) {
            this._paramTypes = null;
        }
    }

    public void setDuplicate(FunctionDecl duplicate) {
        this._duplicate = duplicate;
    }

    public FunctionDecl getDuplicate() {
        return this._duplicate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean parseContents(XSLTParser parser) {
        String override;
        QName qname2;
        String name2 = this.getAttribute("name");
        String nodeName = XPathTreeConstants.jjtNodeName[this.getId()];
        if (!parser.checkAttributeValue(this, nodeName, "name", name2, 3)) return false;
        if (name2.indexOf(":") > 0) {
            qname2 = parser.getQNameIgnoreDefaultNs(name2);
            if (!parser.checkForReservedNamespace(qname2, "xsl:function", (SimpleNode)this)) {
                return false;
            }
        } else {
            ASTMsg error2 = new ASTMsg("MISSING_PREFIX_IN_ATTRIB", "name", "xsl:function", this);
            parser.reportError(3, error2);
            return false;
        }
        this.setQName(qname2);
        String as = this.getAttribute("as");
        if (as.length() > 0) {
            this._returnType = parser.parseSequenceTypeExpression(this, as);
        }
        if ((override = this.getAttribute("override")).length() > 0) {
            if (override.trim().equalsIgnoreCase("yes")) {
                this._override = true;
            } else if (override.trim().equalsIgnoreCase("no")) {
                this._override = false;
            } else {
                ASTMsg error3 = new ASTMsg("INVALID_YES_NO_VALUE", (Object)"override", (SimpleNode)this);
                parser.reportError(3, error3);
                return false;
            }
        }
        this.parseChildren(parser);
        XStaticContext context2 = parser.getStaticContext();
        FunctionDecl func = context2.lookupStylesheetFunction(this._name, this.getArity());
        if (func != null) {
            Expr.ImportPrecedence them;
            Expr.ImportPrecedence us = this.getImportPrecedence();
            if (us.hasSamePrecedenceAs(them = func.getImportPrecedence())) {
                func.setDuplicate(this);
                return false;
            }
            if (them.hasHigherPrecedenceThan(us) || !this._override) {
                return false;
            }
            context2.removeStylesheetFunction(this._name, this.getArity());
        }
        if (this.getArity() > 0) {
            this.setTypeFromParams();
        }
        context2.addStylesheetFunction(this);
        return false;
    }

    public int getParamCount() {
        return this._parameters.size();
    }

    public QName getParamName(int idx) {
        Param p = (Param)this._parameters.get(idx);
        return p.getQName();
    }

    public Param getParam(int idx) {
        Param p = (Param)this._parameters.get(idx);
        return p;
    }

    public TypeExpr getParamType(int idx) {
        return null != this._paramTypes ? this._paramTypes.get(idx) : null;
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        expr.append("declare function ").append(this.getString(this.getQName())).append("(");
        this.getParamsString(expr, abbreviate, indent);
        if (null != this._returnType) {
            expr.append(") as ");
            this._returnType.getXQueryString(expr, abbreviate, indent);
        }
        if (this.isExternal()) {
            expr.append(" external");
        } else {
            expr.append("\n" + indent + "{\n" + indent + " ");
            this.getXQueryStringForChildren(expr, abbreviate, indent);
            expr.append("\n" + indent + "}" + indent + " ");
        }
        expr.append("\r\r");
    }

    protected void getParamsString(StringBuffer expr, boolean abbreviate, String indent) {
        List params = this.getParameters();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                expr.append(',');
            }
            Param p = this.getParam(i);
            p.getXQueryString(expr, abbreviate, indent);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        int childID = n2.getId();
        switch (childID) {
            case 191: {
                QName qname2 = ((IQNameWrapper)n2).getFunctionQName(this);
                if (qname2 == null) break;
                this.handleChild(qname2, context2);
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                this.addChildrenOfUselessNode(context2, n2, i);
                break;
            }
            case 34: {
                Param p = (Param)n2;
                p.jjtSetParent(this);
                this.jjtInsertChild(p, 0);
                if (this.lookupParam(p.getQName()) != null) {
                    ASTMsg error2 = new ASTMsg("ERR_XQ_FUNCTION_PARAM_REDEF", p.getQName(), this.getQName(), this);
                    context2.reportError(3, error2);
                }
                this._parameters.add(0, p);
                break;
            }
            case 165: {
                ISequenceType seqtype = (ISequenceType)n2;
                this._returnType = seqtype.getRealSeqType();
                break;
            }
            case 30: {
                this.setExternal(true);
                break;
            }
            default: {
                SimpleNode reduced = this.reducedNode(context2, (SimpleNode)n2);
                super.jjtInsertChild(reduced, 0);
            }
        }
    }

    private void handleChild(QName qname2, ASTBuildingContext context2) {
        String namespace2 = qname2.getNamespaceURI();
        if (namespace2 != null && namespace2.length() > 0) {
            if (context2.getStaticContext().isReservedNamespace(namespace2)) {
                context2.reportError(3, new ASTMsg("ERR_DEFUALT_FUNCTION_IN_IMPROPER_NAMESPACE", (Object)qname2, (SimpleNode)this));
                return;
            }
        } else {
            String defaultFuncNS = context2.getStaticContext().getDefaultNamespaceForFunction();
            if (defaultFuncNS == null || defaultFuncNS.equals("")) {
                context2.reportError(3, new ASTMsg("ERR_FUNCTION_NEEDS_NAMESPACE", (Object)qname2, (SimpleNode)this));
            }
            if (defaultFuncNS.equals("http://www.w3.org/2005/xpath-functions") || defaultFuncNS.equals("http://www.w3.org/XML/1998/namespace") || defaultFuncNS.equals("http://www.w3.org/2001/XMLSchema") || defaultFuncNS.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                context2.reportError(3, new ASTMsg("ERR_DEFUALT_FUNCTION_IN_IMPROPER_NAMESPACE", (Object)qname2, (SimpleNode)this));
            }
            qname2 = new QName(defaultFuncNS, qname2.getLocalPart());
            this.setQName(qname2);
            return;
        }
        this.setQName(qname2);
    }

    @Override
    public void finishAddingChild(ASTBuildingContext context2, IQNameWrapper name2) {
        this.handleChild(name2.getQName(null), context2);
    }

    @Override
    public void jjtClose(ASTBuildingContext context2) {
        super.jjtClose(context2);
        XStaticContext statcontext = context2.getStaticContext();
        FunctionDecl func = statcontext.lookupStylesheetFunction(this._name, this.getArity());
        if (func != null) {
            Expr.ImportPrecedence them;
            Expr.ImportPrecedence us = this.getImportPrecedence();
            if (us.hasSamePrecedenceAs(them = func.getImportPrecedence())) {
                func.setDuplicate(this);
                return;
            }
            if (them.hasHigherPrecedenceThan(us) || !this._override) {
                return;
            }
            statcontext.removeStylesheetFunction(this._name, this.getArity());
        }
        if (this.getArity() > 0) {
            this.setTypeFromParams();
        }
        statcontext.addStylesheetFunction(this);
    }
}

