/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IQNameWrapper;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IStringLiteral;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class ImportSchemaOrModule
extends TopLevelDecl {
    String _prefix = "";
    String _namespace = "";
    boolean _hasInlineSchema = false;
    List<String> _hints = new ArrayList<String>();

    public ImportSchemaOrModule() {
        super(26);
    }

    public ImportSchemaOrModule(int i) {
        super(i);
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        int childID = n2.getId();
        switch (childID) {
            case 27: {
                SimpleNode sn = (SimpleNode)n2;
                if (sn.jjtGetNumChildren() > 0) {
                    QName namespaceBinding = ((IQNameWrapper)sn.jjtGetChild(0)).getQName(this);
                    if (namespaceBinding == null) break;
                    this.handleChild(namespaceBinding);
                    String prefix2 = this.getPrefix();
                    String uri2 = this.getNamespace();
                    this.checkNamespaceBinding(context2, prefix2, uri2);
                    context2.getStaticContext().addSchemaImportNamespace(prefix2, uri2, context2);
                    context2.getStaticContext().addStaticallyKnownNamespace(prefix2, uri2);
                    break;
                }
                this._prefix = "";
                this._namespace = this._hints.remove(0);
                XStaticContext cont = context2.getStaticContext();
                cont.setDefaultNamespaceForElementType(this._namespace);
                cont.markDefaultNamespaceForElementTypeSet();
                break;
            }
            case 191: {
                IQNameWrapper qname2 = (IQNameWrapper)n2;
                QName namespaceBinding = qname2.getQName(this);
                if (namespaceBinding == null) break;
                this.handleChild(namespaceBinding);
                String prefix3 = this.getPrefix();
                String uri3 = this.getNamespace();
                this.checkNamespaceBinding(context2, prefix3, uri3);
                context2.getStaticContext().addStaticallyKnownNamespace(prefix3, uri3);
                break;
            }
            case 185: {
                String uri4 = ((IStringLiteral)n2).getStr();
                this._hints.add(0, uri4);
                this.checkNamespaceBinding(context2, "", uri4);
                break;
            }
            default: {
                this.assertChildAddNotHandled(childID);
            }
        }
    }

    private void checkNamespaceBinding(ASTBuildingContext context2, String prefix2, String uri2) {
        ASTMsg err = null;
        if (prefix2.equals("xmlns") || prefix2.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(uri2)) {
            err = new ASTMsg("ERR_XQ_XML_PREFIX", this);
        } else if (prefix2.equals("xml")) {
            err = new ASTMsg("ERR_XQ_XML_PREFIX2", this);
        } else if (uri2.length() == 0) {
            err = this.getId() == 26 ? new ASTMsg("ERR_XQ_NS_EMPTY_STRING", new Object[]{prefix2}, (SimpleNode)this) : new ASTMsg("ERR_XQ_MODULE_NS_EMPTY_STRING", new Object[]{prefix2}, (SimpleNode)this);
        }
        if (err != null) {
            context2.reportError(2, err);
        }
    }

    private void handleChild(QName namespaceBinding) {
        this._prefix = namespaceBinding.getLocalPart();
        this._namespace = this._hints.remove(0);
    }

    @Override
    public void finishAddingChild(ASTBuildingContext context2, IQNameWrapper name2) {
        this.handleChild(name2.getQName(null));
    }

    public void addLocationHint(String uri2) {
        this._hints.add(uri2);
    }

    public List<String> getHints() {
        return this._hints;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix2) {
        this._prefix = prefix2;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setNamespace(String namespace2) {
        this._namespace = namespace2;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String targetNS;
        if (this.hasAttribute("namespace")) {
            targetNS = this.getAttribute("namespace");
            if (targetNS.length() == 0) {
                ASTMsg error2 = new ASTMsg("ERR_XSLT_IMPORTSCHEMA", this);
                parser.reportError(2, error2);
            }
        } else {
            targetNS = "";
        }
        this.setNamespace(targetNS);
        if (this.hasAttribute("schema-location")) {
            this.addLocationHint(this.getAttribute("schema-location"));
        }
        this.parseOwnChildren(parser);
        this.addSchemasToStaticContext(parser);
        return false;
    }

    private void parseOwnChildren(XSLTParser parser) {
        int childCount = this.jjtGetNumChildren();
        int schemaChildCount = 0;
        for (int i = 0; i < childCount; ++i) {
            ASTMsg error2;
            Expr child2 = (Expr)this.jjtGetChild(i);
            if (child2 instanceof DirElemConstructor) {
                DirElemConstructor childElem = (DirElemConstructor)child2;
                QName childElemName = childElem.getQName();
                boolean bl = this._hasInlineSchema = childElemName.getLocalPart().equals("schema") && childElemName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema");
                if (this._hasInlineSchema) {
                    ++schemaChildCount;
                }
                if (this._hasInlineSchema && schemaChildCount == 1) {
                    String inlineTargetNamespace;
                    String string2 = inlineTargetNamespace = childElem.hasAttribute("targetNamespace") ? childElem.getAttribute("targetNamespace") : "";
                    if (!this.hasAttribute("namespace")) {
                        this.setNamespace(inlineTargetNamespace);
                        continue;
                    }
                    String importNamespace = this.getNamespace();
                    if (importNamespace.equals(inlineTargetNamespace)) continue;
                    ASTMsg error3 = new ASTMsg("IMPORT_SCHEMA_TARGET_INLINE_MISMATCH_ERR", null, (SimpleNode)this);
                    parser.reportError(2, error3);
                    continue;
                }
                error2 = new ASTMsg("IMPORT_SCHEMA_CONTENT_ERR", null, (SimpleNode)this);
                parser.reportError(2, error2);
                continue;
            }
            if (child2.isSimpleStringValue()) {
                String textValue = child2.getSimpleStringValue();
                for (int ch = 0; ch < textValue.length(); ++ch) {
                    if (XML11Char.isXML11Space(textValue.charAt(ch))) continue;
                    error2 = new ASTMsg("IMPORT_SCHEMA_CONTENT_ERR", null, (SimpleNode)this);
                    parser.reportError(2, error2);
                }
                continue;
            }
            ASTMsg error4 = new ASTMsg("IMPORT_SCHEMA_CONTENT_ERR", null, (SimpleNode)this);
            parser.reportError(2, error4);
        }
        if (schemaChildCount != 0 && this.hasAttribute("schema-location")) {
            ASTMsg error5 = new ASTMsg("IMPORT_SCHEMA_HINT_WITH_INLINE_SCHEMA_ERR", null, (SimpleNode)this);
            parser.reportError(2, error5);
        }
    }

    public boolean hasInlineSchema() {
        return this._hasInlineSchema;
    }

    public DirElemConstructor getInlineSchema() {
        if (this._hasInlineSchema) {
            int childCount = this.jjtGetNumChildren();
            for (int i = 0; i < childCount; ++i) {
                Node child2 = this.jjtGetChild(i);
                if (!(child2 instanceof DirElemConstructor)) continue;
                return (DirElemConstructor)child2;
            }
        }
        return null;
    }

    private void addSchemasToStaticContext(ASTBuildingContext context2) {
        String namespace2;
        XStaticContext cont = context2.getStaticContext();
        List listOfImports = cont.lookupImportedSchemaDecls(namespace2 = this.getNamespace());
        if (listOfImports != null && !listOfImports.isEmpty()) {
            Expr.ImportPrecedence them;
            Expr.ImportPrecedence us = this.getImportPrecedence();
            if (us.hasSamePrecedenceAs(them = ((ImportSchemaOrModule)listOfImports.get(0)).getImportPrecedence())) {
                cont.addImportedSchemaDecl(namespace2, this, false);
            } else if (us.hasHigherPrecedenceThan(them)) {
                cont.addImportedSchemaDecl(namespace2, this, true);
            }
        } else {
            cont.addImportedSchemaDecl(namespace2, this, true);
        }
    }

    private void addModulesToStaticContext(ASTBuildingContext context2) {
        String namespace2;
        XStaticContext cont = context2.getStaticContext();
        if (cont.getModuleImport(namespace2 = this.getNamespace()) == null) {
            cont.addModuleImport(namespace2, this);
        } else {
            context2.reportError(2, new ASTMsg("ERR_XQ_MODULE_DUPLICATE_TARGET_NS", new Object[]{namespace2}, (SimpleNode)this));
        }
    }

    @Override
    public void jjtClose(ASTBuildingContext context2) {
        if (this._prefix.length() == 0 && this._namespace.length() == 0 && !this._hints.isEmpty()) {
            this._namespace = this._hints.remove(0);
        }
        if (this.id == 26) {
            this.addSchemasToStaticContext(context2);
        } else {
            this.addModulesToStaticContext(context2);
        }
    }
}

