/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import java.io.PrintStream;
import javax.xml.namespace.QName;

public final class Key
extends TopLevelDecl {
    private QName _name;
    private Expr _match;
    private Expr _use;
    private String _collation;
    private boolean haveKeySpecifierCache = false;
    private String keySpecifierCache = null;

    public Key() {
        super(223);
    }

    public Key(int i) {
        super(i);
    }

    @Override
    public void dump(String indent, PrintStream out) {
        out.print(indent + "Key");
        out.print(" name=" + this._name);
        if (null == this._match) {
            out.println(" match:NONE");
        } else {
            out.println(" match:");
            this._match.dump(" " + indent, out);
        }
        if (null == this._use) {
            out.println(" use:NONE");
        } else {
            out.println(" use:");
            this._use.dump(" " + indent, out);
        }
        if (null == this._collation) {
            out.println(" collation:NONE");
        } else {
            out.println(" collation=" + this._collation);
        }
        this.dumpChildren(indent + " ", out);
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        if (!parser.isXSLT20()) {
            this.checkContent(parser);
            this._use = parser.parseExpression(this, "use", null);
        } else if (this.hasAttribute("use")) {
            this.checkContent(parser, "ERR_KEY_USE_ATTR_AND_CONTENT_SPECIFIED");
            this._use = parser.parseExpression(this, "use", null);
        } else {
            if (this.jjtGetNumChildren() == 0) {
                ASTMsg error2 = new ASTMsg("ERR_KEY_USE_ATTR_OR_CONTENT_REQUIRED", null, (SimpleNode)this);
                parser.reportError(2, error2);
            }
            this.parseChildren(parser);
            boolean hasSequenceCtor = false;
            for (Object o : this.getChildren()) {
                if (o instanceof Text && ((Text)o).isIgnore()) continue;
                hasSequenceCtor = true;
                break;
            }
            if (!hasSequenceCtor) {
                ASTMsg error3 = new ASTMsg("ANALYZESTRING_MATCHING_NONMATCHING_ERR", null, (SimpleNode)this);
                parser.reportError(2, error3);
            }
        }
        String name2 = this.getAttribute("name");
        String nodeName = XPathTreeConstants.jjtNodeName[this.getId()];
        parser.checkAttributeValue(this, nodeName, "name", name2, 3);
        this._name = parser.getQNameIgnoreDefaultNs(name2);
        parser.checkForReservedNamespace(this._name, "xsl-key", (SimpleNode)this);
        this._match = parser.parsePattern(this, "match", null);
        if (this.hasAttribute("collation")) {
            try {
                String collationURIReference = this.getAttribute("collation");
                if (SystemIDResolver.isAbsoluteURI(collationURIReference)) {
                    this._collation = collationURIReference;
                }
                this._collation = SystemIDResolver.getAbsoluteURI(collationURIReference, this.getBaseURI());
            }
            catch (URI.MalformedURIException e) {
                throw new WrappedRuntimeException(e);
            }
        } else {
            this._collation = this.getDefaultCollationURI(parser);
        }
        return false;
    }

    public QName getQName() {
        return this._name;
    }

    public Expr getMatch() {
        return this._match;
    }

    public Expr getUse() {
        return this._use;
    }

    public void setUse(Expr use) {
        this._use = use;
    }

    public String getCollation() {
        return this._collation;
    }

    public void setCollation(String collation2) {
        this._collation = collation2;
    }

    public String getTextKeySpecifier() {
        if (this.haveKeySpecifierCache) {
            return this.keySpecifierCache;
        }
        this.haveKeySpecifierCache = true;
        if (this._use != null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (Object obj : this.getChildren()) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                if (t.isIgnore()) continue;
                s.append(t.getText());
                continue;
            }
            return null;
        }
        this.keySpecifierCache = s.toString();
        return this.keySpecifierCache;
    }
}

