/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathVisitor;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IPredefinedEntityRef;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Literal
extends Expr {
    protected Object m_literal;

    public Literal(int i) {
        super(i);
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate) {
        switch (this.getId()) {
            case 5: {
                expr.append('\'').append(this.m_literal.toString()).append('\'');
                break;
            }
            default: {
                expr.append(this.m_literal.toString());
            }
        }
    }

    public void setIntValue(BigInteger value2) {
        this.m_literal = value2;
        this.id = 97;
    }

    public void setDecimalValue(BigDecimal value2) {
        this.m_literal = value2;
        this.id = 98;
    }

    public void setStringValue(String value2) {
        this.m_literal = value2;
        this.id = 5;
    }

    public void setDoubleValue(double value2) {
        this.m_literal = new Double(value2);
        this.id = 99;
    }

    public BigDecimal getDecimalLiteral() throws XPath20Exception {
        if (this.getId() == 98) {
            return (BigDecimal)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a decimal");
    }

    public double getDecimalLiteralAsDouble() throws XPath20Exception {
        return this.getDecimalLiteral().doubleValue();
    }

    public double getDoubleLiteral() throws XPath20Exception {
        if (this.getId() == 99) {
            return (Double)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a double");
    }

    public BigInteger getIntegerLiteral() throws XPath20Exception {
        if (this.getId() == 97) {
            return (BigInteger)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not an integer");
    }

    public int getIntegerLiteralAsInt() throws XPath20Exception {
        return this.getIntegerLiteral().intValue();
    }

    public String getStringLiteral() {
        if (this.getId() == 5) {
            return (String)this.m_literal;
        }
        throw new XPath20Exception("ERR_SYSTEM", "Invalid method call: the literal is not a string");
    }

    @Override
    public String getSimpleStringValue() {
        return (String)this.m_literal;
    }

    @Override
    public boolean isSimpleStringValue() {
        return this.getId() == 5;
    }

    @Override
    public String getXQueryString(boolean abbreviate) {
        return this.m_literal.toString();
    }

    @Override
    public void processToken(ASTBuildingContext context2, Token token) {
        super.processToken(context2, token);
        switch (this.id) {
            case 97: {
                this.m_literal = new BigInteger(token.image);
                break;
            }
            case 99: {
                this.m_literal = new Double(token.image);
                break;
            }
            case 5: 
            case 185: {
                String val = token.image.substring(1, token.image.length() - 1);
                String lang2 = context2.getExpressionFactory().getLanguage();
                if (!lang2.equals("XPath1") && !lang2.equals("XSLT1")) {
                    char delimChar = token.image.charAt(0);
                    char[] newVal = new char[val.length()];
                    int newLen = 0;
                    String ref = "";
                    for (int i = 0; i < val.length(); ++i) {
                        char c = val.charAt(i);
                        if (c == delimChar) {
                            newVal[newLen++] = c;
                            ++i;
                            continue;
                        }
                        if (lang2.equals("XQuery1") && c == '&') {
                            ref = this.collectReference(val, i);
                            if (ref.length() > 0) {
                                i += ref.length() - 1;
                                ref = IPredefinedEntityRef.expandReference(ref);
                                for (int j = 0; j < ref.length(); ++j) {
                                    newVal[newLen++] = ref.charAt(j);
                                }
                            } else {
                                newVal[newLen++] = c;
                            }
                            if (!ref.equals("")) continue;
                            ASTMsg error2 = new ASTMsg("XPATH_PARSER_ERR", val);
                            context2.reportError(2, error2);
                            continue;
                        }
                        newVal[newLen++] = c;
                    }
                    val = new String(newVal, 0, newLen);
                }
                this.m_literal = val;
                break;
            }
            case 98: {
                this.m_literal = new BigDecimal(token.image);
                break;
            }
            default: {
                throw new XPathError("ERR_SYSTEM", "Invalid JJTree id:" + this.id);
            }
        }
    }

    private String collectReference(String val, int pos) {
        int i;
        char[] newVal = new char[val.length()];
        int newLen = 0;
        for (i = pos; i < val.length(); ++i) {
            newVal[newLen++] = val.charAt(i);
            if (val.charAt(i) == ';') break;
        }
        if (newLen > 0 && i != val.length()) {
            return new String(newVal, 0, newLen);
        }
        return "";
    }

    @Override
    public String toString() {
        return XPathTreeConstants.jjtNodeName[this.id] + " " + this.getClass() + " " + this.getXQueryString(false);
    }

    @Override
    public Object jjtAccept(XPathVisitor visitor, Object data2) {
        return visitor.visit(this, null);
    }

    @Override
    public int getId() {
        switch (this.id) {
            case 5: 
            case 147: 
            case 185: {
                return 5;
            }
        }
        return super.getId();
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        switch (this.getId()) {
            case 5: {
                StringBuffer buf = new StringBuffer(this.m_literal.toString());
                for (int i = 0; i < buf.length(); ++i) {
                    if (buf.charAt(i) != '\'') continue;
                    buf.insert(i, '\'');
                    ++i;
                }
                expr.append('\'').append(buf.toString()).append('\'');
                break;
            }
            default: {
                expr.append(this.m_literal.toString());
            }
        }
    }

    @Override
    public String getValue() {
        return this.m_literal.toString();
    }
}

