/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import org.xml.sax.Attributes;

public final class Number
extends Expr {
    public static final int LEVEL_SINGLE = 0;
    public static final int LEVEL_MULTIPLE = 1;
    public static final int LEVEL_ANY = 2;
    private Expr _from = null;
    private Expr _count = null;
    private Expr _value = null;
    private Expr _select = null;
    private Expr _lang = null;
    private Expr _format = null;
    private Expr _letterValue = null;
    private Expr _groupingSeparator = null;
    private Expr _groupingSize = null;
    private Expr _ordinal = null;
    private int _level = 0;
    private boolean _levelExists = false;
    private boolean _formatNeeded = false;

    public Number() {
        super(206);
    }

    public Number(int i) {
        super(i);
    }

    public boolean isFormatNeeded() {
        return this._formatNeeded;
    }

    public Expr getCount() {
        return this._count;
    }

    public boolean levelExists() {
        return this._levelExists;
    }

    public Expr getFrom() {
        return this._from;
    }

    public Expr getSelect() {
        return this._select;
    }

    public Expr getFormat() {
        return this._format;
    }

    public Expr getLang() {
        return this._lang;
    }

    public Expr getLetterValue() {
        return this._letterValue;
    }

    public Expr getGroupingSeparator() {
        return this._groupingSeparator;
    }

    public Expr getGroupingSize() {
        return this._groupingSize;
    }

    public Expr getOrdinal() {
        return this._ordinal;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        this.checkContent(parser);
        Attributes attributes2 = this.getAttributes();
        int count2 = attributes2.getLength();
        for (int i = 0; i < count2; ++i) {
            String attrValue;
            String name2 = attributes2.getQName(i);
            String value2 = attributes2.getValue(i);
            if (name2.equals("value")) {
                this._value = parser.parseExpression(this, name2, null);
                continue;
            }
            if (name2.equals("select")) {
                this._select = parser.parseExpression(this, name2, null);
                continue;
            }
            if (name2.equals("count")) {
                this._count = parser.parsePattern(this, name2, null);
                continue;
            }
            if (name2.equals("from")) {
                this._from = parser.parsePattern(this, name2, null);
                continue;
            }
            if (name2.equals("level")) {
                if (value2.equals("single")) {
                    this._level = 0;
                } else if (value2.equals("multiple")) {
                    this._level = 1;
                } else if (value2.equals("any")) {
                    this._level = 2;
                } else {
                    parser.reportError(3, new ASTMsg("NUMBER_LEVEL_ERR", value2));
                }
                this._levelExists = true;
                continue;
            }
            if (name2.equals("format")) {
                this._format = Number.parseAVTAttrContent(parser, value2, this);
                this._formatNeeded = true;
                continue;
            }
            if (name2.equals("lang")) {
                this._lang = Number.parseAVTAttrContent(parser, value2, this);
                this._formatNeeded = true;
                continue;
            }
            if (name2.equals("letter-value")) {
                this._letterValue = Number.parseAVTAttrContent(parser, value2, this);
                if (this._letterValue.isSimpleStringValue() && !(attrValue = this._letterValue.getSimpleStringValue()).equals("alphabetic") && !attrValue.equals("traditional")) {
                    parser.reportError(3, new ASTMsg("NUMBER_LETTERVALUE_ERR"));
                }
                this._formatNeeded = true;
                continue;
            }
            if (name2.equals("grouping-separator")) {
                parser.checkAttributeLength(this, name2, value2);
                this._groupingSeparator = Number.parseAVTAttrContent(parser, value2, this);
                if (this._groupingSeparator.isSimpleStringValue() && (attrValue = this._groupingSeparator.getSimpleStringValue()) != null && value2.codePointCount(0, value2.length()) > 1) {
                    parser.reportError(4, new ASTMsg("NUMBER_GROUPSEPARATOR_ERR", attrValue));
                }
                this._formatNeeded = true;
                continue;
            }
            if (name2.equals("grouping-size")) {
                try {
                    if (!value2.startsWith("{$") || !value2.endsWith("}")) {
                        Integer.parseInt(value2);
                    }
                }
                catch (NumberFormatException nfe) {
                    parser.reportError(3, new ASTMsg("INVALID_ATTR_VALUE_ERR"));
                }
                this._groupingSize = Number.parseAVTAttrContent(parser, value2, this);
                this._formatNeeded = true;
                continue;
            }
            if (!name2.equals("ordinal")) continue;
            this._ordinal = Number.parseAVTAttrContent(parser, value2, this);
            this._formatNeeded = true;
        }
        return false;
    }

    public boolean hasValue() {
        return this._value != null;
    }

    public boolean hasSelect() {
        return this._select != null;
    }

    public Expr getValueExpr() {
        return this._value;
    }

    public void setValue(Expr value2) {
        this._value = value2;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isDefault() {
        return this._from == null && this._count == null;
    }
}

