/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.XPath20Utilities;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Utilities;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathVisitor;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.common.utils.Assert;

public class OperatorExpr
extends Expr {
    public static final short COMMA_SEQUENCE = 0;
    public static final short UNION_COMBINE = 1;
    public static final short INTERSECT_COMBINE = 2;
    public static final short EXCEPT_COMBINE = 3;
    public static final short PLUS_ADDITIVE = 4;
    public static final short MINUS_ADDITIVE = 5;
    public static final short TO = 6;
    public static final short EQUAL_VALUE_COMPARISON = 7;
    public static final short NOTEQUAL_VALUE_COMPARISON = 8;
    public static final short LESSTHAN_VALUE_COMPARISON = 9;
    public static final short LESSOREQUALTHAN_VALUE_COMPARISON = 10;
    public static final short GREATTHAN_VALUE_COMPARISON = 11;
    public static final short GREATOREQUALTHAN_VALUE_COMPARISON = 12;
    public static final short EQUAL_GENERAL_COMPARISON = 13;
    public static final short NOTEQUAL_GENERAL_COMPARISON = 14;
    public static final short LESSTHAN_GENERAL_COMPARISON = 15;
    public static final short LESSOREQUALTHAN_GENERAL_COMPARISON = 16;
    public static final short GREATTHAN_GENERAL_COMPARISON = 17;
    public static final short GREATOREQUALTHAN_GENERAL_COMPARISON = 18;
    public static final short IS_NODE_COMPARISON = 19;
    public static final short IS_NOT_NODE_COMPARISON = 20;
    public static final short EARLIERTHAN_ORDER_COMPARISON = 21;
    public static final short LATERTHAN_ORDER_COMPARISON = 22;
    public static final short AND_LOGICAL = 23;
    public static final short OR_LOGICAL = 24;
    public static final short PLUS_UNARY = 25;
    public static final short MINUS_UNARY = 26;
    public static final short SLASH_STEP = 27;
    public static final short SLASH_SLASH_STEP = 28;
    public static final short COMMA = 29;
    public static final short MULT_PRODUCT = 30;
    public static final short MULT_DIV = 31;
    public static final short MULT_IDIV = 32;
    public static final short MULT_MOD = 33;
    private static final String[] OPTYPE2STRING = new String[]{",", "|", "intersect", "except", "+", "-", "to", "eq", "ne", "lt", "le", "gt", "ge", "=", "!=", "<", "<=", ">", ">=", "is", "isnot", "<<", ">>", "and", "or", "+", "-", "/", "//", ",", "*", "div", "idiv", "mod"};
    private static final boolean[] SPACE_NEEDED = new boolean[]{false, false, true, true, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false, false, true, true, true};
    private static final short[] OPERATOR_PRECEDENCE = new short[]{1, 13, 14, 14, 10, 10, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 2, 12, 12, 15, 15, 1, 11, 11, 11, 11};
    private short _opType;

    public OperatorExpr(int i) {
        super(i);
    }

    public OperatorExpr(int i, OperatorExpr oe) {
        super(i, oe);
        this._opType = oe._opType;
    }

    protected final boolean isSpaceNeeded() {
        return SPACE_NEEDED[this._opType];
    }

    @Override
    protected short getOperatorPrecedence() {
        return OPERATOR_PRECEDENCE[this._opType];
    }

    public boolean isUnary() {
        return this._opType == 25 || this._opType == 26;
    }

    @Override
    public boolean canBeFlatten(ASTBuildingContext context2, Expr expr) {
        if (expr.getId() == 165 && this._opType == 29 && ((OperatorExpr)expr).getOperatorType() == 29) {
            return true;
        }
        boolean flatten = context2.getExpressionFactory().flatten();
        return flatten && expr.getId() == this.getId() && ((OperatorExpr)expr).getOperatorType() == this._opType;
    }

    public String getOperatorChar() {
        return OPTYPE2STRING[this._opType];
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(" ");
        if (this.jjtGetParent() == null && this.getOperandCount() == 0) {
            buf.append("()");
        } else {
            String oper = this.getOperatorChar();
            if (null != oper) {
                buf.append(oper);
            }
        }
        return buf.toString();
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        if (this.jjtGetParent() == null && this.getOperandCount() == 0) {
            expr.append("()");
        } else {
            boolean pred = this.lowerPrecedence();
            if (pred) {
                expr.append('(');
            }
            int size = this.getOperandCount();
            String oper = this.getOperatorChar();
            if (this._opType == 26 || this._opType == 25) {
                expr.append(oper);
            }
            for (int i = 0; i < size; ++i) {
                Expr op2 = this.getOperand(i);
                if (null == op2) continue;
                op2.getXQueryString(expr, abbreviate, indent);
                if (i >= size - 1) continue;
                if (this.isSpaceNeeded()) {
                    expr.append(' ');
                }
                expr.append(oper);
                if (!this.isSpaceNeeded()) continue;
                expr.append(' ');
            }
            if (pred) {
                expr.append(')');
            }
        }
    }

    @Override
    public boolean isRootOnSelfNode() {
        return this.getOperandCount() == 1 && this.getOperand(0).isRootOnSelfNode();
    }

    protected Expr getLastOperand() {
        int numChildren = this.jjtGetNumChildren();
        return (Expr)(numChildren == 0 ? null : this.jjtGetChild(numChildren - 1));
    }

    public void setOpType(short opType) {
        this._opType = opType;
    }

    public Expr addOperand(ASTBuildingContext context2, Expr operand2) throws XPath20Exception {
        operand2 = XPath20Utilities.parentless(operand2);
        super.jjtAppendChild(context2, operand2);
        return operand2;
    }

    public Expr insertOperand(int i, Expr operand2) {
        operand2 = XPath20Utilities.parentless(operand2);
        super.jjtInsertChild(operand2, i);
        return operand2;
    }

    public Expr replaceOperand(ASTBuildingContext context2, int i, Expr operand2) throws XPath20Exception {
        operand2 = XPath20Utilities.parentless(operand2);
        Expr old2 = this.getOperand(i);
        old2.jjtSetParent(null);
        super.jjtAddChild(context2, operand2, i);
        return operand2;
    }

    public void append(ASTBuildingContext context2, OperatorExpr expr) throws XPath20Exception {
        if (expr.getId() == this.getId() && expr.getOperatorType() == this._opType) {
            int size = expr.getOperandCount();
            for (int i = 0; i < size; ++i) {
                this.addOperand(context2, expr.getOperand(i));
            }
        } else {
            throw new XPath20Exception("ERR_SYSTEM", "Operator expressions do not match with the type.");
        }
    }

    public Expr getOperand(int i) {
        Node n2 = this.jjtGetChild(i);
        try {
            return (Expr)n2;
        }
        catch (ClassCastException e) {
            Assert._assert(true, "\nYikes! Node can't be cast to Expr: " + n2.getClass().getName());
            return null;
        }
    }

    public Expr getLHS() {
        Expr n2;
        int operandChildIndex = 0;
        while ((n2 = (Expr)this.jjtGetChild(operandChildIndex)) == null) {
            ++operandChildIndex;
        }
        try {
            return n2;
        }
        catch (ClassCastException e) {
            Assert._assert(true, "\nYikes! Node can't be cast to Expr: " + n2.getClass().getName());
            return null;
        }
    }

    public Expr getRHS() {
        Expr n2;
        int operandChildIndex = 0;
        while (this.jjtGetChild(operandChildIndex) == null) {
            ++operandChildIndex;
        }
        ++operandChildIndex;
        while ((n2 = (Expr)this.jjtGetChild(operandChildIndex)) == null) {
            ++operandChildIndex;
        }
        try {
            return n2;
        }
        catch (ClassCastException e) {
            Assert._assert(true, "\nYikes! Node can't be cast to Expr: " + n2.getClass().getName());
            return null;
        }
    }

    public int getOperandCount() {
        return this.jjtGetNumChildren();
    }

    public short getOperatorType() {
        return this._opType;
    }

    public void removeOperand(Expr operand2) throws XPath20Exception {
        super.jjtRemoveChild(operand2);
    }

    @Override
    public void processToken(ASTBuildingContext context2, Token token) {
        if (this.id != 40) {
            this._opType = Utilities.getOpType(token.image);
        }
    }

    @Override
    public void processValue(ASTBuildingContext context2, String str) {
        if (this.id != 40) {
            this._opType = Utilities.getOpType(str);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        if (n2.getId() == 70) {
            this._opType = (short)26;
        } else if (n2.getId() == 71) {
            this._opType = (short)25;
        } else {
            SimpleNode sn = (SimpleNode)n2;
            if (sn.canBeReduced() || this._opType == 29 && sn.getId() == 40) {
                if (n2.jjtGetNumChildren() == 1 && this.canBeFlatten(context2, (Expr)n2.jjtGetChild(0))) {
                    this.jjtInsertNodeChildren(context2, n2.jjtGetChild(0), 0);
                } else {
                    this.jjtInsertNodeChildren(context2, n2, 0);
                }
            } else {
                if (!(n2 instanceof Expr)) {
                    Assert._assert(true, "Child not good for inserting into operator " + this._opType + ", child is " + XPathTreeConstants.jjtNodeName[n2.getId()]);
                }
                this.jjtInsertChild(n2, 0);
            }
        }
    }

    private boolean isComparisonType() {
        switch (this.getOpType()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void jjtInsertNodeChildren(ASTBuildingContext context2, Node n2, int idx) throws IndexOutOfBoundsException {
        int size = n2.jjtGetNumChildren();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Node child2 = n2.jjtGetChild(i);
                child2.jjtSetParent(this);
                Assert._assert(child2 instanceof Expr, this.toString());
                this.jjtInsertChild(child2, idx + i);
            }
        }
    }

    @Override
    public boolean canBeReduced() {
        return !this.isUnary() && this.getOperandCount() == 1 && this._opType != 28;
    }

    @Override
    public Object jjtAccept(XPathVisitor visitor, Object data2) {
        return visitor.visit(this, null);
    }

    public short getOpType() {
        return this._opType;
    }
}

