/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public final class Output
extends TopLevelDecl {
    private String _version;
    private String _method;
    private String _encoding;
    private boolean _omitHeader = false;
    private String _standalone;
    private String _doctypePublic;
    private String _doctypeSystem;
    private String _cdata;
    private boolean _indent = false;
    private String _mediaType;
    private boolean _disabled = false;
    public static final String XML_VERSION = "1.0";
    public static final String HTML_VERSION = "4.0";

    public Output(int i) {
        super(i);
    }

    public Output() {
        super(212);
    }

    @Override
    public String toString(String indent) {
        return indent + "Output " + this._method;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public String getVersion() {
        return this._version;
    }

    public String getStandalone() {
        return this._standalone;
    }

    public boolean isIndent() {
        return this._indent;
    }

    public void disable() {
        this._disabled = true;
    }

    public boolean isEnabled() {
        return !this._disabled;
    }

    public boolean isOmitHeader() {
        return this._omitHeader;
    }

    public String getCdata() {
        return this._cdata;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public String getOutputMethod() {
        return this._method;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void mergeCdata(String cdata) {
    }

    private char getFirstCharLocName(String lexicalQName) {
        int i = lexicalQName.indexOf(58);
        char first = i < 0 ? lexicalQName.charAt(0) : lexicalQName.charAt(i + 1);
        return first;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parseContents(XSLTParser parser) {
        this.checkContent(parser);
        Attributes attributes2 = this.getAttributes();
        String nodeName = XPathTreeConstants.jjtNodeName[this.getId()];
        if (attributes2 != null) {
            int attr2;
            Expr.ImportPrecedence impPrecedence = parser.getCurrentImportPrecedence();
            XTQProgram top = parser.getTopLevelXTQProgram();
            String nameAsExpandedQName = "";
            int numAtts = attributes2.getLength();
            for (attr2 = 0; attr2 < numAtts; ++attr2) {
                String qName = attributes2.getQName(attr2);
                String value2 = attributes2.getValue(attr2);
                if (!"name".equals(qName)) continue;
                nameAsExpandedQName = this.getExpandedQName(parser, value2, true);
                this.checkExpandedQNameForReservedNS(nameAsExpandedQName, "xsl:output", parser);
                break;
            }
            block19: for (attr2 = 0; attr2 < numAtts; ++attr2) {
                boolean attributeAllowed = false;
                String locName = attributes2.getLocalName(attr2);
                String lexicalQName = attributes2.getQName(attr2);
                String value3 = attributes2.getValue(attr2);
                String val = value3;
                if (val != null) {
                    char first = this.getFirstCharLocName(lexicalQName);
                    switch (first) {
                        case 'b': {
                            if (!"byte-order-mark".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            parser.checkAttributeValue(this, nodeName, "byte-order-mark", value3, 3);
                            break;
                        }
                        case 'c': {
                            if ("cdata-section-elements".equals(lexicalQName)) {
                                attributeAllowed = true;
                                this.parseCdataSectionElements(parser, top, nameAsExpandedQName, value3);
                                continue block19;
                            }
                            if (!parser.isExtensionNamespace(attributes2.getURI(attr2)) || !"content-handler".equals(locName)) break;
                            attributeAllowed = true;
                            break;
                        }
                        case 'd': {
                            if ("doctype-system".equals(lexicalQName)) {
                                attributeAllowed = true;
                                this._doctypeSystem = attributes2.getValue("doctype-system");
                                break;
                            }
                            if (!"doctype-public".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            this._doctypePublic = attributes2.getValue("doctype-public");
                            break;
                        }
                        case 'e': {
                            if ("encoding".equals(lexicalQName)) {
                                String encoding;
                                attributeAllowed = true;
                                this._encoding = encoding = value3;
                                break;
                            }
                            if ("escape-uri-attributes".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "escape-uri-attributes", value3, 3);
                                break;
                            }
                            if (!parser.isExtensionNamespace(attributes2.getURI(attr2)) || !"entities".equals(locName)) break;
                            attributeAllowed = true;
                            XTQProgram context2 = parser.getCurrentXTQProgram();
                            try {
                                value3 = SystemIDResolver.getAbsoluteURI(value3, this.getSystemId());
                                break;
                            }
                            catch (URI.MalformedURIException e) {
                                throw new WrappedRuntimeException(e);
                            }
                        }
                        case 'i': {
                            if ("indent".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "indent", value3, 3);
                                if (value3 == null || value3.equals("") || !value3.equals("yes")) break;
                                this._indent = true;
                                break;
                            }
                            if ("include-content-type".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "include-content-type", value3, 3);
                                break;
                            }
                            if (!parser.isExtensionNamespace(attributes2.getURI(attr2)) || !"indent-amount".equals(locName)) break;
                            attributeAllowed = true;
                            boolean numberValueBad = true;
                            try {
                                int ivalue = Integer.parseInt(value3);
                                if (0 <= ivalue) {
                                    numberValueBad = false;
                                }
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                            if (!numberValueBad) break;
                            ASTMsg err = new ASTMsg("INDENT10_AMOUNT_BAD", (Object[])new String[]{value3, lexicalQName, "xsl:output"}, (SimpleNode)this);
                            parser.reportError(3, err);
                            continue block19;
                        }
                        case 'l': {
                            if (!parser.isExtensionNamespace(attributes2.getURI(attr2)) || !"line-separator".equals(locName)) break;
                            attributeAllowed = true;
                            break;
                        }
                        case 'm': {
                            if ("media-type".equals(lexicalQName)) {
                                attributeAllowed = true;
                                this._mediaType = attributes2.getValue("media-type");
                                break;
                            }
                            if (!"method".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            if (!("xml".equals(value3) || "html".equals(value3) || "text".equals(value3) || "xhtml".equals(value3))) {
                                ASTMsg err = new ASTMsg("METHOD10_VALUE", "xsl:output", value3, this);
                                parser.reportError(3, err);
                                continue block19;
                            }
                            this._method = attributes2.getValue("method");
                            if (this._method == null || this._method.equals("")) {
                                this._method = null;
                                break;
                            }
                            if (this._method == null) break;
                            parser.checkAttributeValue(this, nodeName, "method", value3, 3);
                            this._method = this._method.toLowerCase();
                            break;
                        }
                        case 'n': {
                            if ("normalization-form".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "normalization-form", value3, 3);
                                break;
                            }
                            if (!"name".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            parser.checkAttributeValue(this, nodeName, "name", value3, 3);
                            break;
                        }
                        case 'o': {
                            if ("omit-xml-declaration".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "omit-xml-declaration", value3, 3);
                                if (value3 != null && !value3.equals("") && value3.equals("yes")) {
                                    this._omitHeader = true;
                                }
                            }
                            if (!parser.isExtensionNamespace(attributes2.getURI(attr2)) || !"omit-meta-tag".equals(locName)) break;
                            attributeAllowed = true;
                            if ("yes".equals(value3) || "no".equals(value3)) break;
                            ASTMsg err = new ASTMsg("ATTR10_VAL_NOT_YES_OR_NO", (Object[])new String[]{lexicalQName, "xsl:output", value3}, (SimpleNode)this);
                            parser.reportError(3, err);
                            continue block19;
                        }
                        case 's': {
                            if (!"standalone".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            parser.checkAttributeValue(this, nodeName, "standalone", value3, 3);
                            this._standalone = attributes2.getValue("standalone");
                            break;
                        }
                        case 'u': {
                            if ("undeclare-prefixes".equals(lexicalQName)) {
                                attributeAllowed = true;
                                boolean ok2 = parser.checkAttributeValue(this, nodeName, "undeclare-prefixes", value3, 3);
                                if (ok2) break;
                                continue block19;
                            }
                            if ("use-character-maps".equals(lexicalQName)) {
                                attributeAllowed = true;
                                parser.checkAttributeValue(this, nodeName, "use-character-maps", value3, 3);
                                this.parseUseCharacterMaps(parser, impPrecedence, top, nameAsExpandedQName, locName, value3);
                                continue block19;
                            }
                            if (parser.isExtensionNamespace(attributes2.getURI(attr2)) && "use-url-escaping".equals(locName)) {
                                attributeAllowed = true;
                                if (!"yes".equals(value3) && !"no".equals(value3)) {
                                    ASTMsg err = new ASTMsg("ATTR10_VAL_NOT_YES_OR_NO", value3, "xsl:output", this);
                                    parser.reportError(3, err);
                                    continue block19;
                                }
                            }
                        }
                        case 'v': {
                            if (!"version".equals(lexicalQName)) break;
                            attributeAllowed = true;
                            parser.checkAttributeValue(this, nodeName, "version", value3, 3);
                            this._version = attributes2.getValue("version");
                        }
                    }
                }
                if (!attributeAllowed) continue;
                String uri2 = attributes2.getURI(attr2);
                if (parser.isExtensionNamespace(uri2)) {
                    uri2 = "http://xml.apache.org/xalan";
                }
                this.updateOutputDefinition(top, impPrecedence, nameAsExpandedQName, uri2, locName, lexicalQName, value3);
            }
        }
        return false;
    }

    private void updateOutputDefinition(XTQProgram top, Expr.ImportPrecedence impPrecedence, String nameAsExpandedQName, String attrURI, String locName, String qName, String value2) {
        if (locName.equals(qName)) {
            top.updateEffectiveMergedXslOutputElement(impPrecedence, nameAsExpandedQName, locName, value2);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            sb.append(attrURI);
            sb.append('}');
            sb.append(locName);
            String expandedQName2 = sb.toString();
            top.updateEffectiveMergedXslOutputElement(impPrecedence, nameAsExpandedQName, expandedQName2, value2);
        }
    }

    private void parseUseCharacterMaps(XSLTParser parser, Expr.ImportPrecedence impPrecedence, XTQProgram top, String nameAsExpandedQName, String locName, String value2) {
        MergedCharacterMapsManager charMapManager = parser.getStaticContext().getCharacterMapsManager();
        StringBuffer expandedMapNames = new StringBuffer();
        StringTokenizer tokens = Util.whitespaceTokenize(value2);
        boolean firstName = true;
        while (tokens.hasMoreElements()) {
            String charMapQName = tokens.nextToken();
            String prefix2 = "";
            String localName2 = null;
            if (XML11Char.isXML11ValidQName(charMapQName)) {
                if (XML11Char.isXML11ValidQNameButNotNCName(charMapQName)) {
                    int colon = charMapQName.indexOf(58);
                    prefix2 = charMapQName.substring(0, colon);
                    localName2 = charMapQName.substring(colon + 1);
                } else {
                    prefix2 = "";
                    localName2 = charMapQName;
                }
            } else {
                ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NOT_LEXICAL_QNAME", charMapQName, "xsl:output", this);
                parser.reportError(3, err);
                continue;
            }
            String uri2 = this.lookupNamespace(prefix2);
            String expandedName = null;
            if (uri2 == null || uri2.length() == 0) {
                expandedName = localName2;
                if (0 < prefix2.length()) {
                    ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NO_URI", charMapQName, "xsl:output", this);
                    parser.reportError(3, err);
                    continue;
                }
            } else {
                expandedName = "{" + uri2 + "}" + localName2;
            }
            if (firstName) {
                firstName = false;
            } else {
                expandedMapNames.append(' ');
            }
            expandedMapNames.append(expandedName);
            charMapManager.characterMapIsReferenced(expandedName, this);
        }
        value2 = expandedMapNames.toString();
        top.updateEffectiveMergedXslOutputElement(impPrecedence, nameAsExpandedQName, locName, value2);
    }

    private void parseCdataSectionElements(XSLTParser parser, XTQProgram top, String nameAsExpandedQName, String value2) {
        StringBuffer expandedNames = new StringBuffer();
        StringTokenizer tokens = Util.whitespaceTokenize(value2);
        boolean isFirstToken = true;
        while (tokens.hasMoreTokens()) {
            if (!isFirstToken) {
                expandedNames.append(' ');
            } else {
                isFirstToken = false;
            }
            String qNameOfCDATA = tokens.nextToken();
            if (!parser.isValidQName(qNameOfCDATA)) {
                ASTMsg err = new ASTMsg("CDATA_SECTION_ELEMENTS10_NOT_LEXICAL_QNAME", qNameOfCDATA, "xsl:result-document", this);
                parser.reportError(3, err);
                continue;
            }
            String expandedQName = this.getExpandedQName(parser, qNameOfCDATA);
            if (expandedQName == null) {
                ASTMsg err = new ASTMsg("CDATA_SECTION_ELEMENTS10_NO_URI", qNameOfCDATA, "xsl:result-document", this);
                parser.reportError(3, err);
                continue;
            }
            expandedNames.append(expandedQName);
        }
        String expandedList = expandedNames.toString();
        top.updateEffectiveMergedXslOutputElement(Expr.ImportPrecedence.getLowestPrecedence(), nameAsExpandedQName, "cdata-section-elements", expandedList);
        this._cdata = expandedList;
    }
}

