/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ContextItemExprImpl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionCall;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.IdOrKeyFunctionCallPattern;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.KindTest;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.StepExpr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Assert;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class PathExpr
extends OperatorExpr {
    private boolean m_absolute;

    protected PathExpr() {
        this(82);
    }

    public PathExpr(int i) {
        super(i);
        this.setOpType((short)27);
    }

    public void setAbsolute(ASTBuildingContext context2, boolean value2) {
        if (this.id != 187) {
            if (value2) {
                this.expandAbsolute(context2);
            } else if (this.getOperandCount() != 0 && this.getOperand(0).isRootOnSelfNode()) {
                try {
                    this.removeOperand(this.getOperand(0));
                }
                catch (XPath20Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        this.m_absolute = value2;
    }

    @Override
    public boolean isRootOnSelfNode() {
        return this.getOperandCount() == 1 && this.getOperand(0).isRootOnSelfNode();
    }

    protected void expandAbsolute(ASTBuildingContext context2) {
        if (this.getOperandCount() == 0 || !this.getOperand(0).isRootOnSelfNode()) {
            super.insertOperand(0, context2.getExpressionFactory().createRootOnSelfNode(context2, this.id == 187));
        }
    }

    protected boolean isPattern() {
        return this.id == 187;
    }

    protected void recomputeAbsolute() {
        this.m_absolute = this.getOperandCount() > 0 && this.getOperand(0).isRootOnSelfNode();
    }

    public boolean isAbsolute() {
        return this.m_absolute;
    }

    @Override
    public Expr addOperand(ASTBuildingContext context2, Expr operand2) throws XPath20Exception {
        Expr expr = super.addOperand(context2, operand2);
        this.recomputeAbsolute();
        return expr;
    }

    @Override
    public void append(ASTBuildingContext context2, OperatorExpr expr) throws XPath20Exception {
        super.append(context2, expr);
        this.recomputeAbsolute();
    }

    @Override
    public Expr insertOperand(int i, Expr operand2) {
        Expr expr = super.insertOperand(i, operand2);
        this.recomputeAbsolute();
        return expr;
    }

    @Override
    public void removeOperand(Expr operand2) throws XPath20Exception {
        super.removeOperand(operand2);
        this.recomputeAbsolute();
    }

    @Override
    public Expr replaceOperand(ASTBuildingContext context2, int i, Expr operand2) throws XPath20Exception {
        Expr expr = super.replaceOperand(context2, i, operand2);
        this.recomputeAbsolute();
        return expr;
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate) {
        if (this.isAbsolute()) {
            int i;
            expr.append('/');
            int size = this.getOperandCount();
            int n2 = i = this.isPattern() ? 0 : 1;
            while (i < size) {
                Expr op2 = this.getOperand(i);
                op2.getXQueryString(expr, abbreviate);
                if (i < size - 1) {
                    expr.append('/');
                }
                ++i;
            }
        } else {
            if (this.isAbsolute() && abbreviate) {
                expr.append('/');
            }
            super.getXQueryString(expr, abbreviate);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        switch (n2.getId()) {
            case 106: 
            case 107: 
            case 157: {
                this.addChildrenOfUselessNode(context2, n2, i);
                break;
            }
            case 83: {
                this.addRoot(context2);
                break;
            }
            case 84: {
                if (i == 0) {
                    this.addRootDescendendants(context2);
                    break;
                }
                if (!this.isPattern()) {
                    n2 = context2.getExpressionFactory().createSlashSlashStep(context2, false);
                }
            }
            default: {
                if (this.isPattern()) {
                    this.addPatternStep(context2, n2);
                    break;
                }
                int idx = 0;
                if (((SimpleNode)n2).canBeReduced()) {
                    if (this.getId() == 82 && n2.jjtGetNumChildren() > 0 && n2.jjtGetChild(0).getId() == 82) {
                        super.jjtInsertNodeChildren(context2, n2.jjtGetChild(0), idx);
                        break;
                    }
                    super.jjtInsertChild(n2.jjtGetChild(0), idx);
                    break;
                }
                super.jjtInsertChild(n2, idx);
            }
        }
    }

    private void addPatternStep(ASTBuildingContext context2, Node n2) {
        if (((SimpleNode)n2).canBeReduced()) {
            n2 = this.reducedNode(context2, (SimpleNode)n2);
        }
        if (n2 instanceof StepExpr) {
            StepExpr step2 = (StepExpr)n2;
            if (this.jjtGetNumChildren() == 0) {
                this.jjtInsertChild(step2, 0);
            } else if (this.jjtGetChild(0).getId() == 84) {
                try {
                    step2.setAxisType((short)7);
                }
                catch (XPath20Exception e) {
                    // empty catch block
                }
                this.jjtRemoveChild(this.jjtGetChild(0));
                step2.id = 85;
                step2.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(step2, this.getStepExprRoot());
            } else if (n2.getId() == 84) {
                try {
                    step2.setAxisType((short)13);
                }
                catch (XPath20Exception e) {
                    // empty catch block
                }
                step2.id = 85;
                step2.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(step2, this.getStepExprRoot());
            } else {
                try {
                    step2.setAxisType((short)3);
                }
                catch (XPath20Exception e) {
                    // empty catch block
                }
                step2.id = 85;
                step2.setPatternStepRewrittenToPredicate(true);
                this.prependPredicateAtTail(step2, this.getStepExprRoot());
            }
        } else if (n2 instanceof FunctionCall) {
            FunctionCall fc = (FunctionCall)n2;
            if (this.jjtGetNumChildren() == 0) {
                if (!fc.isIdOrKeyFunc()) {
                    throw new XPathError("ERR_TOP_PATTERN", fc.getQName());
                }
                IdOrKeyFunctionCallPattern fnp = new IdOrKeyFunctionCallPattern(105, fc);
                n2.jjtSetParent(null);
                fc = fnp;
                n2 = fc;
                this.jjtInsertChild(fc, 0);
            } else {
                try {
                    StepExpr step3 = new StepExpr(85);
                    if (this.jjtGetChild(0).getId() == 84) {
                        step3.setAxisType((short)7);
                        this.jjtRemoveChild(this.jjtGetChild(0));
                    } else {
                        step3.setAxisType((short)3);
                    }
                    KindTest kt = new KindTest(169);
                    step3.setNodeTest(context2, kt);
                    FunctionCall idOrKeyF = (FunctionCall)n2;
                    if (!fc.isIdOrKeyFunc()) {
                        throw new XPathError("ERR_TOP_PATTERN", idOrKeyF.getQName());
                    }
                    QName fname = idOrKeyF.getQName();
                    QName newFName = new QName(context2.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction(), fname.getLocalPart());
                    idOrKeyF.setQName(newFName);
                    idOrKeyF.id = 105;
                    Expr eq2 = this.createEqualityCompareForIDOrKey(context2, idOrKeyF);
                    step3.appendPredicate(context2, eq2);
                    this.prependPredicateAtTail(step3, this.getStepExprRoot());
                }
                catch (XPath20Exception e) {}
            }
        } else {
            this.jjtInsertChild(n2, 0);
        }
    }

    private Expr createEqualityCompareForIDOrKey(ASTBuildingContext context2, FunctionCall idOrKeyF) throws XPath20Exception {
        String idList;
        StringTokenizer tokenizer;
        int nTokens;
        Expr expr = idOrKeyF.getOperand(0);
        if (!expr.isSimpleStringValue()) {
            context2.reportError(3, new ASTMsg("ERR_PATTERN_ID_KEY_ARG", expr));
        }
        Assert._assert((nTokens = (tokenizer = Util.whitespaceTokenize(idList = expr.getSimpleStringValue())).countTokens()) != 0, Util.getStringRep(idOrKeyF.getQName()) + " must have one or more IDs as arguments!");
        String id2 = tokenizer.nextToken();
        if (nTokens > 1) {
            idOrKeyF = this.createOneArgFunction(context2, idOrKeyF, id2);
        }
        OperatorExpr result2 = idOrKeyF.getQName().getLocalPart().equals("id") ? this.createNodeEqualityCompare(context2, idOrKeyF) : this.createNodeIsInSequence(context2, idOrKeyF);
        while (tokenizer.hasMoreTokens()) {
            OperatorExpr or2 = new OperatorExpr(57);
            or2.setOpType((short)24);
            id2 = tokenizer.nextToken();
            idOrKeyF = this.createOneArgFunction(context2, idOrKeyF, id2);
            OperatorExpr op2 = this.createNodeEqualityCompare(context2, idOrKeyF);
            or2.jjtAppendChild(context2, result2);
            or2.jjtAppendChild(context2, op2);
            result2 = or2;
        }
        return result2;
    }

    private FunctionCall createOneArgFunction(ASTBuildingContext context2, FunctionCall idOrKeyF, String arg2) {
        QName qname2 = idOrKeyF.getQName();
        FunctionCall newFunc = new FunctionCall(new QName(qname2.getNamespaceURI(), qname2.getLocalPart(), qname2.getPrefix()));
        newFunc.setBuiltInNamespaceFunc(context2.getStaticContext().getBuiltInNamespaceForFunction());
        Literal newArg = new Literal(5);
        newArg.setStringValue(arg2);
        newFunc.jjtAppendChild(context2, newArg);
        return newFunc;
    }

    private OperatorExpr createNodeEqualityCompare(ASTBuildingContext context2, Expr nodeExpr) throws XPath20Exception {
        String defaultNamespaceForFuncs = context2.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction();
        OperatorExpr eq2 = new OperatorExpr(59);
        eq2.setOpType((short)13);
        FunctionCall genUniqueID1 = new FunctionCall(new QName(defaultNamespaceForFuncs, "generate-id"));
        genUniqueID1.setBuiltInNamespaceFunc(defaultNamespaceForFuncs);
        genUniqueID1.jjtAppendChild(context2, nodeExpr);
        eq2.jjtAppendChild(context2, genUniqueID1);
        FunctionCall genUniqueID2 = new FunctionCall(new QName(defaultNamespaceForFuncs, "generate-id"));
        genUniqueID2.setBuiltInNamespaceFunc(defaultNamespaceForFuncs);
        StepExpr self2 = new StepExpr(85);
        self2.setAxisType((short)5);
        KindTest kt4self = new KindTest(169);
        self2.setNodeTest(context2, kt4self);
        genUniqueID2.jjtAppendChild(context2, self2);
        eq2.jjtAppendChild(context2, genUniqueID2);
        return eq2;
    }

    private OperatorExpr createNodeIsInSequence(ASTBuildingContext context2, Expr nodeExpr) throws XPath20Exception {
        FunctionCall nodeIsInSequence2 = new FunctionCall(new QName("http://xtqhp", "nodeIsInSequence"));
        nodeIsInSequence2.setBuiltInNamespaceFunc(context2.getStaticContext().getBuiltInNamespaceForFunction());
        ContextItemExprImpl current2 = new ContextItemExprImpl(102);
        nodeIsInSequence2.jjtAppendChild(context2, nodeExpr);
        nodeIsInSequence2.jjtAppendChild(context2, current2);
        return nodeIsInSequence2;
    }

    public Expr getStepExprRoot() {
        return this.jjtGetNumChildren() > 0 ? (Expr)this.jjtGetChild(0) : null;
    }

    private void addRoot(ASTBuildingContext context2) {
        if (this.isPattern()) {
            if (this.jjtGetNumChildren() == 0) {
                this.setAbsolute(context2, true);
            } else {
                StepExpr step2 = this.createRootStep(context2, (short)3);
                this.prependPredicateAtTail(step2, (StepExpr)this.getStepExprRoot());
            }
        } else {
            this.setAbsolute(context2, true);
        }
    }

    private void addRootDescendendants(ASTBuildingContext context2) {
        if (this.isPattern()) {
            StepExpr step2 = this.createRootStep(context2, (short)7);
            if (this.jjtGetNumChildren() == 0) {
                this.jjtInsertChild(step2, 0);
            } else {
                this.prependPredicateAtTail(step2, (StepExpr)this.getStepExprRoot());
            }
        } else {
            this.setAbsolute(context2, true);
            if (this.id == 82) {
                Node firstChild = this.jjtGetChild(0);
                int insertIndex = firstChild instanceof FunctionCall && ((FunctionCall)firstChild).getQName().getLocalPart().equals("root") && ((FunctionCall)firstChild).getQName().getNamespaceURI().equals(context2.getExpressionFactory().getStaticContext().getBuiltInNamespaceForFunction()) ? 1 : 0;
                super.insertOperand(insertIndex, context2.getExpressionFactory().createSlashSlashStep(context2, false));
            } else if (this.id == 187) {
                super.insertOperand(0, context2.getExpressionFactory().createSlashSlashStep(context2, true));
            } else {
                throw new XPathError("ERR_SYSTEM", "Wrong id on PathExpr: " + this.id);
            }
        }
    }

    Expr getStepExprOfMostDepth(Expr step2) {
        if (step2.jjtGetNumChildren() > 1) {
            Node substep = step2.jjtGetChild(1);
            if (substep instanceof StepExpr && ((StepExpr)substep).isPatternStepRewrittenToPredicate()) {
                return this.getStepExprOfMostDepth((StepExpr)step2.jjtGetChild(1));
            }
            return step2;
        }
        return step2;
    }

    void prependPredicateAtTail(Expr expr, Expr step2) {
        Expr tail = this.getStepExprOfMostDepth(step2);
        if (tail instanceof StepExpr) {
            ((StepExpr)tail).prependPredicate(expr);
        } else {
            Assert.assertNotImplemented();
        }
    }

    private StepExpr createRootStep(ASTBuildingContext context2, short axis) {
        StepExpr step2 = null;
        try {
            step2 = new StepExpr(85);
            step2.setAxisType(axis);
            KindTest kt = new KindTest(169);
            step2.setNodeTest(context2, kt);
            FunctionCall fc = context2.getExpressionFactory().createNotElementNode(context2, false);
            step2.appendPredicate(context2, fc);
        }
        catch (XPath20Exception e) {
            context2.getReporter().report(3, e.getErrorMsg());
        }
        return step2;
    }

    @Override
    public boolean canBeReduced() {
        return (this.id == 82 || !this.isAbsolute()) && this.getOperandCount() == 1;
    }

    @Override
    public void jjtClose(ASTBuildingContext context2) {
        if (this.id == 187 && this.jjtGetNumChildren() > 0) {
            SimpleNode node2 = this.flatToDeep(this.getChildren(), 0);
            super.initChildren();
            super.jjtAddChild(context2, node2, 0);
        }
    }

    @Override
    public int initialChildNumber() {
        return 1;
    }

    @Override
    public void processToken(ASTBuildingContext context2, Token token) {
        switch (token.kind) {
            case 187: 
            case 188: {
                break;
            }
            default: {
                super.processToken(context2, token);
            }
        }
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        if (this.isAbsolute()) {
            int i;
            expr.append('/');
            int size = this.getOperandCount();
            int n2 = i = this.isPattern() ? 0 : 1;
            while (i < size) {
                Expr op2 = this.getOperand(i);
                op2.getXQueryString(expr, abbreviate, indent + " ");
                if (i < size - 1) {
                    expr.append('/');
                }
                ++i;
            }
        } else {
            if (this.isAbsolute() && abbreviate) {
                expr.append('/');
            }
            super.getXQueryString(expr, abbreviate, indent);
        }
    }
}

