/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public final class ResultDocument
extends Expr {
    private Expr _formatExpr;
    private Expr _hrefExpr;
    private Expr _methodExpr;
    private String _useCharacterMapsExpanded;
    private Expr _undeclarePrefixesExpr;
    private Expr _standaloneExpr;
    private Expr _outputVersionExpr;
    private Expr _omitXmlDeclarationExpr;
    private Expr _normalizationFormExpr;
    private Expr _mediaTypeExpr;
    private Expr _indentExpr;
    private Expr _includeContentTypeExpr;
    private Expr _docTypeSystemExpr;
    private Expr _escapeUriAttributesExpr;
    private Expr _encodingExpr;
    private Expr _docTypePublicExpr;
    private Expr _cdataSectionNamesExpr;
    private Expr _byteOrderMarkExpr;
    private String _formatString = "";
    private String _useCharacterMapsString = "";
    protected int _validation = 0;
    protected QName _typeName = null;

    public ResultDocument() {
        super(210);
    }

    public ResultDocument(int i) {
        super(i);
    }

    @Override
    public String toString(String indent) {
        return indent + this.toString();
    }

    @Override
    public String toString() {
        String s;
        String ret = "ResultDocument: href: ";
        if (this._hrefExpr != null && this._hrefExpr.isSimpleStringValue()) {
            s = this._hrefExpr.getSimpleStringValue();
            ret = ret + "href: ";
            ret = ret + s;
        }
        if (this._formatExpr != null && this._formatExpr.isSimpleStringValue()) {
            s = this._formatExpr.getSimpleStringValue();
            ret = ret + "format: ";
            ret = ret + s;
        }
        return ret;
    }

    public Expr getHrefExpr() {
        return this._hrefExpr;
    }

    public Expr getFormatExpr() {
        return this._formatExpr;
    }

    public Expr getMethodExpr() {
        return this._methodExpr;
    }

    public String getOutputDefinitionName() {
        return this._formatString;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String nodeName = XPathTreeConstants.jjtNodeName[this.getId()];
        this._byteOrderMarkExpr = this.getExprForAttr(parser, nodeName, "byte-order-mark");
        this._cdataSectionNamesExpr = this.getExprForAttr(parser, nodeName, "cdata-section-elements");
        this._docTypePublicExpr = this.getExprForAttr(parser, nodeName, "doctype-public");
        this._docTypeSystemExpr = this.getExprForAttr(parser, nodeName, "doctype-system");
        this._encodingExpr = this.getExprForAttr(parser, nodeName, "encoding");
        this._escapeUriAttributesExpr = this.getExprForAttr(parser, nodeName, "escape-uri-attributes");
        this._formatExpr = this.getExprForAttr(parser, nodeName, "format");
        this._formatString = this.getAttribute("format");
        this._hrefExpr = this.getExprForAttr(parser, nodeName, "href");
        this._includeContentTypeExpr = this.getExprForAttr(parser, nodeName, "include-content-type");
        this._indentExpr = this.getExprForAttr(parser, nodeName, "indent");
        this._mediaTypeExpr = this.getExprForAttr(parser, nodeName, "media-type");
        this._methodExpr = this.getExprForAttr(parser, nodeName, "method");
        this._normalizationFormExpr = this.getExprForAttr(parser, nodeName, "normalization-form");
        this._omitXmlDeclarationExpr = this.getExprForAttr(parser, nodeName, "omit-xml-declaration");
        this._outputVersionExpr = this.getExprForAttr(parser, nodeName, "output-version");
        this._standaloneExpr = this.getExprForAttr(parser, nodeName, "standalone");
        this._undeclarePrefixesExpr = this.getExprForAttr(parser, nodeName, "undeclare-prefixes");
        if (this.hasAttribute("use-character-maps")) {
            this._useCharacterMapsString = this.getAttribute("use-character-maps");
            parser.checkAttributeValue(this, nodeName, "use-character-maps", this._useCharacterMapsString, 3);
        }
        this._useCharacterMapsExpanded = this.expandQNames(parser);
        boolean hasValidationAttribute = this.hasAttribute("validation");
        if (hasValidationAttribute) {
            String validationSetting = this.getAttribute("validation");
            parser.checkAttributeValue(this, nodeName, "validation", validationSetting, 3);
            this.setValidation(validationSetting);
        }
        if (this.hasAttribute("type")) {
            if (hasValidationAttribute) {
                ASTMsg error2 = new ASTMsg("NODE_HAS_TYPE_AND_VALIDATION", (Object)nodeName, (SimpleNode)this);
                parser.reportError(3, error2);
            }
            String typeAttrSetting = this.getAttribute("type");
            parser.checkAttributeValue(this, nodeName, "type", typeAttrSetting, 3);
            this.setTypeName(parser.getQNameIgnoreDefaultNs(typeAttrSetting));
        }
        this.parseChildren(parser);
        return false;
    }

    private Expr getExprForAttr(XSLTParser parser, String nodeName, String attrName) {
        Expr exp;
        if (this.hasAttribute(attrName)) {
            String val = this.getAttribute(attrName);
            exp = ResultDocument.parseAVTAttrContent(parser, val, this);
            if (exp.getId() == 228) {
                parser.checkAttributeValue(this, nodeName, attrName, val, 3);
            }
        } else {
            String val = "";
            exp = ResultDocument.parseAVTAttrContent(parser, val, this);
        }
        return exp;
    }

    private String expandQNames(XSLTParser parser) {
        String ret;
        if (this._useCharacterMapsString == null || this._useCharacterMapsString.length() == 0) {
            ret = "";
        } else {
            MergedCharacterMapsManager charMapManager = parser.getStaticContext().getCharacterMapsManager();
            StringBuffer sb = new StringBuffer();
            StringTokenizer tokens = Util.whitespaceTokenize(this._useCharacterMapsString);
            boolean first = true;
            while (tokens.hasMoreElements()) {
                String tok = tokens.nextToken();
                if (!XML11Char.isXML11ValidQName(tok)) {
                    ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NOT_LEXICAL_QNAME", tok, "xsl:result-document", this);
                    parser.reportError(3, err);
                    continue;
                }
                String expandedQName = this.getExpandedQName(parser, tok, true);
                if (expandedQName == null) {
                    ASTMsg err = new ASTMsg("USE_CHARACTER_MAPS_NO_URI", tok, "xsl:result-document", this);
                    parser.reportError(3, err);
                    continue;
                }
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append(expandedQName);
                charMapManager.characterMapIsReferenced(expandedQName, this);
            }
            ret = sb.toString();
        }
        return ret;
    }

    public Expr getByteOrderMarkExpr() {
        return this._byteOrderMarkExpr;
    }

    public Expr getCdataSectionNamesExpr() {
        return this._cdataSectionNamesExpr;
    }

    public Expr getDocTypePublicExpr() {
        return this._docTypePublicExpr;
    }

    public Expr getEncodingExpr() {
        return this._encodingExpr;
    }

    public Expr getEscapeUriAttributesExpr() {
        return this._escapeUriAttributesExpr;
    }

    public Expr getDocTypeSystemExpr() {
        return this._docTypeSystemExpr;
    }

    public Expr getIncludeContentTypeExpr() {
        return this._includeContentTypeExpr;
    }

    public Expr getIndentExpr() {
        return this._indentExpr;
    }

    public Expr getMediaTypeExpr() {
        return this._mediaTypeExpr;
    }

    public Expr getNormalizationFormExpr() {
        return this._normalizationFormExpr;
    }

    public Expr getOmitXmlDeclarationExpr() {
        return this._omitXmlDeclarationExpr;
    }

    public Expr getOutputVersionExpr() {
        return this._outputVersionExpr;
    }

    public Expr getStandaloneExpr() {
        return this._standaloneExpr;
    }

    public Expr getUndeclarePrefixesExpr() {
        return this._undeclarePrefixesExpr;
    }

    public String getUseCharacterMapsExpanded() {
        return this._useCharacterMapsExpanded;
    }

    public void setValidation(String v) {
        if (v.equals("strict")) {
            this._validation = 4;
        } else if (v.equals("lax")) {
            this._validation = 3;
        } else if (v.equals("preserve")) {
            this._validation = 2;
        } else if (v.equals("strip")) {
            this._validation = 1;
        }
    }

    public int getValidation() {
        return this._validation != 0 ? this._validation : this.getXTQProgram().getDefaultValidation();
    }

    public void setTypeName(QName typeName) {
        this._typeName = typeName;
        this._validation = 5;
    }

    public QName getTypeName() {
        return this._typeName;
    }
}

