/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class Template
extends FunctionDecl {
    private QName _mode = null;
    private ArrayList _modes = null;
    private Expr _pattern;
    private BigDecimal _priority;
    private int _position;
    private boolean _disabled = false;
    private boolean _compiled = false;
    private String m_pattern;
    private boolean _isSimpleNamedTemplate = false;
    private List _nonTunnelParams = new ArrayList();
    private List _tunnelParams = new ArrayList();
    private int _numParamsHasDefault = -1;
    private XTQProgram _xtqprog = null;

    public Template() {
        super(227);
    }

    public Template(int i) {
        super(i);
    }

    public Template(String version) {
        super(227);
        this.setProgramVersion(version);
    }

    public boolean hasNonTunnelParams() {
        return this._nonTunnelParams.size() > 0;
    }

    public boolean hasTunnelParams() {
        return this._tunnelParams.size() > 0;
    }

    public boolean isCompiled() {
        return this._compiled;
    }

    public void setCompiled(boolean flag) {
        this._compiled = flag;
    }

    public boolean isSimpleNamedTemplate() {
        return this._isSimpleNamedTemplate;
    }

    public void addNonTunnelParam(Param param) {
        this._nonTunnelParams.add(param);
    }

    public List getNonTunnelParams() {
        return this._nonTunnelParams;
    }

    public void addTunnelParam(Param param) {
        this._tunnelParams.add(param);
    }

    public List getTunnelParams() {
        return this._tunnelParams;
    }

    public int getNumParamsHasDefault() {
        if (this._numParamsHasDefault == -1) {
            ++this._numParamsHasDefault;
            if (this.hasAttribute("name")) {
                int size = this._nonTunnelParams.size();
                for (int i = 0; i < size; ++i) {
                    Param p = (Param)this._nonTunnelParams.get(i);
                    if (!p.hasDefaut()) continue;
                    ++this._numParamsHasDefault;
                }
            }
        }
        return this._numParamsHasDefault;
    }

    @Override
    public Param lookupParam(QName qname2) {
        Param p;
        int i;
        for (i = 0; i < this._nonTunnelParams.size(); ++i) {
            p = (Param)this._nonTunnelParams.get(i);
            if (!p.getQName().equals(qname2)) continue;
            return p;
        }
        for (i = 0; i < this._tunnelParams.size(); ++i) {
            p = (Param)this._tunnelParams.get(i);
            if (!p.getQName().equals(qname2)) continue;
            return p;
        }
        return null;
    }

    public void disable() {
        this._disabled = true;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public BigDecimal getPriority() {
        return this._priority;
    }

    public int getPosition() {
        return this._position;
    }

    public boolean isNamed() {
        return this._name != null;
    }

    public boolean isNamedTemplate() {
        if (this._name == null) {
            return false;
        }
        return !this._name.getLocalPart().startsWith("template$dot$");
    }

    public Expr getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern2) {
        this.m_pattern = pattern2;
    }

    @Override
    public QName getQName() {
        return this._name;
    }

    private void unsetQName() {
        this._name = null;
    }

    @Override
    public void setQName(QName qname2) {
        if (this._name == null) {
            this._name = qname2;
        }
    }

    public QName getModeName() {
        return this._mode;
    }

    public ArrayList getModeNames() {
        return this._modes;
    }

    @Override
    public void dump(String indent, PrintStream out) {
        out.print(indent + "Template");
        out.print(" name=" + this._name);
        if (this._mode != null) {
            out.print(" mode=" + this._mode);
        } else if (this._modes != null) {
            out.print(" mode=" + this._modes);
        } else {
            out.print(" mode=");
        }
        out.print(" priority=" + this._priority);
        out.println(" match=" + this.getAttribute("match"));
        if (null != this._pattern) {
            this._pattern.dump(" " + indent, out);
        }
        this.dumpChildren(indent + " ", out);
    }

    private boolean resolveNamedTemplates(Template other2, XSLTParser parser) {
        if (other2 == null) {
            return true;
        }
        Expr.ImportPrecedence us = this.getImportPrecedence();
        Expr.ImportPrecedence them = other2.getImportPrecedence();
        XStaticContext context2 = parser.getStaticContext();
        if (us.hasHigherPrecedenceThan(them)) {
            other2.disable();
            other2.unsetQName();
            other2.setQName(new QName("template$dot$" + other2.getPosition()));
            return true;
        }
        if (them.hasHigherPrecedenceThan(us)) {
            context2.addTemplate(other2);
            this.disable();
            this.unsetQName();
            this.setQName(new QName("template$dot$" + other2.getPosition()));
            return true;
        }
        return false;
    }

    @Override
    public XTQProgram getXTQProgram() {
        return this._xtqprog;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String as;
        ASTMsg err;
        String name2 = this.getAttribute("name");
        String mode = this.getAttribute("mode");
        String match = this.getAttribute("match");
        String priority = this.getAttribute("priority");
        boolean hasMode = this.hasAttribute("mode");
        this._xtqprog = super.getXTQProgram();
        boolean error2 = false;
        boolean warning2 = false;
        if (match.equals("")) {
            if (name2.equals("")) {
                error2 = true;
            }
            if (!mode.equals("") || !priority.equals("")) {
                if (parser.isXSLT20()) {
                    error2 = true;
                } else {
                    warning2 = true;
                }
            }
        }
        if (error2 || warning2) {
            int category = warning2 ? 4 : 3;
            err = new ASTMsg("INVALID_TEMPLATE_DECLARATION", null, (SimpleNode)this);
            parser.reportError(category, err);
        }
        String nodeName = XPathTreeConstants.jjtNodeName[this.getId()];
        if (name2.length() > 0) {
            parser.checkAttributeValue(this, nodeName, "name", name2, 3);
            this._name = parser.getQNameIgnoreDefaultNs(name2);
            parser.checkForReservedNamespace(this._name, "xsl:template", (SimpleNode)this);
        }
        if (mode.indexOf("#current") > -1) {
            err = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
            parser.reportError(3, err);
        }
        if (hasMode && mode.length() == 0) {
            err = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
            parser.reportError(3, err);
        }
        if (mode.length() > 0) {
            parser.checkAttributeValue(this, nodeName, "mode", mode, 3);
            boolean duplicateMode = false;
            boolean isDefault = false;
            boolean allMixed = false;
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer tokens = Util.whitespaceTokenize(mode);
            while (tokens.hasMoreElements()) {
                String token = tokens.nextToken();
                if (token.equals("#all")) {
                    allMixed = true;
                }
                if (token.equals("#default")) {
                    if (isDefault) {
                        ASTMsg err2 = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
                        parser.reportError(3, err2);
                        break;
                    }
                    isDefault = true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (!token.equals(list.get(i))) continue;
                    duplicateMode = true;
                    break;
                }
                if (duplicateMode) {
                    ASTMsg err3 = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
                    parser.reportError(3, err3);
                    break;
                }
                list.add(token);
            }
            if (allMixed && list.size() > 1) {
                ASTMsg err4 = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
                parser.reportError(3, err4);
            }
            for (int i = 0; i < list.size(); ++i) {
                ASTMsg err5;
                String ncname;
                int colon = ((String)list.get(i)).lastIndexOf(58);
                if (colon != -1) {
                    String prefix2 = ((String)list.get(i)).substring(0, colon);
                    String namespace2 = null;
                    namespace2 = parser.getStaticContext().getNamespaceURI(prefix2);
                    if (parser.isXLSTReservedNS(namespace2)) {
                        ASTMsg err6 = new ASTMsg("MODE_RESERVED_NAMESPACE", prefix2, namespace2, this);
                        parser.reportError(3, err6);
                        break;
                    }
                }
                if ((ncname = (String)list.get(i)).indexOf("#") < 0) {
                    if (parser.isValidQName(ncname)) continue;
                    err5 = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
                    parser.reportError(3, err5);
                    break;
                }
                if (ncname.indexOf("#default") >= 0 || ncname.indexOf("#all") >= 0) continue;
                err5 = new ASTMsg("ERR_TEMPLATE_MODE_STATIC", this);
                parser.reportError(3, err5);
                break;
            }
            list = null;
            tokens = null;
            if (parser.isXSLT20()) {
                this._modes = parser.getQNameListIgnoreDefaultNs(mode);
            } else {
                this._mode = parser.getQNameIgnoreDefaultNs(mode);
            }
        }
        if (match.length() > 0) {
            this._pattern = parser.parsePattern(this, "match", null);
        }
        if (this.m_pattern != null) {
            this._pattern = parser.parsePattern(this, this.m_pattern);
        }
        if (priority.length() > 0) {
            try {
                this._priority = new BigDecimal(priority);
            }
            catch (NumberFormatException e) {
                ASTMsg err7 = new ASTMsg("ERR_PRIORITY", (Object)priority, (SimpleNode)this);
                parser.reportError(3, err7);
            }
        } else {
            this._priority = null;
        }
        this._position = parser.getTemplateIndex();
        if (this._name != null) {
            Template other2 = parser.getStaticContext().addTemplate(this);
            if (!this.resolveNamedTemplates(other2, parser)) {
                ASTMsg err8 = new ASTMsg("TEMPLATE_REDEF_ERR", (Object)this._name, (SimpleNode)this);
                parser.reportError(3, err8);
            }
            if (this._pattern == null && this._mode == null && this._modes == null) {
                this._isSimpleNamedTemplate = true;
            }
        }
        if ((as = this.getAttribute("as")).length() > 0) {
            this.setResultType(parser.parseSequenceTypeExpression(this, as));
        }
        if (this.jjtGetParent() instanceof XTQProgram) {
            ((XTQProgram)this.jjtGetParent()).addTemplate(this);
        }
        parser.setTemplate(this);
        this.parseChildren(parser);
        parser.setTemplate(null);
        return false;
    }

    public void parseSimplified(XTQProgram prog, XSLTParser parser) {
        this._xtqprog = prog;
        this.jjtSetParent(prog);
        this._name = null;
        this._mode = null;
        this._priority = null;
        this._pattern = parser.parsePattern(this, "/");
        this._position = parser.getTemplateIndex();
        Expr root2 = (Expr)this._xtqprog.jjtGetChild(0);
        if (root2 instanceof DirElemConstructor) {
            this.jjtAppendChild(parser, root2);
            root2.jjtSetParent(this);
            this._xtqprog.jjtAddChild(parser, this, 0);
            this._xtqprog.addTemplate(this);
            parser.setTemplate(this);
            parser.getStaticContext().setCurrentNode(root2);
            root2.callParseContents(parser);
            parser.setTemplate(null);
        }
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        if (null == this.getQName()) {
            expr.append("declare template match[");
            if (null != this._pattern) {
                this._pattern.getXQueryString(expr, abbreviate, "");
            } else {
                expr.append(this.m_pattern);
            }
            expr.append("]");
        } else {
            expr.append("declare function ").append(this.getString(this.getQName()));
        }
        expr.append("(");
        this.getParamsString(expr, abbreviate, indent);
        if (null != this._returnType) {
            expr.append(") as ").append(this._returnType);
        } else {
            expr.append(")");
        }
        if (this.isExternal()) {
            expr.append(" external");
        } else {
            if (this._mode != null) {
                expr.append(" mode:").append(this._mode);
            }
            if (this._modes != null) {
                expr.append(" modes:").append(this._modes);
            }
            if (this._priority != null) {
                expr.append(" priority:").append(this._priority);
            }
            expr.append("\n" + indent + "{\n" + indent + " ");
            this.getXQueryStringForChildren(expr, abbreviate, indent);
            expr.append("\n" + indent + "}" + indent + " ");
        }
        expr.append("\r\r");
    }
}

