/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import java.io.PrintStream;
import javax.xml.namespace.QName;

public class VariableBase
extends TopLevelDecl {
    protected QName _name;
    protected boolean _isLocal;
    private Expr _expr;
    private boolean _hasDuplicate = false;
    private TypeExpr _type;
    private boolean _isExternal = false;

    public VariableBase(int i) {
        super(i);
    }

    public void setDuplicate(boolean duplicate) {
        this._hasDuplicate = duplicate;
    }

    public boolean isDuplicate() {
        return this._hasDuplicate;
    }

    public Expr getExpression() {
        return this._expr;
    }

    public void setExpression(Expr expr) {
        this._expr = expr;
        this._expr.jjtSetParent(this);
    }

    @Override
    public String toString() {
        return "variable(" + this._name + ")";
    }

    @Override
    public void dump(String indent, PrintStream out) {
        out.print(indent + "Variable");
        out.print(" name=" + this._name);
        if (null == this._expr) {
            out.println(" select:NONE");
        } else {
            out.println(" select:");
            this._expr.dump(" " + indent, out);
        }
        this.dumpChildren(indent + " ", out);
    }

    public QName getQName() {
        return this._name;
    }

    public TypeExpr getType() {
        return this._type;
    }

    public void setQName(QName name2) {
        this._name = name2;
    }

    @Override
    public void setName(String uri2, String prefix2, String local2) {
        this._name = new QName(uri2, local2, prefix2);
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public void setExternal(boolean value2) {
        this._isExternal = value2;
    }

    public boolean isExternal() {
        return this._isExternal;
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String name2 = this.getAttribute("name");
        if (name2 == null) {
            name2 = "";
        }
        if (name2.length() > 0) {
            if (!parser.isValidQName(name2)) {
                ASTMsg err = new ASTMsg("INVALID_QNAME_ERR", (Object)name2, (SimpleNode)this);
                parser.reportError(3, err);
            }
            this.setQName(parser.getQNameIgnoreDefaultNs(name2));
        } else if (this._name == null) {
            ASTMsg error2 = new ASTMsg("REQUIRED_ATTR_ERR", (Object)"name", (SimpleNode)this);
            parser.reportError(3, error2);
        } else {
            this._name = parser.getQNameIgnoreDefaultNs(this._name.getLocalPart());
        }
        parser.checkForReservedNamespace(this._name, "xsl:variable", (SimpleNode)this);
        String as = this.getAttribute("as");
        if (as.length() > 0) {
            this._type = parser.parseSequenceTypeExpression(this, as);
        }
        this.parseChildren(parser);
        String select2 = this.getAttribute("select");
        if (select2.length() > 0 && this.hasContents()) {
            ASTMsg err = new ASTMsg("ERR_VAR_NO_SELECT_AND_CONTENT", (Object)(this._name.getPrefix().length() > 0 ? "{" + this._name.getNamespaceURI() + "}" + this._name.getLocalPart() : this._name.getLocalPart()), (SimpleNode)this);
            parser.reportError(3, err);
        }
        return false;
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        if (this.isLocal()) {
            expr.append("let $").append(this._name).append(" := ");
        } else {
            expr.append("declare variable ").append(this._name);
        }
        if (this._type != null) {
            expr.append(" as ").append(this._type);
        }
        if (this._expr != null) {
            if (!this.isLocal()) {
                expr.append("{");
            }
            this._expr.getXQueryString(expr, abbreviate, indent);
            if (!this.isLocal()) {
                expr.append("} ");
            }
        } else if (this.jjtGetNumChildren() > 0) {
            if (!this.isLocal()) {
                expr.append("{");
            }
            this.getXQueryStringForChildren(expr, abbreviate, indent);
            if (!this.isLocal()) {
                expr.append("} ");
            }
        } else {
            expr.append("external");
        }
        if (!this.isLocal()) {
            expr.append(";\r");
        }
        expr.append("\r");
    }

    public void setType(TypeExpr type2) {
        this._type = type2;
    }

    public void setLocal(boolean isLocal) {
        this._isLocal = isLocal;
    }
}

