/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.nodes;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.EffectiveMergedOutputElements;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ImportSchemaOrModule;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Key;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.NamespaceAlias;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Output;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VarDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.INSBinding;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IOptionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ISetter;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IVersionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.ASTBuildingTimeNSResolver;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

public class XTQProgram
extends Expr {
    private String _moduleNamespaceNCName;
    private String _moduleNamespaceURILiteral;
    private String _systemId;
    private String _uri;
    private XTQProgram _parentXTQProgram;
    private Boolean _hasLocalParams = null;
    private Boolean _hasTunnelParams = null;
    private String _className;
    private final List _templates = new ArrayList();
    private final HashMap<QName, List<String>> _xqueryOptions = new HashMap();
    private final Hashtable _prefixes = new Hashtable();
    private boolean _hasInheritNamespacesSetToNo = false;
    public XTQProgram _importedFrom = null;
    public XTQProgram _includedFrom = null;
    private List _includedXTQPrograms = null;
    private List _importedXTQPrograms = null;
    private Expr.ImportPrecedence _importPrecedence;
    public List _schemaImports;
    public List _moduleImports;
    private boolean m_stripInputTypeAnnotationsSpecified = false;
    private boolean m_preserveInputTypeAnnotationsSpecified = false;
    private boolean _callsNodeset = false;
    private Hashtable<String, Key> _keys = new Hashtable();
    private HashSet<String> _keyCollationURIs;
    private boolean _numberFormattingUsed = false;
    private boolean _simplified = false;
    private SourceLoader _loader = null;
    private boolean _templateInlining = false;
    private boolean _forwardReference = false;
    private boolean _hasIdCall = false;
    private Output _lastOutputElement = null;
    private Properties _outputProperties = null;
    private XStaticContext _context = null;
    private XSLTParser _parser;
    public static final int UNKNOWN_OUTPUT = 0;
    public static final int XML_OUTPUT = 1;
    public static final int HTML_OUTPUT = 2;
    public static final int TEXT_OUTPUT = 3;
    public static final int XHTML_OUTPUT = 4;
    private int _outputMethod = 0;
    protected int _defaultValidation = 1;
    public EffectiveMergedOutputElements m_mergedOutputElems = null;

    public XTQProgram(int i) {
        super(3);
        this.id = i;
    }

    public XTQProgram() {
        super(3);
    }

    public XTQProgram(XStaticContext context2) {
        super(3);
        this._context = context2;
        this._context.setRunninASTNamespaceContext(new ASTBuildingTimeNSResolver(context2));
    }

    public Hashtable<String, Key> getKeys() {
        return this._keys;
    }

    private HashSet<String> getKeyCollationURIs() {
        if (this._keyCollationURIs == null) {
            Hashtable<String, Key> keys2 = this.getKeys();
            HashSet<String> keyCollationURIs = new HashSet<String>();
            if (keys2 != null) {
                Iterator<Map.Entry<String, Key>> iter = keys2.entrySet().iterator();
                while (iter.hasNext()) {
                    Key nextKey = iter.next().getValue();
                    keyCollationURIs.add(nextKey.getCollation());
                }
            }
            this._keyCollationURIs = keyCollationURIs;
        }
        return this._keyCollationURIs;
    }

    public boolean allKeysUseUCP() {
        HashSet<String> keyCollationURIs = this.getKeyCollationURIs();
        return keyCollationURIs.size() == 1 && keyCollationURIs.contains("http://www.w3.org/2005/xpath-functions/collation/codepoint");
    }

    public List getIncludedStylesheets() {
        return this._includedXTQPrograms;
    }

    public List getImportedStylesheets() {
        return this._importedXTQPrograms;
    }

    public boolean hasIdCall() {
        return this._hasIdCall;
    }

    public int getOutputMethod() {
        return this._outputMethod;
    }

    public void checkOutputMethod() {
        String method;
        if (this._lastOutputElement != null && (method = this._lastOutputElement.getOutputMethod()) != null) {
            if (method.equals("xml")) {
                this._outputMethod = 1;
            } else if (method.equals("html")) {
                this._outputMethod = 2;
            } else if (method.equals("text")) {
                this._outputMethod = 3;
            } else if (method.equals("xhtml")) {
                this._outputMethod = 4;
            }
        }
    }

    public HashMap<QName, List<String>> getOptions() {
        return this._xqueryOptions;
    }

    public void setForwardReference() {
        this._forwardReference = true;
    }

    public boolean getTemplateInlining() {
        return this._templateInlining;
    }

    public void setTemplateInlining(boolean flag) {
        this._templateInlining = flag;
    }

    public boolean isSimplified() {
        return this._simplified;
    }

    public void setSimplified() {
        this._simplified = true;
    }

    public void setHasIdCall(boolean flag) {
        this._hasIdCall = flag;
    }

    public void setOutputProperty(String key2, String value2) {
        if (this._outputProperties == null) {
            this._outputProperties = new Properties();
        }
        this._outputProperties.setProperty(key2, value2);
    }

    public void setOutputProperties(Properties props) {
        this._outputProperties = props;
    }

    public Properties getOutputProperties() {
        return this._outputProperties;
    }

    public Output getLastOutputElement() {
        return this._lastOutputElement;
    }

    public void setLastOutputElement(Output output) {
        this._lastOutputElement = output;
    }

    public void setCallsNodeset(boolean flag) {
        this._callsNodeset = flag;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void setNumberFormattingUsed(boolean flag) {
        this._numberFormattingUsed = flag;
    }

    public boolean isNumberFormattingUsed() {
        return this._numberFormattingUsed;
    }

    public void giveHighestImportPrecedence() {
        this.setImportPrecedence(Expr.ImportPrecedence.createRootImportPrecedence(this._parser));
    }

    public void setImportPrecedence(Expr.ImportPrecedence ip) {
        this._importPrecedence = ip;
    }

    @Override
    public Expr.ImportPrecedence getImportPrecedence() {
        return this._importPrecedence;
    }

    public Set getAllImportedStylesheet(Set theSet) {
        if (this._importedXTQPrograms == null || this._importedXTQPrograms.size() == 0) {
            return theSet;
        }
        for (XTQProgram prog : this._importedXTQPrograms) {
            prog.getAllImportedStylesheet(theSet);
            theSet.add(prog);
        }
        return theSet;
    }

    public boolean checkForLoop(String systemId) {
        if (this._systemId != null && this._systemId.equals(systemId)) {
            return true;
        }
        if (this._parentXTQProgram != null) {
            return this._parentXTQProgram.checkForLoop(systemId);
        }
        return false;
    }

    public void setParser(XSLTParser parser) {
        this._parser = parser;
        this._context = parser.getStaticContext();
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void setParentXTQProgram(XTQProgram parent2) {
        this._parentXTQProgram = parent2;
    }

    public XTQProgram getParentXTQProgram() {
        return this._parentXTQProgram;
    }

    public void setImportingStylesheet(XTQProgram parent2) {
        this._importedFrom = parent2;
        parent2.addIncludedXTQProgram(this);
        parent2.addImportedXTQProgram(this);
    }

    public void setIncludingStylesheet(XTQProgram parent2) {
        this._includedFrom = parent2;
        parent2.addIncludedXTQProgram(this);
    }

    public void addIncludedXTQProgram(XTQProgram child2) {
        if (this._includedXTQPrograms == null) {
            this._includedXTQPrograms = new ArrayList();
        }
        this._includedXTQPrograms.add(child2);
    }

    public void addImportedXTQProgram(XTQProgram child2) {
        if (this._importedXTQPrograms == null) {
            this._importedXTQPrograms = new ArrayList();
        }
        this._importedXTQPrograms.add(child2);
    }

    public void setSystemId(String systemId) {
        this.setSystemId(systemId, null);
    }

    public void setSystemId(String systemId, String fallbackBaseURI) {
        String baseURI;
        if (systemId == null || systemId.length() == 0) {
            this._systemId = SystemIDResolver.getAbsoluteURI("");
            if (fallbackBaseURI == null || fallbackBaseURI.length() == 0) {
                fallbackBaseURI = this._systemId;
            }
        } else if (!systemId.startsWith("generated:")) {
            fallbackBaseURI = this._systemId = SystemIDResolver.getAbsoluteURI(systemId);
        }
        if ((baseURI = (String)this.getProperty(_BASEURI_KEY)) == null) {
            this.setBaseURI(fallbackBaseURI);
        } else if (!SystemIDResolver.isAbsoluteURI(baseURI)) {
            try {
                this.setBaseURI(SystemIDResolver.getAbsoluteURI(baseURI, fallbackBaseURI));
            }
            catch (URI.MalformedURIException e) {
                throw new WrappedRuntimeException(e);
            }
        }
    }

    public void setURI(String uri2) {
        this._uri = uri2;
    }

    public String getURI() {
        return this._uri;
    }

    public void setSourceLoader(SourceLoader loader) {
        this._loader = loader;
    }

    public SourceLoader getSourceLoader() {
        return this._loader;
    }

    public boolean hasLocalParams() {
        if (this._hasLocalParams == null) {
            List templates = this.getAllValidTemplates();
            int n2 = templates.size();
            for (int i = 0; i < n2; ++i) {
                Template template = (Template)templates.get(i);
                if (!template.hasNonTunnelParams() && !template.hasTunnelParams()) continue;
                this._hasLocalParams = Boolean.TRUE;
                return true;
            }
            this._hasLocalParams = Boolean.FALSE;
            return false;
        }
        return this._hasLocalParams;
    }

    public boolean hasTunnelParams() {
        if (this._hasTunnelParams == null) {
            List templates = this.getAllValidTemplates();
            int n2 = templates.size();
            Vector tunnelParams = this._context.getAllTunnelParamNames();
            if (tunnelParams != null && tunnelParams.size() > 0) {
                this._hasTunnelParams = new Boolean(true);
                return true;
            }
            this._hasTunnelParams = new Boolean(false);
            return false;
        }
        return this._hasTunnelParams;
    }

    @Override
    public void addPrefixMapping(String prefix2, String uri2) {
        if (prefix2.equals("") && uri2.equals("http://www.w3.org/1999/xhtml")) {
            return;
        }
        super.addPrefixMapping(prefix2, uri2);
    }

    @Override
    public boolean parseContents(XSLTParser parser) {
        String nodeName;
        double xsltver;
        this.addPrefixMapping("xml", "http://www.w3.org/XML/1998/namespace");
        String verStr = this.getProgramVersion();
        double d = xsltver = verStr != null ? Double.parseDouble(verStr) : 1.0;
        if (this._simplified) {
            this.excludeURI("http://www.w3.org/1999/XSL/Transform");
            Template template = new Template(verStr);
            template.parseSimplified(this, parser);
        } else {
            if (this.hasAttribute("input-type-annotations") && !(xsltver < 2.0)) {
                String att = this.getAttribute("input-type-annotations");
                nodeName = "xsl:stylesheet";
                parser.checkAttributeValue(this, nodeName, "input-type-annotations", att, 3);
                int c = att.compareTo("strip");
                if (c == 0) {
                    this.setStripInputTypeAnnotationsSpecified();
                } else if (c < 0) {
                    this.setPreserveInputTypeAnnotationsSpecified();
                }
            }
            if (this.parseUseWhen(this._parser) == XStaticContext.UseWhenResult.TRUE) {
                this.parseOwnChildren(parser);
            } else {
                this.jjtRemoveAllChildren();
            }
        }
        if (this.hasAttribute("default-validation")) {
            String defaultValidationValue = this.getAttribute("default-validation");
            nodeName = "xsl:stylesheet";
            parser.checkAttributeValue(this, nodeName, "default-validation", defaultValidationValue, 3);
            this.setDefaultValidation(defaultValidationValue);
        }
        return false;
    }

    public final void parseOwnChildren(XSLTParser parser) {
        Expr child2;
        int i;
        boolean[] tolerateError = parser.checkAllowedChildren(this);
        int count2 = this.jjtGetNumChildren();
        for (i = 0; i < count2; ++i) {
            child2 = (Expr)this.jjtGetChild(i);
            if (!(child2 instanceof VariableBase) && !(child2 instanceof NamespaceAlias)) continue;
            parser.getStaticContext().setCurrentNode(child2);
            if (!tolerateError[i]) {
                if (!child2.callParseContents(parser)) continue;
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
                continue;
            }
            try {
                if (!child2.callParseContents(parser)) continue;
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
                continue;
            }
            catch (Throwable t) {
                --count2;
                this.jjtRemoveChild(i);
                --i;
                child2 = null;
            }
        }
        for (i = 0; i < count2; ++i) {
            child2 = (Expr)this.jjtGetChild(i);
            if (!(child2 instanceof VariableBase) && !(child2 instanceof NamespaceAlias)) {
                parser.getStaticContext().setCurrentNode(child2);
                if (!tolerateError[i]) {
                    if (child2.callParseContents(parser)) {
                        --count2;
                        this.jjtRemoveChild(i);
                        --i;
                        child2 = null;
                    }
                } else {
                    try {
                        if (child2.callParseContents(parser)) {
                            --count2;
                            this.jjtRemoveChild(i);
                            --i;
                            child2 = null;
                        }
                    }
                    catch (Throwable t) {
                        --count2;
                        this.jjtRemoveChild(i);
                        --i;
                        child2 = null;
                    }
                }
            }
            if (this._templateInlining || !(child2 instanceof Template)) continue;
            Template template = (Template)child2;
            String name2 = "template$dot$" + template.getPosition();
            template.setQName(parser.getQName(name2));
        }
    }

    @Override
    public String toString() {
        return "Program class=" + this.getClass();
    }

    public String getNamespace(String prefix2) {
        return this.lookupNamespace(prefix2);
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public List getTemplates() {
        return this._templates;
    }

    public List getAllValidTemplates() {
        if (this._includedXTQPrograms != null) {
            ArrayList templates = new ArrayList();
            templates.addAll(this._templates);
            int size = this._includedXTQPrograms.size();
            for (int i = 0; i < size; ++i) {
                XTQProgram included = (XTQProgram)this._includedXTQPrograms.get(i);
                templates.addAll(included.getAllValidTemplates());
            }
            return templates;
        }
        return this._templates;
    }

    protected void addTemplate(Template template) {
        this._templates.add(template);
    }

    public XTQProgram getTopLevelXTQProgram() {
        XTQProgram prog = this;
        boolean isTopLevel = false;
        while (!isTopLevel) {
            if (prog._includedFrom != null) {
                prog = prog._includedFrom;
                continue;
            }
            if (prog._importedFrom != null) {
                prog = prog._importedFrom;
                continue;
            }
            isTopLevel = true;
        }
        return prog;
    }

    public void updateEffectiveMergedXslOutputElement(Expr.ImportPrecedence importPrecedence, String name2, String key2, String value2) {
        this.updateMergedOutputElement(importPrecedence, name2, key2, value2);
    }

    private void updateMergedOutputElement(Expr.ImportPrecedence precedence, String name2, String key2, String val) {
        XTQProgram topLevel = this.getTopLevelXTQProgram();
        if (topLevel.m_mergedOutputElems == null) {
            topLevel.m_mergedOutputElems = new EffectiveMergedOutputElements(this._parser.isXSLT20());
        }
        topLevel.m_mergedOutputElems.updateEffectiveMergedXSLOutputElement(precedence, name2, key2, val);
    }

    public Properties getEffectiveMergedXslOutputProperties(String name2) {
        XTQProgram topLevel = this.getTopLevelXTQProgram();
        return topLevel.m_mergedOutputElems.getEffectiveMergedXslOutputProperties(name2);
    }

    public String[] getEffectiveMergedOutputNames() {
        XTQProgram topLevel = this.getTopLevelXTQProgram();
        return topLevel.m_mergedOutputElems.getOutputNames();
    }

    public EffectiveMergedOutputElements getMergedOutputElements() {
        XTQProgram topLevel = this.getTopLevelXTQProgram();
        return topLevel.m_mergedOutputElems;
    }

    @Override
    public void getXQueryString(StringBuffer expr, boolean abbreviate, String indent) {
        HashMap<String, String> prefixMapping;
        String defaultCollationName = this._context.getDefaultCollationName();
        if (defaultCollationName != null) {
            expr.append("declare default collation '");
            expr.append(defaultCollationName);
            expr.append("';\n");
        }
        if ((prefixMapping = this.getPrefixMapping()) != null) {
            for (Map.Entry<String, String> entry : prefixMapping.entrySet()) {
                String elem2 = entry.getValue();
                String key2 = entry.getKey();
                if (key2.equals("")) {
                    expr.append("declare default namespace '");
                } else {
                    expr.append("declare namespace ");
                    expr.append(key2);
                    expr.append("=");
                }
                expr.append('\"');
                expr.append(elem2);
                expr.append('\"');
                expr.append(";\n");
            }
        }
        this.getXQueryStringForChildren(expr, abbreviate, indent);
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        if (n2 instanceof ISetter) {
            if (15 == n2.getId()) {
                this.setDefaultElementTypeNamespace(context2.getStaticContext().getDefaultNamespaceForElementType());
            }
            return;
        }
        switch (n2.getId()) {
            case 26: {
                this.jjtInsertChild(n2, i);
                ImportSchemaOrModule im = (ImportSchemaOrModule)n2;
                this.updatePrefixes(context2, im, im.getPrefix(), im.getNamespace());
                break;
            }
            case 28: {
                this.jjtInsertChild(n2, i);
                ImportSchemaOrModule im = (ImportSchemaOrModule)n2;
                this.updatePrefixes(context2, im, im.getPrefix(), im.getNamespace());
                break;
            }
            case 8: {
                INSBinding b = (INSBinding)n2;
                String prefix2 = b.getNcname();
                String uri2 = b.getURILiteral();
                if (prefix2.equals("xmlns") || prefix2.equals("xml")) {
                    ASTMsg err = new ASTMsg("ERR_XQ_XML_PREFIX2", b);
                    context2.reportError(3, err);
                }
                this.setModuleNamespaceNCName(prefix2);
                this.setModuleNamespaceURILiteral(uri2);
                this.updatePrefixes(context2, b, prefix2, uri2);
                break;
            }
            case 13: {
                INSBinding b = (INSBinding)n2;
                String prefix3 = b.getNcname();
                String namespace2 = b.getURILiteral();
                if (prefix3.equals("xmlns") || prefix3.equals("xml") || namespace2.equals("http://www.w3.org/XML/1998/namespace")) {
                    ASTMsg err = new ASTMsg("ERR_XQ_XML_PREFIX", b);
                    context2.reportError(3, err);
                }
                this.updatePrefixes(context2, b, prefix3, namespace2);
                break;
            }
            case 16: {
                IOptionDecl od = (IOptionDecl)n2;
                if (od.getQName() == null || od.getValue() == null) break;
                List<String> list = this._xqueryOptions.get(od.getQName());
                if (list == null) {
                    list = new ArrayList<String>();
                    this._xqueryOptions.put(od.getQName(), list);
                }
                list.add(od.getValue());
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 39: {
                this.addChildrenOfUselessNode(context2, n2, 0);
                break;
            }
            case 4: {
                ASTMsg err;
                IVersionDecl vd = (IVersionDecl)n2;
                if (!vd.checkXQueryVersion()) {
                    err = new ASTMsg("ERR_XQ_VERSION_NUMBER", vd.getVersion());
                    context2.reportError(3, err);
                }
                if (vd.checkXQueryEncoding()) break;
                err = new ASTMsg("ERR_XQ_WRONG_ENCODING", vd.getEncoding());
                context2.reportError(3, err);
                break;
            }
            case 12: {
                break;
            }
            case 29: {
                ((VarDecl)n2).setLocal(false);
                super.jjtInsertChild(n2, i);
                break;
            }
            default: {
                super.jjtInsertChild(n2, i);
            }
        }
    }

    private void updatePrefixes(ASTBuildingContext context2, SimpleNode node2, String prefix2, String namespace2) {
        if (context2.getStaticContext().getLanguage() == 3 && this._prefixes.containsKey(prefix2)) {
            ASTMsg err = new ASTMsg("ERR_XQ_PREFIX_REDECLARATION", (Object)prefix2, node2);
            context2.reportError(3, err);
        }
        this._prefixes.put(prefix2, true);
        this.addPrefixMapping(prefix2, namespace2);
    }

    @Override
    public void jjtClose(ASTBuildingContext context2) {
        super.jjtClose(context2);
        this.removeNullChildren();
    }

    @Override
    public void jjtOpen(ASTBuildingContext context2) {
        super.jjtOpen(context2);
    }

    public String getModuleNamespaceNCName() {
        return this._moduleNamespaceNCName;
    }

    public void setModuleNamespaceNCName(String moduleNamespaceNCName) {
        this._moduleNamespaceNCName = moduleNamespaceNCName;
    }

    public String getModuleNamespaceURILiteral() {
        return this._moduleNamespaceURILiteral;
    }

    public void setModuleNamespaceURILiteral(String moduleNamespaceURILiteral) {
        this._moduleNamespaceURILiteral = moduleNamespaceURILiteral;
    }

    public List getModuleImports() {
        return this._moduleImports;
    }

    public void addModuleImport(ImportSchemaOrModule moduleImport) {
        if (null == this._moduleImports) {
            this._moduleImports = new ArrayList();
        }
        this._moduleImports.add(moduleImport);
    }

    public List getSchemaImports() {
        return this._schemaImports;
    }

    public void addSchemaImport(ImportSchemaOrModule schemaImport) {
        if (null == this._schemaImports) {
            this._schemaImports = new ArrayList();
        }
        this._schemaImports.add(schemaImport);
    }

    public boolean getStripInputTypeAnnotationsSpecified() {
        return this.m_stripInputTypeAnnotationsSpecified;
    }

    public void setStripInputTypeAnnotationsSpecified() {
        this.m_stripInputTypeAnnotationsSpecified = true;
    }

    public boolean getPreserveInputTypeAnnotationsSpecified() {
        return this.m_preserveInputTypeAnnotationsSpecified;
    }

    public void setPreserveInputTypeAnnotationsSpecified() {
        this.m_preserveInputTypeAnnotationsSpecified = true;
    }

    protected void setDefaultValidation(String validationValue) {
        if (validationValue.equals("preserve")) {
            this._defaultValidation = 2;
        } else if (validationValue.equals("strip")) {
            this._defaultValidation = 1;
        }
    }

    protected int getDefaultValidation() {
        if (this._context.getLanguage() == 3) {
            switch (this._context.getConstructionMode()) {
                case 1: {
                    this._defaultValidation = 2;
                    return 2;
                }
                case 2: {
                    this._defaultValidation = 1;
                    return 1;
                }
            }
        }
        return this._defaultValidation;
    }

    public XStaticContext getStaticContext() {
        return this._context;
    }

    public void setInheritNamespacesToNo() {
        this._hasInheritNamespacesSetToNo = true;
    }

    public boolean hasInheritNamespacesSetToNo() {
        return this._hasInheritNamespacesSetToNo;
    }

    public boolean isLibraryModule() {
        return this._moduleNamespaceURILiteral != null;
    }
}

