/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public LineInfo containerLineInfo;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal, LineInfo containerLineOffset) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.containerLineInfo = containerLineOffset;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        ASTMsg cause;
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String tok = this.currentToken.next.image;
        int line = this.currentToken.next.beginLine;
        int column = this.currentToken.next.beginColumn;
        String systemId = null;
        if (this.containerLineInfo != null) {
            systemId = this.containerLineInfo.getSystemID();
            if (this.containerLineInfo.getStartLine() > 0) {
                line += this.containerLineInfo.getStartLine() - 1;
            }
            if (this.containerLineInfo.getStartColumn() > 0) {
                column = this.containerLineInfo.getStartColumn();
            }
        }
        if (this.expectedTokenSequences.length == 1) {
            String expected = this.tokenImage[this.expectedTokenSequences[0][0]];
            cause = new ASTMsg("XPATH_GENERATED_PARSER_ERROR_WITH_EXPECTED", systemId, tok, expected, line, column);
        } else {
            cause = new ASTMsg("XPATH_GENERATED_PARSER_ERROR", systemId, tok, line, column);
        }
        return cause.toString();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public SourceLocation getSourceLocation() {
        if (this.currentToken == null) {
            return null;
        }
        int startLine = this.currentToken.next.beginLine;
        int startColumn = this.currentToken.next.beginColumn;
        String systemId = null;
        if (this.containerLineInfo != null) {
            systemId = this.containerLineInfo.getSystemID();
            if (this.containerLineInfo.getStartLine() > 0) {
                startLine += this.containerLineInfo.getStartLine() - 1;
            }
            if (this.containerLineInfo.getStartColumn() > 0) {
                startColumn = this.containerLineInfo.getStartColumn();
            }
        }
        return new SourceLocation(systemId, null, startLine, startColumn, -1, -1);
    }
}

