/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.Parser;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Xq2xml;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class Test {
    static final int DUMP_NONE = 1;
    static final int DUMP_AST = 2;
    static final int DUMP_XQUERYX = 3;
    static final int DUMP_AST_XML = 4;
    static final int DUMP_XQUERY = 5;
    PrintStream xqout1 = System.out;
    PrintStream xqout2;
    String XQueryXOutputFilename = null;

    public static void main(String[] args) {
        Test test2 = new Test();
        test2.process(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String[] args) {
        try {
            int numberArgsLeft = args.length;
            int argsStart = 0;
            boolean isMatchParser = false;
            int dumpFormat = 1;
            while (numberArgsLeft > 0) {
                try {
                    File file;
                    SimpleNode tree;
                    Object parser;
                    if (args[argsStart].equals("-dumptree")) {
                        ++argsStart;
                        --numberArgsLeft;
                        dumpFormat = 2;
                        continue;
                    }
                    if (args[argsStart].equals("-dumpxml")) {
                        ++argsStart;
                        --numberArgsLeft;
                        dumpFormat = 4;
                        continue;
                    }
                    if (args[argsStart].equals("-dumpxquery")) {
                        ++argsStart;
                        --numberArgsLeft;
                        dumpFormat = 5;
                        continue;
                    }
                    if (args[argsStart].equals("-xqueryx")) {
                        ++argsStart;
                        --numberArgsLeft;
                        dumpFormat = 3;
                        continue;
                    }
                    if (args[argsStart].equals("-lang")) {
                        ++argsStart;
                        ++argsStart;
                        --numberArgsLeft;
                        --numberArgsLeft;
                        continue;
                    }
                    if ("-xqueryxfile".equalsIgnoreCase(args[argsStart])) {
                        --numberArgsLeft;
                        dumpFormat = 3;
                        this.XQueryXOutputFilename = args[++argsStart];
                        this.xqout2 = new PrintStream(new FileOutputStream(this.XQueryXOutputFilename));
                        ++argsStart;
                        --numberArgsLeft;
                        continue;
                    }
                    if (args[argsStart].equals("-match")) {
                        isMatchParser = true;
                        System.out.println("Match Pattern Parser");
                        ++argsStart;
                        --numberArgsLeft;
                        continue;
                    }
                    if ("-expr".equalsIgnoreCase(args[argsStart])) {
                        String expr;
                        ++argsStart;
                        --numberArgsLeft;
                        if (dumpFormat != 3) {
                            System.out.println("Running test for: " + args[argsStart]);
                        }
                        if ((expr = args[argsStart]).startsWith("'")) {
                            expr = expr.substring(1, expr.length() - 1);
                        }
                        ++argsStart;
                        --numberArgsLeft;
                        parser = new XPath(null, new StringReader(expr));
                        tree = isMatchParser ? ((XPath)parser).MatchPattern((ASTBuildingContext)parser) : ((XPath)parser).XPath2();
                        this.dump(tree, dumpFormat);
                        continue;
                    }
                    if ("-file".equalsIgnoreCase(args[argsStart])) {
                        ++argsStart;
                        --numberArgsLeft;
                        if (dumpFormat != 3) {
                            System.out.println("Running test for: " + args[argsStart]);
                        }
                        file = new File(args[argsStart]);
                        ++argsStart;
                        --numberArgsLeft;
                        parser = new Parser(null, "XQuery1", file.getAbsolutePath());
                        tree = ((Parser)parser).parse();
                        this.dump(tree, dumpFormat);
                        continue;
                    }
                    if (args[argsStart].endsWith(".xquery")) {
                        if (dumpFormat != 3) {
                            System.out.println("Running test for: " + args[argsStart]);
                        }
                        file = new File(args[argsStart]);
                        ++argsStart;
                        --numberArgsLeft;
                        FileInputStream fis = new FileInputStream(file);
                        XPath parser2 = new XPath(null, new InputStreamReader((InputStream)fis, "utf-8"));
                        SimpleNode tree2 = parser2.XPath2();
                        this.dump(tree2, dumpFormat);
                        continue;
                    }
                    if ("-catalog".equalsIgnoreCase(args[argsStart])) {
                        --numberArgsLeft;
                        String catalogFileName = args[++argsStart];
                        ++argsStart;
                        --numberArgsLeft;
                        this.processW3CTestCatalog(dumpFormat, catalogFileName);
                        continue;
                    }
                    DocumentBuilderFactory dbf = JAXPFactoryHelper.newDocumentBuilderFactory();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc2 = db.parse(args[argsStart]);
                    ++argsStart;
                    --numberArgsLeft;
                    Element tests = doc2.getDocumentElement();
                    NodeList testElems = tests.getChildNodes();
                    int nChildren = testElems.getLength();
                    int testid = 0;
                    for (int i = 0; i < nChildren; ++i) {
                        Node node2 = testElems.item(i);
                        if (1 != node2.getNodeType()) continue;
                        ++testid;
                        String xpathString = ((Element)node2).getAttribute("value");
                        if (dumpFormat != 1) {
                            System.err.println("Test[" + testid + "]: " + xpathString);
                        } else {
                            System.out.print("[" + testid + "]");
                            System.out.flush();
                            if (testid < 20) {
                                if (testid % 18 == 0) {
                                    System.out.println();
                                }
                            } else if (testid < 114) {
                                if (testid % 14 == 0) {
                                    System.out.println();
                                }
                            } else if (testid < 1000) {
                                if (testid % 12 == 0) {
                                    System.out.println();
                                }
                            } else if (testid % 10 == 0) {
                                System.out.println();
                            }
                        }
                        XPath parser3 = new XPath(null, new StringReader(xpathString));
                        SimpleNode tree3 = parser3.XPath2();
                        this.dump(tree3, dumpFormat);
                    }
                    System.out.println();
                    if (dumpFormat != 3) {
                        System.out.println("Test successful!!!");
                    }
                    System.out.flush();
                    break;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
            }
            if (dumpFormat != 3) {
                System.out.println("Test successful!!!");
            }
        }
        finally {
            if (this.xqout2 != null) {
                this.xqout2.close();
                this.xqout2 = null;
            }
        }
    }

    private void processW3CTestCatalog(int dumpFormat, String catalogFileName) throws ParserConfigurationException, SAXException, IOException {
        String fname;
        Element testCase;
        System.out.println("Running catalog for: " + catalogFileName);
        DocumentBuilderFactory dbf = JAXPFactoryHelper.newDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc2 = db.parse(catalogFileName);
        NodeIterator testCases = ((DocumentTraversal)((Object)doc2)).createNodeIterator(doc2, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node node2) {
                String nm = node2.getNodeName();
                return nm.equals("test-case") ? (short)1 : 3;
            }
        }, true);
        int totalCount = 0;
        Vector<String> failedList = new Vector<String>();
        Vector<String> failedErrorList = new Vector<String>();
        Vector<String> filesNotFound = new Vector<String>();
        Vector<String> filesNotXQueryXValid = new Vector<String>();
        boolean hadEnough = false;
        int wobblycount = 0;
        block4: while ((testCase = (Element)testCases.nextNode()) != null && !hadEnough) {
            Element query;
            NodeIterator queryies = ((DocumentTraversal)((Object)doc2)).createNodeIterator(testCase, 1, new NodeFilter(){

                @Override
                public short acceptNode(Node node2) {
                    String nm = node2.getNodeName();
                    return nm.equals("query") ? (short)1 : 3;
                }
            }, true);
            while ((query = (Element)queryies.nextNode()) != null && !hadEnough) {
                String fileString = query.getAttribute("name");
                String locString = testCase.getAttribute("FilePath").replace('/', File.separatorChar);
                File catFile = new File(catalogFileName);
                String locCatFile = catFile.getParent();
                String absFileName = locCatFile + File.separator + "Queries" + File.separator + "XQuery" + File.separator + locString + fileString + ".xq";
                if (dumpFormat != 1 && dumpFormat != 3) {
                    System.out.print("== ");
                    System.out.print(absFileName);
                    System.out.println(" ==");
                }
                boolean isParseError = false;
                String scenario = testCase.getAttribute("scenario");
                if (scenario.equals("parse-error")) {
                    isParseError = true;
                }
                ++totalCount;
                try {
                    File file = new File(absFileName);
                    FileInputStream fis = new FileInputStream(file);
                    XPath parser = new XPath(null, new InputStreamReader((InputStream)fis, "utf-8"));
                    SimpleNode tree = parser.XPath2();
                    if (isParseError) {
                        failedErrorList.addElement(fileString);
                        System.out.print("x");
                        System.out.flush();
                    } else {
                        System.out.print(".");
                        System.out.flush();
                        this.XQueryXOutputFilename = "t.xqueryx";
                        this.xqout2 = new PrintStream(new FileOutputStream(this.XQueryXOutputFilename));
                        this.xqout1 = null;
                        boolean isValid = this.processToXQueryXAndValidate(tree, null);
                        System.out.print(isValid ? "v" : "i");
                        if (!isValid) {
                            filesNotXQueryXValid.addElement(file.getCanonicalPath());
                            if (filesNotXQueryXValid.size() > 10) {
                                hadEnough = true;
                                continue block4;
                            }
                        }
                    }
                    this.dump(tree, dumpFormat);
                }
                catch (FileNotFoundException e) {
                    filesNotFound.addElement(fileString);
                    System.out.print("f");
                    System.out.flush();
                }
                catch (Exception e) {
                    if (!isParseError) {
                        failedList.addElement(fileString);
                        System.out.print("e");
                        System.out.flush();
                    } else {
                        System.out.print(",");
                        System.out.flush();
                    }
                }
                catch (Error e2) {
                    if (!isParseError) {
                        failedList.addElement(fileString);
                        System.out.print("e");
                        System.out.flush();
                    }
                    System.out.print(",");
                    System.out.flush();
                }
                if (totalCount * 2 % 60 != 0) continue;
                System.out.println();
                for (int i = 0; i < wobblycount; ++i) {
                    System.out.print('>');
                }
                if (++wobblycount <= 2) continue;
                wobblycount = 0;
            }
        }
        System.out.println();
        if (filesNotFound.size() > 0) {
            System.out.println("Files not found: ");
            for (int i = 0; i != filesNotFound.size(); ++i) {
                fname = (String)filesNotFound.elementAt(i);
                System.out.print(fname);
                if (i + 1 != filesNotFound.size()) {
                    System.out.print(", ");
                }
                if ((i + 1) % 4 != 0) continue;
                System.out.println();
            }
            System.out.println();
        }
        if (failedList.size() > 0 || failedErrorList.size() > 0) {
            if (failedList.size() > 0) {
                System.out.println("SHOULD HAVE SUCCEEDED BUT DIDN'T: ");
                for (int i = 0; i != failedList.size(); ++i) {
                    fname = (String)failedList.elementAt(i);
                    System.out.print(fname);
                    if (i + 1 != failedList.size()) {
                        System.out.print(", ");
                    }
                    if ((i + 1) % 4 != 0) continue;
                    System.out.println();
                }
                System.out.println();
            }
            if (failedErrorList.size() > 0) {
                System.out.println("SHOULD HAVE FAILED BUT DIDN'T: ");
                for (int i = 0; i != failedErrorList.size(); ++i) {
                    fname = (String)failedErrorList.elementAt(i);
                    System.out.print(fname);
                    if (i + 1 != failedErrorList.size()) {
                        System.out.print(", ");
                    }
                    if ((i + 1) % 4 != 0) continue;
                    System.out.println();
                }
                System.out.println();
            }
            System.out.print("Failed " + (failedList.size() + failedErrorList.size()) + " out of ");
        } else {
            System.out.print("Total Success!! ");
        }
        System.out.println(totalCount + " cases");
        if (filesNotXQueryXValid.size() > 0) {
            System.err.println("XQueryX Translation Failed: ");
            for (int i = 0; i != filesNotXQueryXValid.size(); ++i) {
                fname = (String)filesNotXQueryXValid.elementAt(i);
                System.err.println(fname);
            }
        }
    }

    void dump(SimpleNode tree, int format2) {
        Vector errors;
        boolean isValid;
        if (format2 == 2) {
            tree.dump("|");
        } else if (format2 == 4) {
            try {
                if (null != this.XQueryXOutputFilename) {
                    this.xqout1 = new PrintStream(new FileOutputStream(this.XQueryXOutputFilename));
                }
                PrintWriter systemOutWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.xqout1, "UTF-8"));
                Xq2xml.convert(" ", systemOutWriter, tree);
                systemOutWriter.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (format2 == 5) {
            StringBuffer buf = new StringBuffer();
            tree.getXQueryString(buf, false, " ");
            System.out.println(buf.toString());
        } else if (format2 == 3 && !(isValid = this.processToXQueryXAndValidate(tree, errors = new Vector()))) {
            System.err.println("XQueryX Translation is invalid!");
            for (int i = 0; i < errors.size(); ++i) {
                String msg = (String)errors.elementAt(i);
                System.err.println(msg);
            }
        }
    }

    private boolean processToXQueryXAndValidate(SimpleNode tree, Vector errors) {
        Object[] args;
        Class[] argTypes;
        boolean isValidDoc = false;
        try {
            Class<?> transformerClass = Class.forName("XQueryToXQueryX");
            Object transformer = transformerClass.newInstance();
            argTypes = new Class[]{SimpleNode.class, PrintStream.class, PrintStream.class};
            Method transformMethod = transformerClass.getMethod("transform", argTypes);
            args = new Object[]{tree, this.xqout1, this.xqout2};
            transformMethod.invoke(transformer, args);
        }
        catch (ClassNotFoundException e) {
            System.err.println("XQueryX translator not yet supported!");
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            if (null != this.xqout2) {
                this.xqout2.close();
                this.xqout2 = null;
                Class<?> validatorClass = Class.forName("XMLValidator");
                Object validator = validatorClass.newInstance();
                argTypes = new Class[]{String.class, Vector.class};
                Method validateXMLFile = validatorClass.getMethod("validateXMLFile", argTypes);
                args = new Object[]{this.XQueryXOutputFilename, errors};
                Boolean isValid = (Boolean)validateXMLFile.invoke(validator, args);
                isValidDoc = isValid;
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("XML Validator class not found!");
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
        return isValidDoc;
    }
}

