/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.utils.XPathError;

public class Utilities {
    public static final short getOpType(String opstr) {
        int optype;
        switch (opstr.charAt(0)) {
            case '+': {
                optype = 4;
                break;
            }
            case '-': {
                optype = 5;
                break;
            }
            case '*': {
                optype = 30;
                break;
            }
            case 'd': {
                optype = 31;
                break;
            }
            case 'i': {
                if (opstr.equals("idiv")) {
                    optype = 32;
                    break;
                }
                if (opstr.equals("is")) {
                    optype = 19;
                    break;
                }
                optype = 2;
                break;
            }
            case 'm': {
                optype = 33;
                break;
            }
            case 'u': 
            case '|': {
                optype = 1;
                break;
            }
            case 'a': {
                optype = 23;
                break;
            }
            case 'o': {
                optype = 24;
                break;
            }
            case '=': {
                optype = 13;
                break;
            }
            case '!': {
                optype = 14;
                break;
            }
            case '<': {
                if (opstr.equals("<<")) {
                    optype = 21;
                    break;
                }
                if (opstr.equals("<=")) {
                    optype = 16;
                    break;
                }
                optype = 15;
                break;
            }
            case '>': {
                if (opstr.equals(">>")) {
                    optype = 22;
                    break;
                }
                if (opstr.equals(">=")) {
                    optype = 18;
                    break;
                }
                optype = 17;
                break;
            }
            case 'e': {
                if (opstr.equals("except")) {
                    optype = 3;
                    break;
                }
                optype = 7;
                break;
            }
            case 'n': {
                optype = 8;
                break;
            }
            case 'l': {
                if (opstr.equals("lt")) {
                    optype = 9;
                    break;
                }
                optype = 10;
                break;
            }
            case 'g': {
                if (opstr.equals("gt")) {
                    optype = 11;
                    break;
                }
                optype = 12;
                break;
            }
            case 't': {
                optype = 6;
                break;
            }
            case '/': {
                optype = 28;
                break;
            }
            default: {
                throw new XPathError("ERR_SYSTEM", "Unrecognized token: " + opstr);
            }
        }
        return (short)optype;
    }
}

