/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.utils.XPathError;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class XQueryToXQueryX
implements XPathTreeConstants {
    Stack _openElemStack = new Stack();
    Stack _outputStack = new Stack();
    Stack _stackChecks = new Stack();
    PrintWriter _xqout1;
    PrintWriter _xqout2;
    static final int BSP_STRIP = 0;
    static final int BSP_PRESERVE = 1;
    int _boundarySpacePolicy = 0;
    private static int MAXCHAR = 65535;

    public XQueryToXQueryX() throws UnsupportedEncodingException {
        try {
            this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            try {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            }
            catch (UnsupportedEncodingException e1) {
                this._xqout1 = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
            }
        }
    }

    public XQueryToXQueryX(PrintWriter xqout) throws UnsupportedEncodingException {
        this._xqout1 = xqout;
    }

    public XQueryToXQueryX(PrintStream xqout) throws UnsupportedEncodingException {
        this._xqout1 = xqout != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout, "utf-8")) : null;
    }

    public XQueryToXQueryX(PrintStream xqout, PrintStream xqout2) throws UnsupportedEncodingException {
        this._xqout1 = xqout != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout, "utf-8")) : null;
        this._xqout2 = xqout2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)xqout2, "utf-8")) : null;
    }

    private void xqprintln() {
        if (null != this._xqout1) {
            this._xqout1.println();
        }
        if (null != this._xqout2) {
            this._xqout2.println();
        }
    }

    private void xqprintln(String s) {
        if (null != this._xqout1) {
            this._xqout1.println(s);
        }
        if (null != this._xqout2) {
            this._xqout2.println(s);
        }
    }

    private void xqprint(String s) {
        if (null != this._xqout1) {
            this._xqout1.print(s);
        }
        if (null != this._xqout2) {
            this._xqout2.print(s);
        }
    }

    private static void writeUTF16Surrogate(PrintWriter ps, char c, char[] ch, int i, int end) {
        int surrogateValue = XQueryToXQueryX.getURF16SurrogateValue(c, ch, i, end);
        ps.print('&');
        ps.print('#');
        ps.print(Integer.toString(surrogateValue));
        ps.print(';');
    }

    private static int getURF16SurrogateValue(char c, char[] ch, int i, int end) {
        int next;
        if (i + 1 >= end) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new XPathError("ERR_SYSTEM", "Invalid UTF-16 surrogate detected: " + Integer.toHexString(c));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    private static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    private static boolean canConvert(char ch) {
        boolean isLegal;
        boolean bl = isLegal = ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
        if (!isLegal) {
            throw new XPathError("ERR_INVALID_CHAR", null);
        }
        return ch <= MAXCHAR;
    }

    private void xqprintEscaped(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                this.xqprint("&lt;");
                continue;
            }
            if (c == '>') {
                this.xqprint("&gt;");
                continue;
            }
            if (c == '&') {
                this.xqprint("&amp;");
                continue;
            }
            if (XQueryToXQueryX.isUTF16Surrogate(c)) {
                char[] chars = s.toCharArray();
                int n2 = s.length();
                if (null != this._xqout1) {
                    XQueryToXQueryX.writeUTF16Surrogate(this._xqout1, c, chars, i, n2 - 1);
                }
                if (null == this._xqout2) continue;
                XQueryToXQueryX.writeUTF16Surrogate(this._xqout2, c, chars, i, n2 - 1);
                continue;
            }
            if (!XQueryToXQueryX.canConvert(c)) {
                this.xqprint("&#");
                this.xqprint(Integer.toString(c));
                this.xqprint(";");
                continue;
            }
            if (null != this._xqout1) {
                this._xqout1.print(c);
            }
            if (null == this._xqout2) continue;
            this._xqout2.print(c);
        }
    }

    private void indent() {
        int indentAmount = this._openElemStack.size();
        for (int i = 0; i < indentAmount; ++i) {
            this.xqprint(" ");
        }
    }

    private void pd(String s, int i) {
        this.indent();
        for (int j = 0; j < i; ++j) {
            this.xqprint(" ");
        }
        this.xqprint("<!-- ");
        this.xqprint(s);
        this.xqprintln(" -->");
    }

    private void pd(String s) {
        this.pd(s, 0);
    }

    private void pd(int id2) {
        this.pd(jjtNodeName[id2], 0);
    }

    private void pushElem(int id2, SimpleNode node2) {
        this.indent();
        this._outputStack.push("<");
        String nodeName = jjtNodeName[id2];
        String s = "xqx:" + nodeName.substring(0, 1).toLowerCase() + nodeName.substring(1);
        this._outputStack.push(s);
        this._openElemStack.push(s);
        this._openElemStack.push(node2);
    }

    private void pushElem(String s, SimpleNode node2) {
        this.indent();
        this._outputStack.push("<");
        this._outputStack.push(s);
        this._openElemStack.push(s);
        this._openElemStack.push(node2);
    }

    private void pushAttr(String name2, String val) {
        this._outputStack.push(" ");
        this._outputStack.push(name2);
        this._outputStack.push("=\"");
        this._outputStack.push(val);
        this._outputStack.push("\"");
    }

    private void flushOpen(SimpleNode node2, boolean doLF) {
        if (this._outputStack.size() > 0) {
            if (node2 != this._openElemStack.peek()) {
                return;
            }
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String s = (String)this._outputStack.elementAt(i);
                this.xqprint(s);
            }
            this.xqprint(">");
            if (doLF) {
                this.xqprintln();
            }
            this._outputStack.removeAllElements();
        }
    }

    private void flushOpen(SimpleNode node2) {
        this.flushOpen(node2, true);
    }

    private void flushEmpty(SimpleNode node2) {
        if (this._outputStack.size() > 0) {
            if (node2 != this._openElemStack.peek()) {
                return;
            }
            this._openElemStack.pop();
            this._openElemStack.pop();
            for (int i = 0; i < this._outputStack.size(); ++i) {
                String s = (String)this._outputStack.elementAt(i);
                this.xqprint(s);
            }
            this.xqprintln("/>");
            this._outputStack.removeAllElements();
        }
    }

    private void flushClose(SimpleNode node2, boolean doIndent) {
        if (this._openElemStack.size() == 0) {
            return;
        }
        if (node2 != this._openElemStack.peek()) {
            return;
        }
        this._openElemStack.pop();
        String elemName = (String)this._openElemStack.pop();
        if (doIndent) {
            this.indent();
        }
        this.xqprint("</");
        this.xqprint(elemName);
        this.xqprintln(">");
    }

    private void flushClose(SimpleNode node2) {
        this.flushClose(node2, true);
    }

    private boolean isJustWhitespace(SimpleNode node2) {
        if (node2.getId() == 127 || node2.getId() == 116) {
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                SimpleNode child2 = (SimpleNode)node2.jjtGetChild(i);
                if (this.isJustWhitespace(child2)) continue;
                return false;
            }
            return true;
        }
        if (node2.getId() == 128 || node2.getId() == 124 || node2.getId() == 126) {
            return Util.trimWhitespace(node2.getValue()).length() == 0;
        }
        return false;
    }

    private boolean isPreviousSiblingBoundaryWhitespaceChar(SimpleNode node2) {
        if ((node2 = this.getPreviousSibling(this.sn(node2.jjtGetParent()))) == null) {
            return true;
        }
        if (node2.jjtGetNumChildren() > 0) {
            node2 = this.sn(node2.jjtGetChild(0));
        }
        if (node2.getId() == 128 || node2.getId() == 124 || node2.getId() == 126) {
            if (Util.trimWhitespace(node2.getValue()).length() == 0) {
                return this.isPreviousSiblingBoundaryWhitespaceChar(node2);
            }
        } else {
            return node2.getId() != 129 || (node2 = this.sn(node2.jjtGetChild(0))).getId() != 132 && node2.getId() != 131 && node2.getId() != 130;
        }
        return false;
    }

    private boolean isNextSiblingBoundaryWhitespaceChar(SimpleNode node2) {
        if ((node2 = this.getNextSibling(this.sn(node2.jjtGetParent()))) == null) {
            return true;
        }
        if (node2.jjtGetNumChildren() > 0) {
            node2 = this.sn(node2.jjtGetChild(0));
        }
        if (node2.getId() == 128 || node2.getId() == 124 || node2.getId() == 126) {
            if (Util.trimWhitespace(node2.getValue()).length() == 0) {
                return this.isNextSiblingBoundaryWhitespaceChar(node2);
            }
        } else {
            return node2.getId() != 129 || (node2 = this.sn(node2.jjtGetChild(0))).getId() != 132 && node2.getId() != 131 && node2.getId() != 130;
        }
        return false;
    }

    private boolean isBoundaryWhitespaceChar(SimpleNode node2) {
        return (node2.getId() == 128 || node2.getId() == 124 || node2.getId() == 126) && Util.trimWhitespace(node2.getValue()).length() == 0 && this.isPreviousSiblingBoundaryWhitespaceChar(node2) && this.isNextSiblingBoundaryWhitespaceChar(node2);
    }

    private boolean shouldStripChar(SimpleNode node2) {
        return this._boundarySpacePolicy == 0 && this.isBoundaryWhitespaceChar(node2);
    }

    private boolean shouldVoidPathExpr(SimpleNode node2) {
        if (this.getNumExprChildren(node2) > 1) {
            return false;
        }
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            SimpleNode child2 = (SimpleNode)node2.jjtGetChild(i);
            if (child2.getId() != 85) continue;
            return false;
        }
        return true;
    }

    private void markCheck() {
        this._stackChecks.push(new Integer(this._openElemStack.size()));
    }

    private boolean check(SimpleNode node2) {
        int currentSize;
        int markSize = (Integer)this._stackChecks.pop();
        if (markSize != (currentSize = this._openElemStack.size())) {
            // empty if block
        }
        return markSize == currentSize;
    }

    private void xqflush() {
        if (null != this._xqout1) {
            this._xqout1.flush();
        }
        if (null != this._xqout2) {
            this._xqout2.flush();
        }
    }

    public boolean transform(SimpleNode node2, PrintStream ps1) throws UnsupportedEncodingException {
        this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
        boolean ret = this.transform(node2);
        this.xqflush();
        return ret;
    }

    public boolean transform(SimpleNode node2, PrintStream ps1, PrintStream ps2) throws UnsupportedEncodingException {
        this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
        this._xqout2 = ps2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps2, "utf-8")) : null;
        boolean ret = this.transform(node2);
        this.xqflush();
        return ret;
    }

    public boolean transformNoEncodingException(SimpleNode node2, PrintStream ps1, PrintStream ps2) {
        try {
            this._xqout1 = ps1 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps1, "utf-8")) : null;
            this._xqout2 = ps2 != null ? new PrintWriter(new OutputStreamWriter((OutputStream)ps2, "utf-8")) : null;
        }
        catch (UnsupportedEncodingException e) {
            this._xqout1 = ps1 != null ? new PrintWriter(ps1) : null;
            this._xqout2 = ps2 != null ? new PrintWriter(ps2) : null;
        }
        boolean ret = this.transform(node2);
        this.xqflush();
        return ret;
    }

    public boolean transform(SimpleNode node2) {
        this.markCheck();
        int id2 = node2.getId();
        switch (id2) {
            case 0: {
                this.xqprintln("<?xml version=\"1.0\"?>");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.pushElem("xqx:module", node2);
                this.pushAttr("xmlns:xqx", "http://www.w3.org/2005/XQueryX");
                this._outputStack.push("\n           ");
                this.pushAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this._outputStack.push("\n           ");
                this.pushAttr("xsi:schemaLocation", "http://www.w3.org/2005/XQueryX\n                                http://www.w3.org/2005/XQueryX/xqueryx.xsd");
                break;
            }
            case 4: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                    SimpleNode child2 = (SimpleNode)node2.jjtGetChild(i);
                    if (i == 0) {
                        this.pushElem("xqx:version", child2);
                        this.flushOpen(child2, false);
                        this.xqprint(child2.getValue().substring(1, child2.getValue().length() - 1));
                        this.flushClose(child2, false);
                        continue;
                    }
                    if (i != 1) continue;
                    this.pd("encoding: " + child2.getValue());
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 5: 
            case 97: 
            case 98: 
            case 99: {
                String elemName;
                boolean doValue = true;
                switch (id2) {
                    case 97: {
                        elemName = "xqx:integerConstantExpr";
                        break;
                    }
                    case 98: {
                        elemName = "xqx:decimalConstantExpr";
                        break;
                    }
                    case 99: {
                        elemName = "xqx:doubleConstantExpr";
                        break;
                    }
                    case 5: {
                        if (this.getParentID(node2) == 16) {
                            elemName = "xqx:optionContents";
                            doValue = false;
                            break;
                        }
                        elemName = "xqx:stringConstantExpr";
                        break;
                    }
                    default: {
                        elemName = "UNKNOWN!";
                    }
                }
                this.pushElem(elemName, node2);
                this.flushOpen(node2, doValue);
                if (doValue) {
                    this.pushElem("xqx:value", node2);
                    this.flushOpen(node2, false);
                }
                String val = node2.getValue();
                if (id2 == 5) {
                    val = val.substring(1, val.length() - 1);
                }
                this.xqprintEscaped(val);
                if (doValue) {
                    this.flushClose(node2, false);
                }
                this.flushClose(node2, doValue);
                return this.check(node2);
            }
            case 25: {
                break;
            }
            case 185: {
                if (this.getParentID(node2) == 25) {
                    this.pushElem("xqx:baseUriDecl", node2);
                } else if (this.getParentID(node2) == 50) {
                    this.pushElem("xqx:collation", node2);
                } else if (this.getParentID(node2) == 24) {
                    this.pushElem("xqx:defaultCollationDecl", node2);
                } else {
                    this.pushElem("xqx:uri", node2);
                }
                this.flushOpen(node2, false);
                SimpleNode child3 = this.sn(node2.jjtGetChild(0));
                String val = child3.getValue();
                val = val.substring(1, val.length() - 1);
                this.xqprint(val);
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 9: {
                if (node2.jjtGetNumChildren() <= 0) break;
                this.pushElem("xqx:prolog", node2);
                break;
            }
            case 93: 
            case 94: {
                String qname2 = node2.getValue();
                int i = qname2.indexOf(58);
                if (i > 0) {
                    String prefix2 = qname2.substring(0, i);
                    qname2 = qname2.substring(i + 1);
                    if (prefix2.equals("*")) {
                        this.pushElem("xqx:star", node2);
                        this.flushEmpty(node2);
                    } else {
                        this.pushElem("xqx:NCName", node2);
                        this.flushOpen(node2, false);
                        this.xqprint(prefix2);
                        this.flushClose(node2, false);
                    }
                }
                if (qname2.equals("*")) {
                    this.pushElem("xqx:star", node2);
                    this.flushEmpty(node2);
                } else {
                    this.pushElem("xqx:NCName", node2);
                    this.flushOpen(node2, false);
                    this.xqprint(qname2);
                    this.flushClose(node2, false);
                }
                return this.check(node2);
            }
            case 163: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                this.transformChildren(node2);
                if (this.sn(node2.jjtGetChild(0)).getValue() != null) {
                    this.pushElem("xqx:optional", node2);
                    this.flushEmpty(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 168: {
                break;
            }
            case 175: 
            case 179: {
                if (node2.getValue() == null || !node2.getValue().equals("*")) break;
                this.pushElem(id2 == 175 ? 182 : 183, node2);
                this.flushOpen(node2);
                this.pushElem("xqx:star", node2);
                this.flushEmpty(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 182: 
            case 183: {
                this.pushElem(id2, node2);
                break;
            }
            case 78: 
            case 190: 
            case 191: {
                int pid = this.getParentID(node2);
                if (pid == 157 || pid == 159) {
                    this.pushElem("xqx:tagName", node2);
                } else if (pid == 184) {
                    this.pushElem("xqx:typeName", node2);
                } else if (pid == 162) {
                    this.pushElem("xqx:piTarget", node2);
                } else if (pid == 168) {
                    this.pushElem(168, node2);
                } else if (pid == 13) {
                    this.pushElem("xqx:prefix", node2);
                } else if (pid == 29 || pid == 34) {
                    this.pushElem("xqx:varName", node2);
                } else if (pid == 32) {
                    this.pushElem("xqx:functionName", node2);
                } else if (pid == 16) {
                    this.pushElem("xqx:optionName", node2);
                } else {
                    this.pushElem("xqx:QName", node2);
                }
                String qname3 = this.processPrefix(node2.getValue());
                this.flushOpen(node2, false);
                this.xqprint(qname3);
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 111: {
                if (this.getParentID(node2) == 114 && node2.getValue().startsWith("xmlns:")) {
                    this.pushElem("xqx:prefix", node2);
                    this.flushOpen(node2, false);
                    int i = node2.getValue().indexOf(58);
                    String prefix3 = node2.getValue().substring(i + 1);
                    this.xqprint(prefix3);
                    this.flushClose(node2, false);
                    return this.check(node2);
                }
                if (this.getParentID(node2) == 114) {
                    this.pushElem("xqx:attributeName", node2);
                } else {
                    this.pushElem("xqx:tagName", node2);
                }
                String qname4 = this.processPrefix(node2.getValue());
                this.flushOpen(node2, false);
                this.xqprint(qname4);
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 192: {
                this.pushElem("xqx:functionName", node2);
                String qname5 = this.processPrefix(node2.getValue());
                this.flushOpen(node2, false);
                this.xqprint(qname5);
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 92: {
                this.pushElem("xqx:Wildcard", node2);
                break;
            }
            case 91: {
                if (this.getChildID(node2, 0) == 92) break;
            }
            case 100: {
                int pid = this.getParentID(node2);
                if (pid == 43 || pid == 45 || pid == 53) {
                    this.pushElem("xqx:typedVariableBinding", node2);
                    this.flushOpen(node2, true);
                    this.pushElem(id2, node2);
                } else if (pid == 55 || pid == 54) {
                    this.pushElem("xqx:variableBinding", node2);
                } else if (id2 == 100) {
                    this.pushElem("xqx:varRef", node2);
                    this.flushOpen(node2, true);
                    this.pushElem("xqx:name", node2);
                } else {
                    this.pushElem(id2, node2);
                }
                String qname6 = ((SimpleNode)node2.jjtGetChild(0)).getValue();
                if (null != qname6) {
                    qname6 = this.processPrefix(qname6);
                }
                this.flushOpen(node2, false);
                this.xqprint(qname6);
                this.flushClose(node2, false);
                SimpleNode nextSibling = this.getNextSibling(node2);
                if (null != nextSibling && nextSibling.getId() == 164) {
                    this.transform(nextSibling);
                }
                if (pid == 43 || pid == 45 || pid == 53) {
                    this.flushClose(node2, true);
                } else if (id2 == 100) {
                    this.flushClose(node2, true);
                }
                return this.check(node2);
            }
            case 44: {
                this.pushElem("xqx:positionalVariableBinding", node2);
                String val = this.sn(this.sn(node2.jjtGetChild(0)).jjtGetChild(0)).getValue();
                String qname7 = this.processPrefix(val);
                this.flushOpen(node2, false);
                this.xqprint(qname7);
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 167: {
                if (node2.getValue() == null || !node2.getValue().equals("item")) break;
                this.pushElem("xqx:anyItemType", node2);
                this.flushEmpty(node2);
                return this.check(node2);
            }
            case 165: {
                int pid = this.getParentID(node2);
                if (pid == 55 || pid == 32) {
                    this.pushElem("xqx:typeDeclaration", node2);
                    this.flushOpen(node2);
                }
                if (node2.getValue() != null && node2.getValue().equals("empty-sequence")) {
                    this.pushElem("xqx:voidSequenceType", node2);
                    this.flushEmpty(node2);
                } else {
                    this.transformChildren(node2);
                }
                if (pid == 55 || pid == 32) {
                    this.flushClose(node2);
                }
                return this.check(node2);
            }
            case 40: {
                if (this.getNumExprChildren(node2) <= 1) break;
                this.pushElem("xqx:sequenceExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 82: {
                if (this.shouldVoidPathExpr(node2)) break;
                this.pushElem(id2, node2);
                this.flushOpen(node2, true);
                int start = 0;
                SimpleNode argExpr = this.sn(node2.jjtGetChild(0));
                if (argExpr.getId() != 85) {
                    this.pushElem("xqx:argExpr", node2);
                    this.flushOpen(node2, true);
                    this.transform(argExpr);
                    this.flushClose(node2);
                    ++start;
                } else {
                    int childID = this.getChildID(argExpr, 0);
                    if (childID != 86 && childID != 88 && childID != 87 && childID != 87 && childID != 89) {
                        ++start;
                        this.pushElem("xqx:argExpr", node2);
                        this.flushOpen(node2, true);
                        int n2 = argExpr.jjtGetNumChildren();
                        SimpleNode predicateList = null;
                        for (int i = 0; i < n2; ++i) {
                            SimpleNode child4 = (SimpleNode)argExpr.jjtGetChild(i);
                            if (child4.getId() == 95) {
                                predicateList = child4;
                                continue;
                            }
                            this.transform(child4);
                        }
                        this.flushClose(node2);
                        if (null != predicateList) {
                            this.transform(predicateList);
                        }
                    }
                }
                for (int i = start; i < node2.jjtGetNumChildren(); ++i) {
                    SimpleNode child5 = this.sn(node2.jjtGetChild(i));
                    if (child5.getId() == 85 || child5.getId() == 84 || child5.getId() == 83) {
                        this.transform(child5);
                        continue;
                    }
                    this.pushElem("xqx:stepExpr", node2);
                    this.flushOpen(node2, true);
                    this.pushElem("xqx:filterExpr", node2);
                    this.flushOpen(node2, true);
                    if (child5.getId() == 101) {
                        this.pushElem("xqx:parenthesizedExpr", node2);
                        this.flushOpen(node2, true);
                    }
                    this.transform(child5);
                    if (child5.getId() == 101) {
                        this.flushClose(node2);
                    }
                    this.flushClose(node2);
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 95: {
                this.pushElem("xqx:predicates", node2);
                break;
            }
            case 105: {
                this.pushElem("xqx:functionCallExpr", node2);
                this.flushOpen(node2, true);
                SimpleNode funcNameExpr = (SimpleNode)node2.jjtGetChild(0);
                this.transform(funcNameExpr);
                this.pushElem("xqx:arguments", node2);
                this.flushOpen(node2, true);
                int start = 1;
                this.transformChildren(node2, start);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 85: {
                this.pushElem(id2, node2);
                this.flushOpen(node2, true);
                int start = 0;
                int childID = this.getChildID(node2, start);
                if (childID == 102 || childID == 101) {
                    if (childID == 101) {
                        this.pushElem("xqx:filterExpr", node2);
                        this.flushOpen(node2, true);
                        this.pushElem("xqx:parenthesizedExpr", node2);
                        this.flushOpen(node2, true);
                    } else if (childID == 102) {
                        this.pushElem("xqx:filterExpr", node2);
                        this.flushOpen(node2, true);
                    }
                    SimpleNode predicateList = null;
                    for (int i = start; i < node2.jjtGetNumChildren(); ++i) {
                        SimpleNode child6 = (SimpleNode)node2.jjtGetChild(i);
                        if (child6.getId() == 95) {
                            predicateList = child6;
                            continue;
                        }
                        this.transform(child6);
                    }
                    this.flushClose(node2, true);
                    if (childID == 101) {
                        this.flushClose(node2, true);
                    }
                    if (null != predicateList) {
                        this.transform(predicateList);
                    }
                    this.flushClose(node2);
                    return this.check(node2);
                }
                if (childID == 86 || childID == 88) {
                    this.pushElem("xqx:xpathAxis", node2);
                    this.flushOpen(node2, false);
                    String axisStr = this.sn(node2.jjtGetChild(0)).getValue();
                    this.xqprint(axisStr);
                    ++start;
                    this.flushClose(node2, false);
                } else if (childID == 89) {
                    this.pushElem("xqx:xpathAxis", node2);
                    this.flushOpen(node2, false);
                    this.xqprint("parent");
                    this.flushClose(node2, false);
                    this.pushElem("xqx:anyKindTest", node2);
                    this.flushEmpty(node2);
                    ++start;
                } else if (childID == 87) {
                    String optionalAttribIndicator = this.sn(node2.jjtGetChild(0)).getValue();
                    if (optionalAttribIndicator != null && optionalAttribIndicator.equals("@")) {
                        this.pushElem("xqx:xpathAxis", node2);
                        this.flushOpen(node2, false);
                        this.xqprint("attribute");
                        this.flushClose(node2, false);
                    } else {
                        SimpleNode prev = this.getPreviousSibling(node2);
                        if (prev != null) {
                            if (prev.getId() != 84) {
                                // empty if block
                            }
                            this.pushElem("xqx:xpathAxis", node2);
                            this.flushOpen(node2, false);
                            this.xqprint("child");
                            this.flushClose(node2, false);
                        }
                    }
                    this.transformChildren(this.sn(node2.jjtGetChild(0)), start);
                    ++start;
                } else {
                    SimpleNode prev = this.getPreviousSibling(node2);
                    if (prev != null) {
                        if (prev.getId() != 84) {
                            // empty if block
                        }
                        this.pushElem("xqx:xpathAxis", node2);
                        this.flushOpen(node2, false);
                        this.xqprint("child");
                        this.flushClose(node2, false);
                    }
                }
                this.transformChildren(node2, start);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 53: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                this.pushElem("xqx:quantifier", node2);
                this.flushOpen(node2, false);
                this.xqprint(node2.getValue());
                this.flushClose(node2, false);
                int n3 = node2.jjtGetNumChildren();
                for (int i = 0; i < n3 - 1; i += 2) {
                    SimpleNode typedVariableBinding = this.sn(node2.jjtGetChild(i));
                    this.pushElem("xqx:quantifiedExprInClause", node2);
                    this.flushOpen(node2);
                    this.transform(typedVariableBinding);
                    this.pushElem("xqx:sourceExpr", node2);
                    this.flushOpen(node2);
                    SimpleNode sourceExpr = this.sn(node2.jjtGetChild(i + 1));
                    this.transform(sourceExpr);
                    this.flushClose(node2);
                    this.flushClose(node2);
                }
                this.pushElem("xqx:predicateExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, n3 - 1, n3 - 1);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 56: {
                this.pushElem("xqx:ifThenElseExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:ifClause", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 0, 0);
                this.flushClose(node2);
                this.pushElem("xqx:thenClause", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 1, 1);
                this.flushClose(node2);
                this.pushElem("xqx:elseClause", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 2, 2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 42: {
                this.pushElem("xqx:flworExpr", node2);
                this.flushOpen(node2);
                int n4 = node2.jjtGetNumChildren();
                this.transformChildren(node2, 0, n4 - 2);
                this.pushElem("xqx:returnClause", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, n4 - 1, n4 - 1);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 60: {
                this.pushElem("xqx:rangeSequenceExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:startExpr", node2);
                this.flushOpen(node2);
                this.transform(this.sn(node2.jjtGetChild(0)));
                this.flushClose(node2);
                this.pushElem("xqx:endExpr", node2);
                this.flushOpen(node2);
                this.transform(this.sn(node2.jjtGetChild(1)));
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 69: {
                int nUnarys = 0;
                for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                    SimpleNode child7 = this.sn(node2.jjtGetChild(i));
                    if (child7.getId() == 71) {
                        this.pushElem("xqx:unaryPlusOp", node2);
                        this.flushOpen(node2);
                        this.pushElem("xqx:operand", node2);
                        this.flushOpen(node2);
                        ++nUnarys;
                        continue;
                    }
                    if (child7.getId() == 70) {
                        this.pushElem("xqx:unaryMinusOp", node2);
                        this.flushOpen(node2);
                        this.pushElem("xqx:operand", node2);
                        this.flushOpen(node2);
                        ++nUnarys;
                        continue;
                    }
                    this.transform(child7);
                    for (int j = 0; j < nUnarys; ++j) {
                        this.flushClose(node2);
                        this.flushClose(node2);
                    }
                    break;
                }
                return this.check(node2);
            }
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                switch (id2) {
                    case 61: {
                        String op2 = node2.getValue();
                        String elemName = op2.equals("+") ? "xqx:addOp" : (op2.equals("-") ? "xqx:subtractOp" : "JJTADDITIVEEXPR UNKNOWN EXPR!");
                        this.pushElem(elemName, node2);
                        break;
                    }
                    case 62: {
                        String op3 = node2.getValue();
                        String elemName = op3.equals("*") ? "xqx:multiplyOp" : (op3.equals("div") ? "xqx:divOp" : (op3.equals("idiv") ? "xqx:idivOp" : (op3.equals("mod") ? "xqx:modOp" : "JJTMULTIPLICATIVEEXPR UNKNOWN EXPR: " + op3)));
                        this.pushElem(elemName, node2);
                        break;
                    }
                    case 63: {
                        this.pushElem("xqx:unionOp", node2);
                        break;
                    }
                    case 64: {
                        String op4 = node2.getValue();
                        String elemName = op4.equals("intersect") ? "xqx:intersectOp" : (op4.equals("except") ? "xqx:exceptOp" : "JJTINTERSECTEXCEPTEXPR UNKNOWN EXPR: " + op4);
                        this.pushElem(elemName, node2);
                        break;
                    }
                    case 58: {
                        this.pushElem("xqx:andOp", node2);
                        break;
                    }
                    case 57: {
                        this.pushElem("xqx:orOp", node2);
                        break;
                    }
                    case 59: {
                        String op5 = node2.getValue();
                        String elemName = op5.equals("eq") ? "xqx:eqOp" : (op5.equals("ne") ? "xqx:neOp" : (op5.equals("lt") ? "xqx:ltOp" : (op5.equals("le") ? "xqx:leOp" : (op5.equals("gt") ? "xqx:gtOp" : (op5.equals("ge") ? "xqx:geOp" : (op5.equals("=") ? "xqx:equalOp" : (op5.equals("!=") ? "xqx:notEqualOp" : (op5.equals("<") ? "xqx:lessThanOp" : (op5.equals("<=") ? "xqx:lessThanOrEqualOp" : (op5.equals(">") ? "xqx:greaterThanOp" : (op5.equals(">=") ? "xqx:greaterThanOrEqualOp" : (op5.equals("is") ? "xqx:isOp" : (op5.equals("<<") ? "xqx:nodeBeforeOp" : (op5.equals(">>") ? "xqx:nodeAfterOp" : "JJTCOMPARISONEXPR UNKNOWN: " + op5))))))))))))));
                        this.pushElem(elemName, node2);
                        break;
                    }
                    default: {
                        this.pushElem("???", node2);
                    }
                }
                this.flushOpen(node2);
                this.pushElem("xqx:firstOperand", node2);
                this.flushOpen(node2);
                this.transform(this.sn(node2.jjtGetChild(0)));
                this.flushClose(node2);
                this.pushElem("xqx:secondOperand", node2);
                this.flushOpen(node2);
                this.transform(this.sn(node2.jjtGetChild(1)));
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 83: {
                this.pushElem("xqx:rootExpr", node2);
                break;
            }
            case 84: {
                if (this.sn(node2.jjtGetParent()).jjtGetChild(0) == node2) {
                    this.pushElem("xqx:pathExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:argExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:rootExpr", node2);
                    this.flushEmpty(node2);
                    this.flushClose(node2);
                    this.pushElem("xqx:stepExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:xpathAxis", node2);
                    this.flushOpen(node2, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(node2, false);
                    this.pushElem("xqx:anyKindTest", node2);
                    this.flushEmpty(node2);
                    this.flushClose(node2);
                    this.flushClose(node2);
                } else {
                    this.pushElem("xqx:stepExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:xpathAxis", node2);
                    this.flushOpen(node2, false);
                    this.xqprint("descendant-or-self");
                    this.flushClose(node2, false);
                    this.pushElem("xqx:anyKindTest", node2);
                    this.flushEmpty(node2);
                    this.flushClose(node2);
                }
                return this.check(node2);
            }
            case 43: 
            case 45: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                int n5 = node2.jjtGetNumChildren();
                for (int i = 0; i <= n5; ++i) {
                    SimpleNode child8 = (SimpleNode)node2.jjtGetChild(i);
                    if (child8.getId() != 100) continue;
                    this.pushElem(id2 == 43 ? "xqx:forClauseItem" : "xqx:letClauseItem", node2);
                    this.flushOpen(node2, true);
                    this.transform(child8);
                    SimpleNode nextChild = (SimpleNode)node2.jjtGetChild(i + 1);
                    if (nextChild.getId() == 164) {
                        nextChild = (SimpleNode)node2.jjtGetChild(++i + 1);
                    }
                    if (nextChild.getId() == 44) {
                        this.transformChildren(node2, ++i, i);
                    }
                    this.pushElem(id2 == 43 ? "xqx:forExpr" : "xqx:letExpr", node2);
                    this.flushOpen(node2, true);
                    ++i;
                    while (i < n5) {
                        child8 = (SimpleNode)node2.jjtGetChild(i);
                        if (child8.getId() == 100) {
                            --i;
                            break;
                        }
                        this.transform(child8);
                        ++i;
                    }
                    this.flushClose(node2);
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 48: {
                int n6 = node2.jjtGetNumChildren();
                for (int i = 0; i < n6; ++i) {
                    SimpleNode child9 = this.sn(node2.jjtGetChild(i));
                    this.pushElem("xqx:orderBySpec", node2);
                    this.flushOpen(node2);
                    this.transform(child9);
                    if (child9.getId() == 49) {
                        int n2 = child9.jjtGetNumChildren();
                        for (int j = 0; j < n2; ++j) {
                            SimpleNode child2 = this.sn(child9.jjtGetChild(j));
                            if (child2.getId() != 50 || child2.jjtGetNumChildren() <= 0) continue;
                            this.transform(child2);
                        }
                    }
                    this.flushClose(node2);
                }
                return this.check(node2);
            }
            case 49: {
                this.pushElem("xqx:orderByExpr", node2);
                this.flushOpen(node2);
                int n7 = node2.jjtGetNumChildren();
                for (int i = 0; i < n7; ++i) {
                    SimpleNode child10 = this.sn(node2.jjtGetChild(i));
                    if (child10.getId() == 50) continue;
                    this.transform(child10);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 50: {
                if (node2.jjtGetNumChildren() == 0) {
                    return this.check(node2);
                }
                this.pushElem(id2, node2);
                break;
            }
            case 173: {
                this.pushElem("xqx:piTest", node2);
                if (node2.jjtGetNumChildren() > 0) {
                    this.flushOpen(node2);
                    SimpleNode child11 = this.sn(node2.jjtGetChild(0));
                    this.markCheck();
                    this.pushElem("xqx:piTarget", child11);
                    this.flushOpen(child11, false);
                    String ncName = child11.getValue();
                    if (child11.getId() == 5) {
                        ncName = ncName.substring(1, ncName.length() - 1);
                    }
                    this.xqprint(ncName);
                    this.flushClose(child11, false);
                    this.check(child11);
                    this.flushClose(node2);
                } else {
                    this.flushEmpty(node2);
                }
                return this.check(node2);
            }
            case 26: {
                SimpleNode targetNamespace;
                this.pushElem("xqx:schemaImport", node2);
                this.flushOpen(node2);
                SimpleNode child12 = this.sn(node2.jjtGetChild(0));
                int start = 0;
                if (child12.getId() == 27 && child12.jjtGetNumChildren() > 0) {
                    this.pushElem("xqx:namespacePrefix", node2);
                    this.flushOpen(node2, false);
                    this.xqprint(this.sn(child12.jjtGetChild(0)).getValue());
                    ++start;
                    this.flushClose(node2, false);
                    targetNamespace = this.sn(node2.jjtGetChild(1));
                    ++start;
                } else if (child12.getId() == 27) {
                    this.pushElem("xqx:defaultElementNamespace", node2);
                    this.flushEmpty(node2);
                    ++start;
                    targetNamespace = this.sn(node2.jjtGetChild(1));
                    ++start;
                } else {
                    targetNamespace = child12;
                    ++start;
                }
                this.pushElem("xqx:targetNamespace", targetNamespace);
                this.flushOpen(targetNamespace, false);
                String val = this.sn(targetNamespace.jjtGetChild(0)).getValue();
                val = val.substring(1, val.length() - 1);
                this.xqprint(val);
                this.flushClose(targetNamespace, false);
                for (int i = start; i < node2.jjtGetNumChildren(); ++i) {
                    SimpleNode tl = this.sn(node2.jjtGetChild(i));
                    this.pushElem("xqx:targetLocation", tl);
                    this.flushOpen(tl, false);
                    val = this.sn(targetNamespace.jjtGetChild(0)).getValue();
                    val = val.substring(1, val.length() - 1);
                    this.xqprint(val);
                    this.flushClose(tl, false);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 51: 
            case 52: {
                this.pushElem("xqx:orderingKind", node2);
                this.flushOpen(node2, false);
                if (id2 == 51) {
                    this.xqprint("ascending");
                } else {
                    this.xqprint("descending");
                }
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 19: 
            case 20: {
                if (this.getParentID(node2) == 18) {
                    this.pushElem("xqx:emptyOrderingDecl", node2);
                } else {
                    this.pushElem("xqx:emptyOrderingMode", node2);
                }
                this.flushOpen(node2, false);
                if (id2 == 51) {
                    this.xqprint("empty greatest");
                } else {
                    this.xqprint("empty least");
                }
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 101: {
                if (node2.jjtGetNumChildren() != 0) break;
                this.pushElem("xqx:sequenceExpr", node2);
                break;
            }
            case 15: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                this.pushElem("xqx:defaultNamespaceCategory", node2);
                this.flushOpen(node2, false);
                this.xqprint(node2.getValue());
                this.flushClose(node2, false);
                this.transformChildren(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 14: {
                this._boundarySpacePolicy = node2.getValue().equals("preserve") ? 1 : 0;
                return this.check(node2);
            }
            case 17: 
            case 22: 
            case 23: 
            case 31: 
            case 166: {
                this.pushElem(id2, node2);
                this.flushOpen(node2, false);
                this.xqprint(node2.getValue());
                this.flushClose(node2, false);
                return this.check(node2);
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                if (id2 == 65) {
                    this.pushElem("xqx:instanceOfExpr", node2);
                } else {
                    this.pushElem(id2, node2);
                }
                this.flushOpen(node2);
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 0, 0);
                this.flushClose(node2);
                if (id2 != 68 && id2 != 67) {
                    this.pushElem("xqx:sequenceType", node2);
                    this.flushOpen(node2);
                    this.transformChildren(node2, 1, 1);
                    this.flushClose(node2);
                } else {
                    this.transformChildren(node2, 1, 1);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 103: 
            case 104: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 54: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 0, 0);
                this.flushClose(node2);
                int n8 = node2.jjtGetNumChildren();
                int startOfDefault = n8 - 2;
                this.transformChildren(node2, 1, startOfDefault - 1);
                if (this.getChildID(node2, startOfDefault) != 100) {
                    this.transformChildren(node2, startOfDefault, startOfDefault);
                    ++startOfDefault;
                }
                this.pushElem("xqx:typeswitchExprDefaultClause", node2);
                this.flushOpen(node2);
                if (startOfDefault == n8 - 2) {
                    this.transformChildren(node2, startOfDefault, startOfDefault);
                    ++startOfDefault;
                }
                this.pushElem("xqx:resultExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, startOfDefault, startOfDefault);
                this.flushClose(node2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 55: {
                this.pushElem("xqx:typeswitchExprCaseClause", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 0, 1);
                this.pushElem("xqx:resultExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2, 2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 32: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                int start = 0;
                this.transformChildren(node2, start, start);
                if (this.getChildID(node2, ++start) == 33) {
                    this.transformChildren(node2, start, start);
                    ++start;
                } else {
                    this.pushElem("xqx:paramList", node2);
                    this.flushEmpty(node2);
                }
                int end = node2.jjtGetNumChildren() - 1;
                this.transformChildren(node2, start, end - 1);
                start = end;
                if (this.getChildID(node2, end) == 30) {
                    this.transformChildren(node2, start, end);
                } else {
                    this.pushElem("xqx:functionBody", node2);
                    this.flushOpen(node2);
                    this.transformChildren(node2, start, end);
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 29: {
                this.pushElem(id2, node2);
                this.flushOpen(node2);
                int start = 0;
                int end = node2.jjtGetNumChildren() - 1;
                this.transformChildren(node2, start, end - 1);
                start = end;
                if (this.getChildID(node2, end) == 30) {
                    this.transformChildren(node2, start, end);
                } else {
                    this.pushElem("xqx:varValue", node2);
                    this.flushOpen(node2);
                    this.transformChildren(node2, start, end);
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 39: 
            case 41: 
            case 46: 
            case 47: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 102: 
            case 164: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 178: 
            case 180: {
                this.pushElem(id2, node2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 24: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 70: 
            case 71: 
            case 77: 
            case 90: 
            case 96: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 129: 
            case 145: 
            case 184: {
                break;
            }
            case 130: {
                this.xqprint(node2.getValue());
                break;
            }
            case 131: {
                String ref = node2.getValue();
                this.xqprint(ref);
                break;
            }
            case 132: {
                this.xqprint("{{");
                break;
            }
            case 133: {
                this.xqprint("}}");
                break;
            }
            case 134: {
                this.pushElem("xqx:computedCommentConstructor", node2);
                break;
            }
            case 138: {
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:stringConstantExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:value", node2);
                this.flushOpen(node2, false);
                this.transformChildren(node2);
                this.flushClose(node2, false);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 139: 
            case 140: 
            case 148: 
            case 154: {
                this.xqprintEscaped(node2.getValue());
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 142: 
            case 143: 
            case 146: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                break;
            }
            case 149: {
                this.pushElem("xqx:computedTextConstructor", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:stringConstantExpr", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:value", node2);
                this.flushOpen(node2, false);
                this.xqprint("<![CDATA[");
                this.transformChildren(node2);
                this.xqprint("]]>");
                this.flushClose(node2, false);
                this.flushClose(node2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 147: {
                break;
            }
            case 141: {
                this.pushElem("xqx:computedPIConstructor", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:piTarget", node2);
                this.flushOpen(node2, false);
                this.xqprint(this.sn(node2.jjtGetChild(1)).getValue());
                this.flushClose(node2, false);
                if (this.hasChildID(node2, 147)) {
                    this.pushElem("xqx:piValueExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:stringConstantExpr", node2);
                    this.flushOpen(node2);
                    this.pushElem("xqx:value", node2);
                    this.flushOpen(node2, false);
                    this.transformChildren(node2, 2);
                    this.flushClose(node2, false);
                    this.flushClose(node2);
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 156: 
            case 160: 
            case 161: {
                switch (id2) {
                    case 156: {
                        String elemName = "xqx:computedDocumentConstructor";
                        break;
                    }
                    case 160: {
                        String elemName = "xqx:computedTextConstructor";
                        break;
                    }
                    case 161: {
                        String elemName = "xqx:computedCommentConstructor";
                        break;
                    }
                    default: {
                        String elemName = "UNKNOWN-" + jjtNodeName[id2];
                    }
                }
                this.pushElem("xqx:computedTextConstructor", node2);
                this.flushOpen(node2);
                this.pushElem("xqx:argExpr", node2);
                this.flushOpen(node2);
                this.transformChildren(node2);
                this.flushClose(node2);
                this.flushClose(node2);
                return this.check(node2);
            }
            case 155: {
                break;
            }
            case 157: 
            case 159: 
            case 162: {
                this.pushElem(id2 == 159 ? "xqx:computedAttributeConstructor" : (id2 == 162 ? "xqx:computedPIConstructor" : "xqx:computedElementConstructor"), node2);
                this.flushOpen(node2);
                int start = 0;
                if (this.getChildID(node2, 0) == 37) {
                    if (id2 == 162) {
                        this.pushElem("xqx:piTargetExpr", node2);
                    } else {
                        this.pushElem("xqx:tagNameExpr", node2);
                    }
                    this.flushOpen(node2);
                    this.transformChildren(node2, 1, 1);
                    this.flushClose(node2);
                    start += 3;
                } else {
                    this.transformChildren(node2, 0, 0);
                    ++start;
                }
                if (id2 == 159 || id2 == 162) {
                    this.pushElem(id2 == 159 ? "xqx:valueExpr" : "xqx:piValueExpr", node2);
                    this.flushOpen(node2);
                    if (this.getNumExprChildren(node2, start) == 0) {
                        this.pushElem("xqx:sequenceExpr", node2);
                        this.flushEmpty(node2);
                    } else {
                        this.transformChildren(node2, start);
                    }
                    this.flushClose(node2);
                } else {
                    this.transformChildren(node2, start);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 158: {
                this.pushElem(id2, node2);
                break;
            }
            case 114: {
                if (this.getNumRealChildren(node2) > 0) {
                    this.pushElem("xqx:attributeList", node2);
                    this.flushOpen(node2);
                    int n9 = node2.jjtGetNumChildren();
                    for (int i = 0; i < n9; ++i) {
                        SimpleNode child13 = this.sn(node2.jjtGetChild(i));
                        if (child13.getId() == 111) {
                            if (child13.getValue().startsWith("xmlns:")) {
                                this.pushElem("xqx:namespaceDeclaration", node2);
                            } else {
                                this.pushElem("xqx:attributeConstructor", node2);
                            }
                            this.flushOpen(node2);
                        }
                        this.transform(child13);
                        if (child13.getId() != 116) continue;
                        this.flushClose(node2);
                    }
                    this.flushClose(node2);
                }
                return this.check(node2);
            }
            case 127: {
                if (this.getChildID(node2, 0) != 128) break;
                String charStr = this.sn(node2.jjtGetChild(0)).getValue();
                this.xqprintEscaped(charStr);
                return this.check(node2);
            }
            case 108: {
                this.pushElem("xqx:elementConstructor", node2);
                this.flushOpen(node2);
                int n10 = node2.jjtGetNumChildren();
                boolean didFindDirElemContent = false;
                SimpleNode openChild = null;
                int nPush = 0;
                for (int i = 0; i < n10; ++i) {
                    SimpleNode child14 = this.sn(node2.jjtGetChild(i));
                    if (child14.getId() == 127) {
                        if (!didFindDirElemContent) {
                            this.pushElem("xqx:elementContent", node2);
                            this.flushOpen(node2);
                            didFindDirElemContent = true;
                        }
                        if (this.isEncloseExpr(child14)) {
                            if (nPush == 2) {
                                this.flushClose(node2, !this.isElemContentChar(openChild));
                                this.flushClose(node2);
                            }
                            openChild = this.sn(this.sn(child14.jjtGetChild(0)).jjtGetChild(0));
                            child14 = this.sn(this.sn(child14.jjtGetChild(0)).jjtGetChild(0));
                            nPush = 0;
                        } else if (this.isElemContentChar(child14)) {
                            if (child14.getId() == 127 && this.shouldStripChar(this.sn(child14.jjtGetChild(0)))) continue;
                            if (!this.isElemContentChar(openChild)) {
                                this.pushElem("xqx:stringConstantExpr", node2);
                                this.flushOpen(node2);
                                this.pushElem("xqx:value", node2);
                                this.flushOpen(node2, false);
                                nPush = 2;
                            }
                            openChild = child14;
                        } else {
                            if (nPush == 2) {
                                this.flushClose(node2, !this.isElemContentChar(openChild));
                                this.flushClose(node2);
                            }
                            openChild = child14;
                            nPush = 0;
                        }
                    }
                    this.transform(child14);
                }
                if (nPush == 2) {
                    this.flushClose(node2, false);
                    this.flushClose(node2);
                }
                if (didFindDirElemContent) {
                    this.flushClose(node2);
                }
                this.flushClose(node2);
                return this.check(node2);
            }
            case 116: {
                SimpleNode child15;
                int i;
                if (this.isJustWhitespace(node2)) {
                    return this.check(node2);
                }
                int n11 = node2.jjtGetNumChildren();
                int isOpenMode = -1;
                boolean isAttributeValueExpr = false;
                for (i = 0; i < n11; ++i) {
                    child15 = this.sn(node2.jjtGetChild(i));
                    if (!this.isEncloseExpr(child15)) continue;
                    isAttributeValueExpr = true;
                    break;
                }
                if (isAttributeValueExpr) {
                    this.pushElem("xqx:attributeValueExpr", node2);
                    this.flushOpen(node2);
                    int nPush = 0;
                    for (int i2 = 0; i2 < n11; ++i2) {
                        SimpleNode child16 = this.sn(node2.jjtGetChild(i2));
                        if (this.isEncloseExpr(child16)) {
                            if (nPush == 2) {
                                this.flushClose(node2, !this.isAttrContentChar(isOpenMode));
                                this.flushClose(node2);
                            }
                            isOpenMode = this.sn(this.sn(child16.jjtGetChild(0)).jjtGetChild(0)).getId();
                            child16 = this.sn(this.sn(child16.jjtGetChild(0)).jjtGetChild(0));
                            nPush = 0;
                        } else if (this.isAttrContentChar(child16.getId())) {
                            if (!this.isAttrContentChar(isOpenMode)) {
                                this.pushElem("xqx:stringConstantExpr", node2);
                                this.flushOpen(node2);
                                this.pushElem("xqx:value", node2);
                                this.flushOpen(node2, false);
                                nPush = 2;
                            }
                            isOpenMode = child16.getId();
                        } else {
                            if (child16.getId() == 117 || child16.getId() == 119 || child16.getId() == 120 || child16.getId() == 122) continue;
                            if (nPush == 2) {
                                this.flushClose(node2, !this.isAttrContentChar(isOpenMode));
                                this.flushClose(node2);
                            }
                            isOpenMode = child16.getId();
                            nPush = 0;
                        }
                        this.transform(child16);
                    }
                    if (nPush == 2) {
                        this.flushClose(node2, false);
                        this.flushClose(node2);
                    }
                    this.flushClose(node2);
                } else {
                    if (this.getPreviousSibling(this.getPreviousSibling(node2)).getValue().startsWith("xmlns:")) {
                        this.pushElem("xqx:uri", node2);
                    } else {
                        this.pushElem("xqx:attributeValue", node2);
                    }
                    this.flushOpen(node2, false);
                    for (i = 0; i < n11; ++i) {
                        child15 = this.sn(node2.jjtGetChild(i));
                        if (child15.getId() == 117 || child15.getId() == 119 || child15.getId() == 120 || child15.getId() == 122) continue;
                        this.transform(child15);
                    }
                    this.flushClose(node2, false);
                }
                return this.check(node2);
            }
            case 118: {
                this.xqprint("\"\"");
                return this.check(node2);
            }
            case 121: {
                this.xqprint("''");
                return this.check(node2);
            }
            case 124: 
            case 126: 
            case 128: {
                if (node2.getValue() != null) {
                    this.xqprintEscaped(node2.getValue());
                }
                return this.check(node2);
            }
        }
        int n12 = node2.jjtGetNumChildren();
        if (n12 == 0) {
            this.flushEmpty(node2);
        } else {
            this.flushOpen(node2);
            this.transformChildren(node2);
            this.flushClose(node2);
        }
        return this.check(node2);
    }

    private SimpleNode getNextSibling(SimpleNode node2) {
        int nSiblingsOrSelf = node2.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < nSiblingsOrSelf; ++i) {
            SimpleNode siblingOrSelf = this.sn(node2.jjtGetParent().jjtGetChild(i));
            if (siblingOrSelf != node2) continue;
            if (i + 1 >= nSiblingsOrSelf) break;
            return this.sn(node2.jjtGetParent().jjtGetChild(i + 1));
        }
        return null;
    }

    private SimpleNode getPreviousSibling(SimpleNode node2) {
        int nSiblingsOrSelf = node2.jjtGetParent().jjtGetNumChildren();
        for (int i = 0; i < nSiblingsOrSelf; ++i) {
            SimpleNode siblingOrSelf = this.sn(node2.jjtGetParent().jjtGetChild(i));
            if (siblingOrSelf != node2) continue;
            if (i <= 0) break;
            return this.sn(node2.jjtGetParent().jjtGetChild(i - 1));
        }
        return null;
    }

    private boolean hasChildID(SimpleNode node2, int id2) {
        int n2 = node2.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode child2 = this.sn(node2.jjtGetChild(i));
            if (child2.getId() != id2) continue;
            return true;
        }
        return false;
    }

    private int getNumExprChildren(SimpleNode node2) {
        return this.getNumExprChildren(node2, 0);
    }

    private int getNumExprChildren(SimpleNode node2, int start) {
        int count2 = 0;
        int n2 = node2.jjtGetNumChildren();
        for (int i = start; i < n2; ++i) {
            SimpleNode child2 = this.sn(node2.jjtGetChild(i));
            if (child2.getId() == 77 || child2.getId() == 37 || child2.getId() == 38) continue;
            ++count2;
        }
        return count2;
    }

    private int getNumRealChildren(SimpleNode node2) {
        int count2 = 0;
        int n2 = node2.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            SimpleNode child2 = this.sn(node2.jjtGetChild(i));
            if (child2.getId() == 77) continue;
            ++count2;
        }
        return count2;
    }

    private boolean isEncloseExpr(SimpleNode child2) {
        return (child2.getId() == 123 || child2.getId() == 125 || child2.getId() == 127) && this.sn(child2.jjtGetChild(0)).getId() == 129 && this.sn(this.sn(child2.jjtGetChild(0)).jjtGetChild(0)).getId() == 35;
    }

    private boolean isAttrContentChar(int id2) {
        switch (id2) {
            case 118: 
            case 121: 
            case 123: 
            case 125: {
                return true;
            }
            case 129: {
                return true;
            }
        }
        return false;
    }

    private boolean isElemContentChar(SimpleNode node2) {
        if (node2 == null) {
            return false;
        }
        if (node2.getId() == 127) {
            switch (this.getChildID(node2, 0)) {
                case 128: {
                    return true;
                }
                case 129: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String processPrefix(String qname2) {
        if (qname2 == null) {
            return qname2;
        }
        int i = qname2.indexOf(58);
        if (i > 0) {
            String prefix2 = qname2.substring(0, i);
            qname2 = qname2.substring(i + 1);
            this.pushAttr("xqx:prefix", prefix2);
        }
        return qname2;
    }

    private SimpleNode sn(Node node2) {
        return (SimpleNode)node2;
    }

    private void transformChildren(SimpleNode node2, int start, int end) {
        for (int i = start; i <= end; ++i) {
            SimpleNode child2 = (SimpleNode)node2.jjtGetChild(i);
            this.transform(child2);
        }
    }

    private void transformChildren(SimpleNode node2, int start) {
        this.transformChildren(node2, start, node2.jjtGetNumChildren() - 1);
    }

    private void transformChildren(SimpleNode node2) {
        this.transformChildren(node2, 0, node2.jjtGetNumChildren() - 1);
    }

    private int getParentID(SimpleNode node2) {
        return ((SimpleNode)node2.jjtGetParent()).getId();
    }

    private int getChildID(SimpleNode node2, int i) {
        return ((SimpleNode)node2.jjtGetChild(i)).getId();
    }

    private SimpleNode getFirstChildIgnoreS(SimpleNode node2) {
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            SimpleNode child2 = this.sn(node2.jjtGetChild(i));
            if (child2.getId() == 77) continue;
            return this.sn(child2);
        }
        return null;
    }
}

