/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Literal;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IChar;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.ICharDash;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors.IQNameWrapper;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.scontext.ASTBuildingTimeNSResolver;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.util.Hashtable;
import java.util.List;

public class IDirAttributeList
extends SimpleNode {
    private ASTBuildingTimeNSResolver _nscontext = null;

    @Override
    public void processToken(ASTBuildingContext context2, Token token) {
        if (token.kind == 154 || token.kind == 164) {
            this.applyNSresolve(context2);
        }
    }

    public void applyNSresolve(ASTBuildingContext context2) {
        if (this._nscontext == null) {
            XStaticContext scontext = context2.getStaticContext();
            ASTBuildingTimeNSResolver prev = (ASTBuildingTimeNSResolver)scontext.getRunninASTNamespaceContext();
            Hashtable<String, Boolean> xmlns_names = new Hashtable<String, Boolean>();
            this._nscontext = new ASTBuildingTimeNSResolver(prev);
            List attributeElements = this.getChildren();
            for (Object attrMaybe : attributeElements) {
                ASTMsg err;
                DirAttributeConstructor attr2 = (DirAttributeConstructor)attrMaybe;
                IQNameWrapper wrapper = attr2.getQnameWrapper();
                String attRawName = wrapper.getImage();
                boolean isNSNode = attRawName.startsWith("xmlns") && (attRawName.equals("xmlns") || attRawName.startsWith("xmlns:"));
                int nChildren = attr2.jjtGetNumChildren();
                if (isNSNode && nChildren > 1) {
                    ASTMsg err2 = new ASTMsg("ERR_NAMESPACE_DECL_URI_LITERAL");
                    context2.getReporter().report(3, err2);
                }
                StringBuffer buf = new StringBuffer();
                for (int k = 0; k < nChildren; ++k) {
                    Literal lit;
                    String val;
                    Expr expr = (Expr)attr2.jjtGetChild(k);
                    if (isNSNode) {
                        if (expr instanceof Text) {
                            val = expr.getSimpleStringValue();
                            buf.append(val);
                            lit = context2.getExpressionFactory().createStringLiteralExpr(val);
                            attr2.jjtReplaceChild(lit, k);
                            continue;
                        }
                        ASTMsg err3 = new ASTMsg("ERR_NAMESPACE_DECL_URI_LITERAL");
                        context2.getReporter().report(3, err3);
                        continue;
                    }
                    if (!expr.isSimpleStringValue()) continue;
                    val = expr.getSimpleStringValue();
                    buf.append(val);
                    lit = context2.getExpressionFactory().createStringLiteralExpr(val);
                    attr2.jjtReplaceChild(lit, k);
                }
                if (!isNSNode) continue;
                String prefix2 = this.getPrefixFromXMLNSDecl(attRawName);
                if (prefix2.equals("xmlns") || prefix2.equals("xml")) {
                    err = new ASTMsg("ERR_XQ_XML_PREFIX");
                    context2.getReporter().report(3, err);
                }
                if (xmlns_names.containsKey(attRawName)) {
                    err = new ASTMsg("ERR_XQ_DUPLICATE_NAMESPACE");
                    context2.getReporter().report(3, err);
                } else {
                    xmlns_names.put(attRawName, true);
                }
                String uri2 = buf.toString();
                if (uri2.equals("")) {
                    uri2 = null;
                }
                this._nscontext.addMapping(prefix2, uri2);
                if (prefix2.equals("xml")) continue;
                DirElemConstructor elem2 = context2.getExpressionFactory().peekOpenElem();
                if (uri2 == null) continue;
                elem2.addPrefixMapping(prefix2, uri2);
                if (elem2.isExcludedNamespace(uri2)) continue;
                elem2.registerNamespace(prefix2, uri2);
            }
            context2.getStaticContext().setRunninASTNamespaceContext(this._nscontext);
        }
    }

    private String getPrefixFromXMLNSDecl(String attRawName) {
        int index2 = attRawName.indexOf(58);
        return index2 >= 0 ? attRawName.substring(index2 + 1) : "";
    }

    public IDirAttributeList(int i) {
        super(i);
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        if (n2 instanceof IChar || n2 instanceof ICharDash) {
            DirAttributeConstructor attr2 = (DirAttributeConstructor)this.jjtGetLastChild();
            Text val = (Text)attr2.jjtGetChild(0);
            if (n2 instanceof IChar) {
                val.pushChar(((IChar)n2).getChar());
            } else {
                ICharDash icd = (ICharDash)n2;
                val.pushChar(icd.getChar1());
                val.pushChar(icd.getChar2());
            }
        } else {
            int childID = n2.getId();
            switch (childID) {
                case 77: 
                case 115: {
                    break;
                }
                case 116: {
                    super.jjtAppendChild(context2, n2);
                    break;
                }
                case 111: {
                    DirAttributeConstructor attr3 = (DirAttributeConstructor)this.jjtGetLastChild();
                    IQNameWrapper qnameWrapper = (IQNameWrapper)n2;
                    attr3.setQnameWrapper(qnameWrapper);
                    break;
                }
                default: {
                    this.assertChildAddNotHandled(childID);
                }
            }
        }
    }

    public ASTBuildingTimeNSResolver getNscontext() {
        return this._nscontext;
    }
}

