/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.tempconstructors;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import javax.xml.namespace.QName;

public class IQNameWrapper
extends SimpleNode {
    private String _image;
    private String _unresolvedImage = null;
    private String _savedImage = null;
    private int _savedDefaultKind;
    private QName _qname;
    private short _type;
    private String _ncname;
    private ASTBuildingContext _context;
    private int _defaultNameResolution = 1;
    public static final int ELEMENT_RESOLUTION = 1;
    public static final int FUNCTION_RESOLUTION = 2;
    public static final int NONAMESPACE_RESOLUTION = 3;

    public IQNameWrapper(int i) {
        super(i);
    }

    public IQNameWrapper(int i, int defaultNameResolution) {
        super(i);
        this._defaultNameResolution = defaultNameResolution;
    }

    @Override
    public void processValue(ASTBuildingContext context2, String val) {
        super.processValue(context2, val);
        if (val.equals("*")) {
            this._type = 0;
        } else {
            this._qname = IQNameWrapper.resolveQName(context2, val, this._defaultNameResolution);
            this._type = (short)3;
        }
    }

    @Override
    public void processToken(ASTBuildingContext context2, Token t) {
        super.processToken(context2, t);
        String image = t.image.trim();
        if (image.equals("{") || image.equals("}")) {
            return;
        }
        this._image = image;
        this._context = context2;
    }

    public boolean isUnresolvedQName() {
        return this._type != 4;
    }

    public void delayedResolve(ASTBuildingContext context2, SimpleNode node2) {
        this._image = this._unresolvedImage;
        this.processImage(context2, this._savedImage, this._savedDefaultKind, null);
        node2.finishAddingChild(context2, this);
    }

    private void processImage(ASTBuildingContext context2, String image, int defaultKind, SimpleNode node2) {
        if (this.id == 92) {
            this._type = 0;
            this._image = null;
            return;
        }
        if (this.id == 94) {
            this._ncname = image;
            this._ncname = this._ncname.substring(this._ncname.indexOf(":") + 1);
            this._type = (short)2;
            this._image = null;
            return;
        }
        if (!this._context.getResolveQNames()) {
            if (this._type == 4) {
                return;
            }
            this._qname = null;
            this._type = (short)4;
            this._unresolvedImage = this._image;
            this._savedDefaultKind = defaultKind;
            this._savedImage = image;
            this._image = null;
            this._context.saveUnresolvedQName(this, node2, context2);
            return;
        }
        switch (this.id) {
            case 191: 
            case 192: {
                this._qname = IQNameWrapper.resolveQName(context2, image, defaultKind);
                this._type = (short)3;
                break;
            }
            case 93: {
                XStaticContext staticCtx = context2.getStaticContext();
                this._ncname = image;
                this._ncname = this._ncname.substring(0, this._ncname.indexOf(":"));
                String ns = staticCtx.getNamespaceURI(this._ncname);
                if (ns == null || ns.length() == 0) {
                    if (context2.getStaticContext().getLanguage() == 3) {
                        ASTMsg err = new ASTMsg("ERR_XQ_WRONG_QNAME_URI", new Object[]{this._ncname});
                        context2.getReporter().report(3, err);
                    } else {
                        ASTMsg err = new ASTMsg("NAMESPACE_UNDEF_ERR", (Object)this._ncname, (SimpleNode)this);
                        context2.getReporter().report(3, err);
                    }
                }
                this._type = 1;
                break;
            }
            default: {
                String qname2 = image;
                int parenIndex = qname2.lastIndexOf("(");
                if (parenIndex > 0) {
                    qname2 = qname2.substring(0, parenIndex);
                }
                this._qname = IQNameWrapper.resolveQName(context2, qname2, defaultKind);
                this._type = (short)3;
            }
        }
        this._image = null;
    }

    public static QName resolveQName(ASTBuildingContext context2, String image, int defaultKind) {
        image = image.trim();
        QName qname2 = null;
        int colonIdx = image.indexOf(":");
        if (colonIdx == -1) {
            if (context2.getStaticContext().getLanguage() != 3) {
                qname2 = context2.getExpressionFactory().createQName(null, image, null);
            } else if (defaultKind == 1) {
                String ns = IQNameWrapper.getNamespaceForPrefix(context2, "");
                String defaultNamespaceURI = context2.getStaticContext().getDefaultNamespaceForElementType();
                qname2 = defaultNamespaceURI != null && !defaultNamespaceURI.equals("") && ns == null ? context2.getExpressionFactory().createQName(defaultNamespaceURI, image, "") : (ns == null ? context2.getExpressionFactory().createQName(null, image, null) : context2.getExpressionFactory().createQName(ns, image, ""));
            } else if (defaultKind == 2) {
                String defaultNamespaceURI = context2.getExpressionFactory().getStaticContext().getDefaultNamespaceForFunction();
                qname2 = defaultNamespaceURI != null && !defaultNamespaceURI.equals("") ? context2.getExpressionFactory().createQName(defaultNamespaceURI, image, "") : context2.getExpressionFactory().createQName(null, image, null);
            } else if (defaultKind == 3) {
                qname2 = context2.getExpressionFactory().createQName(null, image, null);
            }
        } else {
            String prefix2 = image.substring(0, colonIdx);
            String ns = IQNameWrapper.getNamespaceForPrefix(context2, prefix2);
            if (ns == null) {
                if (context2.getStaticContext().getLanguage() == 3) {
                    ASTMsg err = new ASTMsg("ERR_XQ_WRONG_QNAME_URI", new Object[]{prefix2});
                    context2.getReporter().report(3, err);
                } else {
                    Expr node2 = context2.getStaticContext().getCurrentNode();
                    ASTMsg err = new ASTMsg("NAMESPACE_UNDEF_ERR", (Object)prefix2, (SimpleNode)node2);
                    context2.getReporter().report(3, err);
                }
            }
            qname2 = context2.getExpressionFactory().createQName(ns, image.substring(colonIdx + 1), prefix2);
        }
        return qname2;
    }

    public static String getNamespaceForPrefix(ASTBuildingContext context2, String prefix2) {
        String ns = context2.getStaticContext().getRunninASTNamespaceContext().getNamespaceURI(prefix2);
        if (ns == null || ns.length() == 0) {
            return null;
        }
        return ns;
    }

    @Override
    public void jjtAddChild(ASTBuildingContext context2, Node n2, int i) {
        if (n2 instanceof IQNameWrapper) {
            this._ncname = ((IQNameWrapper)n2)._ncname;
            this._qname = ((IQNameWrapper)n2)._qname;
            this._type = ((IQNameWrapper)n2)._type;
            this._image = ((IQNameWrapper)n2)._image;
            this._context = ((IQNameWrapper)n2)._context;
            this.setId(n2.getId());
        }
    }

    public QName getQName(SimpleNode node2) {
        if (this._image != null) {
            this.processImage(this._context, this._image, 1, node2);
        }
        return this._qname;
    }

    public QName getFunctionQName(SimpleNode node2) {
        if (this._image != null) {
            this.processImage(this._context, this._image, 2, node2);
        }
        return this._qname;
    }

    public QName getNoNamespaceQName(SimpleNode node2) {
        if (this._image != null) {
            this.processImage(this._context, this._image, 3, node2);
        }
        return this._qname;
    }

    public String getWildcardNcname(SimpleNode node2) {
        if (this._image != null) {
            this.processImage(this._context, this._image, 1, node2);
        }
        return this._ncname;
    }

    public short getWildcardType(SimpleNode node2) {
        if (this._image != null) {
            this.processImage(this._context, this._image, 1, node2);
        }
        return this._type;
    }

    public String getImage() {
        return this._image;
    }
}

