/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceCache;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.CharBufferReader;
import com.ibm.xltxe.rnm1.xtq.common.utils.InputSource2CharBuffer;
import com.ibm.xltxe.rnm1.xtq.common.utils.IntVector;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import java.nio.CharBuffer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TraceXSLTParser
extends XSLTParser {
    private static final char[] systemEOL = System.getProperty("line.separator").toCharArray();
    private static final char[] windowsEOL = new char[]{'\r', '\n'};
    private static final char[] unixEOL = new char[]{'\n'};
    private static final int SHIFT = 1;
    private static final int UNDEFINED = -1;
    private SourceCache m_sourceCache;
    private Locator m_locator;
    private Vector<Node> m_nodes;
    private CharBuffer m_documentChars;
    private IntVector m_lineOffsetTable;

    public TraceXSLTParser() {
    }

    public TraceXSLTParser(boolean isXSLT20, XStaticContext context2, SourceCache sourceCache) {
        super(isXSLT20, context2);
        this.m_sourceCache = sourceCache;
    }

    public TraceXSLTParser(boolean isXSLT20, ExpressionFactoryImpl exprFactoryImpl) {
        super(isXSLT20, exprFactoryImpl);
    }

    @Override
    public Expr parse(XMLReader xmlReader, InputSource input, Expr astExpr) {
        InputSource2CharBuffer is2cb = null;
        try {
            this.setup();
            is2cb = new InputSource2CharBuffer(input);
        }
        catch (Exception e) {
            ASTMsg error2 = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)input.getSystemId(), (SimpleNode)astExpr);
            this.reportError(2, error2, (Throwable)e);
        }
        this.m_documentChars = is2cb.getCharBuffer();
        String systemId = input.getSystemId();
        if (this.m_sourceCache != null && (input.getByteStream() != null || input.getCharacterStream() != null)) {
            this.m_sourceCache.addDocument(input.getSystemId(), this.m_documentChars.toString(), is2cb.getEncoding());
        }
        CharBufferReader cbr = new CharBufferReader(this.m_documentChars);
        this.updateLineOffsets();
        InputSource newInput = new InputSource(cbr);
        newInput.setSystemId(input.getSystemId());
        newInput.setPublicId(input.getPublicId());
        Expr expr = super.parse(xmlReader, newInput, astExpr);
        this.m_documentChars = null;
        return expr;
    }

    private void setup() {
        this.m_nodes = new Vector();
        this.m_lineOffsetTable = new IntVector();
        this.m_lineOffsetTable.addElement(0);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() {
        super.startDocument();
    }

    @Override
    public void endDocument() {
        super.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix2, String uri2) {
        super.startPrefixMapping(prefix2, uri2);
    }

    @Override
    public void endPrefixMapping(String prefix2) {
        super.endPrefixMapping(prefix2);
    }

    @Override
    public void startElement(String uri2, String localname2, String qname2, Attributes attributes2) throws SAXException {
        int line = this.m_locator.getLineNumber();
        int col = this.m_locator.getColumnNumber();
        this.newNode(line, col, 1);
        super.startElement(uri2, localname2, qname2, attributes2);
    }

    @Override
    public void endElement(String uri2, String localname2, String qname2) {
        int col;
        Expr expr = this.getCurrentElement();
        int line = this.m_locator.getLineNumber();
        Node node2 = this.newNode(line, col = this.m_locator.getColumnNumber(), 1);
        if (node2 != null) {
            this.setEndTagLineInfo(expr);
        }
        super.endElement(uri2, localname2, qname2);
    }

    @Override
    public void characters(char[] ch, int start, int length2) {
        int line = this.m_locator.getLineNumber();
        int col = this.m_locator.getColumnNumber();
        this.newNode(line, col, 2);
        super.characters(ch, start, length2);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length2) {
        int line = this.m_locator.getLineNumber();
        int col = this.m_locator.getColumnNumber();
        int off = this.numCharsToEOL(line - 1) + (col - 1);
        if (0 <= off && off < this.m_documentChars.limit()) {
            char ch = this.m_documentChars.get(off);
            while (ch != '>' && ch != '\r' && ch != '\n' && off < this.m_documentChars.limit() - 1) {
                ++col;
                ch = this.m_documentChars.get(++off);
            }
            if (ch == '>') {
                ++off;
                ++col;
            }
        }
        this.newNode(line, col, 2);
        super.ignorableWhitespace(chars, start, length2);
    }

    @Override
    public void comment(char[] ch, int start, int length2) throws SAXException {
        int line = this.m_locator.getLineNumber();
        int col = this.m_locator.getColumnNumber();
        this.newNode(line, col, 2);
        super.comment(ch, start, length2);
    }

    @Override
    public void processingInstruction(String name2, String value2) {
        int line = this.m_locator.getLineNumber();
        int col = this.m_locator.getColumnNumber();
        this.newNode(line, col, 2);
        super.processingInstruction(name2, value2);
    }

    @Override
    public void skippedEntity(String name2) {
        super.skippedEntity(name2);
    }

    @Override
    protected void setLineInfo(Expr expr) {
        expr.setLineInfo(this.createLineInfo());
    }

    @Override
    protected void updateLineInfo(Expr expr) {
        LineInfo info = expr.getLineInfo();
        if (info == null) {
            info = this.createLineInfo();
        } else {
            Node node2 = this.m_nodes.lastElement();
            if (node2 != null) {
                info = new LineInfo(info.getSystemID(), info.getPublicID(), info.getStartLine(), info.getStartColumn(), node2.m_line2, node2.m_lineOffset2, info.getStartOffset(), node2.m_absOffset2);
            }
        }
        expr.setLineInfo(info);
    }

    private void setEndTagLineInfo(Expr expr) {
        expr.setEndTagLineInfo(this.createLineInfo());
    }

    private LineInfo createLineInfo() {
        LineInfo info = null;
        Node node2 = this.m_nodes.lastElement();
        if (node2 != null) {
            info = new LineInfo(this.m_locator.getSystemId(), this.m_locator.getPublicId(), node2.m_line1, node2.m_lineOffset1, node2.m_line2, node2.m_lineOffset2, node2.m_absOffset1, node2.m_absOffset2);
        }
        return info;
    }

    private void updateLineOffsets() {
        int i;
        int max2 = this.m_documentChars.limit();
        int lastEOL = this.m_lineOffsetTable.elementAt(this.m_lineOffsetTable.size() - 1);
        int n2 = i = lastEOL == 0 ? lastEOL : lastEOL + 1;
        while (i < max2) {
            block12: {
                int j;
                block11: {
                    block10: {
                        if (i + systemEOL.length - 1 < max2) {
                            for (j = 0; j < systemEOL.length; ++j) {
                                if (max2 > i + j && this.m_documentChars.get(i + j) == systemEOL[j]) {
                                    continue;
                                }
                                break block10;
                            }
                            this.m_lineOffsetTable.addElement(i += systemEOL.length - 1);
                            ++i;
                            continue;
                        }
                    }
                    if (i + windowsEOL.length - 1 < max2) {
                        for (j = 0; j < windowsEOL.length; ++j) {
                            if (max2 > i + j && this.m_documentChars.get(i + j) == windowsEOL[j]) {
                                continue;
                            }
                            break block11;
                        }
                        this.m_lineOffsetTable.addElement(i += windowsEOL.length - 1);
                        ++i;
                        continue;
                    }
                }
                if (i + unixEOL.length - 1 < max2) {
                    for (j = 0; j < unixEOL.length; ++j) {
                        if (max2 > i + j && this.m_documentChars.get(i + j) == unixEOL[j]) {
                            continue;
                        }
                        break block12;
                    }
                    this.m_lineOffsetTable.addElement(i += unixEOL.length - 1);
                    ++i;
                    continue;
                }
            }
            ++i;
        }
    }

    private final int numCharsToEOL(int line) {
        int retval = line < 0 || this.m_lineOffsetTable.size() <= line ? -1 : this.m_lineOffsetTable.elementAt(line);
        return retval;
    }

    private Node newNode(int line, int col, int type2) {
        int iprev = this.m_nodes.size() - 1;
        if (0 <= iprev) {
            Node prev = this.m_nodes.elementAt(iprev);
            if (prev.m_line2 < line || prev.m_lineOffset2 < col) {
                Node n2 = new Node(line, col, type2);
                n2.m_line1 = prev.m_line2;
                n2.m_lineOffset1 = prev.m_lineOffset2;
                n2.setAbsOffset1(prev.m_absOffset2);
                this.m_nodes.add(n2);
                return n2;
            }
            return null;
        }
        Node n3 = new Node(line, col, type2);
        n3.m_line1 = n3.m_line2;
        int col1 = 1;
        for (int col_guess = col - 2; 1 < col_guess; --col_guess) {
            char ch;
            int off = this.numCharsToEOL(n3.m_line1 - 1) + (col_guess - 1);
            if (0 > off || off >= this.m_documentChars.limit() || (ch = this.m_documentChars.get(off)) != '<' && ch != '>') continue;
            col1 = col_guess - 1;
            break;
        }
        n3.m_lineOffset1 = col1;
        n3.m_lineOffset1 = n3.m_lineOffset1 + 0;
        n3.setAbsOffset1(this.numCharsToEOL(n3.m_line1 - 1) + (col1 - 1));
        this.m_nodes.add(n3);
        return n3;
    }

    private class Node {
        private static final int TYPE_START_ELEM = 1;
        private static final int TYPE_OTHER = 2;
        private final int m_type;
        private int m_line1;
        private int m_lineOffset1;
        private int m_absOffset1;
        private final int m_line2;
        private final int m_lineOffset2;
        private final int m_absOffset2;

        private Node(int line2, int col2, int type2) {
            this.m_line2 = line2;
            this.m_lineOffset2 = col2;
            this.m_type = type2;
            this.m_absOffset2 = TraceXSLTParser.this.numCharsToEOL(line2 - 1) + col2;
        }

        public void setAbsOffset1(int off) {
            char ch;
            if (this.m_type == 1 && 0 <= off && off < TraceXSLTParser.this.m_documentChars.limit() && (ch = TraceXSLTParser.this.m_documentChars.get(off)) != '<' && ++off < TraceXSLTParser.this.m_documentChars.limit() && (ch = TraceXSLTParser.this.m_documentChars.get(off)) != '<') {
                ++off;
            }
            this.m_absOffset1 = off;
        }

        public String toString() {
            return "(" + this.m_line1 + "," + this.m_lineOffset1 + ")->(" + this.m_line2 + "," + this.m_lineOffset2 + ")";
        }
    }
}

