/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.namespace.QName;

class XSLTParseQNameUtils
implements Constants {
    private Hashtable<String, QName> _qNames = new Hashtable(512);
    private Hashtable<String, Dictionary<String, QName>> _namespaces = new Hashtable();

    public static XSLTParseQNameUtils newInstance() {
        return new XSLTParseQNameUtils();
    }

    public void reset() {
        if (null != this._qNames) {
            this._qNames.clear();
        }
        if (null != this._namespaces) {
            this._namespaces.clear();
        }
    }

    private XSLTParseQNameUtils() {
    }

    protected QName getQNameSafe(String stringRep, XStaticContext staticContext) {
        int colon = stringRep.lastIndexOf(58);
        if (colon != -1) {
            String prefix2 = stringRep.substring(0, colon);
            String localname2 = stringRep.substring(colon + 1);
            String namespace2 = null;
            if (!prefix2.equals("xmlns") && (namespace2 = staticContext.getNamespaceURI(prefix2)) == null) {
                namespace2 = "";
            }
            return this.getQName(namespace2, prefix2, localname2);
        }
        String uri2 = stringRep.equals("xmlns") ? null : staticContext.getNamespaceURI("");
        return this.getQName(uri2, "", stringRep);
    }

    protected QName getQName(ASTBuildingContext context2, String stringRep, boolean reportError, boolean ignoreDefaultNs, XStaticContext staticContext) {
        int colon = stringRep.lastIndexOf(58);
        if (colon != -1) {
            String prefix2 = stringRep.substring(0, colon);
            String localname2 = stringRep.substring(colon + 1);
            String namespace2 = null;
            if (!prefix2.equals("xmlns") && ((namespace2 = staticContext.getNamespaceURI(prefix2)) == null || namespace2.length() == 0) && reportError) {
                Expr node2 = staticContext.getCurrentNode();
                ASTMsg err = node2 != null ? new ASTMsg("NAMESPACE_UNDEF_ERR", (Object)prefix2, (SimpleNode)node2) : new ASTMsg("NAMESPACE_UNDEF_ERR", prefix2);
                context2.reportError(3, err);
            }
            return this.getQName(namespace2, prefix2, localname2);
        }
        if (stringRep.equals("xmlns")) {
            ignoreDefaultNs = true;
        }
        String defURI = ignoreDefaultNs ? null : staticContext.getNamespaceURI("");
        return this.getQName(defURI, "", stringRep);
    }

    protected QName getQName(String namespace2, String prefix2, String localname2) {
        String lexicalQName;
        if (namespace2 == null || namespace2.equals("")) {
            QName name2 = this._qNames.get(localname2);
            if (name2 == null) {
                name2 = prefix2 != null ? new QName("", localname2, prefix2) : new QName(localname2);
                this._qNames.put(localname2, name2);
            }
            return name2;
        }
        Dictionary<String, QName> space2 = this._namespaces.get(namespace2);
        if (prefix2 == null) {
            prefix2 = "";
        }
        String string2 = lexicalQName = prefix2.length() == 0 ? localname2 : prefix2 + ':' + localname2;
        if (space2 == null) {
            QName name3 = new QName(namespace2, localname2, prefix2);
            space2 = new Hashtable<String, QName>();
            this._namespaces.put(namespace2, space2);
            space2.put(lexicalQName, name3);
            return name3;
        }
        QName name4 = space2.get(lexicalQName);
        if (name4 == null) {
            name4 = new QName(namespace2, localname2, prefix2);
            space2.put(lexicalQName, name4);
        }
        return name4;
    }
}

