/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.XPath20Exception;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CharacterMap;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.FunctionDecl;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.JavaExtension;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Output;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ResultDocument;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.TypeExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UnsupportedElement;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.ParseException;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLT1ParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLT2ParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParseQNameUtils;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParseTables;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTBaseMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.AttributeList;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.scontext.MergedCharacterMapsManager;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xtq.utils.Reporter;
import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.xml4j.api.s1.xs.PSVIProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XSLTParser
extends ASTBuildingContext
implements Constants,
ContentHandler,
LexicalHandler {
    private static final String XSL = "xsl";
    private Locator _locator = null;
    private XMLReader _reader = null;
    private boolean _debug = false;
    private XSLTParseTables _parseTables;
    private QName _useAttributeSets;
    private Hashtable _variableScope;
    private XTQProgram _currentXTQProgram;
    private XTQProgram _topLevelXTQProgram;
    private Output _output;
    private Template _template;
    private boolean _rootNamespaceDef;
    private Expr _root;
    private String _target;
    private ExpressionFactoryImpl _expressionFactory;
    private XStaticContext _staticContext;
    private final boolean _isXSLT20;
    private boolean _xml10Only;
    private boolean _isSecureProcessing;
    private XSLTParseQNameUtils parseUtilsInstance;
    private Reporter _reporter;
    private HashSet _extensionNamespaces = null;
    private Expr.ImportPrecedence _currentImportPrecedence;
    private String _PImedia = null;
    private String _PItitle = null;
    private String _PIcharset = null;
    private int _templateIndex = 0;
    private String exprString;
    private Stack _parentStack = null;
    private Stack _entityInfoStack = null;
    private int _elementDepthInEntity = 0;
    private HashMap _prefixMapping = null;
    private PSVIProvider _psviProvider = null;

    public XSLTParser() {
        this(false, new XStaticContext());
        this._xml10Only = false;
    }

    public XSLTParser(boolean isXSLT20, XStaticContext context2) {
        this(isXSLT20, context2, new Reporter());
    }

    public XSLTParser(boolean isXSLT20, XStaticContext context2, Reporter reporter) {
        this._expressionFactory = new ExpressionFactoryImpl(context2);
        this._reporter = reporter;
        this._isXSLT20 = isXSLT20;
        this._xml10Only = false;
    }

    public XSLTParser(boolean isXSLT20, ExpressionFactoryImpl exprFactoryImpl) {
        this._expressionFactory = exprFactoryImpl;
        this._reporter = new Reporter();
        this._isXSLT20 = isXSLT20;
        this._xml10Only = false;
    }

    public void init() {
        this.initLanguageSetting();
        this.parseUtilsInstance = XSLTParseQNameUtils.newInstance();
        this._variableScope = new Hashtable();
        this._template = null;
        this._staticContext = this._expressionFactory.getContext();
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        if (this._isXSLT20) {
            this._parseTables = XSLT2ParseTables.getInstance();
        } else {
            this._parseTables = XSLT1ParseTables.getInstance();
            this._staticContext.setBuiltInNamespaceForFunction();
        }
        this._useAttributeSets = this.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "use-attribute-sets");
    }

    protected void initLanguageSetting() {
        if (this._isXSLT20) {
            this.getExpressionFactory().setLanguage("XSLT2");
        } else {
            this.getExpressionFactory().setLanguage("XSLT1");
        }
    }

    public void reset() {
        this.parseUtilsInstance.reset();
        this._variableScope.clear();
        this._template = null;
        this._currentXTQProgram = null;
        this._output = null;
        this._root = null;
        this._rootNamespaceDef = false;
        this._expressionFactory.reset();
        this.initLanguageSetting();
        this._reporter.reset();
    }

    public Expr.ImportPrecedence getCurrentImportPrecedence() {
        return this._currentImportPrecedence;
    }

    public void setCurrentImportPrecedence(Expr.ImportPrecedence ip) {
        this._currentImportPrecedence = ip;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean flag) {
        this._debug = flag;
    }

    public void setXML10Only(boolean flag) {
        this._xml10Only = flag;
    }

    public boolean isXSLT20() {
        return this._isXSLT20;
    }

    @Override
    public ExpressionFactoryImpl getExpressionFactory() {
        return this._expressionFactory;
    }

    @Override
    public XStaticContext getStaticContext() {
        return this._staticContext;
    }

    public void setXMLReader(XMLReader reader) {
        this._reader = reader;
    }

    public XMLReader getXMLReader() {
        return this._reader;
    }

    public void setOutput(Output output) {
        if (this._output != null) {
            Expr.ImportPrecedence _precedence = this._output.getImportPrecedence();
            Expr.ImportPrecedence precedence = output.getImportPrecedence();
            if (precedence.hasSamePrecedenceAs(_precedence) || precedence.hasHigherPrecedenceThan(_precedence)) {
                String cdata = this._output.getCdata();
                output.mergeCdata(cdata);
                this._output.disable();
                this._output = output;
            } else {
                output.disable();
            }
        } else {
            this._output = output;
        }
    }

    public Output getOutput() {
        return this._output;
    }

    public Properties getOutputProperties() {
        Properties p = this.getTopLevelXTQProgram().getOutputProperties();
        return p;
    }

    public void setCurrentXTQProgram(XTQProgram stylesheet) {
        this._currentXTQProgram = stylesheet;
    }

    public XTQProgram getCurrentXTQProgram() {
        return this._currentXTQProgram;
    }

    public XTQProgram getTopLevelXTQProgram() {
        return this._topLevelXTQProgram;
    }

    public void setTopLevelXTQProgram(XTQProgram stylesheet) {
        this._topLevelXTQProgram = stylesheet;
    }

    public QName getQNameSafe(String stringRep) {
        return this.parseUtilsInstance.getQNameSafe(stringRep, this._staticContext);
    }

    public QName getQName(String stringRep) {
        return this.parseUtilsInstance.getQName(this, stringRep, true, false, this._staticContext);
    }

    public QName getQNameIgnoreDefaultNs(String stringRep) {
        return this.parseUtilsInstance.getQName(this, stringRep, true, true, this._staticContext);
    }

    public ArrayList<QName> getQNameListIgnoreDefaultNs(String stringRep) {
        ArrayList<QName> list = new ArrayList<QName>();
        StringTokenizer tokens = Util.whitespaceTokenize(stringRep);
        while (tokens.hasMoreElements()) {
            String token = (String)tokens.nextElement();
            list.add(this.parseUtilsInstance.getQName(this, token, true, true, this._staticContext));
        }
        return list;
    }

    public QName getQName(String stringRep, boolean reportError) {
        return this.parseUtilsInstance.getQName(this, stringRep, reportError, false, this._staticContext);
    }

    public QName getQName(String stringRep, boolean reportError, boolean ignoreDefaultNs) {
        return this.parseUtilsInstance.getQName(this, stringRep, reportError, ignoreDefaultNs, this._staticContext);
    }

    public QName getQName(String namespace2, String prefix2, String localname2) {
        return this.parseUtilsInstance.getQName(namespace2, prefix2, localname2);
    }

    public QName getQName(String scope2, String name2) {
        return this.parseUtilsInstance.getQName(this, scope2 + name2, true, false, this._staticContext);
    }

    public QName getQName(QName scope2, QName name2) {
        return this.parseUtilsInstance.getQName(this, scope2.toString() + name2.toString(), true, false, this._staticContext);
    }

    public QName getUseAttributeSets() {
        return this._useAttributeSets;
    }

    public boolean isXLSTReservedNS(String namespace2) {
        if (namespace2.equals("http://www.w3.org/1999/XSL/Transform")) {
            return true;
        }
        if (namespace2.equals("http://www.w3.org/2005/xpath-functions")) {
            return true;
        }
        if (namespace2.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (namespace2.equals("http://www.w3.org/2001/XMLSchema")) {
            return true;
        }
        return namespace2.equals("http://www.w3.org/2001/XMLSchema-instance");
    }

    public boolean checkForReservedNamespace(QName qname2, String construct2, SimpleNode node2) {
        if (qname2 == null) {
            return true;
        }
        String namespace2 = qname2.getNamespaceURI();
        return this.checkForReservedNamespace(namespace2, construct2, node2);
    }

    public boolean checkForReservedNamespace(String namespace2, String construct2, SimpleNode node2) {
        if (!this.isXLSTReservedNS(namespace2)) {
            return true;
        }
        ASTMsg error2 = new ASTMsg("IN_RESERVED_NAMESPACE", "name", construct2, node2);
        this.reportError(3, error2);
        return false;
    }

    public XTQProgram makeStylesheet(Expr element2) {
        try {
            XTQProgram stylesheet;
            if (element2 instanceof XTQProgram) {
                stylesheet = (XTQProgram)element2;
                stylesheet.setParser(this);
                int count2 = stylesheet.jjtGetNumChildren();
                for (int i = 0; i < count2; ++i) {
                    Expr child2 = (Expr)stylesheet.jjtGetChild(i);
                    if (child2.getId() != 108) continue;
                    this.checkForNullNS(child2);
                }
            } else {
                stylesheet = new XTQProgram();
                stylesheet.setLineInfo(element2.getLineInfo());
                stylesheet.setParser(this);
                stylesheet.setSimplified();
                stylesheet.jjtAppendChild(this, element2);
                String ver = element2.getProgramVersion();
                if (null == ver) {
                    ASTMsg error2 = new ASTMsg("SIMPLIFIED_MODULE_VER_ERR");
                    this.reportError(2, error2);
                }
                stylesheet.setProgramVersion(ver);
                if (element2.lookupNamespace("") == null) {
                    element2.addPrefixMapping("", "");
                }
            }
            return stylesheet;
        }
        catch (ClassCastException e) {
            ASTMsg err = new ASTMsg("NOT_STYLESHEET_ERR", element2);
            this._reporter.report(2, err);
            return null;
        }
    }

    public void createAST(XTQProgram stylesheet) {
        if (stylesheet != null) {
            stylesheet.callParseContents(this);
            int count2 = stylesheet.jjtGetNumChildren();
            for (int i = 0; i < count2; ++i) {
                Node child2 = stylesheet.jjtGetChild(i);
                if (!(child2 instanceof Text)) continue;
                Text text2 = (Text)child2;
                int line = text2.getLineNumber();
                int column = text2.getColumnNumber();
                ASTMsg err = new ASTMsg("ILLEGAL_TEXT_NODE_ERR", line, column, (Object)null);
                this.reportError(3, err);
            }
            this.reportDuplicateErrors();
            this.globalUseCharacterMapsErrors(stylesheet);
        }
    }

    private void globalUseCharacterMapsErrors(XTQProgram stylesheet) {
        ASTMsg err;
        Expr expr;
        int i;
        String[] referencedMaps;
        XStaticContext context2 = this.getStaticContext();
        MergedCharacterMapsManager mapMgr = context2.getCharacterMapsManager();
        if (mapMgr != null && (referencedMaps = mapMgr.getReferences()) != null && referencedMaps.length > 0) {
            Object[] nodes2 = mapMgr.getReferencingNodes();
            for (int i2 = 0; i2 < referencedMaps.length; ++i2) {
                String uri2;
                String localName2;
                String expandedName = referencedMaps[i2];
                MergedCharacterMapsManager.CharacterMapRecord cm = mapMgr.findCharMap(expandedName);
                Expr e = (Expr)nodes2[i2];
                String nodeName = "";
                if (e instanceof Output) {
                    if (cm != null) {
                        cm.mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    nodeName = "xsl:output";
                } else if (e instanceof ResultDocument) {
                    if (cm != null) {
                        cm.mightBeUsedByOutputOrResultDocument();
                        continue;
                    }
                    nodeName = "xsl:result-document";
                } else if (e instanceof CharacterMap) {
                    if (cm != null) continue;
                    nodeName = "xsl:character-map";
                }
                int curly = expandedName.indexOf(125);
                if (0 <= curly) {
                    localName2 = expandedName.substring(curly + 1);
                    uri2 = expandedName.substring(1, curly);
                } else {
                    localName2 = expandedName;
                    uri2 = "";
                }
                Object[] params = new String[]{nodeName, localName2, uri2};
                ASTMsg err2 = new ASTMsg("USE_CHARACTER_MAPS_NO_NAME_MATCH", params, (SimpleNode)e);
                this.reportError(3, err2);
            }
        }
        String[] names = mapMgr.getCharacterMapNames();
        for (i = 0; i < names.length; ++i) {
            MergedCharacterMapsManager.CharacterMapRecord map2 = mapMgr.findCharMap(names[i]);
            if (!map2.isDuplicate()) continue;
            String uri3 = map2.getURI();
            String localName3 = map2.getLocalName();
            expr = (Expr)map2.getExpr();
            err = uri3 == null || uri3.length() == 0 ? new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES1", (Object)localName3, (SimpleNode)expr) : new ASTMsg("CHARACTER_MAP_NAME_DUPLICATES2", localName3, uri3, expr);
            this.reportError(3, err);
        }
        mapMgr.process();
        block5: for (i = 0; i < names.length; ++i) {
            MergedCharacterMapsManager.CharacterMapRecord map3 = mapMgr.findCharMap(names[i]);
            int status = mapMgr.getStatus(names[i]);
            switch (status) {
                case 3: {
                    MergedCharacterMapsManager.CharacterMapRecord[] list = mapMgr.getCircularList(names[i]);
                    StringBuffer sb = new StringBuffer();
                    for (int ii = 0; ii < list.length; ++ii) {
                        if (0 < ii) {
                            sb.append(", ");
                        }
                        sb.append(list[ii].getLexicalQName());
                    }
                    String slist = sb.toString();
                    expr = (Expr)map3.getExpr();
                    err = new ASTMsg("USE_CHARACTER_MAPS_CIRCULAR", (Object)slist, (SimpleNode)expr);
                    this.reportError(3, err);
                    continue block5;
                }
            }
        }
    }

    protected void reportDuplicateErrors() {
        Hashtable<String, FunctionDecl> functions = this._staticContext.getStylesheetFunctions();
        if (null != functions) {
            Enumeration<FunctionDecl> enum_functions = functions.elements();
            while (enum_functions.hasMoreElements()) {
                FunctionDecl func = enum_functions.nextElement();
                FunctionDecl duplicate = func.getDuplicate();
                if (duplicate == null) continue;
                String name2 = func.getQName().toString();
                this.generateDuplicateError(name2, duplicate);
            }
        }
    }

    protected void generateDuplicateError(String name2, Expr node2) {
        ASTMsg err = new ASTMsg("FUNCTION_REDEF_ERR", (Object)name2, (SimpleNode)node2);
        this.reportError(3, err);
    }

    public Expr parse(XMLReader reader, InputSource input, Expr astExpr) {
        try {
            ValidatorHandler validator = this.getStaticContext().getSchema().newValidatorHandler();
            reader.setContentHandler(validator);
            validator.setContentHandler(this);
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException spe) {
                }

                @Override
                public void error(SAXParseException spe) {
                }

                @Override
                public void fatalError(SAXParseException spe) {
                }
            });
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            if (validator instanceof PSVIProvider) {
                this.setPsviProvider((PSVIProvider)((Object)validator));
            } else if (reader instanceof PSVIProvider) {
                this.setPsviProvider((PSVIProvider)((Object)reader));
            }
            reader.parse(input);
            return this.getStylesheet(this._root);
        }
        catch (FileNotFoundException fnf) {
            ASTMsg error2 = new ASTMsg("ERR_UNABLE_TO_RETRIEVE_RESOURCE", (Object)input.getSystemId(), (SimpleNode)astExpr);
            this.reportError(2, error2);
        }
        catch (IOException e) {
            if (this._debug) {
                e.printStackTrace();
            }
            this.reportError(2, new ASTMsg(e));
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (this._debug) {
                e.printStackTrace();
                if (ex != null) {
                    ex.printStackTrace();
                }
            }
            if (e instanceof SAXParseException) {
                ASTMsg error3 = new ASTMsg("PARSE_ERR", ((SAXParseException)e).getSystemId(), ((SAXParseException)e).getMessage(), ((SAXParseException)e).getLineNumber(), ((SAXParseException)e).getColumnNumber());
                this.reportError(2, error3);
            }
            this.reportError(2, new ASTMsg(e));
        }
        return null;
    }

    public Expr parse(InputSource input, Expr astExpr) {
        try {
            SAXParserFactory factory = JAXPFactoryHelper.newSAXParserFactory();
            try {
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception e) {
                factory.setNamespaceAware(true);
            }
            if (this._isSecureProcessing) {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            return this.parse(reader, input, astExpr);
        }
        catch (ParserConfigurationException e) {
            ASTMsg err = new ASTMsg("ERR_SYSTEM", "SAX parser is not configured correctly.");
            this.reportError(2, err);
        }
        catch (SAXParseException e) {
            this.reportError(2, new ASTMsg("PARSE_ERR", e.getSystemId(), e.getMessage(), e.getLineNumber(), e.getColumnNumber()));
        }
        catch (SAXException e) {
            this.reportError(2, new ASTMsg(e.getMessage()));
        }
        return null;
    }

    public Expr getDocumentRoot() {
        return this._root;
    }

    public void setPIParameters(String media, String title, String charset) {
        this._PImedia = media;
        this._PItitle = title;
        this._PIcharset = charset;
    }

    private Expr getStylesheet(Expr root2) {
        if (this._root instanceof XTQProgram || this._target == null) {
            if (!this._rootNamespaceDef) {
                ASTMsg msg = new ASTMsg("MISSING_XSLT_URI_ERR");
                this._reporter.report(2, msg);
            }
            return root2;
        }
        if (this._target.charAt(0) == '#') {
            Expr element2 = this.findStylesheet(root2, this._target.substring(1));
            if (element2 == null) {
                ASTMsg msg = new ASTMsg("MISSING_XSLT_TARGET_ERR", (Object)this._target, (SimpleNode)root2);
                this._reporter.report(2, msg);
            }
            return element2;
        }
        return this.loadExternalStylesheet(this._target, root2);
    }

    private Expr findStylesheet(Expr root2, String href) {
        if (root2 == null) {
            return null;
        }
        if (root2 instanceof XTQProgram) {
            String id2 = root2.getAttribute("xml:id");
            if (id2.equals(href)) {
                return root2;
            }
            id2 = root2.getAttribute("id");
            String type2 = root2.getAttributeType("id");
            if (id2.equals(href) && type2.equals("ID")) {
                return root2;
            }
        }
        int count2 = root2.jjtGetNumChildren();
        for (int i = 0; i < count2; ++i) {
            Expr child2 = (Expr)root2.jjtGetChild(i);
            Expr node2 = this.findStylesheet(child2, href);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    private Expr loadExternalStylesheet(String location, Expr element2) {
        String uri2 = null;
        try {
            uri2 = SystemIDResolver.getAbsoluteURI(location, element2.getBaseURI());
        }
        catch (URI.MalformedURIException e) {
            throw new WrappedRuntimeException(e);
        }
        InputSource input = new InputSource(uri2);
        Expr external = this.parse(input, element2);
        return external;
    }

    public boolean elementSupported(String namespace2, String localName2) {
        return this._parseTables.getInstrClass(this.getQName(namespace2, XSL, localName2)) != null;
    }

    public Iterator getInstructionItr() {
        return this._parseTables.getInstrQNames();
    }

    public Template getTemplate() {
        return this._template;
    }

    public void setTemplate(Template template) {
        this._template = template;
    }

    public int getTemplateIndex() {
        return this._templateIndex++;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Expr makeInstance(String uri2, String prefix2, String local2, Attributes attributes2, Expr parent2) {
        Expr node2 = null;
        QName qname2 = this.getQName(uri2, prefix2, local2);
        String className = (String)this._parseTables.getInstrClass(qname2);
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                node2 = (Expr)clazz.newInstance();
                node2.setNodeQName(qname2);
                this.setLineInfo(node2);
                node2.jjtSetParent(parent2);
                if (node2 instanceof XTQProgram) {
                    if (this._topLevelXTQProgram == null) {
                        this._topLevelXTQProgram = (XTQProgram)node2;
                    }
                    XTQProgram program = (XTQProgram)node2;
                    program.setParser(this);
                }
                node2.setName(uri2, prefix2, local2);
                node2.setAttributes(new AttributeList(attributes2, this._psviProvider));
                node2.setPrefixMapping(this._prefixMapping);
                this.setStandardAttributes(uri2, node2, attributes2, parent2);
                this.checkAttributes(node2, attributes2, qname2);
            }
            catch (ClassNotFoundException e) {
                ASTMsg err = new ASTMsg("ERR_SYSTEM", "The class " + node2 + " can not be found: " + e.getMessage());
                this.reportError(3, err);
            }
            catch (IllegalAccessException e) {
                ASTMsg err = new ASTMsg("ERR_SYSTEM", "The class " + node2 + " can not be accessed: " + e.getMessage());
                this.reportError(3, err);
            }
            catch (InstantiationException e) {
                ASTMsg err = new ASTMsg("ERR_SYSTEM", "The class " + node2 + " can not be instantiated: " + e.getMessage());
                this.reportError(3, err);
            }
        } else if (uri2 != null) {
            node2 = new UnsupportedElement(uri2, prefix2, local2);
            node2.setNodeQName(qname2);
            this.setLineInfo(node2);
            node2.jjtSetParent(parent2);
            node2.setAttributes(new AttributeList(attributes2));
            node2.setPrefixMapping(this._prefixMapping);
            this.setStandardAttributes(uri2, node2, attributes2, parent2);
            if (uri2.equals("http://www.w3.org/1999/XSL/Transform")) {
                UnsupportedElement elem2 = (UnsupportedElement)node2;
                ASTMsg msg = new ASTMsg("UNSUPPORTED_XSL_ERR", node2.getLineNumber(), node2.getColumnNumber(), local2);
                elem2.setErrorMessage(msg);
                try {
                    double ver;
                    String verStr = elem2.getProgramVersion();
                    double d = ver = verStr != null ? Double.valueOf(verStr) : 1.0;
                    if (!(ver <= 2.0)) {
                        // empty if block
                    }
                }
                catch (Exception e) {
                    ASTMsg err = new ASTMsg("ERR_SYSTEM", (Object)e.getMessage(), (SimpleNode)elem2);
                    this.reportError(2, err, (Throwable)e);
                }
            } else if (uri2.equals("http://xml.apache.org/xalan/xsltc")) {
                UnsupportedElement elem3 = (UnsupportedElement)node2;
                elem3.setIsExtension();
                ASTMsg msg = new ASTMsg("UNSUPPORTED_EXT_ERR", node2.getLineNumber(), node2.getColumnNumber(), local2);
                elem3.setErrorMessage(msg);
            } else {
                XTQProgram sheet = this._topLevelXTQProgram;
                if (sheet != null && node2.isExtension(uri2) && sheet != parent2) {
                    UnsupportedElement elem4 = (UnsupportedElement)node2;
                    elem4.setIsExtension();
                    ASTMsg msg = new ASTMsg("UNSUPPORTED_EXT_ERR", node2.getLineNumber(), node2.getColumnNumber(), prefix2 + ":" + local2);
                    elem4.setErrorMessage(msg);
                } else if (uri2.equals("http://www.ibm.com/xmlns/prod/xltxe-j") && local2.equals("java-extension")) {
                    node2 = new JavaExtension(108);
                    node2.setNodeQName(qname2);
                    this.setLineInfo(node2);
                    node2.jjtSetParent(parent2);
                    node2.setName(uri2, prefix2, local2);
                    node2.setAttributes(new AttributeList(attributes2, this._psviProvider));
                    node2.setPrefixMapping(this._prefixMapping);
                    this.setStandardAttributes(uri2, node2, attributes2, parent2);
                    this.checkAttributes(node2, attributes2, qname2);
                } else {
                    LineInfo lineInfo = node2.getLineInfo();
                    node2 = new DirElemConstructor(108);
                    node2.jjtSetParent(parent2);
                    node2.setAttributes(new AttributeList(attributes2));
                    node2.setPrefixMapping(this._prefixMapping);
                    this.setStandardAttributes(uri2, node2, attributes2, parent2);
                    node2.setLineInfo(lineInfo);
                    this.checkAttributes(node2, attributes2, qname2);
                }
            }
        }
        if (node2 != null && node2 instanceof DirElemConstructor) {
            ((DirElemConstructor)node2).setQName(qname2);
        }
        return node2;
    }

    private void checkAttributes(Expr node2, Attributes attrs, QName qname2) {
        String[] requiredAtt = this._parseTables.getRequiredAttrs(qname2);
        String[] optionalAtt = this._parseTables.getOptAttrs(qname2);
        String ver = node2.getProgramVersion();
        double version = 0.0;
        if (null != ver) {
            try {
                version = Double.valueOf(ver);
            }
            catch (NumberFormatException e) {
                ASTMsg error2 = new ASTMsg("XSL_VERSION_ERR", ver);
                this.reportError(2, error2);
            }
        }
        this.checkForStandardAttrsOnLRE(node2, qname2, attrs);
        ArrayList<String> reqAttsTemp = null;
        if (requiredAtt != null) {
            reqAttsTemp = new ArrayList<String>(requiredAtt.length);
            for (int n2 = 0; n2 < requiredAtt.length; ++n2) {
                reqAttsTemp.add(requiredAtt[n2]);
            }
        }
        if (version <= 2.0 && (requiredAtt != null || optionalAtt != null)) {
            int n3 = attrs.getLength();
            for (int i = 0; i < n3; ++i) {
                String attrQName = attrs.getQName(i);
                if (this._isXSLT20 ? attrQName.startsWith("xml") || attrQName.indexOf(58) > 0 && !attrs.getURI(i).equals("http://www.w3.org/1999/XSL/Transform") : attrQName.startsWith("xml") || attrQName.indexOf(58) > 0) continue;
                boolean found = false;
                if (requiredAtt != null) {
                    for (int j = 0; j < requiredAtt.length; ++j) {
                        if (!attrQName.equalsIgnoreCase(requiredAtt[j])) continue;
                        found = true;
                        reqAttsTemp.remove(requiredAtt[j]);
                        break;
                    }
                }
                if (optionalAtt != null && !found) {
                    for (int j = 0; j < optionalAtt.length; ++j) {
                        if (!attrQName.equalsIgnoreCase(optionalAtt[j])) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    if (!this._isXSLT20 && ver.equals("2.0")) {
                        this._parseTables = XSLT2ParseTables.getInstance();
                    }
                    HashMap standardAttrTemp = this._parseTables.getStdAttrs();
                    for (int j = 0; j < standardAttrTemp.size(); ++j) {
                        if (!standardAttrTemp.containsKey(attrQName)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                ASTMsg err = new ASTMsg("ILLEGAL_ATTRIBUTE_ERR", (Object)attrQName, (SimpleNode)node2);
                this.reportError(5, err);
            }
            if (!reqAttsTemp.isEmpty()) {
                for (int j = 0; j < reqAttsTemp.size(); ++j) {
                    ASTMsg err = new ASTMsg("REQUIRED_ATTR_ERR", (Object)((String)reqAttsTemp.get(j)), (SimpleNode)node2);
                    this.reportError(3, err);
                }
            }
        }
    }

    public boolean checkAttributeValue(Expr node2, String qname2, String attrQname, String attrValue, int errCategory) {
        int generalAttrType = this._parseTables.getAttributeTypeIndex(attrQname);
        boolean result2 = false;
        switch (generalAttrType) {
            case 0: {
                result2 = this.checkFixedAttributeValues(node2, qname2, attrQname, attrValue, errCategory);
                break;
            }
            case 1: {
                result2 = true;
                break;
            }
            case 2: {
                result2 = true;
                break;
            }
            case 3: {
                if (XML11Char.isXML11ValidToken(attrValue)) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "'token'", attrValue, node2);
                this.reportError(errCategory, err);
                result2 = false;
                break;
            }
            case 4: {
                result2 = true;
                break;
            }
            case 5: {
                if (this.isValidQName(attrValue)) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "QName", attrValue, node2);
                this.reportError(errCategory, err);
                result2 = false;
                break;
            }
            case 6: {
                String badQName = this.invalidQNames(attrValue, null);
                if (badQName == null) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_LIST_VALUE_ERR", "QNames", badQName, node2);
                this.reportError(errCategory, err);
                result2 = false;
                break;
            }
            case 7: {
                result2 = true;
                break;
            }
            case 8: {
                switch (attrValue.length()) {
                    case 0: {
                        result2 = false;
                        break;
                    }
                    case 1: {
                        result2 = true;
                        break;
                    }
                    case 2: {
                        result2 = attrValue.codePointCount(0, 2) == 1;
                        break;
                    }
                    default: {
                        result2 = false;
                    }
                }
                if (result2) break;
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "character", attrValue, node2);
                this.reportError(errCategory, err);
                break;
            }
            case 9: {
                result2 = true;
                break;
            }
            case 10: {
                result2 = true;
                break;
            }
            case 11: {
                if (XML11Char.isXML11ValidNCName(attrValue)) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NCName", attrValue, node2);
                this.reportError(errCategory, err);
                result2 = false;
                break;
            }
            case 12: {
                if (XML11Char.isXML11ValidNmtoken(attrValue)) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "NMTOKEN", attrValue, node2);
                this.reportError(errCategory, err);
                result2 = false;
                break;
            }
            case 13: {
                result2 = true;
                break;
            }
            case 14: {
                result2 = true;
                break;
            }
            case 15: {
                result2 = true;
                break;
            }
            case 16: {
                result2 = true;
                break;
            }
            case 17: {
                result2 = true;
                break;
            }
            case 18: {
                result2 = true;
                break;
            }
            case 19: {
                result2 = true;
                break;
            }
            case 20: {
                if (XML11Char.isXML11ValidQNameButNotNCName(attrValue)) {
                    result2 = true;
                    break;
                }
                ASTMsg err = new ASTMsg("INVALID_ATTR_VALUE_ERR", "qname-but-not-ncname", attrValue, node2);
                this.reportError(errCategory, err);
                result2 = false;
            }
        }
        return result2;
    }

    private boolean checkFixedAttributeValues(Expr node2, String qname2, String attrQname, String attrValue, int errCategory) {
        String[] attrList = this._parseTables.getFixedAttributeValues(attrQname);
        String temp = "";
        for (int i = 0; i < attrList.length; ++i) {
            if (attrValue.equals(attrList[i])) {
                return true;
            }
            temp = temp + "'" + attrList[i] + "'";
            if (i >= attrList.length - 1) continue;
            temp = temp + " | ";
        }
        Object[] params = new String[]{qname2, attrQname, attrValue, temp};
        ASTMsg err = new ASTMsg("INVALID_FIXED_ATTR_VALUE_ERR", params, (SimpleNode)node2);
        this.reportError(errCategory, err);
        return false;
    }

    boolean isExtension(QName nodeName) {
        String ns = nodeName.getNamespaceURI();
        return ns != null && !ns.equals("") && !ns.equals("http://www.w3.org/1999/XSL/Transform");
    }

    public ArrayList getAllowedChildren(Expr node2) {
        QName nodeName = node2.getNodeQName();
        if (node2.getId() == 108) {
            nodeName = ((DirElemConstructor)node2).getQName();
            return this._parseTables.getAllowedChildrenList(this.parseUtilsInstance.getQName("http://www.w3.org/1999/XSL/Transform", XSL, "element"));
        }
        return this._parseTables.getAllowedChildrenList(nodeName);
    }

    /*
     * Unable to fully structure code
     */
    public boolean[] checkAllowedChildren(Expr node) {
        count = node.jjtGetNumChildren();
        tolerateError = new boolean[count];
        isForwards = node.isForwardsCompatibilityMode();
        allowedChildrenList = this.getAllowedChildren(node);
        nodeName = node.getNodeQName();
        nodeId = node.getId();
        if (nodeId == 108) {
            nodeName = ((DirElemConstructor)node).getQName();
        }
        block8: for (i = 0; i < count; ++i) {
            block20: {
                child = (Expr)node.jjtGetChild(i);
                cid = child.getId();
                childQName = child.getNodeQName();
                if (cid != 108) break block20;
                childQName = ((DirElemConstructor)child).getQName();
                if (child.hasAttribute("http://www.w3.org/1999/XSL/Transform", "use-when")) {
                    useWhen = child.getAttribute("http://www.w3.org/1999/XSL/Transform", "use-when");
                    Expr.parseExpression(this, child, useWhen);
                    if (useWhen != null && useWhen != "") {
                        useWhen = "boolean(" + useWhen + ")";
                        child.setUseWhen(useWhen);
                        switch (2.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[this.getStaticContext().evaluateUseWhen(this, child).ordinal()]) {
                            case 1: {
                                node.jjtRemoveChild(i);
                                child = null;
                                --i;
                                --count;
                                continue block8;
                            }
                            case 2: {
                                tolerateError[i] = true;
                                continue block8;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            switch (2.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[child.parseUseWhen(this).ordinal()]) {
                case 1: {
                    node.jjtRemoveChild(i);
                    child = null;
                    --i;
                    --count;
                    continue block8;
                }
                case 2: {
                    tolerateError[i] = true;
                    continue block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (isForwards && cid == 16 && null != childQName && "http://www.w3.org/1999/XSL/Transform".equals(childQName.getNamespaceURI())) {
                        if (nodeId == 3) {
                            node.jjtRemoveChild(i);
                            child = null;
                            --i;
                            --count;
                            continue block8;
                        }
                        if (this._parseTables.isSequenceConstructor(nodeId)) {
                            if (this.hasFallback(child)) {
                                this.keepFallback(child);
                            } else {
                                this.reportError(node, child);
                            }
                        }
                    }
                    if ((allowedChildrenList == null || allowedChildrenList.contains(new Integer(cid))) && (allowedChildrenList != null || count <= 0)) continue block8;
                    if (isForwards && null != childQName && "http://www.w3.org/1999/XSL/Transform".equals(childQName.getNamespaceURI())) {
                        if (nodeId == 3) {
                            node.jjtRemoveChild(i);
                            child = null;
                            --i;
                            --count;
                            continue block8;
                        }
                        if (this._parseTables.isSequenceConstructor(nodeId) && this.hasFallback(child)) {
                            this.keepFallback(child);
                            continue block8;
                        }
                    }
                    this.reportError(node, child);
                }
            }
        }
        return tolerateError;
    }

    private boolean hasFallback(Expr node2) {
        int count2 = node2.jjtGetNumChildren();
        for (int i = 0; i < count2; ++i) {
            Expr child2 = (Expr)node2.jjtGetChild(i);
            int childId = child2.getId();
            if (childId != 200) continue;
            return true;
        }
        return false;
    }

    private void keepFallback(Expr node2) {
        int count2 = node2.jjtGetNumChildren();
        for (int i = 0; i < count2; ++i) {
            Expr child2 = (Expr)node2.jjtGetChild(i);
            int childId = child2.getId();
            if (childId == 200) continue;
            node2.jjtRemoveChild(i);
            child2 = null;
            --i;
            --count2;
        }
    }

    private void reportError(Expr parent2, Expr child2) {
        QName nodeName = parent2.getNodeQName();
        if (parent2.getId() == 108) {
            nodeName = ((DirElemConstructor)parent2).getQName();
        }
        int cid = child2.getId();
        QName childQName = child2.getNodeQName();
        String[] params = new String[2];
        if (cid == 108) {
            childQName = ((DirElemConstructor)child2).getQName();
        }
        if (childQName == null) {
            return;
        }
        params[0] = nodeName.getPrefix().equals("") ? "<" : "<" + nodeName.getPrefix() + ":";
        params[0] = params[0] + nodeName.getLocalPart() + ">";
        params[1] = childQName.getPrefix().equals("") ? "<" : "<" + childQName.getPrefix() + ":";
        params[1] = params[1] + childQName.getLocalPart() + ">";
        ASTMsg error2 = new ASTMsg("INVALID_CHILD_ERR", params[0], params[1], parent2);
        this.reportError(3, error2);
    }

    public void checkNodesOrder(Expr node2) {
        if (node2.getChildren() == null) {
            return;
        }
        int nodeId = node2.getId();
        boolean isForwards = node2.isForwardsCompatibilityMode();
        Iterator children = node2.getChildren().iterator();
        switch (nodeId) {
            case 3: {
                boolean hasImp = false;
                boolean hasNode = false;
                Expr impNode = null;
                while (children.hasNext()) {
                    Expr child2 = (Expr)children.next();
                    int cid = child2.getId();
                    if (cid == 228 && ((Text)child2).isIgnore()) continue;
                    if (cid == 221 && child2.getRealParent() == node2) {
                        if (!hasNode) continue;
                        impNode = child2;
                        break;
                    }
                    hasNode = true;
                }
                if (impNode == null) break;
                ASTMsg err = new ASTMsg("ERR_ORDER_IMPORT", impNode);
                this.reportError(3, err);
                break;
            }
            case 201: 
            case 202: 
            case 209: {
                boolean beforeSort = false;
                boolean wrongSort = false;
                while (children.hasNext()) {
                    Expr child3 = (Expr)children.next();
                    int cid = child3.getId();
                    if (cid == 228 && ((Text)child3).isIgnore()) continue;
                    if (cid != 211) {
                        beforeSort = true;
                    } else if (beforeSort) {
                        wrongSort = true;
                    }
                    if (!wrongSort || !isForwards || !this.hasFallback(child3)) continue;
                    this.keepFallback(child3);
                    wrongSort = false;
                }
                if (!wrongSort) break;
                ASTMsg err = new ASTMsg("SORT_POSITION_ERR", (Object)node2.getNodeQName(), (SimpleNode)node2);
                this.reportError(3, err);
                break;
            }
            case 197: {
                ASTMsg err;
                int whenCnt = 0;
                int otherCnt = 0;
                while (children.hasNext()) {
                    Expr child4 = (Expr)children.next();
                    int cid = child4.getId();
                    if (cid == 228 && ((Text)child4).isIgnore()) continue;
                    if (cid == 215) {
                        if (otherCnt > 0) {
                            ASTMsg err2 = new ASTMsg("WHEN_ELEMENT_ERR");
                            this.reportError(3, err2);
                        }
                        ++whenCnt;
                        continue;
                    }
                    ++otherCnt;
                }
                if (whenCnt == 0) {
                    err = new ASTMsg("MISSING_WHEN_ERR");
                    this.reportError(3, err);
                }
                if (otherCnt <= true) break;
                err = new ASTMsg("MULTIPLE_OTHERWISE_ERR");
                this.reportError(3, err);
                break;
            }
            case 32: 
            case 227: {
                boolean foundSomethingBeforeParams = false;
                boolean wrongParam = false;
                Expr child5 = null;
                while (children.hasNext()) {
                    child5 = (Expr)children.next();
                    int cid = child5.getId();
                    if (cid == 228 && ((Text)child5).isIgnore()) continue;
                    if (cid != 34) {
                        foundSomethingBeforeParams = true;
                    } else if (foundSomethingBeforeParams) {
                        wrongParam = true;
                    }
                    if (!wrongParam || !isForwards || !this.hasFallback(child5)) continue;
                    this.keepFallback(child5);
                    wrongParam = false;
                }
                if (!wrongParam) break;
                String parentElem = nodeId == 32 ? "xsl:function" : "xsl:template";
                ASTMsg err = new ASTMsg("PARAM_POSITION_ERR", parentElem);
                this.reportError(3, err);
                break;
            }
        }
    }

    public Expr parseExpression(ASTBuildingContext context2, Expr parent2, String exp) {
        Expr expr = null;
        try {
            this._expressionFactory.setExprContext(parent2);
            expr = this._expressionFactory.createExpr(context2, exp);
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (Expr)expr.jjtGetChild(0);
            }
            expr.jjtSetParent(parent2);
        }
        catch (XPath20Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)exp, (SimpleNode)parent2));
        }
        return expr;
    }

    public TypeExpr parseSequenceTypeExpression(Expr parent2, String exp) {
        TypeExpr expr = null;
        try {
            this._expressionFactory.setExprContext(parent2);
            this._expressionFactory.setContext(this._staticContext);
            XPath parser = new XPath((ASTBuildingContext)this, new StringReader(exp));
            try {
                QName typeName;
                String defaultNS;
                TypeExpr node2 = parser.SequenceTypeStandalone();
                if (exp.indexOf(58) == -1 && !(defaultNS = parent2.getDefaultNS()).equals("") && (typeName = node2.getTypeName()) != null) {
                    QName newName = this._expressionFactory.createQName(defaultNS, typeName.getLocalPart(), typeName.getPrefix());
                    node2.setTypeName(newName);
                }
                node2.jjtSetParent(null);
                expr = node2;
            }
            catch (ParseException e) {
                throw new XPath20Exception(e);
            }
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (TypeExpr)expr.jjtGetChild(0);
            }
            expr.jjtSetParent(parent2);
        }
        catch (XPath20Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)exp, (SimpleNode)parent2));
        }
        return expr;
    }

    public Expr parseExpression(Expr parent2, String attr2, String def) {
        String exp = parent2.getAttribute(attr2);
        if (exp.length() == 0 && def != null) {
            exp = def;
        }
        return this.parseExpression(this, parent2, exp);
    }

    public String getExprString() {
        return this.exprString;
    }

    public Expr parseExpression(String exp) {
        Expr expr = null;
        this.exprString = exp;
        try {
            expr = this._expressionFactory.createExpr(this, exp);
            if (expr.getId() == 40 && expr.jjtGetNumChildren() == 1) {
                expr = (Expr)expr.jjtGetChild(0);
            }
        }
        catch (XPath20Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", exp));
        }
        return expr;
    }

    public Expr parsePattern(Expr parent2, String pattern2) {
        Expr expr = null;
        try {
            this._expressionFactory.setExprContext(parent2);
            expr = this._expressionFactory.createPattern(this, this._staticContext, pattern2);
            if (null != expr) {
                expr.jjtSetParent(parent2);
            }
        }
        catch (XPath20Exception e) {
            if (this._debug) {
                e.printStackTrace();
            }
            this.reportError(3, new ASTMsg("XPATH_PARSER_ERR", (Object)pattern2, (SimpleNode)parent2));
        }
        return expr;
    }

    public Expr parsePattern(Expr parent2, String attr2, String def) {
        String pattern2 = parent2.getAttribute(attr2);
        if (pattern2 != null && pattern2.startsWith("//")) {
            String subPattern;
            int index2 = pattern2.indexOf("key(");
            if (index2 == -1) {
                index2 = pattern2.indexOf("id(");
            }
            String string2 = subPattern = index2 == -1 ? pattern2.substring(index2 + 1) : pattern2.substring(index2);
            if (subPattern.indexOf("key(") > -1 || subPattern.indexOf("id(") > -1) {
                ASTMsg err = new ASTMsg("ERR_TOP_PATTERN", pattern2);
                this.reportError(3, err);
            }
        }
        if (pattern2.length() == 0 && def != null) {
            pattern2 = def;
        }
        return this.parsePattern(parent2, pattern2);
    }

    public boolean errorsFound() {
        return this._reporter.errorsFound();
    }

    public void printErrors() {
        this._reporter.printErrors();
    }

    public void printWarnings() {
        this._reporter.printWarnings();
    }

    @Override
    public void reportError(int category, ASTBaseMsg error2) {
        this._reporter.report(category, error2);
    }

    public void reportError(int category, ASTBaseMsg error2, Throwable cause) {
        this._reporter.report(category, error2, cause);
    }

    @Override
    public void reportError(int category, String error2) {
        int line = this._locator.getLineNumber();
        int column = this._locator.getColumnNumber();
        ASTMsg err = new ASTMsg(error2, line, column, (Object)null);
        this.reportError(category, err);
    }

    public void reportError(int category, String message, Throwable cause) {
        this._reporter.report(category, message, cause);
    }

    public Vector getErrors() {
        return this._reporter.getErrors();
    }

    public Vector getWarnings() {
        return this._reporter.getWarnings();
    }

    @Override
    public void startDocument() {
        this._root = null;
        this._target = null;
        this._prefixMapping = null;
        this._parentStack = new Stack();
        if (this._locator != null) {
            this._entityInfoStack = new Stack();
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix2, String uri2) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new HashMap();
        }
        this._prefixMapping.put(prefix2, uri2);
    }

    @Override
    public void endPrefixMapping(String prefix2) {
    }

    @Override
    public void startElement(String uri2, String localname2, String qname2, Attributes attributes2) throws SAXException {
        Expr element2;
        int col = qname2.lastIndexOf(58);
        String prefix2 = col == -1 ? "" : qname2.substring(0, col);
        Expr parent2 = this._root == null ? null : (Expr)this._parentStack.peek();
        if (uri2 == null) {
            uri2 = "";
        }
        if ((element2 = this.makeInstance(uri2, prefix2, localname2, attributes2, parent2)) == null) {
            ASTMsg err = new ASTMsg("ELEMENT_PARSE_ERR", prefix2 + ':' + localname2);
            throw new SAXException(err.toString());
        }
        if (this._root == null) {
            this._rootNamespaceDef = this._prefixMapping != null && this._prefixMapping.containsValue("http://www.w3.org/1999/XSL/Transform");
            this._root = element2;
        } else {
            parent2.jjtAppendChild(this, element2);
            element2.jjtSetParent(parent2);
        }
        this._prefixMapping = null;
        this._parentStack.push(element2);
        ++this._elementDepthInEntity;
        element2.setIsTopLevelElementInEntity(this._elementDepthInEntity == 1);
    }

    @Override
    public void endElement(String uri2, String localname2, String qname2) {
        this._parentStack.pop();
        --this._elementDepthInEntity;
    }

    private void setStandardAttributes(String uri2, Expr node2, Attributes attrs, Expr parent2) {
        int n2 = attrs.getLength();
        boolean hasVersion = false;
        boolean hasDefaultNS = false;
        boolean hasBaseURI = false;
        String excludeResultPrefixes = null;
        String excludeExtPrefixes = null;
        for (int i = 0; i < n2; ++i) {
            ASTMsg err;
            String[] exceptions;
            String attrLocalName;
            String attrURI = attrs.getURI(i);
            if (attrURI == null) {
                attrURI = "";
            }
            if ((attrLocalName = attrs.getLocalName(i)) == null) {
                attrLocalName = "";
            }
            if (attrURI.equals("http://www.w3.org/XML/1998/namespace") && attrLocalName.equals("base")) {
                node2.setBaseURI(attrs.getValue(i));
                hasBaseURI = true;
                continue;
            }
            if ((!attrURI.equals("") || uri2 == null || !uri2.equals("http://www.w3.org/1999/XSL/Transform")) && !attrURI.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            if (attrLocalName.equals("version")) {
                node2.setProgramVersion(attrs.getValue(i));
                hasVersion = true;
                continue;
            }
            if (attrLocalName.equals("xpath-default-namespace")) {
                node2.setDefaultElementTypeNamespace(attrs.getValue(i));
                hasDefaultNS = true;
                continue;
            }
            if (attrLocalName.equals("exclude-result-prefixes")) {
                excludeResultPrefixes = attrs.getValue(i);
                if (this.invalidNCNames(excludeResultPrefixes, exceptions = new String[]{"#default"}) == null || excludeResultPrefixes.equals("#all")) continue;
                err = new ASTMsg("INVALID_NCNAME_ERR", (Object)excludeResultPrefixes, this);
                this.reportError(3, err);
                continue;
            }
            if (!attrLocalName.equals("extension-element-prefixes") || this.invalidNCNames(excludeExtPrefixes = attrs.getValue(i), exceptions = new String[]{"#default"}) == null) continue;
            err = new ASTMsg("INVALID_NCNAME_ERR", (Object)excludeExtPrefixes, this);
            this.reportError(3, err);
        }
        if (!hasVersion && null != parent2 && node2.getId() != 3) {
            node2.setProgramVersion(parent2.getProgramVersion());
        }
        if (!hasDefaultNS) {
            if (null == parent2 || node2.getId() == 3) {
                node2.setDefaultElementTypeNamespace("");
            } else {
                node2.setDefaultElementTypeNamespace(parent2.getDefaultNS());
            }
        }
        if (node2.getId() == 3) {
            node2.setExcludeResultPrefixes(this, excludeResultPrefixes, null);
            node2.setExtensionElemPrefixes(this, excludeExtPrefixes, null);
        } else {
            node2.setExcludeResultPrefixes(this, excludeResultPrefixes, parent2);
            node2.setExtensionElemPrefixes(this, excludeExtPrefixes, parent2);
        }
        node2.excludePrefixes(this);
        if (!hasBaseURI && !this._entityInfoStack.empty() && this._locator != null) {
            node2.setBaseURI(this._locator.getSystemId());
            hasBaseURI = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length2) {
        Text text2;
        String string2 = new String(ch, start, length2);
        Expr parent2 = (Expr)this._parentStack.peek();
        if (string2.length() == 0) {
            return;
        }
        if (parent2 instanceof Text) {
            Text text3 = (Text)parent2;
            text3.setText(string2);
            this.updateLineInfo(text3);
            return;
        }
        if (Util.trimWhitespace(string2).length() != 0 && parent2 instanceof XTQProgram) {
            if (this._isXSLT20) {
                this.reportError(2, "STYLESHEET_HAS_TEXT_NODE");
            } else {
                this.reportError(3, "ILLEGAL_TEXT_NODE_ERR");
            }
        }
        if (parent2 instanceof XTQProgram) {
            return;
        }
        Expr bro = parent2.lastChild();
        if (bro != null && bro instanceof Text && !(text2 = (Text)bro).isTextElement() && length2 >= 1) {
            text2.setText(string2);
            this.updateLineInfo(text2);
            return;
        }
        text2 = new Text(string2, parent2.getProgramVersion());
        this.setLineInfo(text2);
        parent2.jjtAppendChild(this, text2);
    }

    private String getTokenValue(String token) {
        int start = token.indexOf(34);
        int stop = token.lastIndexOf(34);
        if (start < 0) {
            int start2 = token.indexOf(39);
            int stop2 = token.lastIndexOf(39);
            if (start2 < 0) {
                return token;
            }
            return token.substring(start2 + 1, stop2);
        }
        return token.substring(start + 1, stop);
    }

    @Override
    public void processingInstruction(String name2, String value2) {
        if (this._target == null && name2.equals("xml-stylesheet")) {
            String href = null;
            String media = null;
            String title = null;
            String charset = null;
            StringTokenizer tokens = Util.whitespaceTokenize(value2);
            while (tokens.hasMoreElements()) {
                String token = (String)tokens.nextElement();
                if (token.startsWith("href")) {
                    href = this.getTokenValue(token);
                    continue;
                }
                if (token.startsWith("media")) {
                    media = this.getTokenValue(token);
                    continue;
                }
                if (token.startsWith("title")) {
                    title = this.getTokenValue(token);
                    continue;
                }
                if (!token.startsWith("charset")) continue;
                charset = this.getTokenValue(token);
            }
            if (!(this._PImedia != null && !this._PImedia.equals(media) || this._PItitle != null && !this._PImedia.equals(title) || this._PIcharset != null && !this._PImedia.equals(charset))) {
                this._target = href;
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length2) {
    }

    @Override
    public void skippedEntity(String name2) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public boolean isReservedNamespace(String namespace2) {
        return this._parseTables.hasReservedNamespace(namespace2);
    }

    public Properties getMergedXslOuputProperties(String formatName) {
        XTQProgram ss = this.getTopLevelXTQProgram();
        Properties p = ss.getEffectiveMergedXslOutputProperties(formatName);
        return p;
    }

    public void AppendExpandedQName(StringBuffer expandedQNameList, String qName) {
        int colon = qName.lastIndexOf(58);
        if (colon != -1) {
            String prefix2 = qName.substring(0, colon);
            String localname2 = qName.substring(colon + 1);
            String namespace2 = null;
            namespace2 = this._staticContext.getNamespaceURI(prefix2);
            if (namespace2 == null || namespace2.length() == 0) {
                expandedQNameList.append(localname2);
            } else {
                expandedQNameList.append('{');
                expandedQNameList.append(namespace2);
                expandedQNameList.append('}');
                expandedQNameList.append(localname2);
            }
        } else {
            String localName2 = qName;
            String defURI = this._staticContext.getNamespaceURI("");
            if (!"".equals(defURI)) {
                expandedQNameList.append('{');
                expandedQNameList.append(defURI);
                expandedQNameList.append('}');
            }
            expandedQNameList.append(localName2);
        }
    }

    public static void main(String[] args) throws Exception {
        int numberArgsLeft = args.length;
        int argsStart = 0;
        boolean dumpTree = false;
        File file = null;
        String xsltVersion = "2.0";
        while (numberArgsLeft > 0) {
            if (args[argsStart].equals("-dumptree")) {
                dumpTree = true;
                ++argsStart;
                --numberArgsLeft;
                continue;
            }
            if ("-file".equalsIgnoreCase(args[argsStart])) {
                --numberArgsLeft;
                file = new File(args[++argsStart]);
                ++argsStart;
                --numberArgsLeft;
                continue;
            }
            if ("-xsltversion".equalsIgnoreCase(args[argsStart])) {
                --numberArgsLeft;
                xsltVersion = args[++argsStart];
                ++argsStart;
                --numberArgsLeft;
                continue;
            }
            if (args[argsStart].endsWith(".xslt") || args[argsStart].endsWith(".xsl")) {
                System.out.println("Running test for: " + args[argsStart]);
                file = new File(args[argsStart]);
                ++argsStart;
                --numberArgsLeft;
                continue;
            }
            if ("-catalog".equalsIgnoreCase(args[argsStart])) {
                System.err.println("-catalog not yet implemented");
                System.exit(-1);
                continue;
            }
            System.out.println("XSLTParser [-dumptree] -file {filename}");
        }
        XTQProgram stylesheet = XSLTParser.makeAST(file, xsltVersion);
        if (null != stylesheet) {
            stylesheet.dump("|", System.out);
        } else {
            System.err.println("Could not process XSLT file!");
        }
    }

    private static XTQProgram makeAST(File file, String xsltVersion) {
        InputSource input = new InputSource(file.getAbsolutePath());
        return XSLTParser.makeAST(input, xsltVersion);
    }

    private static XTQProgram makeAST(InputSource input, String xsltVersion) {
        XSLTParser parser = new XSLTParser(xsltVersion.equals("2.0"), new XStaticContext());
        parser.init();
        return parser.makeAST(input);
    }

    public XTQProgram makeAST(InputSource input) {
        XMLReader reader = this.getXMLReader();
        Expr element2 = reader == null ? this.parse(input, null) : this.parse(reader, input, null);
        if (!this.errorsFound() && element2 != null) {
            XTQProgram stylesheet = this.makeStylesheet(element2);
            stylesheet.giveHighestImportPrecedence();
            this.setTopLevelXTQProgram(stylesheet);
            stylesheet.setSystemId(input.getSystemId());
            stylesheet.setURI(input.getSystemId());
            stylesheet.setParentXTQProgram(null);
            this.setCurrentXTQProgram(stylesheet);
            this.setCurrentImportPrecedence(stylesheet.getImportPrecedence());
            this.createAST(stylesheet);
            stylesheet.getImportPrecedence().computePrecedenceOnImportTree();
            return stylesheet;
        }
        this.printWarnings();
        this.printErrors();
        return null;
    }

    public void setErrorHandler(com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler errorHandler) {
        this._reporter.setErrorHandler(errorHandler);
    }

    public boolean getSecureProcessing() {
        return this._isSecureProcessing;
    }

    public void setSecureProcessing(boolean value2) {
        this._isSecureProcessing = value2;
    }

    public boolean isValidQName(String name2) {
        boolean valid2 = !this._xml10Only ? XML11Char.isXML11ValidQName(name2) : XML11Char.isXML11ValidQName(name2);
        return valid2;
    }

    public boolean isValidNCName(String name2) {
        boolean valid2 = !this._xml10Only ? XML11Char.isXML11ValidNCName(name2) : XML11Char.isXML11ValidNCName(name2);
        return valid2;
    }

    public String invalidQNames(String QNameList, String[] ignoreList) {
        String invalidList = this.invalidNames(true, QNameList, ignoreList);
        return invalidList;
    }

    public String invalidNCNames(String QNameList, String[] ignoreList) {
        String invalidList = this.invalidNames(false, QNameList, ignoreList);
        return invalidList;
    }

    private String invalidNames(boolean qnames, String QNameList, String[] ignoreList) {
        String invalidList = null;
        if (QNameList != null && !QNameList.equals("")) {
            StringTokenizer tokens = new StringTokenizer(QNameList, " \t\n\r");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ((!qnames || this.isValidQName(token)) && (qnames || this.isValidNCName(token))) continue;
                boolean ignore = false;
                if (ignoreList != null) {
                    for (int i = 0; i < ignoreList.length; ++i) {
                        if (!ignoreList[i].equals(token)) continue;
                        ignore = true;
                        break;
                    }
                }
                if (ignore) continue;
                if (invalidList == null) {
                    invalidList = token;
                    continue;
                }
                invalidList = invalidList + ' ';
                invalidList = invalidList + token;
            }
        }
        return invalidList;
    }

    public void checkForStandardAttrsOnLRE(Expr node2, QName qname2, Attributes attrs) {
        if (node2.getId() == 108) {
            HashMap standardAtt = this._parseTables.getStdAttrs();
            String[] reqLREAttrs = this._parseTables.getRequiredAttrsForLRE();
            int numAttrsRequired = reqLREAttrs != null ? reqLREAttrs.length : 0;
            boolean[] reqAttrsCheckList = new boolean[numAttrsRequired];
            String[] optLREAttrs = this._parseTables.getOptAttrsForLRE();
            String attrQName = null;
            String attrLocalName = null;
            String attrURI = null;
            int length2 = attrs.getLength();
            for (int j = 0; j < length2; ++j) {
                attrQName = attrs.getQName(j);
                attrLocalName = attrs.getLocalName(j);
                attrURI = attrs.getURI(j);
                if (!this.isXSLT20()) continue;
                if (attrURI != null && attrURI.equals("http://www.w3.org/1999/XSL/Transform")) {
                    boolean isKnownXSLTAttribute = false;
                    if (standardAtt != null && standardAtt.containsKey(attrLocalName)) {
                        isKnownXSLTAttribute = true;
                    } else {
                        int i;
                        if (reqLREAttrs != null) {
                            for (i = 0; i < reqLREAttrs.length && !isKnownXSLTAttribute; ++i) {
                                if (!reqLREAttrs[i].equals(attrLocalName)) continue;
                                isKnownXSLTAttribute = true;
                                if (reqAttrsCheckList[i]) continue;
                                reqAttrsCheckList[i] = true;
                                --numAttrsRequired;
                            }
                        }
                        if (!isKnownXSLTAttribute && optLREAttrs != null) {
                            for (i = 0; i < optLREAttrs.length && !isKnownXSLTAttribute; ++i) {
                                if (!optLREAttrs[i].equals(attrLocalName)) continue;
                                isKnownXSLTAttribute = true;
                            }
                        }
                    }
                    if (isKnownXSLTAttribute) continue;
                    ASTMsg error2 = new ASTMsg("ATTR_ERR", (Object)attrQName, (SimpleNode)node2);
                    this.reportError(3, error2);
                    continue;
                }
                if (!attrQName.startsWith("xml") && attrQName.indexOf(58) > 0 && attrs.getURI(j).equals("http://www.w3.org/1999/XSL/Transform")) continue;
            }
            if (numAttrsRequired != 0) {
                for (int i = 0; i < reqAttrsCheckList.length; ++i) {
                    if (reqAttrsCheckList[i]) continue;
                    ASTMsg error3 = new ASTMsg("REQUIRED_ATTR_ERR", (Object)("xsl:" + reqLREAttrs[i]), (SimpleNode)node2);
                    this.reportError(3, error3);
                }
            }
        }
    }

    public void checkForNullNS(Expr node2) {
        QName name2;
        String prefix2;
        String uri2;
        if (node2.getId() == 108 && ((uri2 = node2.lookupNamespace(prefix2 = (name2 = ((DirElemConstructor)node2).getQName()).getPrefix())) == null || uri2 == "")) {
            ASTMsg error2 = new ASTMsg("NULL_NS_TOPLEVEL_CHILD", (Object)name2, (SimpleNode)node2);
            this.reportError(3, error2);
        }
    }

    public void checkAttributeLength(Expr node2, String name2, String value2) {
        if (node2.getId() == 206 && name2.equals("grouping-separator") && !value2.startsWith("{") && value2.codePointCount(0, value2.length()) > 1) {
            ASTMsg error2 = new ASTMsg("NUMBER_GROUPSEPARATOR_ERR", name2);
            this.reportError(3, error2);
        }
    }

    @Override
    public Reporter getReporter() {
        return this._reporter;
    }

    public boolean isExtensionNamespace(String namespace2) {
        if (namespace2 == null || namespace2.length() == 0) {
            return false;
        }
        if (this._extensionNamespaces == null) {
            this._extensionNamespaces = new HashSet();
            this._extensionNamespaces.add("http://www.ibm.com/xmlns/prod/xltxe-j");
            this._extensionNamespaces.add("http://xml.apache.org/xalan");
            this._extensionNamespaces.add("http://xml.apache.org/xslt");
        }
        return this._extensionNamespaces.contains(namespace2);
    }

    public void hasDuplicateVarDeclaration(VariableBase var) {
        QName name2 = var.getQName();
        if ((var.getId() == 29 || var.getId() == 34) && var.isDuplicate()) {
            ASTMsg error2 = new ASTMsg("VAR_REDEF_ERR", (Object)name2, (SimpleNode)var);
            this.reportError(3, error2);
        }
    }

    @Override
    public void startDTD(String name2, String publicID, String systemID) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
        if (this._entityInfoStack != null) {
            this._entityInfoStack.push(new Integer(this._elementDepthInEntity));
        }
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
        this._elementDepthInEntity = (Integer)this._entityInfoStack.pop();
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void setExpressionFactory(ExpressionFactoryImpl expressionFactory) {
        this._expressionFactory = expressionFactory;
    }

    public PSVIProvider getPsviProvider() {
        return this._psviProvider;
    }

    public void setPsviProvider(PSVIProvider psviProvider) {
        this._psviProvider = psviProvider;
    }

    protected void setLineInfo(Expr node2) {
        if (this._locator != null) {
            node2.setLineInfo(LineInfo.createLineInfo(this._locator));
        }
    }

    protected void updateLineInfo(Expr node2) {
    }

    protected Expr getCurrentElement() {
        return (Expr)this._parentStack.peek();
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult;

        static {
            $SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult = new int[XStaticContext.UseWhenResult.values().length];
            try {
                2.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[XStaticContext.UseWhenResult.FALSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$com$ibm$xltxe$rnm1$xtq$scontext$XStaticContext$UseWhenResult[XStaticContext.UseWhenResult.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

