/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.res;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.BaseMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;

public abstract class ASTBaseMsg
extends BaseMsg {
    private SourceLocation m_location;
    private SimpleNode m_node;

    public ASTBaseMsg(String messageOrCode, boolean isCode) {
        super(messageOrCode, isCode);
    }

    public ASTBaseMsg(String code, Object[] params) {
        super(code, params);
    }

    public ASTBaseMsg(String code, Object[] params, SourceLocation location) {
        super(code, params);
        this.m_location = location;
    }

    public ASTBaseMsg(String code, Object[] params, SimpleNode node2) {
        super(code, params);
        this.m_location = this.createSourceLocation(node2);
        this.m_node = node2;
    }

    public ASTBaseMsg(String message, SimpleNode node2) {
        super(message);
        this.m_location = this.createSourceLocation(node2);
        this.m_node = node2;
    }

    public ASTBaseMsg(String code, Object[] params, int line, int column) {
        super(code, params);
        this.m_location = this.createSourceLocation(line, column);
    }

    public ASTBaseMsg(String message, int line, int column) {
        super(message);
        this.m_location = this.createSourceLocation(line, column);
    }

    public ASTBaseMsg(String code, String systemId, Object[] param, int line, int column) {
        super(code, param);
        this.m_location = this.createSourceLocation(systemId, line, column);
    }

    public ASTBaseMsg(String codeOrMessage, SimpleNode node2, boolean isCode) {
        super(codeOrMessage, isCode);
        this.m_location = this.createSourceLocation(node2);
        this.m_node = node2;
    }

    public ASTBaseMsg(String message, SourceLocation location) {
        super(message, false);
        this.m_location = location;
    }

    public SourceLocation getSourceLocation() {
        return this.m_location;
    }

    private SourceLocation createSourceLocation(SimpleNode node2) {
        if (node2 == null) {
            return null;
        }
        return new SourceLocation(node2.getSystemId(), node2.getPublicId(), node2.getStartLineNumber(), node2.getStartColumnNumber(), node2.getEndLineNumber(), node2.getEndColumnNumber());
    }

    private SourceLocation createSourceLocation(int line, int column) {
        return new SourceLocation(null, null, line, column, -1, -1);
    }

    private SourceLocation createSourceLocation(String systemId, int line, int column) {
        return new SourceLocation(systemId, null, line, column, -1, -1);
    }

    @Override
    protected String formatLocation() {
        String result2 = "";
        String url = null;
        if (this.m_location != null) {
            url = this.m_location.getSystemId();
            if (url == null) {
                url = this.m_location.getPublicId();
            }
            if (url == null) {
                url = new ASTMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            int line = this.m_location.getLineNumber();
            String lineStr = String.valueOf(line);
            if (line <= 0) {
                lineStr = new ASTMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            int col = this.m_location.getColumnNumber();
            String colStr = String.valueOf(col);
            if (col <= 0) {
                colStr = new ASTMsg("UNKNOWN_MSG").getFormattedMessage();
            }
            result2 = new ASTMsg("SOURCE_LOCATION_MSG", new Object[]{url, lineStr, colStr}).getFormattedMessage();
        }
        return result2;
    }

    public SimpleNode getNode() {
        return this.m_node;
    }
}

