/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.ast.res;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class BaseMsg {
    private String m_code;
    private String m_message = null;
    private Object[] m_params = null;

    public BaseMsg(String code, Object[] params) {
        this.m_code = code;
        if (params != null && (params.length != 1 || params[0] != null)) {
            this.m_params = params;
        }
    }

    public BaseMsg(String message) {
        this.m_message = message;
    }

    public BaseMsg(String codeOrMessage, boolean isCode) {
        if (isCode) {
            this.m_code = codeOrMessage;
        } else {
            this.m_message = codeOrMessage;
        }
    }

    protected abstract ResourceBundle getBundle();

    public String toString() {
        String prefix2 = this.m_params == null ? (null != this.m_code ? new String(this.getErrorMessage()) : this.m_message) : MessageFormat.format(this.getErrorMessage(), this.m_params);
        return prefix2 + this.formatLocation();
    }

    public String toString(Object obj) {
        Object[] params = new Object[]{obj.toString()};
        String prefix2 = MessageFormat.format(this.getErrorMessage(), params);
        return prefix2 + this.formatLocation();
    }

    public String toString(Object obj0, Object obj1) {
        Object[] params = new Object[]{obj0.toString(), obj1.toString()};
        String prefix2 = MessageFormat.format(this.getErrorMessage(), params);
        return prefix2 + this.formatLocation();
    }

    public String getFormattedMessage() {
        String message = this.m_params == null ? (null != this.m_code ? new String(this.getErrorMessage()) : this.m_message) : MessageFormat.format(this.getErrorMessage(), this.m_params);
        return message;
    }

    protected abstract String formatLocation();

    public String getErrorCode() {
        return this.m_code;
    }

    public Object[] getParams() {
        return this.m_params;
    }

    private String getErrorMessage() {
        return this.getBundle().getString(this.m_code);
    }
}

