/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AttributeReader;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantValue;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Deprecated;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.InnerClasses;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.PMGClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Signature;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.StackMap;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Synthetic;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Unknown;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Attribute
implements Cloneable,
Node,
Serializable {
    protected int name_index;
    protected int length;
    protected byte tag;
    protected ConstantPool constant_pool;
    private static HashMap readers = new HashMap();

    protected Attribute(byte tag, int name_index, int length2, ConstantPool constant_pool) {
        this.tag = tag;
        this.name_index = name_index;
        this.length = length2;
        this.constant_pool = constant_pool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.name_index);
        file.writeInt(this.length);
    }

    public static void addAttributeReader(String name2, AttributeReader r) {
        readers.put(name2, r);
    }

    public static void removeAttributeReader(String name2) {
        readers.remove(name2);
    }

    public static final Attribute readAttribute(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        int tag = -1;
        int name_index = file.readUnsignedShort();
        ConstantUtf8 c = (ConstantUtf8)constant_pool.getConstant(name_index, (byte)1);
        String name2 = c.getBytes();
        int length2 = file.readInt();
        for (int i = 0; i < 12; i = (int)((byte)(i + 1))) {
            if (!name2.equals(Constants.ATTRIBUTE_NAMES[i])) continue;
            tag = i;
            break;
        }
        switch (tag) {
            case -1: {
                AttributeReader r = (AttributeReader)readers.get(name2);
                if (r != null) {
                    return r.createAttribute(name_index, length2, file, constant_pool);
                }
                return new Unknown(name_index, length2, file, constant_pool);
            }
            case 1: {
                return new ConstantValue(name_index, length2, file, constant_pool);
            }
            case 0: {
                return new SourceFile(name_index, length2, file, constant_pool);
            }
            case 2: {
                return new Code(name_index, length2, file, constant_pool);
            }
            case 3: {
                return new ExceptionTable(name_index, length2, file, constant_pool);
            }
            case 4: {
                return new LineNumberTable(name_index, length2, file, constant_pool);
            }
            case 5: {
                return new LocalVariableTable(name_index, length2, file, constant_pool);
            }
            case 6: {
                return new InnerClasses(name_index, length2, file, constant_pool);
            }
            case 7: {
                return new Synthetic(name_index, length2, file, constant_pool);
            }
            case 8: {
                return new Deprecated(name_index, length2, file, constant_pool);
            }
            case 9: {
                return new PMGClass(name_index, length2, file, constant_pool);
            }
            case 10: {
                return new Signature(name_index, length2, file, constant_pool);
            }
            case 11: {
                return new StackMap(name_index, length2, file, constant_pool);
            }
        }
        throw new IllegalStateException("Ooops! default case reached.");
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length2) {
        this.length = length2;
    }

    public final void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }
}

