/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantCP;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ConstantPool
implements Cloneable,
Node,
Serializable {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constant_pool) {
        this.setConstantPool(constant_pool);
    }

    ConstantPool(DataInputStream file) throws IOException, ClassFormatException {
        this.constant_pool_count = file.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(file);
            byte tag = this.constant_pool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    public String constantToString(Constant c) throws ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = "" + ((ConstantDouble)c).getBytes();
                break;
            }
            case 4: {
                str = "" + ((ConstantFloat)c).getBytes();
                break;
            }
            case 5: {
                str = "" + ((ConstantLong)c).getBytes();
                break;
            }
            case 3: {
                str = "" + ((ConstantInteger)c).getBytes();
                break;
            }
            case 12: {
                str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static final String escape(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len + 5);
        char[] ch = str.toCharArray();
        block7: for (int i = 0; i < len; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public String constantToString(int index2, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index2, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constant_pool_count);
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(file);
        }
    }

    public Constant getConstant(int index2) {
        if (index2 >= this.constant_pool.length || index2 < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index2 + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index2];
    }

    public Constant getConstant(int index2, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index2);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index2 + " is null.");
        }
        if (c.getTag() == tag) {
            return c;
        }
        throw new ClassFormatException("Expected class `" + Constants.CONSTANT_NAMES[tag] + "' at index " + index2 + " and got " + c);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int index2, byte tag) throws ClassFormatException {
        int i;
        Constant c = this.getConstant(index2, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int index2, Constant constant) {
        this.constant_pool[index2] = constant;
    }

    public void setConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
        this.constant_pool_count = constant_pool == null ? 0 : constant_pool.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < this.constant_pool_count; ++i) {
            buf.append(i + ")" + this.constant_pool[i] + "\n");
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        c.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            c.constant_pool[i] = this.constant_pool[i].copy();
        }
        return c;
    }
}

