/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Signature
extends Attribute {
    private int signature_index;

    public Signature(Signature c) {
        this(c.getNameIndex(), c.getLength(), c.getSignatureIndex(), c.getConstantPool());
    }

    Signature(int name_index, int length2, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length2, file.readUnsignedShort(), constant_pool);
    }

    public Signature(int name_index, int length2, int signature_index, ConstantPool constant_pool) {
        super((byte)10, name_index, length2, constant_pool);
        this.signature_index = signature_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitSignature(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.signature_index);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    public final String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    private static boolean identStart(int ch) {
        return ch == 84 || ch == 76;
    }

    private static boolean identPart(int ch) {
        return ch == 47 || ch == 59;
    }

    private static final void matchIdent(MyByteArrayInputStream in2, StringBuffer buf) {
        int ch = in2.read();
        if (ch == -1) {
            throw new RuntimeException("Illegal signature: " + in2.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(ch)) {
            StringBuffer buf2 = new StringBuffer();
            int count2 = 1;
            while (Character.isJavaIdentifierPart((char)ch)) {
                buf2.append((char)ch);
                ++count2;
                ch = in2.read();
            }
            if (ch == 58) {
                in2.skip("Ljava/lang/Object".length());
                buf.append(buf2);
                ch = in2.read();
                in2.unread();
            } else {
                for (int i = 0; i < count2; ++i) {
                    in2.unread();
                }
            }
            return;
        }
        StringBuffer buf2 = new StringBuffer();
        ch = in2.read();
        do {
            buf2.append((char)ch);
        } while ((ch = in2.read()) != -1 && (Character.isJavaIdentifierPart((char)ch) || ch == 47));
        buf.append(buf2.toString().replace('/', '.'));
        if (ch != -1) {
            in2.unread();
        }
    }

    private static final void matchGJIdent(MyByteArrayInputStream in2, StringBuffer buf) {
        Signature.matchIdent(in2, buf);
        int ch = in2.read();
        if (ch == 60 || ch == 40) {
            buf.append((char)ch);
            Signature.matchGJIdent(in2, buf);
            while ((ch = in2.read()) != 62 && ch != 41) {
                if (ch == -1) {
                    throw new RuntimeException("Illegal signature: " + in2.getData() + " reaching EOF");
                }
                buf.append(", ");
                in2.unread();
                Signature.matchGJIdent(in2, buf);
            }
            buf.append((char)ch);
        } else {
            in2.unread();
        }
        ch = in2.read();
        if (Signature.identStart(ch)) {
            in2.unread();
            Signature.matchGJIdent(in2, buf);
        } else {
            if (ch == 41) {
                in2.unread();
                return;
            }
            if (ch != 59) {
                throw new RuntimeException("Illegal signature: " + in2.getData() + " read " + (char)ch);
            }
        }
    }

    public static String translate(String s) {
        StringBuffer buf = new StringBuffer();
        Signature.matchGJIdent(new MyByteArrayInputStream(s), buf);
        return buf.toString();
    }

    public static final boolean isFormalParameterList(String s) {
        return s.startsWith("<") && s.indexOf(58) > 0;
    }

    public static final boolean isActualParameterList(String s) {
        return s.startsWith("L") && s.endsWith(">;");
    }

    @Override
    public final String toString() {
        String s = this.getSignature();
        return "Signature(" + s + ")";
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        return (Signature)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String data2) {
            super(data2.getBytes());
        }

        final int mark() {
            return this.pos;
        }

        final String getData() {
            return new String(this.buf);
        }

        final void reset(int p) {
            this.pos = p;
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

