/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Node;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.StackMapEntry;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int name_index, int length2, StackMapEntry[] map2, ConstantPool constant_pool) {
        super((byte)11, name_index, length2, constant_pool);
        this.setStackMap(map2);
    }

    StackMap(int name_index, int length2, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length2, (StackMapEntry[])null, constant_pool);
        this.map_length = file.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i] = new StackMapEntry(file, constant_pool);
        }
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map_length);
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i].dump(file);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] map2) {
        this.map = map2;
        this.map_length = map2 == null ? 0 : map2.length;
    }

    @Override
    public final String toString() {
        StringBuffer buf = new StringBuffer("StackMap(");
        for (int i = 0; i < this.map_length; ++i) {
            buf.append(this.map[i].toString());
            if (i >= this.map_length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.constant_pool = constant_pool;
        return c;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

