/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.classfile;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ClassFormatException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class Utility {
    private static int consumed_chars;
    private static boolean wide;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP;
    private static int[] MAP_CHAR;
    private static final char ESCAPE_CHAR = '$';

    public static final String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static final String accessToString(int access_flags, boolean for_class) {
        StringBuffer buf = new StringBuffer();
        int p = 0;
        int i = 0;
        while (p < 2048) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(Constants.ACCESS_NAMES[i] + " ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static final String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index2, int length2, boolean verbose) {
        StringBuffer buf = new StringBuffer(code.length * 20);
        ByteSequence stream2 = new ByteSequence(code);
        try {
            int i;
            for (i = 0; i < index2; ++i) {
                Utility.codeToString(stream2, constant_pool, verbose);
            }
            i = 0;
            while (stream2.available() > 0) {
                if (length2 < 0 || i < length2) {
                    String indices = Utility.fillup(stream2.getIndex() + ":", 6, true, ' ');
                    buf.append(indices + Utility.codeToString(stream2, constant_pool, verbose) + '\n');
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ClassFormatException("Byte code error: " + e);
        }
        return buf.toString();
    }

    public static final String codeToString(byte[] code, ConstantPool constant_pool, int index2, int length2) {
        return Utility.codeToString(code, constant_pool, index2, length2, true);
    }

    public static final String codeToString(ByteSequence bytes2, ConstantPool constant_pool, boolean verbose) throws IOException {
        int i;
        short opcode = (short)bytes2.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer(Constants.OPCODE_NAMES[opcode]);
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes2.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (i = 0; i < no_pad_bytes; ++i) {
                byte b = bytes2.readByte();
                if (b == 0) continue;
            }
            default_offset = bytes2.readInt();
        }
        switch (opcode) {
            case 170: {
                int i2;
                int low = bytes2.readInt();
                int high = bytes2.readInt();
                int offset = bytes2.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = " + (default_offset += offset) + ", low = " + low + ", high = " + high + "(");
                int[] jump_table = new int[high - low + 1];
                for (i2 = 0; i2 < jump_table.length; ++i2) {
                    jump_table[i2] = offset + bytes2.readInt();
                    buf.append(jump_table[i2]);
                    if (i2 >= jump_table.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 171: {
                int i2;
                int npairs = bytes2.readInt();
                int offset = bytes2.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = " + (default_offset += offset) + ", npairs = " + npairs + " (");
                for (i2 = 0; i2 < npairs; ++i2) {
                    match[i2] = bytes2.readInt();
                    jump_table[i2] = offset + bytes2.readInt();
                    buf.append("(" + match[i2] + ", " + jump_table[i2] + ")");
                    if (i2 >= npairs - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#" + (bytes2.getIndex() - 1 + bytes2.readShort()));
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#" + (bytes2.getIndex() - 1 + bytes2.readInt()));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes2.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes2.readUnsignedByte();
                }
                buf.append("\t\t%" + vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<" + Constants.TYPE_NAMES[bytes2.readByte()] + ">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index2 = bytes2.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index2, (byte)9) + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index2 = bytes2.readUnsignedShort();
                buf.append("\t<" + constant_pool.constantToString(index2, (byte)7) + ">" + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                int index2 = bytes2.readUnsignedShort();
                buf.append("\t" + constant_pool.constantToString(index2, (byte)10) + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 185: {
                int index2 = bytes2.readUnsignedShort();
                int nargs = bytes2.readUnsignedByte();
                buf.append("\t" + constant_pool.constantToString(index2, (byte)11) + (verbose ? " (" + index2 + ")\t" : "") + nargs + "\t" + bytes2.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index2 = bytes2.readUnsignedShort();
                buf.append("\t\t" + constant_pool.constantToString(index2, constant_pool.getConstant(index2).getTag()) + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 18: {
                int index2 = bytes2.readUnsignedByte();
                buf.append("\t\t" + constant_pool.constantToString(index2, constant_pool.getConstant(index2).getTag()) + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 189: {
                int index2 = bytes2.readUnsignedShort();
                buf.append("\t\t<" + Utility.compactClassName(constant_pool.getConstantString(index2, (byte)7), false) + ">" + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 197: {
                int index2 = bytes2.readUnsignedShort();
                int dimensions = bytes2.readUnsignedByte();
                buf.append("\t<" + Utility.compactClassName(constant_pool.getConstantString(index2, (byte)7), false) + ">\t" + dimensions + (verbose ? " (" + index2 + ")" : ""));
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes2.readUnsignedShort();
                    constant = bytes2.readShort();
                    wide = false;
                } else {
                    vindex = bytes2.readUnsignedByte();
                    constant = bytes2.readByte();
                }
                buf.append("\t\t%" + vindex + "\t" + constant);
                break;
            }
            default: {
                if (Constants.NO_OF_OPERANDS[opcode] <= 0) break;
                block27: for (i = 0; i < Constants.TYPE_OF_OPERANDS[opcode].length; ++i) {
                    buf.append("\t\t");
                    switch (Constants.TYPE_OF_OPERANDS[opcode][i]) {
                        case 8: {
                            buf.append(bytes2.readByte());
                            continue block27;
                        }
                        case 9: {
                            buf.append(bytes2.readShort());
                            continue block27;
                        }
                        case 10: {
                            buf.append(bytes2.readInt());
                            continue block27;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                }
            }
        }
        return buf.toString();
    }

    public static final String codeToString(ByteSequence bytes2, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes2, constant_pool, true);
    }

    public static final String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static final String compactClassName(String str, String prefix2, boolean chopit) {
        int len = prefix2.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix2) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static final String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    private static final boolean is_digit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final boolean is_space(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public static final int setBit(int flag, int i) {
        return flag | Utility.pow2(i);
    }

    public static final int clearBit(int flag, int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static final boolean isSet(int flag, int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    public static final String methodTypeToSignature(String ret, String[] argv) throws ClassFormatException {
        String str;
        StringBuffer buf = new StringBuffer("(");
        if (argv != null) {
            for (int i = 0; i < argv.length; ++i) {
                str = Utility.getSignature(argv[i]);
                if (str.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + argv[i]);
                }
                buf.append(str);
            }
        }
        str = Utility.getSignature(ret);
        buf.append(")" + str);
        return buf.toString();
    }

    public static final String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static final String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index2 = 1;
            while (signature.charAt(index2) != ')') {
                vec.add(Utility.signatureToString(signature.substring(index2), chopit));
                index2 += consumed_chars;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        String[] types2 = new String[vec.size()];
        vec.toArray(types2);
        return types2;
    }

    public static final String methodSignatureReturnType(String signature) throws ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static final String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatException {
        String type2;
        try {
            int index2 = signature.lastIndexOf(41) + 1;
            type2 = Utility.signatureToString(signature.substring(index2), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        return type2;
    }

    public static final String methodSignatureToString(String signature, String name2, String access) {
        return Utility.methodSignatureToString(signature, name2, access, true);
    }

    public static final String methodSignatureToString(String signature, String name2, String access, boolean chopit) {
        return Utility.methodSignatureToString(signature, name2, access, chopit, null);
    }

    public static final String methodSignatureToString(String signature, String name2, String access, boolean chopit, LocalVariableTable vars) throws ClassFormatException {
        String type2;
        StringBuffer buf = new StringBuffer("(");
        int var_index = access.indexOf("static") >= 0 ? 0 : 1;
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index2 = 1;
            while (signature.charAt(index2) != ')') {
                String param_type = Utility.signatureToString(signature.substring(index2), chopit);
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l = vars.getLocalVariable(var_index);
                    if (l != null) {
                        buf.append(" " + l.getName());
                    }
                } else {
                    buf.append(" arg" + var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index2 += consumed_chars;
            }
            type2 = Utility.signatureToString(signature.substring(++index2), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return access + (access.length() > 0 ? " " : "") + type2 + " " + name2 + buf.toString();
    }

    private static final int pow2(int n2) {
        return 1 << n2;
    }

    public static final String replace(String str, String old2, String new_) {
        StringBuffer buf = new StringBuffer();
        try {
            int index2 = str.indexOf(old2);
            if (index2 != -1) {
                int old_index = 0;
                while ((index2 = str.indexOf(old2, old_index)) != -1) {
                    buf.append(str.substring(old_index, index2));
                    buf.append(new_);
                    old_index = index2 + old2.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static final String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static final String signatureToString(String signature, boolean chopit) {
        consumed_chars = 1;
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index2 = signature.indexOf(59);
                    if (index2 < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    consumed_chars = index2 + 1;
                    return Utility.compactClassName(signature.substring(1, index2), chopit);
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n2 = 0;
                    while (signature.charAt(n2) == '[') {
                        brackets.append("[]");
                        ++n2;
                    }
                    int consumed_chars = n2;
                    String type2 = Utility.signatureToString(signature.substring(n2), chopit);
                    Utility.consumed_chars += consumed_chars;
                    return type2 + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + e + ":" + signature);
        }
    }

    public static String getSignature(String type2) {
        StringBuffer buf = new StringBuffer();
        char[] chars = type2.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index2 = -1;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) continue block4;
                    delim = true;
                    continue block4;
                }
                case '[': {
                    if (!char_found) {
                        throw new RuntimeException("Illegal type: " + type2);
                    }
                    index2 = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) continue block4;
                    buf.append(chars[i]);
                }
            }
        }
        int brackets = 0;
        if (index2 > 0) {
            brackets = Utility.countBrackets(type2.substring(index2));
        }
        type2 = buf.toString();
        buf.setLength(0);
        for (int i = 0; i < brackets; ++i) {
            buf.append('[');
        }
        boolean found = false;
        for (int i = 4; i <= 12 && !found; ++i) {
            if (!Constants.TYPE_NAMES[i].equals(type2)) continue;
            found = true;
            buf.append(Constants.SHORT_TYPE_NAMES[i]);
        }
        if (!found) {
            buf.append('L' + type2.replace('.', '/') + ';');
        }
        return buf.toString();
    }

    private static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count2 = 0;
        boolean open = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '[': {
                    if (open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    continue block4;
                }
                case ']': {
                    if (!open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count2;
                    continue block4;
                }
            }
        }
        if (open) {
            throw new RuntimeException("Illegally nested brackets:" + brackets);
        }
        return count2;
    }

    public static final byte typeOfMethodSignature(String signature) throws ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index2 = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index2));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static final byte typeOfSignature(String signature) throws ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
            }
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static short searchOpcode(String name2) {
        name2 = name2.toLowerCase();
        for (short i = 0; i < Constants.OPCODE_NAMES.length; i = (short)(i + 1)) {
            if (!Constants.OPCODE_NAMES[i].equals(name2)) continue;
            return i;
        }
        return -1;
    }

    private static final short byteToShort(byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static final String toHexString(byte[] bytes2) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes2.length; ++i) {
            short b = Utility.byteToShort(bytes2[i]);
            String hex2 = Integer.toString(b, 16);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex2);
            if (i >= bytes2.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static final String format(int i, int length2, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i), length2, left_justify, fill);
    }

    public static final String fillup(String str, int length2, boolean left_justify, char fill) {
        int len = length2 - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        for (int j = 0; j < buf.length; ++j) {
            buf[j] = fill;
        }
        if (left_justify) {
            return str + new String(buf);
        }
        return new String(buf) + str;
    }

    static final boolean equals(byte[] a, byte[] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static final void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static final String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static final String printArray(Object[] obj, boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static final String printArray(Object[] obj, boolean braces, boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (braces) {
            buf.append('{');
        }
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != null) {
                buf.append((quote ? "\"" : "") + obj[i].toString() + (quote ? "\"" : ""));
            } else {
                buf.append("null");
            }
            if (i >= obj.length - 1) continue;
            buf.append(", ");
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public static String encode(byte[] bytes2, boolean compress) throws IOException {
        if (compress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(bytes2, 0, bytes2.length);
            gos.close();
            baos.close();
            bytes2 = baos.toByteArray();
        }
        CharArrayWriter caw = new CharArrayWriter();
        JavaWriter jw = new JavaWriter(caw);
        for (int i = 0; i < bytes2.length; ++i) {
            int in2 = bytes2[i] & 0xFF;
            jw.write(in2);
        }
        return caw.toString();
    }

    public static byte[] decode(String s, boolean uncompress) throws IOException {
        int ch;
        char[] chars = s.toCharArray();
        CharArrayReader car = new CharArrayReader(chars);
        JavaReader jr = new JavaReader(car);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((ch = jr.read()) >= 0) {
            bos.write(ch);
        }
        bos.close();
        car.close();
        jr.close();
        byte[] bytes2 = bos.toByteArray();
        if (uncompress) {
            int b;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes2));
            byte[] tmp = new byte[bytes2.length * 3];
            int count2 = 0;
            while ((b = gis.read()) >= 0) {
                tmp[count2++] = (byte)b;
            }
            bytes2 = new byte[count2];
            System.arraycopy(tmp, 0, bytes2, 0, count2);
        }
        return bytes2;
    }

    public static final String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < ch.length; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    static {
        int i;
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int j = 0;
        boolean k = false;
        for (i = 65; i <= 90; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        for (i = 103; i <= 122; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (Utility.isJavaIdentifierPart((char)b) && b != 36) {
                this.out.write(b);
            } else {
                this.out.write(36);
                if (b >= 0 && b < 48) {
                    this.out.write(CHAR_MAP[b]);
                } else {
                    char[] tmp = Integer.toHexString(b).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader in2) {
            super(in2);
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != 36) {
                return b;
            }
            int i = this.in.read();
            if (i < 0) {
                return -1;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102) {
                int j = this.in.read();
                if (j < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i, (char)j};
                int s = Integer.parseInt(new String(tmp), 16);
                return s;
            }
            return MAP_CHAR[i];
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                cbuf[off + i] = (char)this.read();
            }
            return len;
        }
    }
}

