/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public ArrayType(byte type2, int dimensions) {
        this(BasicType.getType(type2), dimensions);
    }

    public ArrayType(String class_name, int dimensions) {
        this(new ObjectType(class_name), dimensions);
    }

    public ArrayType(Type type2, int dimensions) {
        super((byte)13, "<dummy>");
        if (dimensions < 1 || dimensions > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + dimensions);
        }
        switch (type2.getType()) {
            case 13: {
                ArrayType array = (ArrayType)type2;
                this.dimensions = dimensions + array.dimensions;
                this.basic_type = array.basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = dimensions;
                this.basic_type = type2;
            }
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.dimensions; ++i) {
            buf.append('[');
        }
        buf.append(this.basic_type.getSignature());
        this.signature = buf.toString();
    }

    public Type getBasicType() {
        return this.basic_type;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int hashcode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    public boolean equals(Object type2) {
        if (type2 instanceof ArrayType) {
            ArrayType array = (ArrayType)type2;
            return array.dimensions == this.dimensions && array.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

