/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IndexedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short opcode, int index2) {
        super(opcode, (short)3);
        this.setIndex(index2);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeShort(this.index);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + str;
    }

    @Override
    protected void initFromFile(ByteSequence bytes2, boolean wide) throws IOException {
        this.setIndex(bytes2.readUnsignedShort());
        this.length = (short)3;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index2) {
        if (index2 < 0) {
            throw new ClassGenException("Negative index value: " + index2);
        }
        this.index = index2;
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name2 = cp.getConstantString(this.index, (byte)7);
        if (!name2.startsWith("[")) {
            name2 = "L" + name2 + ";";
        }
        return Type.getType(name2);
    }
}

