/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AccessFlags;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.SourceFile;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassObserver;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private ArrayList field_vec = new ArrayList();
    private ArrayList method_vec = new ArrayList();
    private ArrayList attribute_vec = new ArrayList();
    private ArrayList interface_vec = new ArrayList();
    private ArrayList observers;

    public ClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces, ConstantPoolGen cp) {
        this.class_name = class_name;
        this.super_class_name = super_class_name;
        this.file_name = file_name;
        this.access_flags = access_flags;
        this.cp = cp;
        if (file_name != null) {
            this.addAttribute(new SourceFile(cp.addUtf8("SourceFile"), 2, cp.addUtf8(file_name), cp.getConstantPool()));
        }
        this.class_name_index = cp.addClass(class_name);
        this.superclass_name_index = cp.addClass(super_class_name);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.addInterface(interfaces[i]);
            }
        }
    }

    public ClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces) {
        this(class_name, super_class_name, file_name, access_flags, interfaces, new ConstantPoolGen());
    }

    public ClassGen(JavaClass clazz) {
        int i;
        this.class_name_index = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.class_name = clazz.getClassName();
        this.super_class_name = clazz.getSuperclassName();
        this.file_name = clazz.getSourceFileName();
        this.access_flags = clazz.getAccessFlags();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Attribute[] attributes2 = clazz.getAttributes();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        for (i = 0; i < interfaces.length; ++i) {
            this.addInterface(interfaces[i]);
        }
        for (i = 0; i < attributes2.length; ++i) {
            this.addAttribute(attributes2[i]);
        }
        for (i = 0; i < methods.length; ++i) {
            this.addMethod(methods[i]);
        }
        for (i = 0; i < fields.length; ++i) {
            this.addField(fields[i]);
        }
    }

    public JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        Attribute[] attributes2 = this.getAttributes();
        ConstantPool cp = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, cp, interfaces, fields, methods, attributes2);
    }

    public void addInterface(String name2) {
        this.interface_vec.add(name2);
    }

    public void removeInterface(String name2) {
        this.interface_vec.remove(name2);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute a) {
        this.attribute_vec.add(a);
    }

    public void addMethod(Method m) {
        this.method_vec.add(m);
    }

    public void addEmptyConstructor(int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConstants.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        il.append(InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(Field f2) {
        this.field_vec.add(f2);
    }

    public boolean containsField(Field f2) {
        return this.field_vec.contains(f2);
    }

    public Field containsField(String name2) {
        for (Field f2 : this.field_vec) {
            if (!f2.getName().equals(name2)) continue;
            return f2;
        }
        return null;
    }

    public Method containsMethod(String name2, String signature) {
        for (Method m : this.method_vec) {
            if (!m.getName().equals(name2) || !m.getSignature().equals(signature)) continue;
            return m;
        }
        return null;
    }

    public void removeAttribute(Attribute a) {
        this.attribute_vec.remove(a);
    }

    public void removeMethod(Method m) {
        this.method_vec.remove(m);
    }

    public void replaceMethod(Method old2, Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.method_vec.indexOf(old2);
        if (i < 0) {
            this.method_vec.add(new_);
        } else {
            this.method_vec.set(i, new_);
        }
    }

    public void replaceField(Field old2, Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.field_vec.indexOf(old2);
        if (i < 0) {
            this.field_vec.add(new_);
        } else {
            this.field_vec.set(i, new_);
        }
    }

    public void removeField(Field f2) {
        this.field_vec.remove(f2);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String name2) {
        this.class_name = name2.replace('/', '.');
        this.class_name_index = this.cp.addClass(name2);
    }

    public void setSuperclassName(String name2) {
        this.super_class_name = name2.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(name2);
    }

    public Method[] getMethods() {
        Method[] methods = new Method[this.method_vec.size()];
        this.method_vec.toArray(methods);
        return methods;
    }

    public void setMethods(Method[] methods) {
        this.method_vec.clear();
        for (int m = 0; m < methods.length; ++m) {
            this.addMethod(methods[m]);
        }
    }

    public void setMethodAt(Method method, int pos) {
        this.method_vec.set(pos, method);
    }

    public Method getMethodAt(int pos) {
        return (Method)this.method_vec.get(pos);
    }

    public String[] getInterfaceNames() {
        int size = this.interface_vec.size();
        String[] interfaces = new String[size];
        this.interface_vec.toArray(interfaces);
        return interfaces;
    }

    public int[] getInterfaces() {
        int size = this.interface_vec.size();
        int[] interfaces = new int[size];
        for (int i = 0; i < size; ++i) {
            interfaces[i] = this.cp.addClass((String)this.interface_vec.get(i));
        }
        return interfaces;
    }

    public Field[] getFields() {
        Field[] fields = new Field[this.field_vec.size()];
        this.field_vec.toArray(fields);
        return fields;
    }

    public Attribute[] getAttributes() {
        Attribute[] attributes2 = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.toArray(attributes2);
        return attributes2;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setClassNameIndex(int class_name_index) {
        this.class_name_index = class_name_index;
        this.class_name = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.super_class_name = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o);
    }

    public void removeObserver(ClassObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e = this.observers.iterator();
            while (e.hasNext()) {
                ((ClassObserver)e.next()).notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

